/*
 * Decompiled with CFR 0.152.
 */
package ace;

import ace.Coordinator;
import ace.InstanceClassifier;
import ace.datatypes.DataBoard;
import ace.datatypes.Project;
import ace.datatypes.SegmentedClassification;
import ace.datatypes.TrainedModel;
import ace.xmlparsers.ParseACEZipFile;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.PrintStream;
import java.io.Serializable;
import java.util.LinkedList;
import mckay.utilities.staticlibraries.StringMethods;
import weka.core.Utils;

public class CommandLine
implements Serializable {
    public String classifier_type;
    public String save_file;
    public String feature_selector;
    public boolean order_randomly = false;
    public double max_spread = 0.0;
    public double max_membership = 0.0;
    public boolean save_intermediate_arffs = false;
    public String project_path;
    public String load_zip;
    public String taxonomy_file;
    public String feature_key_file;
    public String classifications_file;
    public String[] feature_vector_files;
    public String arff_file;
    public boolean train = false;
    public String testing_to_load_classifiers_file;
    public String cross_validation_string;
    public String experimentation_string;
    public boolean verbose = false;
    public String zip_file;
    public String file_type;
    public boolean unzip;
    public String[] dozip = null;
    public String[] zip_add;
    public String zip_extract;
    public String zip_directory;

    public CommandLine(String[] options) throws Exception {
        String feature_vector_file;
        this.zip_file = Utils.getOption((String)"zipfile", (String[])options);
        if (this.zip_file.length() == 0) {
            this.zip_file = null;
        }
        this.file_type = Utils.getOption((String)"filetype", (String[])options);
        if (this.file_type.length() == 0) {
            this.file_type = null;
        }
        this.zip_directory = Utils.getOption((String)"zip_dir", (String[])options);
        if (this.zip_directory.length() == 0) {
            this.zip_directory = null;
        }
        this.zip_extract = Utils.getOption((String)"zip_extract", (String[])options);
        if (this.zip_extract.length() == 0 && this.file_type == null) {
            this.zip_extract = null;
        }
        this.unzip = Utils.getFlag((String)"unzip", (String[])options);
        if (Utils.getFlag((String)"dozip", (String[])options)) {
            this.dozip = StringMethods.removeEmptyStringsFromArray((String[])options);
        }
        if (Utils.getFlag((String)"zip_add", (String[])options)) {
            this.zip_add = StringMethods.removeEmptyStringsFromArray((String[])options);
        }
        if (this.file_type != null && this.unzip) {
            throw new Exception("The -filename command is only to be used in conjunction with the -zip_extract command.");
        }
        if ((this.dozip != null || this.unzip) && (this.zip_add != null || this.zip_extract != null) || (this.dozip != null || this.zip_add != null) && (this.unzip || this.zip_extract != null)) {
            throw new Exception("You may only specify one zip operation at a time.");
        }
        if ((this.unzip || this.zip_extract != null || this.dozip != null || this.zip_add != null) && this.zip_file == null) {
            throw new Exception("Please specify name of zipfile using the -zip_file flag.");
        }
        if ((this.unzip || this.zip_extract != null) && this.zip_directory == null) {
            this.zip_directory = StringMethods.getExtension((String)this.zip_file) != null ? StringMethods.removeExtension((String)this.zip_file) : this.zip_file;
        }
        if (Utils.getFlag((String)"help", (String[])options)) {
            CommandLine.printHelpMessage();
            System.exit(0);
        }
        this.classifier_type = Utils.getOption((String)"learner", (String[])options);
        if (this.classifier_type.length() == 0) {
            this.classifier_type = null;
        }
        this.save_file = Utils.getOption((String)"sres", (String[])options);
        if (this.save_file.length() == 0) {
            this.save_file = null;
        }
        String max_spread_option = Utils.getOption((String)"max_spread", (String[])options);
        String max_membersip_option = Utils.getOption((String)"max_memb", (String[])options);
        this.feature_selector = Utils.getOption((String)"dr", (String[])options);
        if (this.feature_selector.length() == 0) {
            this.feature_selector = null;
        }
        if (max_spread_option.length() != 0) {
            this.max_spread = new Double(max_spread_option);
        }
        if (max_membersip_option.length() != 0) {
            this.max_membership = new Double(max_membersip_option);
        }
        if (Utils.getFlag((String)"rand_ord", (String[])options)) {
            this.order_randomly = true;
        }
        if (Utils.getFlag((String)"sarff", (String[])options)) {
            this.save_intermediate_arffs = true;
        }
        if (Utils.getFlag((String)"verbose", (String[])options)) {
            this.verbose = true;
        }
        this.project_path = Utils.getOption((String)"proj", (String[])options);
        if (this.project_path.length() == 0) {
            this.project_path = null;
        }
        this.load_zip = Utils.getOption((String)"lzip", (String[])options);
        if (this.load_zip.length() == 0) {
            this.load_zip = null;
        }
        this.arff_file = Utils.getOption((String)"arff", (String[])options);
        if (this.arff_file.length() == 0) {
            this.arff_file = null;
        }
        this.taxonomy_file = Utils.getOption((String)"ltax", (String[])options);
        if (this.taxonomy_file.length() == 0) {
            this.taxonomy_file = null;
        }
        this.feature_key_file = Utils.getOption((String)"lfkey", (String[])options);
        if (this.feature_key_file.length() == 0) {
            Object feature_key_files = null;
            this.feature_key_file = null;
        }
        this.classifications_file = Utils.getOption((String)"lmclas", (String[])options);
        if (this.classifications_file.length() == 0) {
            Object classifications_files = null;
            this.classifications_file = null;
        }
        if ((feature_vector_file = Utils.getOption((String)"lfvec", (String[])options)).length() == 0) {
            this.feature_vector_files = null;
        } else {
            LinkedList<String> feature_vector_file_list = new LinkedList<String>();
            while (!feature_vector_file.equals("")) {
                feature_vector_file_list.add(feature_vector_file);
                feature_vector_file = Utils.getOption((String)"lfvec", (String[])options);
            }
            this.feature_vector_files = feature_vector_file_list.toArray(new String[1]);
        }
        if (Utils.getFlag((String)"train", (String[])options)) {
            this.train = true;
        }
        this.testing_to_load_classifiers_file = Utils.getOption((String)"classify", (String[])options);
        if (this.testing_to_load_classifiers_file.length() == 0) {
            this.testing_to_load_classifiers_file = null;
        }
        this.cross_validation_string = Utils.getOption((String)"cv", (String[])options);
        if (this.cross_validation_string.length() == 0) {
            this.cross_validation_string = null;
        }
        this.experimentation_string = Utils.getOption((String)"exp", (String[])options);
        if (this.experimentation_string.length() == 0) {
            this.experimentation_string = null;
        }
        if (this.train && this.testing_to_load_classifiers_file != null) {
            throw new Exception("Must specify either training or testing, not both.");
        }
        if (!(!this.train && this.testing_to_load_classifiers_file == null || this.experimentation_string == null && this.cross_validation_string == null)) {
            throw new Exception("May not train or test if cross-validating or experimenting.");
        }
        if (this.cross_validation_string != null && this.experimentation_string != null) {
            throw new Exception("Must specify either cross validation or experimentation, not both");
        }
        if (this.cross_validation_string != null && this.classifier_type == null) {
            throw new Exception("Must specify number of folds AND Classifier type.");
        }
        if (this.train && this.classifier_type == null) {
            throw new Exception("Must specify Classifier type");
        }
        if (this.train && this.save_file == null) {
            throw new Exception("Must specify file name of trained Classifier.");
        }
        if (this.project_path != null && this.load_zip != null) {
            throw new Exception("May either specify ACE project file or ACE zip file, not both.");
        }
        if (this.arff_file != null && (this.project_path != null || this.feature_vector_files != null || this.load_zip != null)) {
            throw new Exception("Please specify either a Weka ARFF file or ACE XML files, not both.");
        }
        if ((this.project_path != null || this.load_zip != null) && this.feature_vector_files != null) {
            throw new Exception("Unable to load individual ACE XML files when loading project from an ACE project file or ACE zip file");
        }
        if (this.load_zip != null) {
            String temp_directory = "TEMPZIP";
            this.project_path = ParseACEZipFile.parseZip(this.load_zip, temp_directory);
        }
        if (this.project_path != null) {
            Project project = new Project();
            project.parseProjectFile(this.project_path);
            this.taxonomy_file = project.taxonomy_path;
            this.feature_key_file = project.feature_settings_paths[0];
            this.classifications_file = project.classification_paths[0];
            this.feature_vector_files = new String[1];
            this.feature_vector_files[0] = project.feature_vectors_paths[0];
        }
    }

    public void processRequests() throws Exception {
        block18: {
            if (this.arff_file == null) {
                if (this.feature_key_file == null) {
                    throw new Exception("No feature definitions specified.");
                }
                if (this.feature_vector_files == null || this.feature_vector_files[0] == null) {
                    throw new Exception("No feature values specified.");
                }
            }
            Coordinator doer = null;
            try {
                DataBoard data_board = null;
                data_board = this.arff_file == null ? new DataBoard(this.taxonomy_file, this.feature_key_file, this.feature_vector_files, this.classifications_file) : new DataBoard(this.arff_file);
                doer = new Coordinator(data_board, this.arff_file, this.save_intermediate_arffs);
                int max_attribute = 6;
                if (this.train) {
                    PrintStream out = System.out;
                    TrainedModel trained = doer.train(this.max_spread, this.max_membership, this.order_randomly, this.feature_selector, this.classifier_type, out, max_attribute, this.verbose);
                    File saved = new File(this.save_file);
                    FileOutputStream save_stream = new FileOutputStream(saved);
                    System.out.println("save_file" + this.save_file);
                    ObjectOutputStream object_stream = new ObjectOutputStream(save_stream);
                    object_stream.writeObject(trained);
                    object_stream.flush();
                    save_stream.close();
                    System.out.println("\nClassifier succesfully trained.\n");
                    break block18;
                }
                if (this.testing_to_load_classifiers_file != null) {
                    TrainedModel trained;
                    try {
                        FileInputStream load_stream = new FileInputStream(new File(this.testing_to_load_classifiers_file));
                        ObjectInputStream object_stream = new ObjectInputStream(load_stream);
                        trained = (TrainedModel)object_stream.readObject();
                        load_stream.close();
                    }
                    catch (IOException e) {
                        throw new IOException("Invalid classifier file: " + this.testing_to_load_classifiers_file);
                    }
                    SegmentedClassification[] resulting_classifications = doer.classify(this.save_file, trained);
                    System.out.println("\n");
                    if (doer.data_board.model_classifications != null) {
                        StringBuffer out = new StringBuffer();
                        String success = InstanceClassifier.getSuccessString(doer.data_board.model_classifications, resulting_classifications, out);
                        System.out.println(out + success);
                        break block18;
                    }
                    for (int i = resulting_classifications.length - 1; i >= 0; --i) {
                        if (resulting_classifications[i].sub_classifications != null) {
                            for (int j = 0; j < resulting_classifications[i].sub_classifications.length; ++j) {
                                System.out.println("\t\tSUBSECTION: " + resulting_classifications[i].sub_classifications[j].start + " to " + resulting_classifications[i].sub_classifications[j].stop + " \n\t\t\tCLASSIFICATION: " + resulting_classifications[i].sub_classifications[j].classifications[0]);
                            }
                            continue;
                        }
                        System.out.println("INSTANCE: " + resulting_classifications[i].identifier + " \n\tCLASSIFICATION: " + resulting_classifications[i].classifications[0]);
                    }
                    break block18;
                }
                if (this.cross_validation_string != null) {
                    String file_name = this.save_file;
                    int number_folds = new Integer(this.cross_validation_string);
                    if (number_folds < 2) {
                        throw new Exception("Must be at least 2 cross-validation folds");
                    }
                    PrintStream out = System.out;
                    System.out.println(doer.crossValidate(this.max_spread, this.max_membership, this.order_randomly, file_name, this.classifier_type, this.feature_selector, number_folds, max_attribute, out, this.verbose));
                    break block18;
                }
                if (this.experimentation_string != null) {
                    int number_folds;
                    String file_name = "experimentation_results";
                    if (this.save_file != null && StringMethods.getExtension((String)(file_name = this.save_file)) != null) {
                        file_name = StringMethods.removeExtension((String)file_name);
                    }
                    if ((number_folds = new Integer(this.experimentation_string).intValue()) < 2) {
                        throw new Exception("Must be at least 2 cross-validation folds");
                    }
                    PrintStream output = System.out;
                    String out = doer.experiment(this.max_spread, this.max_membership, this.order_randomly, file_name, number_folds, output, this.verbose, max_attribute);
                    System.out.println(out);
                    break block18;
                }
                throw new Exception("Neither training nor testing nor cross-validation nor experimentation specified.");
            }
            catch (Exception e) {
                System.out.println("ERROR: " + e.getMessage() + "\n");
                e.printStackTrace();
            }
        }
    }

    public void processZip() throws Exception {
        if (this.dozip != null) {
            ParseACEZipFile.saveZip(this.dozip, this.zip_file);
        } else if (this.unzip) {
            ParseACEZipFile.parseZip(this.zip_file, this.zip_directory);
        } else if (this.zip_add != null) {
            ParseACEZipFile.add(this.zip_file, this.zip_add);
        } else if (this.zip_extract != null) {
            ParseACEZipFile.extract(this.zip_extract, this.zip_file, this.file_type, this.zip_directory);
        }
    }

    public static void printHelpMessage() {
        System.out.println("\nThis is the ACE classification system.\n\nThis utility loads a taxonomy, set of feature definitions, feature definitions and/or model classifications and uses them to train a, classifier or extract a classification from a trined classifier.\n\nThe command line options are as follows:\n\nGENERAL OPTIONS:\n-help: Dispay a guide to this utility. No option is needed\n\nZIP UTILITIES:\n-dozip: Compress following list of files into a zip file. -zipfileflag is required.\n-unzip: Decompress entire contents of given zip file. The -zipfile flag is required.\n-zip_add: Add a single file or single directory to the given zip file.The -zipfile flag is required\n-zip_extract: Extract a single file or all files of a specified ACE XML type (if -filetype flag is present) from the given zip file.The -zipfile flag is required.\n-filetype: Specifies the type of files to be extracted. This flagis only used in conjunction with the -extract flag. All files of the specified type will be extracted from the given zip file. \nAccepted file types are:\n\t>\"taxonomy_file\"\n\t>\"feature_key_file\"\n\t>\"feature_vector_file\"\n\t>\"classifications_file\"\n\t>\"project_file\"\n-zipfile: \n\tWhen decompressing: the zip file from which to extract.\n\tWhen compressing: the name of the zip file into which files will be compressed.-zip_dir: The directory into which the files should be extracted.\n\nLOADING OPTIONS:\n-proj: Automatically load an ACE project from the ACE XML project file specified by the single opiton.\n-lzip: Load an ACE project from an ACE zip file. Option is the path name of zip file.\n-ltax: Load the specified taxonomy_file XML file.\n-lfkey: Load the specified feature_key_file XML file.\n-lfvec: Load the specified feature_vector_file XML file(s).\n-lmclas: Load the specified classifications_file XML file(s).\n-arff: Load training or testing data from an ARFF file instead of XML files(s).Note that it is assumed that the class attribute is the last attribute.\n\nTRAINING OPTIONS:\n-train: Train the Classifier\n-learner: (required flag) Specify the type of Classifier to be trained.\nTypes of classifiers can be specified in accordance to the following codes:\n\t>Unweighted k-nn (k = 1): IBk\n\t>Naive Bayesian: NaiveBayes\n\t>Support Vector Machine: SMO\n\t>C4.5 Decision Tree: J48\n\t>Backprop Neural Network: MultilayerPerceptron\n\t>AdaBoost: AdaBoostM1\t>AdaBoost: Bagging\n-sres: (required flag) Specify the name of the file in which the trained classifier will be saved.\n-dr: Takes single option specifying the type of dimensionality reduction to be performed.\nIf null, no dimensionality reduction will be performed.\nCodes for feature selectors are as follows:\n\t>Principal Componants: PCA\n\t>Exhaustive search using naive Bayesian classifier: EXB\n\t>Genetic search using naive Bayesian classifier: GNB\n-sarff: Saves training data to an arff file after parsing, afterthinning and again after feature selection, if any. Useful for testing.\n-max_spread: The maximum ratio between the number of training instancesbelonging to any class compared to the least populous class.\n-max_memb: The maximum number of training instances that may belong to each class.\n-rand_ord: The presence of this flag causes training instances to be randomly reordered.\n-verbose: Prints detailed information about the dimensionality reduction that was performed.\n\nCLASSIFYING OPTIONS:\n-classify: Perform classifications using a trained classifier.Load the given classifier info to perform the classification.\n-sarff: Saves testing data to an arff file after parsing and again after feature selection, if any. Useful for testing.\n-sres: Save the test results in an ACE XML classifications fileor an arff file, depending on the filetype of the input data.\n\nCROSS-VALIDATING OPTIONS:\n-cv: Perform a cross validation. Must specify number of folds as option.\n-learner: (required flag) Specify the type of Weka Classifier to be used during cross validation\nTypes of classifiers can be specified in accordance to the following codes:\n\t>Unweighted k-nn (k = 1): IBk\n\t>Naive Bayesian: NaiveBayes\n\t>Support Vector Machine: SMO\n\t>C4.5 Decision Tree: J48\n\t>Backprop Neural Network: MultilayerPerceptron\n\t>AdaBoost: AdaBoostM1\n\t>AdaBoost: Bagging\n-sres: Saves results in a text file with the given name. If not present, results are only printed to standard out.\n-fs: Takes single option specifying the type of dimensionality to be performed.If null, no feature selection will be performed.\nCodes for feature selectors are as follows:\n\t>Principal Componants: PCA\n\t>Exhaustive search using naive Bayesian classifier: EXB\n\t>Genetic search using naive Bayesian classifier: GNB\n-sarff: Saves training data to an arff file after parsing, after thinning and again after feature selection, if any. Useful for testing.\n-max_spread: The maximum ratio between the number of training instances belonging to any class compared to the least populous class.\n-max_memb: The maximum number of training instances that may belong to each class.\n-rand_ord: The presence of this flag causes training instances to be randomly reordered.\n-verbose: The results for the paritioning and classification of each individual instance is printed and saved as well as detailed information about the dimensionality reduction that was performed. Incorrect classifications are marked with an asterix.\n\nEXPERIMENTATION OPTIONS\n-exp: Perform a cross-validation and output the results to standard out. Specifies the number of cross-validation folds.\n-sres: Saves results in files with the given base file name. If not present, results are saved with default base file name.\n-sarff: Saves training data to an arff file after parsing, after thinning and again after feature selection, if any. Useful for testing.\n-max_spread: The maximum ratio between the number of training instances belonging to any class compared to the least populous class.\n-max_memb: The maximum number of training instances that may belong to each class.\n-rand_ord: The presence of this flag causes training instances to be randomly reordered.\n-verbose: The presence of this flag causes extra information about the dimensionality reduction to be printed and saved.");
    }

    public void dumpContents() {
        System.out.println("project_path: " + this.project_path);
        System.out.println("zip_file: " + this.zip_file);
        System.out.println("zip_directory: " + this.zip_directory);
        System.out.println("train: " + this.train);
        System.out.println("classifier_type: " + this.classifier_type);
        System.out.println("testing_to_load_classifiers_file: " + this.testing_to_load_classifiers_file);
        System.out.println("save_file: " + this.save_file);
        System.out.println("cross_validation_string: " + this.cross_validation_string);
        System.out.println("experimentation_string: " + this.experimentation_string);
        System.out.println("dimensionality reduction: " + this.feature_selector);
        System.out.println("order_randomly: " + this.order_randomly);
        System.out.println("max_spread: " + this.max_spread);
        System.out.println("max_membership: " + this.max_membership);
        System.out.println("save_intermediate_arffs: " + this.save_intermediate_arffs);
        System.out.println("taxonomy_file: " + this.taxonomy_file);
        System.out.println("feature_key_file: " + this.feature_key_file);
        System.out.println("classifications_file: " + this.classifications_file);
        System.out.println("feature_vector_files[0]: " + this.feature_vector_files[0]);
        System.out.println("arff_file: " + this.arff_file);
    }
}

