/*
 * Decompiled with CFR 0.152.
 */
package ace;

import java.io.OutputStream;
import java.util.LinkedList;
import weka.attributeSelection.ASEvaluation;
import weka.attributeSelection.ASSearch;
import weka.attributeSelection.AttributeSelection;
import weka.attributeSelection.ClassifierSubsetEval;
import weka.attributeSelection.ExhaustiveSearch;
import weka.attributeSelection.GeneticSearch;
import weka.attributeSelection.PrincipalComponents;
import weka.attributeSelection.Ranker;
import weka.classifiers.Classifier;
import weka.classifiers.bayes.NaiveBayes;
import weka.core.Attribute;
import weka.core.Instances;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DimensionalityReducer {
    public static String getSelectedFeatureNames(AttributeSelection feature_selection, int original_number_features, Instances instances) throws Exception {
        String report = new String();
        if (instances != null) {
            int i;
            int[] selected_features = feature_selection.selectedAttributes();
            String[] feature_names = new String[selected_features.length - 1];
            for (i = 0; i < feature_names.length; ++i) {
                Attribute this_attribute = instances.attribute(selected_features[i]);
                feature_names[i] = this_attribute.name();
            }
            report = report + "\nSELECTED FEATURES (" + feature_names.length + " of " + original_number_features + "):";
            for (i = 0; i < feature_names.length; ++i) {
                report = report + "\n\t" + feature_names[i];
            }
        } else {
            report = feature_selection.toResultsString();
        }
        return report + "\n";
    }

    public static Instances[] getDimensionallyReducedInstances(Instances instances, LinkedList<String> selectors, LinkedList<String> selector_descriptions, LinkedList<String> features_selected, double[][] preparation_times, OutputStream out, boolean verbose, int max_attribute) throws Exception {
        int original_number_features = instances.numAttributes() - 1;
        selector_descriptions.clear();
        features_selected.clear();
        out.write("\nPreparing feature selectors...".getBytes());
        AttributeSelection[] feature_selections = DimensionalityReducer.getFeatureSelectors(instances, selectors, selector_descriptions, preparation_times, max_attribute, out);
        Instances[] instances_dimensionally_reduced = new Instances[feature_selections.length + 1];
        Instances these_instances = null;
        for (int i = 0; i < instances_dimensionally_reduced.length; ++i) {
            out.write(("\nPerforming selection " + (i + 1) + " of " + instances_dimensionally_reduced.length + "...").getBytes());
            if (i == instances_dimensionally_reduced.length - 1) {
                these_instances = instances;
                selector_descriptions.add("No feature selection");
                features_selected.add(DimensionalityReducer.getFormattedSelectedFeatureNames(these_instances, original_number_features));
                double[][] temp_times = new double[1][preparation_times[0].length + 1];
                for (int j = 0; j < preparation_times[0].length; ++j) {
                    temp_times[0][j] = preparation_times[0][j];
                }
                temp_times[0][preparation_times[0].length] = 0.0;
                preparation_times[0] = temp_times[0];
                instances_dimensionally_reduced[i] = these_instances;
                continue;
            }
            these_instances = new Instances(instances);
            long start_time = System.currentTimeMillis();
            feature_selections[i].SelectAttributes(these_instances);
            these_instances = feature_selections[i].reduceDimensionality(these_instances);
            long stop_time = System.currentTimeMillis();
            if (verbose) {
                features_selected.add(feature_selections[i].toResultsString());
            } else {
                features_selected.add(DimensionalityReducer.getFormattedSelectedFeatureNames(these_instances, original_number_features));
            }
            double[] dArray = preparation_times[0];
            int n = i;
            dArray[n] = dArray[n] + (double)(stop_time - start_time) / 60000.0;
            instances_dimensionally_reduced[i] = these_instances;
        }
        return instances_dimensionally_reduced;
    }

    public static String getFormattedSelectedFeatureNames(Instances instances, int original_number_features) {
        int num_features = instances.numAttributes() - 1;
        String results = "SELECTED FEATURES (" + num_features + " of " + original_number_features + "):\n";
        for (int i = 0; i < num_features; ++i) {
            if (i == instances.classIndex()) continue;
            results = results + "\t" + instances.attribute(i).name() + "\n";
        }
        return results + "\n";
    }

    public static AttributeSelection[] getFeatureSelectors(Instances instances, LinkedList<String> selectors, LinkedList<String> selector_descriptions, double[][] preparation_times, int max_attribute, OutputStream out) throws Exception {
        long stop_time;
        long start_time;
        LinkedList<AttributeSelection> feature_selectors = new LinkedList<AttributeSelection>();
        LinkedList<Double> preparation_times_list = new LinkedList<Double>();
        selector_descriptions.clear();
        Ranker this_search_method = null;
        PrincipalComponents this_evaluation_method = null;
        NaiveBayes this_evaluation_classifier = null;
        AttributeSelection this_feature_selector = null;
        if (selectors.contains("PCA")) {
            start_time = System.currentTimeMillis();
            this_search_method = new Ranker();
            this_evaluation_method = new PrincipalComponents();
            this_feature_selector = new AttributeSelection();
            this_feature_selector.setSearch((ASSearch)this_search_method);
            this_feature_selector.setEvaluator((ASEvaluation)this_evaluation_method);
            stop_time = System.currentTimeMillis();
            feature_selectors.add(this_feature_selector);
            selector_descriptions.add("Principal Components Analysis (PCA)");
            preparation_times_list.add(new Double((double)(stop_time - start_time) / 60000.0));
        }
        if (selectors.contains("EXB")) {
            if (instances.numAttributes() <= max_attribute) {
                start_time = System.currentTimeMillis();
                this_search_method = new ExhaustiveSearch();
                this_evaluation_method = new ClassifierSubsetEval();
                this_evaluation_classifier = new NaiveBayes();
                ((ClassifierSubsetEval)this_evaluation_method).setClassifier((Classifier)this_evaluation_classifier);
                ((ClassifierSubsetEval)this_evaluation_method).buildEvaluator(instances);
                ((ClassifierSubsetEval)this_evaluation_method).setUseTraining(true);
                this_feature_selector = new AttributeSelection();
                this_feature_selector.setSearch((ASSearch)this_search_method);
                this_feature_selector.setEvaluator((ASEvaluation)this_evaluation_method);
                stop_time = System.currentTimeMillis();
                feature_selectors.add(this_feature_selector);
                selector_descriptions.add("Exhaustive search using naive Bayesian classifier");
                preparation_times_list.add(new Double((double)(stop_time - start_time) / 60000.0));
            } else {
                out.write(("WARNING: Exhaustive search will not be performed because data has more than " + max_attribute + " attributes.").getBytes());
            }
        }
        if (selectors.contains("GNB")) {
            start_time = System.currentTimeMillis();
            this_search_method = new GeneticSearch();
            this_evaluation_method = new ClassifierSubsetEval();
            this_evaluation_classifier = new NaiveBayes();
            ((ClassifierSubsetEval)this_evaluation_method).setClassifier((Classifier)this_evaluation_classifier);
            ((ClassifierSubsetEval)this_evaluation_method).buildEvaluator(instances);
            ((ClassifierSubsetEval)this_evaluation_method).setUseTraining(true);
            this_feature_selector = new AttributeSelection();
            this_feature_selector.setSearch((ASSearch)this_search_method);
            this_feature_selector.setEvaluator((ASEvaluation)this_evaluation_method);
            stop_time = System.currentTimeMillis();
            feature_selectors.add(this_feature_selector);
            selector_descriptions.add("Genetic search using naive Bayesian classifier");
            preparation_times_list.add(new Double((double)(stop_time - start_time) / 60000.0));
            Double[] times = preparation_times_list.toArray(new Double[1]);
            preparation_times[0] = new double[times.length];
            for (int i = 0; i < preparation_times.length; ++i) {
                preparation_times[0][i] = times[i];
            }
        }
        return feature_selectors.toArray(new AttributeSelection[1]);
    }
}

