/*
 * Decompiled with CFR 0.152.
 */
package ace;

import ace.Coordinator;
import ace.CrossValidator;
import ace.DimensionalityReducer;
import ace.InstanceClassifier;
import ace.Trainer;
import ace.datatypes.CrossValidationResults;
import ace.datatypes.TrainedModel;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.text.DecimalFormat;
import java.util.LinkedList;
import mckay.utilities.staticlibraries.ArrayMethods;
import mckay.utilities.staticlibraries.MathAndStatsMethods;
import weka.attributeSelection.AttributeSelection;
import weka.classifiers.Classifier;
import weka.classifiers.bayes.NaiveBayes;
import weka.classifiers.functions.MultilayerPerceptron;
import weka.classifiers.functions.SMO;
import weka.classifiers.lazy.IBk;
import weka.classifiers.meta.AdaBoostM1;
import weka.classifiers.meta.Bagging;
import weka.classifiers.trees.J48;
import weka.core.Instances;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Experimenter {
    OutputStream out;

    public Experimenter(OutputStream out) {
        this.out = out;
    }

    public String crossValidateMultiApproaches(int folds, Instances instances, String results_base_file_name, boolean save_intermediate_arffs, boolean verbose, int max_attribute, String[] identifiers, int num_overall, String[] hierarchy) throws Exception {
        LinkedList<String> classifier_descriptions_list = new LinkedList<String>();
        LinkedList<String> selector_descriptions_list = new LinkedList<String>();
        LinkedList<String> features_selected_list = new LinkedList<String>();
        LinkedList<String> selectors = new LinkedList<String>();
        selectors.add("PCA");
        selectors.add("EXB");
        selectors.add("GNB");
        double[][] preparation_times = new double[1][];
        DecimalFormat df = new DecimalFormat("####0.0#");
        int num_validation = (int)Math.ceil(num_overall / (folds + 1));
        LinkedList<String> pub_names = new LinkedList<String>();
        Instances valid = this.getPublicationSet(instances, pub_names, identifiers, hierarchy, num_validation, num_overall);
        num_overall -= num_validation;
        Object[] hierarchy2 = ArrayMethods.removeNullEntriesFromArray((Object[])hierarchy);
        hierarchy = new String[hierarchy2.length];
        for (int i = 0; i < hierarchy2.length; ++i) {
            hierarchy[i] = hierarchy2[i].toString();
        }
        Instances[] instances_array = DimensionalityReducer.getDimensionallyReducedInstances(instances, selectors, selector_descriptions_list, features_selected_list, preparation_times, this.out, verbose, max_attribute);
        String[] selector_descriptions = selector_descriptions_list.toArray(new String[1]);
        String[] features_selected = features_selected_list.toArray(new String[1]);
        double[] best_error_rates_accross_feature_sets = new double[instances_array.length];
        String[] best_classifiers_accross_feature_sets = new String[instances_array.length];
        CrossValidationResults[][] cvres = new CrossValidationResults[instances_array.length][];
        int[] best_indices = new int[instances_array.length];
        for (int inst = 0; inst < instances_array.length; ++inst) {
            StringBuffer cv_results = new StringBuffer();
            this.out.write("\n+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++\n".getBytes());
            this.out.write("+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++\n".getBytes());
            this.out.write("+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++\n\n\n".getBytes());
            this.out.write(("Processing feature set " + (inst + 1) + " of " + instances_array.length + "...\n").getBytes());
            this.out.write(("DIMENSIONALITY REDUCTION: " + selector_descriptions[inst] + "\n").getBytes());
            this.out.write(("TIME TAKEN: " + preparation_times[0][inst] + " minutes\n").getBytes());
            this.out.write((features_selected[inst] + "\n").getBytes());
            Classifier[] classifiers = Coordinator.getAllUntrainedClassifiers(classifier_descriptions_list);
            int[] partition_array = CrossValidator.generatePartitionArray(folds, num_overall);
            CrossValidator cver = new CrossValidator(instances_array[inst], partition_array, folds, hierarchy, identifiers);
            cvres[inst] = CrossValidationResults.generateArray(classifier_descriptions_list);
            for (int i = 0; i < classifiers.length; ++i) {
                TrainedModel trained = new TrainedModel();
                trained.classifier = classifiers[i];
                this.out.write(("Testing classifier " + (i + 1) + " of " + classifiers.length + "...\n").getBytes());
                String file_name = null;
                cver.crossValidate(trained, cvres[inst], instances_array[inst], this.out, cv_results, file_name, cvres[inst][i].classifier_descriptions, save_intermediate_arffs, verbose, i);
            }
            double[] error_rates = new double[cvres[inst].length];
            for (int i = 0; i < cvres[inst].length; ++i) {
                error_rates[i] = cvres[inst][i].error_rates;
            }
            StringBuffer best_results = new StringBuffer();
            int best_indice = MathAndStatsMethods.getIndexOfSmallest((double[])error_rates);
            cv_results.append("\n\n==================================================\n");
            cv_results.append("==================================================\n\n");
            best_results.append("\n\n------------------------------------------------------------------\n");
            best_results.append("---------------------------BEST RESULTS---------------------------\n");
            best_results.append("------------------------------------------------------------------\n\n");
            best_results.append("BEST CLASSIFIER: " + classifier_descriptions_list.get(best_indice));
            best_results.append("\nBEST DIMENSIONALITY REDUCTION: " + selector_descriptions[inst]);
            best_results.append("\nTIME TAKEN: " + preparation_times[0][inst] + " minutes\n");
            best_results.append(features_selected[inst] + "\n");
            best_results.append("\nBEST SUCCESS RATE: " + df.format(100.0 - cvres[inst][best_indice].error_rates) + "%");
            best_results.append("\nBEST ERROR RATE: " + df.format(cvres[inst][best_indice].error_rates) + "%");
            best_results.append("\nBEST STANDARD DEVIATION: " + df.format(cvres[inst][best_indice].standard_deviation) + "%");
            best_results.append("\nNUMBER OF FOLDS: " + folds + "\n");
            best_results.append("\nCONFUSION MATRIX: \n" + cvres[inst][best_indice].cross_validation_confusion_matrices);
            best_error_rates_accross_feature_sets[inst] = error_rates[best_indice];
            best_indices[inst] = best_indice;
            best_classifiers_accross_feature_sets[inst] = best_results.toString();
            best_results.append("\n\n------------------------------------------------------------------\n");
            best_results.append("----------------------INDIVIDUAL CLASSIFIERS----------------------\n");
            best_results.append("------------------------------------------------------------------\n\n");
            best_results.append(cv_results);
            if (results_base_file_name == null) continue;
            File save_file = new File(results_base_file_name + "_" + (inst + 1) + ".txt");
            FileOutputStream to = new FileOutputStream(save_file);
            DataOutputStream writer = new DataOutputStream(to);
            writer.writeBytes(best_results.toString());
        }
        this.out.flush();
        int best_indice_overall = MathAndStatsMethods.getIndexOfSmallest((double[])best_error_rates_accross_feature_sets);
        StringBuffer best_results_report = new StringBuffer();
        int best_indice = best_indices[best_indice_overall];
        TrainedModel publication_model = cvres[best_indice_overall][best_indice].trained;
        Experimenter.resetClassifier(publication_model);
        if (best_indice_overall < best_indices.length - 1) {
            AttributeSelection[] selects = DimensionalityReducer.getFeatureSelectors(instances, selectors, selector_descriptions_list, preparation_times, max_attribute, this.out);
            selects[best_indice_overall].SelectAttributes(instances);
            selects[best_indice_overall].reduceDimensionality(instances);
            valid = selects[best_indice_overall].reduceDimensionality(valid);
        }
        Trainer.train(instances_array[best_indice_overall], publication_model);
        Instances validated = InstanceClassifier.classifyInstances(publication_model, valid, save_intermediate_arffs);
        String[] classes = CrossValidator.getClassNames(instances);
        double correct = InstanceClassifier.getCorrectCount(valid, validated);
        double success_rate = 100.0 * correct / (double)num_validation;
        double error_rate = 100.0 - success_rate;
        double[][] confusion_matrix = InstanceClassifier.getConfusionMatrix(valid, validated, classes);
        String confusion_string = InstanceClassifier.formatConfusionMatrix(confusion_matrix, classes);
        best_results_report.append("\n\n------------------------------------------------------------------\n");
        best_results_report.append("-----------VALIDATION RESULTS FOR BEST FOUND CLASSIFIER-----------\n");
        best_results_report.append("------------------------------------------------------------------\n");
        if (verbose) {
            String[][] names_array = new String[2][num_validation];
            names_array[1] = pub_names.toArray(names_array[1]);
            best_results_report.append(CrossValidator.getClassifications(valid, validated, instances_array[best_indice_overall], names_array));
        }
        best_results_report.append("\nBEST FOUND CLASSIFIER: " + (String)classifier_descriptions_list.get(best_indice));
        best_results_report.append("\nDIMENSIONALITY REDUCTION: " + selector_descriptions[best_indice_overall]);
        best_results_report.append("\n" + features_selected[best_indice_overall] + "\n");
        best_results_report.append("\nSUCCESS RATE: " + df.format(success_rate) + "%");
        best_results_report.append("\nERROR RATE: " + df.format(error_rate) + "%");
        best_results_report.append("\nCONFUSION MATRIX: \n" + confusion_string);
        if (results_base_file_name != null) {
            File save_file = new File(results_base_file_name + "_best_overall.txt");
            FileOutputStream to = new FileOutputStream(save_file);
            DataOutputStream writer = new DataOutputStream(to);
            writer.writeBytes(best_results_report.toString() + best_classifiers_accross_feature_sets[best_indice_overall]);
        }
        return best_classifiers_accross_feature_sets[best_indice_overall] + best_results_report.toString();
    }

    public static void resetClassifier(TrainedModel trained) throws Exception {
        String[] options = trained.classifier.getOptions();
        if (trained.classifier instanceof IBk) {
            trained.classifier = new IBk();
        }
        if (trained.classifier instanceof NaiveBayes) {
            trained.classifier = new NaiveBayes();
        }
        if (trained.classifier instanceof SMO) {
            trained.classifier = new SMO();
        }
        if (trained.classifier instanceof J48) {
            trained.classifier = new J48();
        }
        if (trained.classifier instanceof MultilayerPerceptron) {
            trained.classifier = new MultilayerPerceptron();
        }
        if (trained.classifier instanceof AdaBoostM1) {
            trained.classifier = new AdaBoostM1();
        }
        if (trained.classifier instanceof Bagging) {
            trained.classifier = new Bagging();
        }
        trained.classifier.setOptions(options);
    }

    private Instances getPublicationSet(Instances instances, LinkedList<String> pub_names, String[] identifiers, String[] hierarchy, int num_validation, int num_overall) {
        int[] overall = CrossValidator.getIndecesOfOverallInstances(hierarchy, num_overall);
        Instances valid = new Instances(instances, num_validation);
        LinkedList<String> names_list = new LinkedList<String>();
        LinkedList<Integer> overall_indeces = new LinkedList<Integer>();
        LinkedList indeces_list = new LinkedList();
        for (int i = 0; i < overall.length; ++i) {
            names_list.add(identifiers[i]);
            overall_indeces.add(overall[i]);
        }
        for (int inst = 0; inst < num_validation; ++inst) {
            int random = MathAndStatsMethods.generateRandomNumber((int)overall_indeces.size());
            int indece = (Integer)overall_indeces.get(random);
            valid.add(instances.instance(indece));
            indeces_list.add(overall_indeces.get(random));
            pub_names.add((String)names_list.get(random));
            Integer[] subsection_indeces = CrossValidator.getIndecesOfSubsections(hierarchy, ((Integer)overall_indeces.get(random)).toString());
            for (int i = 0; i < subsection_indeces.length; ++i) {
                valid.add(instances.instance(subsection_indeces[i].intValue()));
                indeces_list.add(subsection_indeces[i]);
                pub_names.add((String)names_list.get(subsection_indeces[i]));
            }
            overall_indeces.remove(random);
            names_list.remove(random);
        }
        Instances instances2 = new Instances(instances);
        String[] hierarchy2 = hierarchy;
        instances.delete();
        int j = 0;
        for (int i = 0; i < instances2.numInstances(); ++i) {
            if (indeces_list.contains(new Integer(i))) continue;
            instances.add(instances2.instance(i));
            hierarchy[j] = hierarchy2[i];
            ++j;
        }
        if (j < hierarchy.length) {
            for (int k = j; k < hierarchy.length; ++k) {
                hierarchy[k] = null;
            }
        }
        return valid;
    }
}

