/*
 * Decompiled with CFR 0.152.
 */
package ace;

import ace.datatypes.DataBoard;
import ace.datatypes.SegmentedClassification;
import ace.datatypes.TrainedModel;
import java.io.File;
import java.text.DecimalFormat;
import mckay.utilities.staticlibraries.MathAndStatsMethods;
import mckay.utilities.staticlibraries.StringMethods;
import weka.core.Instances;
import weka.core.Utils;
import weka.core.converters.ArffSaver;

public class InstanceClassifier {
    public static SegmentedClassification[] classify(TrainedModel trained, DataBoard data_board, Instances instances, String results_file, boolean save_intermediate_arffs) throws Exception {
        boolean use_top_level_features = true;
        boolean use_sub_section_features = true;
        SegmentedClassification[] resulting_classifications = data_board.getClassifiedResults(instances, save_intermediate_arffs, trained, use_top_level_features, use_sub_section_features);
        for (int i = 0; i < resulting_classifications.length; ++i) {
            SegmentedClassification.mergeAdjacentSections(resulting_classifications[i]);
        }
        if (results_file != null) {
            if (StringMethods.getExtension((String)results_file).equals(".arff")) {
                ArffSaver saver = new ArffSaver();
                saver.setInstances(instances);
                saver.setFile(new File(results_file));
                saver.setDestination(new File(results_file));
                saver.writeBatch();
            } else if (StringMethods.getExtension((String)results_file).equals(".xml")) {
                SegmentedClassification.saveClassifications(resulting_classifications, new File(results_file), "");
            }
        }
        return resulting_classifications;
    }

    public static Instances classifyInstances(TrainedModel trained, Instances instances, boolean save_intermediate_arffs) throws Exception {
        Instances classified = new Instances(instances);
        for (int inst = 0; inst < instances.numInstances(); ++inst) {
            double predicted = trained.classifier.classifyInstance(instances.instance(inst));
            classified.instance(inst).setClassValue(predicted);
        }
        return classified;
    }

    public static double[][] getConfusionMatrix(Instances model, Instances classified, String[] classes) {
        int num_classes = classes.length;
        double[][] matrix = new double[num_classes][num_classes];
        for (int inst = 0; inst < model.numInstances(); ++inst) {
            int predicted = (int)classified.instance(inst).classValue();
            int actual = (int)model.instance(inst).classValue();
            double[] dArray = matrix[actual];
            int n = predicted;
            dArray[n] = dArray[n] + 1.0;
        }
        return matrix;
    }

    public static String formatConfusionMatrix(double[][] matrix, String[] classes) {
        int j;
        int i;
        int num_classes = classes.length;
        StringBuffer text = new StringBuffer();
        char[] IDChars = new char[]{'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z'};
        boolean fractional = false;
        double maxval = 0.0;
        for (i = 0; i < num_classes; ++i) {
            for (j = 0; j < num_classes; ++j) {
                double current = matrix[i][j];
                if (current < 0.0) {
                    current *= -10.0;
                }
                if (current > maxval) {
                    maxval = current;
                }
                double fract = current - Math.rint(current);
                if (fractional || !(Math.log(fract) / Math.log(10.0) >= -2.0)) continue;
                fractional = true;
            }
        }
        int IDWidth = 1 + Math.max((int)(Math.log(maxval) / Math.log(10.0) + (double)(fractional ? 3 : 0)), (int)(Math.log(num_classes) / Math.log(IDChars.length)));
        for (i = 0; i < num_classes; ++i) {
            if (fractional) {
                text.append(" ").append(InstanceClassifier.num2ShortID(i, IDChars, IDWidth - 3)).append("   ");
                continue;
            }
            text.append(" ").append(InstanceClassifier.num2ShortID(i, IDChars, IDWidth));
        }
        text.append("   <-- classified as\n");
        for (i = 0; i < num_classes; ++i) {
            for (j = 0; j < num_classes; ++j) {
                text.append(" ").append(Utils.doubleToString((double)matrix[i][j], (int)IDWidth, (int)(fractional ? 2 : 0)));
            }
            text.append(" | ").append(InstanceClassifier.num2ShortID(i, IDChars, IDWidth)).append(" = ").append(classes[i]).append("\n");
        }
        return text.toString();
    }

    protected static String num2ShortID(int num, char[] IDChars, int IDWidth) {
        int i;
        char[] ID = new char[IDWidth];
        for (i = IDWidth - 1; i >= 0; --i) {
            ID[i] = IDChars[num % IDChars.length];
            if ((num = num / IDChars.length - 1) < 0) break;
        }
        --i;
        while (i >= 0) {
            ID[i] = 32;
            --i;
        }
        return new String(ID);
    }

    public static double getCorrectCount(Instances models, Instances results) {
        double correct_count = 0.0;
        for (int r = 0; r < results.numInstances(); ++r) {
            String model_clas = models.instance(r).stringValue(models.classIndex());
            String result_clas = results.instance(r).stringValue(results.classIndex());
            if (model_clas == null || result_clas == null || !model_clas.equals(result_clas)) continue;
            correct_count += 1.0;
        }
        return correct_count;
    }

    public static String getSuccessString(SegmentedClassification[] models, SegmentedClassification[] results, StringBuffer out) {
        double success_rate;
        DecimalFormat df = new DecimalFormat("####0.0#");
        double[] correct = InstanceClassifier.getSuccessRate(models, results, out);
        double total_count = correct[2];
        double total_sections = 0.0;
        for (int clas = 0; clas < results.length; ++clas) {
            if (results[clas].sub_classifications == null) continue;
            total_sections += (double)results[clas].sub_classifications.length;
        }
        double correct_overall = correct[0];
        double correct_sections = correct[1];
        String overall_results = "";
        String section_results = "";
        if (total_count != 0.0 && correct_overall != 0.0) {
            success_rate = 100.0 * correct_overall / total_count;
            overall_results = "\nSUCCESS RATES FOR OVERALL CLASSIFICATIONS:\n" + df.format(success_rate) + "%: " + correct_overall + " / " + total_count + "\n" + df.format(total_count - correct_overall) + " misclassifications.\n\n";
        }
        if (total_sections != 0.0 && correct_sections != 0.0) {
            success_rate = 100.0 * correct_sections / total_sections;
            section_results = "SUCCESS RATES FOR CLASSIFICATION OF SECTIONS:\n" + df.format(success_rate) + "%: " + correct_sections + " / " + total_sections + "\n" + df.format(total_sections - correct_sections) + " misclassifications.\n\n";
        }
        return overall_results + section_results;
    }

    private static double[] getSuccessRate(SegmentedClassification[] models, SegmentedClassification[] results, StringBuffer out) {
        double[] correct = new double[3];
        double correct_count = 0.0;
        int[] number_false_positives = new int[models.length];
        double sections_correct = 0.0;
        double sections_false_positives = 0.0;
        boolean unknowns = false;
        for (int r = 0; r < results.length; ++r) {
            for (int m = 0; m < models.length; ++m) {
                if (!models[m].identifier.equals(results[r].identifier)) continue;
                number_false_positives[m] = 0;
                String[] model_clas = models[m].classifications;
                String[] result_clas = results[r].classifications;
                if (model_clas != null && result_clas != null) {
                    correct[2] = correct[2] + 1.0;
                    double correct_number_classes = model_clas.length;
                    double found_number_classes = 0.0;
                    for (int r_clas = 0; r_clas < result_clas.length; ++r_clas) {
                        boolean found = false;
                        for (int m_clas = 0; m_clas < model_clas.length; ++m_clas) {
                            if (!model_clas[m_clas].equals(result_clas[r_clas])) continue;
                            found = true;
                            found_number_classes += 1.0;
                            m_clas = model_clas.length;
                        }
                        if (found) continue;
                        int n = m;
                        number_false_positives[n] = number_false_positives[n] + 1;
                    }
                    if (number_false_positives[m] > 0 && number_false_positives[m] == model_clas.length) {
                        out.append("*");
                    }
                    if (result_clas.length < model_clas.length && number_false_positives[m] < result_clas.length) {
                        out.append("^");
                    }
                    String classes = StringMethods.concatenateArrayOfStrings((String[])model_clas);
                    out.append("INSTANCE " + r + ": " + results[r].identifier + " \n\tPREDICTED CLASS: " + result_clas[0] + "     ACTUAL CLASS: " + classes + "\n");
                    double this_score = found_number_classes / correct_number_classes;
                    correct_count += this_score;
                } else {
                    out.append("INSTANCE " + r + ": " + results[r].identifier + " \n\tPREDICTED CLASS: " + result_clas[0] + "     ACTUAL CLASS: *UNKNOWN*\n");
                    unknowns = true;
                }
                SegmentedClassification[] mod_sec = models[m].sub_classifications;
                SegmentedClassification[] res_sec = results[r].sub_classifications;
                if (mod_sec != null && res_sec != null) {
                    int r_sec;
                    double[] mod_low_bound = new double[mod_sec.length];
                    double[] mod_high_bound = new double[mod_sec.length];
                    for (int i = 0; i < mod_sec.length; ++i) {
                        mod_low_bound[i] = mod_sec[i].start;
                        mod_high_bound[i] = mod_sec[i].stop;
                    }
                    double[] res_low_bound = new double[res_sec.length];
                    double[] res_high_bound = new double[res_sec.length];
                    for (int i = 0; i < res_sec.length; ++i) {
                        res_low_bound[i] = res_sec[i].start;
                        res_high_bound[i] = res_sec[i].stop;
                    }
                    String[][] model_labels_of_results = new String[res_sec.length][];
                    for (r_sec = 0; r_sec < res_sec.length; ++r_sec) {
                        model_labels_of_results[r_sec] = null;
                        double[] fraction_in = new double[mod_sec.length];
                        double result_length = res_high_bound[r_sec] - res_low_bound[r_sec];
                        for (int m_sec = 0; m_sec < mod_sec.length; ++m_sec) {
                            fraction_in[m_sec] = res_high_bound[r_sec] < mod_low_bound[m_sec] || res_low_bound[r_sec] > mod_high_bound[m_sec] ? 0.0 : (res_low_bound[r_sec] >= mod_low_bound[m_sec] && res_high_bound[r_sec] <= mod_high_bound[m_sec] ? 1.0 : (res_low_bound[r_sec] <= mod_low_bound[m_sec] && res_high_bound[r_sec] >= mod_high_bound[m_sec] ? (mod_high_bound[m_sec] - mod_low_bound[m_sec]) / result_length : (res_low_bound[r_sec] <= mod_low_bound[m_sec] && res_high_bound[r_sec] <= mod_high_bound[m_sec] && res_high_bound[r_sec] >= mod_low_bound[m_sec] ? (res_high_bound[r_sec] - mod_low_bound[m_sec]) / result_length : (res_low_bound[r_sec] >= mod_low_bound[m_sec] && res_high_bound[r_sec] >= mod_high_bound[m_sec] && res_low_bound[r_sec] <= mod_high_bound[m_sec] ? (mod_high_bound[m_sec] - res_low_bound[r_sec]) / result_length : 0.0))));
                        }
                        int best_m_sec = MathAndStatsMethods.getIndexOfLargest((double[])fraction_in);
                        model_labels_of_results[r_sec] = mod_sec[best_m_sec].classifications;
                    }
                    for (r_sec = 0; r_sec < res_sec.length; ++r_sec) {
                        String[] section_result_clas = res_sec[r_sec].classifications;
                        String[] section_model_clas = model_labels_of_results[r_sec];
                        double correct_number_classes = section_model_clas.length;
                        double found_number_classes = 0.0;
                        for (int r_clas = 0; r_clas < section_result_clas.length; ++r_clas) {
                            boolean found = false;
                            for (int m_clas = 0; m_clas < section_model_clas.length; ++m_clas) {
                                if (!section_model_clas[m_clas].equals(section_result_clas[r_clas])) continue;
                                found = true;
                                found_number_classes += 1.0;
                                m_clas = section_model_clas.length;
                            }
                            out.append("\t\t");
                            if (!found) {
                                sections_false_positives += 1.0;
                                out.append("*");
                            }
                            String sec_classes = StringMethods.concatenateArrayOfStrings((String[])section_model_clas);
                            out.append("SECTION " + r_sec + ": " + res_sec[r_sec].start + " to " + res_sec[r_sec].stop + " \n\t\t\tPREDICTED CLASS: " + section_result_clas[0] + "     ACTUAL CLASS: " + sec_classes + "\n");
                        }
                        double this_score = found_number_classes / correct_number_classes;
                        sections_correct += this_score;
                    }
                }
                m = models.length;
            }
        }
        if (unknowns) {
            out.append("\nWARNING: Some model instances were unlabelled and were not included in the calculation of success rates.\n");
        }
        correct[0] = correct_count;
        correct[1] = sections_correct;
        return correct;
    }
}

