/*
 * Decompiled with CFR 0.152.
 */
package ace.datatypes;

import ace.datatypes.DataSet;
import ace.xmlparsers.XMLDocumentParser;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.Serializable;
import java.util.Vector;
import mckay.utilities.staticlibraries.StringMethods;
import weka.core.Instances;

public class FeatureDefinition
implements Serializable {
    public String name;
    public String description;
    public boolean is_sequential;
    public int dimensions;
    private static final long serialVersionUID = 2L;

    public FeatureDefinition() {
        this.name = "Undefined Feature";
        this.description = new String("");
        this.is_sequential = false;
        this.dimensions = 1;
    }

    public FeatureDefinition(String name, String description, boolean is_sequential, int dimensions) {
        this.name = name;
        this.description = description;
        this.is_sequential = is_sequential;
        this.dimensions = dimensions;
    }

    public FeatureDefinition(Instances instances, int index) {
        this.name = instances.attribute(index).name();
        this.description = "";
        this.is_sequential = false;
        this.dimensions = 1;
    }

    public String getFeatureDescription() {
        String info = "NAME: " + this.name + "\n";
        info = info + "DESCRIPTION: " + this.description + "\n";
        info = info + "IS SEQUENTIAL: " + this.is_sequential + "\n";
        info = info + "DIMENSIONS: " + this.dimensions + "\n\n";
        return info;
    }

    public static String getFeatureDescriptions(FeatureDefinition[] definitions) {
        String combined_descriptions = new String();
        for (int i = 0; i < definitions.length; ++i) {
            combined_descriptions = combined_descriptions + definitions[i].getFeatureDescription();
        }
        return combined_descriptions;
    }

    public static FeatureDefinition[] parseFeatureDefinitionsFile(String feature_key_file_path) throws Exception {
        Object[] results = (Object[])XMLDocumentParser.parseXMLDocument(feature_key_file_path, "feature_key_file");
        FeatureDefinition[] parse_results = new FeatureDefinition[results.length];
        for (int i = 0; i < parse_results.length; ++i) {
            parse_results[i] = (FeatureDefinition)results[i];
        }
        String duplicates = FeatureDefinition.verifyFeatureNameUniqueness(parse_results);
        if (duplicates != null) {
            throw new Exception("Could not parse because there are multiple\noccurences of the following feature names:\n" + duplicates);
        }
        return parse_results;
    }

    public static void saveFeatureDefinitions(FeatureDefinition[] definitions, File to_save_to, String comments) throws Exception {
        String duplicates = FeatureDefinition.verifyFeatureNameUniqueness(definitions);
        if (duplicates != null) {
            throw new Exception("Could not save because there are multiple\noccurences of the following feature names:\n" + duplicates);
        }
        try {
            FileOutputStream to = new FileOutputStream(to_save_to);
            DataOutputStream writer = new DataOutputStream(to);
            String pre_tree_part = new String("<?xml version=\"1.0\"?>\n<!DOCTYPE feature_key_file [\n   <!ELEMENT feature_key_file (comments, feature+)>\n   <!ELEMENT comments (#PCDATA)>\n   <!ELEMENT feature (name, description?, is_sequential, parallel_dimensions)>\n   <!ELEMENT name (#PCDATA)>\n   <!ELEMENT description (#PCDATA)>\n   <!ELEMENT is_sequential (#PCDATA)>\n   <!ELEMENT parallel_dimensions (#PCDATA)>\n]>\n\n<feature_key_file>\n\n   <comments>" + comments + "</comments>\n\n");
            writer.writeBytes(pre_tree_part);
            for (int feat = 0; feat < definitions.length; ++feat) {
                writer.writeBytes("   <feature>\n");
                writer.writeBytes("      <name>" + definitions[feat].name + "</name>\n");
                if (!definitions[feat].description.equals("")) {
                    writer.writeBytes("      <description>" + definitions[feat].description + "</description>\n");
                }
                writer.writeBytes("      <is_sequential>" + definitions[feat].is_sequential + "</is_sequential>\n");
                writer.writeBytes("      <parallel_dimensions>" + definitions[feat].dimensions + "</parallel_dimensions>\n");
                writer.writeBytes("   </feature>\n\n");
            }
            writer.writeBytes("</feature_key_file>");
            writer.close();
        }
        catch (Exception e) {
            throw new Exception("Unable to write file " + to_save_to.getName() + ".");
        }
    }

    public static String verifyFeatureNameUniqueness(FeatureDefinition[] definitions) {
        boolean found_duplicate = false;
        Vector<String> duplicates = new Vector<String>();
        for (int i = 0; i < definitions.length - 1; ++i) {
            for (int j = i + 1; j < definitions.length; ++j) {
                if (!definitions[i].name.equals(definitions[j].name)) continue;
                found_duplicate = true;
                duplicates.add(definitions[i].name);
                j = definitions.length;
            }
        }
        if (found_duplicate) {
            Object[] duplicated_names_obj = duplicates.toArray();
            String[] duplicated_names = new String[duplicated_names_obj.length];
            for (int i = 0; i < duplicated_names.length; ++i) {
                duplicated_names[i] = (String)duplicated_names_obj[i];
            }
            String duplicates_formatted = new String();
            for (int i = 0; i < duplicated_names.length; ++i) {
                duplicates_formatted = duplicates_formatted + duplicated_names[i];
                if (i >= duplicated_names.length - 1) continue;
                duplicates_formatted = duplicates_formatted + ", ";
            }
            return duplicates_formatted;
        }
        return null;
    }

    public static FeatureDefinition[] getMergedFeatureDefinitions(FeatureDefinition[][] to_combine) throws Exception {
        int number_features = 0;
        for (int i = 0; i < to_combine.length; ++i) {
            number_features += to_combine[i].length;
        }
        FeatureDefinition[] feature_definitions_combined = new FeatureDefinition[number_features];
        int index_so_far = 0;
        for (int i = 0; i < to_combine.length; ++i) {
            for (int j = 0; j < to_combine[i].length; ++j) {
                feature_definitions_combined[index_so_far] = to_combine[i][j];
                ++index_so_far;
            }
        }
        String duplicates = FeatureDefinition.verifyFeatureNameUniqueness(feature_definitions_combined);
        if (duplicates != null) {
            throw new Exception("Could not combine the feature types becauase the\nFeature Definitions to be combined contain multiple\noccurences of the following feature names:\n" + duplicates);
        }
        return feature_definitions_combined;
    }

    public static FeatureDefinition[] generateFeatureDefinitions(DataSet[] feature_vectors) throws Exception {
        String[] features = DataSet.getFeatureNames(feature_vectors);
        features = StringMethods.removeDuplicateEntries((String[])features);
        FeatureDefinition[] generated = new FeatureDefinition[features.length];
        for (int i = 0; i < features.length; ++i) {
            generated[i] = new FeatureDefinition(features[i], "", false, 1);
        }
        return generated;
    }
}

