/*
 * Decompiled with CFR 0.152.
 */
package ace.datatypes;

import ace.datatypes.SegmentedClassification;
import ace.xmlparsers.XMLDocumentParser;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.Serializable;
import java.util.LinkedList;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import mckay.utilities.staticlibraries.StringMethods;
import weka.core.Instances;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Taxonomy
implements Serializable {
    public DefaultTreeModel taxonomy;
    private static final long serialVersionUID = 1L;

    public Taxonomy() {
        DefaultMutableTreeNode new_node = new DefaultMutableTreeNode("Taxonomy");
        this.taxonomy = new DefaultTreeModel(new_node);
    }

    public Taxonomy(String taxonomy_name) {
        DefaultMutableTreeNode new_node = new DefaultMutableTreeNode(taxonomy_name);
        this.taxonomy = new DefaultTreeModel(new_node);
    }

    public Taxonomy(DefaultTreeModel existing_taxonomy) {
        this.taxonomy = existing_taxonomy;
    }

    public Taxonomy(Instances instances) {
        DefaultMutableTreeNode new_node = new DefaultMutableTreeNode("TaxonomyFromARFF");
        this.taxonomy = new DefaultTreeModel(new_node);
        for (int i = 0; i < instances.classAttribute().numValues(); ++i) {
            this.addClass(instances.classAttribute().value(i));
        }
    }

    public void addClass(String new_class_name) {
        DefaultMutableTreeNode new_node = new DefaultMutableTreeNode(new_class_name);
        DefaultMutableTreeNode root_node = (DefaultMutableTreeNode)this.taxonomy.getRoot();
        this.taxonomy.insertNodeInto(new_node, root_node, root_node.getChildCount());
    }

    public void addChildClass(DefaultMutableTreeNode new_node, DefaultMutableTreeNode parent_node) {
        this.taxonomy.insertNodeInto(new_node, parent_node, parent_node.getChildCount());
    }

    public void addSiblingClass(DefaultMutableTreeNode new_node, DefaultMutableTreeNode sibling_node) throws Exception {
        int selected_index;
        DefaultMutableTreeNode parent_node = (DefaultMutableTreeNode)sibling_node.getParent();
        if (parent_node != null) {
            selected_index = parent_node.getIndex(sibling_node);
            if (selected_index == -1) {
                throw new Exception("Given sibling node is not in the taxonomy");
            }
        } else {
            throw new Exception("Parent of given sibling node is null.");
        }
        this.taxonomy.insertNodeInto(new_node, parent_node, selected_index + 1);
    }

    public void deleteClass(String name_of_class_to_delete) {
        DefaultMutableTreeNode root = (DefaultMutableTreeNode)this.taxonomy.getRoot();
        for (int i = 0; i < root.getChildCount(); ++i) {
            DefaultMutableTreeNode child = (DefaultMutableTreeNode)root.getChildAt(i);
            this.searchForBranchesToRemove(name_of_class_to_delete, child);
        }
    }

    public void deleteBranchOfTaxonomy(DefaultMutableTreeNode node_to_delete) throws Exception {
        if (node_to_delete.getParent() == null) {
            throw new Exception("Parent of given node to delete is null.");
        }
        this.taxonomy.removeNodeFromParent(node_to_delete);
    }

    public void setTaxonomyName(String taxonomy_name) {
        DefaultMutableTreeNode root = (DefaultMutableTreeNode)this.taxonomy.getRoot();
        root.setUserObject(taxonomy_name);
    }

    public String getFormattedTreeStructure() {
        if (this.taxonomy == null) {
            return new String("");
        }
        String output_text = new String();
        DefaultMutableTreeNode root = (DefaultMutableTreeNode)this.taxonomy.getRoot();
        for (int i = 0; i < root.getChildCount(); ++i) {
            DefaultMutableTreeNode child = (DefaultMutableTreeNode)root.getChildAt(i);
            output_text = output_text + Taxonomy.assembleTreeElements(child, 1);
        }
        return output_text;
    }

    public String[] getLeafLabels() {
        String[][] categories = this.getLeafsAndTheirParents();
        String[] leaf_categories = new String[categories.length];
        for (int i = 0; i < leaf_categories.length; ++i) {
            leaf_categories[i] = categories[i][0];
        }
        return leaf_categories;
    }

    public String[] getParentLabels() {
        DefaultMutableTreeNode root = (DefaultMutableTreeNode)this.taxonomy.getRoot();
        String[] parent_categories = new String[root.getChildCount()];
        DefaultMutableTreeNode this_parent = null;
        for (int i = 0; i < parent_categories.length; ++i) {
            this_parent = i == 0 ? (DefaultMutableTreeNode)root.getFirstChild() : this_parent.getNextSibling();
            parent_categories[i] = (String)this_parent.getUserObject();
        }
        return parent_categories;
    }

    public String[] getMiddleLabels() {
        String[][] categories = this.getLeafsAndTheirParents();
        String[] parent_categories = this.getParentLabels();
        LinkedList<String> categories_so_far = new LinkedList<String>();
        for (int i = 0; i < categories.length; ++i) {
            for (int j = 1; j < categories[i].length; ++j) {
                boolean present = false;
                for (int k = 0; k < parent_categories.length; ++k) {
                    if (!categories[i][j].equals(parent_categories[k])) continue;
                    present = true;
                    k = parent_categories.length + 1;
                }
                if (present) continue;
                boolean present_2 = false;
                for (int k = 0; k < categories_so_far.size(); ++k) {
                    if (!categories[i][j].equals((String)categories_so_far.get(k))) continue;
                    present_2 = true;
                    k = categories_so_far.size() + 1;
                }
                if (present_2) continue;
                categories_so_far.add(categories[i][j]);
            }
        }
        String[] final_categories = new String[categories_so_far.size()];
        for (int i = 0; i < categories_so_far.size(); ++i) {
            final_categories[i] = (String)categories_so_far.get(i);
        }
        return final_categories;
    }

    public String[][] getLeafsAndTheirParents() {
        int i;
        int k;
        int j;
        int i2;
        DefaultMutableTreeNode root = (DefaultMutableTreeNode)this.taxonomy.getRoot();
        String[][] results = new String[root.getLeafCount()][];
        DefaultMutableTreeNode leaf = root.getFirstLeaf();
        int count = 0;
        while (count < root.getLeafCount()) {
            TreeNode[] ancestry_uncasted = this.taxonomy.getPathToRoot(leaf);
            DefaultMutableTreeNode[] ancestry = new DefaultMutableTreeNode[ancestry_uncasted.length];
            for (i2 = 0; i2 < ancestry.length; ++i2) {
                ancestry[i2] = (DefaultMutableTreeNode)ancestry_uncasted[i2];
            }
            String[] ancestor_names = new String[ancestry.length - 1];
            for (i2 = 0; i2 < ancestry.length - 1; ++i2) {
                ancestor_names[i2] = (String)ancestry[i2 + 1].getUserObject();
            }
            results[count] = ancestor_names;
            ++count;
            leaf = leaf.getNextLeaf();
        }
        String[][] reversed_results = new String[results.length][];
        for (int i3 = 0; i3 < results.length; ++i3) {
            reversed_results[i3] = new String[results[i3].length];
            int k2 = 0;
            for (j = results[i3].length - 1; j >= 0; --j) {
                reversed_results[i3][k2] = results[i3][j];
                ++k2;
            }
            results[i3] = reversed_results[i3];
        }
        int replacement_count = 0;
        for (i2 = 0; i2 < results.length; ++i2) {
            for (j = 0; j < i2; ++j) {
                if (results[i2] == null || results[j] == null || !results[i2][0].equals(results[j][0])) continue;
                String[] temp = new String[results[i2].length - 1];
                int m = 1;
                for (int k3 = 0; k3 < results[i2].length - 1; ++k3) {
                    temp[k3] = results[i2][m];
                    ++m;
                }
                String[] temp_2 = new String[results[j].length + temp.length];
                for (k = 0; k < temp_2.length; ++k) {
                    temp_2[k] = k < results[j].length ? results[j][k] : temp[k - results[j].length];
                }
                results[j] = temp_2;
                results[i2] = null;
                ++replacement_count;
            }
        }
        String[][] reduced_results = new String[results.length - replacement_count][];
        int m = 0;
        for (i = 0; i < reduced_results.length; ++i) {
            while (results[m] == null) {
                ++m;
            }
            reduced_results[i] = results[m];
            ++m;
        }
        for (i = 0; i < reduced_results.length; ++i) {
            int repetition_count = 0;
            for (int j2 = 1; j2 < reduced_results[i].length; ++j2) {
                for (k = 1; k < reduced_results[i].length; ++k) {
                    if (reduced_results[i][j2] == null || j2 == k || !reduced_results[i][j2].equals(reduced_results[i][k])) continue;
                    ++repetition_count;
                    reduced_results[i][j2] = null;
                }
            }
            if (repetition_count == 0) continue;
            String[] temp = new String[reduced_results.length];
            for (int j3 = 0; j3 < reduced_results[i].length; ++j3) {
                temp[j3] = reduced_results[i][j3];
            }
            reduced_results[i] = new String[reduced_results[i].length - repetition_count];
            reduced_results[i][0] = temp[0];
            int reduced_results_index = 1;
            for (int j4 = 1; j4 < temp.length; ++j4) {
                if (temp[j4] == null) continue;
                reduced_results[i][reduced_results_index] = temp[j4];
                ++reduced_results_index;
            }
        }
        return reduced_results;
    }

    public String[][] getAllParentsAndTheirDirectChildren() {
        LinkedList<String[]> parents_and_their_children = new LinkedList<String[]>();
        DefaultMutableTreeNode root = (DefaultMutableTreeNode)this.taxonomy.getRoot();
        int number_children = root.getChildCount();
        for (int child = 0; child < number_children; ++child) {
            DefaultMutableTreeNode this_child = (DefaultMutableTreeNode)root.getChildAt(child);
            this.addChildrenToList(parents_and_their_children, this_child);
        }
        Object[] list_as_object = parents_and_their_children.toArray();
        String[][] results = new String[list_as_object.length][];
        for (int i = 0; i < results.length; ++i) {
            results[i] = (String[])list_as_object[i];
        }
        return results;
    }

    public boolean isTreeEmpty() {
        if (this.taxonomy == null) {
            return true;
        }
        DefaultMutableTreeNode root = (DefaultMutableTreeNode)this.taxonomy.getRoot();
        return root.getChildCount() == 0;
    }

    public String[] getClassesInClassificationsButNotTaxonomy(SegmentedClassification[] seg_classes) {
        String[] classification_leaf_classes = SegmentedClassification.getLeafClasses(seg_classes);
        String[] taxonomy_leaf_classes = this.getLeafLabels();
        LinkedList<String> classes_list = new LinkedList<String>();
        for (int i = 0; i < classification_leaf_classes.length; ++i) {
            boolean found = false;
            for (int j = 0; j < taxonomy_leaf_classes.length; ++j) {
                if (!classification_leaf_classes[i].equals(taxonomy_leaf_classes[j])) continue;
                found = true;
                j = taxonomy_leaf_classes.length;
            }
            if (found) continue;
            classes_list.add(classification_leaf_classes[i]);
        }
        if (classes_list.size() == 0) {
            return null;
        }
        return classes_list.toArray(new String[1]);
    }

    public String[] getClassesInTaxonomyButNotInClassifications(SegmentedClassification[] seg_classes) {
        String[] taxonomy_leaf_classes = this.getLeafLabels();
        String[] classification_leaf_classes = SegmentedClassification.getLeafClasses(seg_classes);
        LinkedList<String> classes_list = new LinkedList<String>();
        for (int i = 0; i < taxonomy_leaf_classes.length; ++i) {
            boolean found = false;
            for (int j = 0; j < classification_leaf_classes.length; ++j) {
                if (!classification_leaf_classes[j].equals(taxonomy_leaf_classes[i])) continue;
                found = true;
                j = classification_leaf_classes.length;
            }
            if (found) continue;
            classes_list.add(taxonomy_leaf_classes[i]);
        }
        if (classes_list.size() == 0) {
            return null;
        }
        return classes_list.toArray(new String[1]);
    }

    public static Taxonomy parseTaxonomyFile(String taxonomy_file_path) throws Exception {
        DefaultTreeModel[] parse_results = (DefaultTreeModel[])XMLDocumentParser.parseXMLDocument(taxonomy_file_path, "taxonomy_file");
        Taxonomy new_taxonomy = new Taxonomy(parse_results[0]);
        Taxonomy.setRootName(new_taxonomy, taxonomy_file_path);
        return new_taxonomy;
    }

    public static void saveTaxonomy(Taxonomy taxonomy_to_save, File to_save_to, String comments) throws Exception {
        try {
            FileOutputStream to = new FileOutputStream(to_save_to);
            DataOutputStream writer = new DataOutputStream(to);
            String pre_tree_part = new String("<?xml version=\"1.0\"?>\n<!DOCTYPE taxonomy_file [\n   <!ELEMENT taxonomy_file (comments, parent_class+)>\n   <!ELEMENT comments (#PCDATA)>\n   <!ELEMENT parent_class (class_name, sub_class*)>\n   <!ELEMENT class_name (#PCDATA)>\n   <!ELEMENT sub_class (class_name, sub_class*)>\n]>\n\n<taxonomy_file>\n\n   <comments>" + comments + "</comments>\n\n");
            writer.writeBytes(pre_tree_part);
            DefaultMutableTreeNode taxonomy_node = (DefaultMutableTreeNode)taxonomy_to_save.taxonomy.getRoot();
            for (int i = 0; i < taxonomy_node.getChildCount(); ++i) {
                writer.writeBytes("   <parent_class>\n");
                DefaultMutableTreeNode child = (DefaultMutableTreeNode)taxonomy_node.getChildAt(i);
                writer.writeBytes(Taxonomy.assembleTreeXMLElements(child, 1));
                writer.writeBytes("   </parent_class>\n\n");
            }
            writer.writeBytes("</taxonomy_file>");
            writer.close();
        }
        catch (Exception e) {
            throw new Exception("Unable to write file " + to_save_to.getName() + ".");
        }
    }

    public static void setRootName(Taxonomy given_taxonomy, String file_path) {
        String file_name = StringMethods.removeExtension((String)StringMethods.convertFilePathToFileName((String)file_path));
        ((DefaultMutableTreeNode)given_taxonomy.taxonomy.getRoot()).setUserObject(file_name);
    }

    private void searchForBranchesToRemove(String name_of_class_to_delete, DefaultMutableTreeNode node) {
        String label = (String)node.getUserObject();
        if (label.equals(name_of_class_to_delete)) {
            try {
                this.deleteBranchOfTaxonomy(node);
            }
            catch (Exception e) {}
        } else if (!node.isLeaf()) {
            for (int i = 0; i < node.getChildCount(); ++i) {
                DefaultMutableTreeNode child = (DefaultMutableTreeNode)node.getChildAt(i);
                this.searchForBranchesToRemove(name_of_class_to_delete, node);
            }
        }
    }

    private void addChildrenToList(LinkedList<String[]> list, DefaultMutableTreeNode node) {
        if (!node.isLeaf()) {
            int child;
            int number_children = node.getChildCount();
            String[] direct_descendants = new String[number_children];
            for (int child2 = 0; child2 < number_children; ++child2) {
                DefaultMutableTreeNode this_child = (DefaultMutableTreeNode)node.getChildAt(child2);
                direct_descendants[child2] = (String)this_child.getUserObject();
            }
            String[] results = new String[1 + number_children];
            results[0] = (String)node.getUserObject();
            for (child = 0; child < number_children; ++child) {
                results[child + 1] = direct_descendants[child];
            }
            list.add(results);
            for (child = 0; child < number_children; ++child) {
                DefaultMutableTreeNode this_child = (DefaultMutableTreeNode)node.getChildAt(child);
                if (this_child.isLeaf()) continue;
                this.addChildrenToList(list, this_child);
            }
        }
    }

    private static String assembleTreeElements(DefaultMutableTreeNode node, int depth) {
        int j;
        String tree_string = new String("");
        if (depth != 1) {
            for (j = 0; j <= depth; ++j) {
                tree_string = tree_string + " ";
            }
        }
        if (node.isLeaf()) {
            for (j = 0; j <= depth + 1; ++j) {
                tree_string = tree_string + " ";
            }
            tree_string = tree_string + node.getUserObject() + "\n";
        } else {
            for (int i = 0; i < node.getChildCount(); ++i) {
                if (i == 0) {
                    for (int j2 = 0; j2 <= depth + 1; ++j2) {
                        tree_string = tree_string + " ";
                    }
                    tree_string = tree_string + node.getUserObject() + "\n";
                }
                DefaultMutableTreeNode child = (DefaultMutableTreeNode)node.getChildAt(i);
                tree_string = tree_string + Taxonomy.assembleTreeElements(child, depth + 1);
            }
        }
        return tree_string;
    }

    private static String assembleTreeXMLElements(DefaultMutableTreeNode node, int depth) {
        int j;
        String XML_string = new String("");
        if (depth != 1) {
            for (j = 0; j <= depth; ++j) {
                XML_string = XML_string + "   ";
            }
            XML_string = XML_string + "<sub_class>\n";
        }
        if (node.isLeaf()) {
            for (j = 0; j <= depth + 1; ++j) {
                XML_string = XML_string + "   ";
            }
            XML_string = XML_string + "<class_name>" + node.getUserObject() + "</class_name>\n";
        } else {
            for (int i = 0; i < node.getChildCount(); ++i) {
                if (i == 0) {
                    for (int j2 = 0; j2 <= depth + 1; ++j2) {
                        XML_string = XML_string + "   ";
                    }
                    XML_string = XML_string + "<class_name>" + node.getUserObject() + "</class_name>\n";
                }
                DefaultMutableTreeNode child = (DefaultMutableTreeNode)node.getChildAt(i);
                XML_string = XML_string + Taxonomy.assembleTreeXMLElements(child, depth + 1);
            }
        }
        if (depth != 1) {
            for (j = 0; j <= depth; ++j) {
                XML_string = XML_string + "   ";
            }
            XML_string = XML_string + "</sub_class>\n";
        }
        return XML_string;
    }

    public static Taxonomy generateTaxonomy(SegmentedClassification[] classifications) {
        Taxonomy generated = new Taxonomy();
        if (classifications != null) {
            for (int i = 0; i < classifications.length; ++i) {
                if (classifications[i].classifications != null) {
                    for (int j = 0; j < classifications[i].classifications.length; ++j) {
                        if (StringMethods.isStringInArray((String)classifications[i].classifications[j], (String[])generated.getParentLabels())) continue;
                        generated.addClass(classifications[i].classifications[j]);
                    }
                }
                if (classifications[i].sub_classifications == null) continue;
                for (int k = 0; k < classifications[i].sub_classifications.length; ++k) {
                    for (int l = 0; l < classifications[i].sub_classifications[k].classifications.length; ++l) {
                        if (StringMethods.isStringInArray((String)classifications[i].sub_classifications[k].classifications[l], (String[])generated.getParentLabels())) continue;
                        generated.addClass(classifications[i].sub_classifications[k].classifications[l]);
                    }
                }
            }
        }
        return generated;
    }
}

