/*
 * Decompiled with CFR 0.152.
 */
package ace.gui;

import ace.datatypes.DataBoard;
import ace.datatypes.DataSet;
import ace.datatypes.SegmentedClassification;
import java.text.DecimalFormat;
import javax.swing.table.DefaultTableModel;
import mckay.utilities.staticlibraries.StringMethods;

public class InstancesTableModel
extends DefaultTableModel {
    private boolean display_meta_data = false;
    private boolean display_feature_values = false;
    private boolean has_sections = false;

    InstancesTableModel() {
    }

    public void fillTable(DataBoard data_board, String[] identifiers_to_expand, boolean display_meta_data, boolean display_feature_values) throws Exception {
        block21: {
            int numb_meta_data_cols;
            block20: {
                this.clearTable();
                this.display_meta_data = display_meta_data;
                this.display_feature_values = display_feature_values;
                Object[] column_names = this.getColumnNames(data_board);
                for (int i = 0; i < column_names.length; ++i) {
                    this.addColumn(column_names[i]);
                }
                numb_meta_data_cols = 0;
                if (data_board.getInstanceMetaDataFields() != null) {
                    numb_meta_data_cols = data_board.getInstanceMetaDataFields().length;
                }
                if (data_board.feature_vectors == null) break block20;
                String[][] model_classifications_overall = null;
                String[][][] model_classifications_sections = null;
                if (data_board.model_classifications != null) {
                    model_classifications_overall = SegmentedClassification.getOverallLabelsOfDataSets(data_board.feature_vectors, data_board.model_classifications);
                    if (identifiers_to_expand != null) {
                        model_classifications_sections = SegmentedClassification.getSubSectionLabelsOfDataSets(data_board.feature_vectors, data_board.model_classifications);
                    }
                }
                for (int i = 0; i < data_board.feature_vectors.length; ++i) {
                    SegmentedClassification matching_model;
                    String[] overall_classes = null;
                    if (model_classifications_overall != null) {
                        overall_classes = model_classifications_overall[i] != null ? model_classifications_overall[i] : new String[]{"?"};
                    }
                    String[] overall_meta_data = null;
                    String[] overall_meta_data_key = null;
                    if (display_meta_data && (matching_model = data_board.getMatchingModelClassification(data_board.feature_vectors[i])) != null) {
                        overall_meta_data = matching_model.misc_info_info;
                        overall_meta_data_key = matching_model.misc_info_key;
                    }
                    String[][] top_feat_vals = null;
                    if (display_feature_values) {
                        top_feat_vals = data_board.feature_vectors[i].getFeatureValuesOfTopLevel(data_board.feature_definitions);
                    }
                    boolean expand_this_instance = false;
                    if (data_board.feature_vectors[i].sub_sets != null && identifiers_to_expand != null && StringMethods.isStringInArray((String)data_board.feature_vectors[i].identifier, (String[])identifiers_to_expand)) {
                        expand_this_instance = true;
                    }
                    this.addRowToTable(false, expand_this_instance, data_board.hasSections(), data_board.feature_vectors[i].identifier, null, null, overall_classes, overall_meta_data, overall_meta_data_key, numb_meta_data_cols, top_feat_vals);
                    if (!expand_this_instance) continue;
                    String[][] array_to_pass = new String[data_board.feature_vectors[i].sub_sets.length][1];
                    for (int j = 0; j < data_board.feature_vectors[i].sub_sets.length; ++j) {
                        SegmentedClassification matching_model_section;
                        if (data_board.model_classifications != null) {
                            SegmentedClassification matching = SegmentedClassification.findMatchingClassification(data_board.feature_vectors[i], data_board.model_classifications);
                            if (matching != null) {
                                String[] section_classes = this.getMergedSectionalClassificationsStrings(matching.sub_classifications, data_board.feature_vectors[i].sub_sets);
                                for (int k = 0; k < section_classes.length; ++k) {
                                    array_to_pass[k][0] = section_classes[k];
                                }
                            }
                        } else {
                            for (int k = 0; k < array_to_pass.length; ++k) {
                                array_to_pass[k][0] = null;
                            }
                        }
                        String[] section_meta_data = null;
                        String[] section_meta_data_key = null;
                        if (display_meta_data && (matching_model_section = data_board.getMatchingModelClassification(data_board.feature_vectors[i].sub_sets[j])) != null) {
                            section_meta_data = matching_model_section.misc_info_info;
                            section_meta_data_key = matching_model_section.misc_info_key;
                        }
                        String[][] section_feat_vals = null;
                        if (display_feature_values) {
                            section_feat_vals = data_board.feature_vectors[i].sub_sets[j].getFeatureValuesOfTopLevel(data_board.feature_definitions);
                        }
                        String start = String.valueOf(data_board.feature_vectors[i].sub_sets[j].start);
                        String stop = String.valueOf(data_board.feature_vectors[i].sub_sets[j].stop);
                        boolean has = data_board.hasSections();
                        this.addRowToTable(true, expand_this_instance, has, "     Section " + (j + 1), start, stop, array_to_pass[j], section_meta_data, section_meta_data_key, numb_meta_data_cols, section_feat_vals);
                    }
                }
                break block21;
            }
            if (data_board.model_classifications == null) break block21;
            for (int i = 0; i < data_board.model_classifications.length; ++i) {
                boolean expand_this_instance = false;
                if (data_board.model_classifications[i].sub_classifications != null && identifiers_to_expand != null && StringMethods.isStringInArray((String)data_board.model_classifications[i].identifier, (String[])identifiers_to_expand)) {
                    expand_this_instance = true;
                }
                this.addRowToTable(false, expand_this_instance, data_board.hasSections(), data_board.model_classifications[i].identifier, String.valueOf(data_board.model_classifications[i].start), String.valueOf(data_board.model_classifications[i].stop), data_board.model_classifications[i].classifications, data_board.model_classifications[i].misc_info_info, data_board.model_classifications[i].misc_info_key, numb_meta_data_cols, null);
                if (!expand_this_instance) continue;
                for (int j = 0; j < data_board.model_classifications[i].sub_classifications.length; ++j) {
                    this.addRowToTable(true, expand_this_instance, data_board.hasSections(), "     Section " + (j + 1), String.valueOf(data_board.model_classifications[i].sub_classifications[j].start), String.valueOf(data_board.model_classifications[i].sub_classifications[j].stop), data_board.model_classifications[i].sub_classifications[j].classifications, data_board.model_classifications[i].sub_classifications[j].misc_info_info, data_board.model_classifications[i].sub_classifications[j].misc_info_key, numb_meta_data_cols, null);
                }
            }
        }
    }

    public boolean isCellEditable(int row, int column) {
        return true;
    }

    public Class getColumnClass(int column) {
        Object value = this.getValueAt(0, column);
        return value == null ? Object.class : value.getClass();
    }

    private void clearTable() {
        while (this.getRowCount() != 0) {
            this.removeRow(0);
        }
    }

    private Object[] getColumnNames(DataBoard data_board) {
        int i;
        int number_columns = 0;
        String[] basic_headings = new String[]{new String("Identifier")};
        number_columns = basic_headings.length;
        if (data_board.hasSections()) {
            number_columns += 3;
            this.has_sections = true;
        }
        if (data_board.getModelClassifications() != null) {
            ++number_columns;
        }
        String[] meta_data_headings = null;
        if (this.display_meta_data && (meta_data_headings = data_board.getInstanceMetaDataFields()) != null) {
            number_columns += meta_data_headings.length;
        }
        String[] feature_names = null;
        if (this.display_feature_values && (feature_names = data_board.getFeatureNames()) != null) {
            number_columns += feature_names.length;
        }
        Object[] column_headings = new Object[number_columns];
        int current_column = 0;
        if (this.has_sections) {
            column_headings[current_column] = "Show Sections";
            ++current_column;
        }
        for (i = 0; i < basic_headings.length; ++i) {
            column_headings[i + current_column] = new String(basic_headings[i]);
        }
        current_column += basic_headings.length;
        if (this.has_sections) {
            column_headings[current_column] = "Start";
            column_headings[current_column + 1] = "Stop";
            current_column += 2;
        }
        if (meta_data_headings != null) {
            for (i = 0; i < meta_data_headings.length; ++i) {
                column_headings[i + current_column] = new String(meta_data_headings[i]);
            }
            current_column += meta_data_headings.length;
        }
        if (data_board.getModelClassifications() != null) {
            column_headings[current_column + 0] = "Classes";
            ++current_column;
        }
        if (feature_names != null) {
            for (i = 0; i < feature_names.length; ++i) {
                column_headings[i + current_column] = new String(feature_names[i]);
            }
            current_column += feature_names.length;
        }
        return column_headings;
    }

    private void addRowToTable(boolean is_section, boolean should_be_expanded, boolean subsections_exist, String identifier, String start, String stop, String[] classes, String[] meta_data, String[] meta_data_key, int numb_meta_data_cols, String[][] feature_values) {
        Object[] row_contents = new Object[this.getColumnCount()];
        int current_column = 1;
        if (subsections_exist) {
            row_contents[0] = is_section ? null : (should_be_expanded ? new Boolean(true) : new Boolean(false));
            row_contents[1] = identifier;
            current_column = 2;
        } else {
            row_contents[0] = identifier;
        }
        if (subsections_exist) {
            if (is_section) {
                row_contents[current_column] = start;
                row_contents[current_column + 1] = stop;
            } else {
                row_contents[current_column] = new String("NA");
                row_contents[current_column + 1] = new String("NA");
            }
            current_column += 2;
        }
        if (this.display_meta_data) {
            int last_meta_col = current_column + numb_meta_data_cols - 1;
            if (meta_data != null) {
                for (int i = 0; i < meta_data.length; ++i) {
                    for (int j = current_column; j <= last_meta_col; ++j) {
                        if (!meta_data_key[i].equals(this.getColumnName(j))) continue;
                        row_contents[j] = meta_data[i];
                        j = current_column + numb_meta_data_cols;
                    }
                }
            }
            while (current_column <= last_meta_col) {
                if (row_contents[current_column] == null) {
                    row_contents[current_column] = "?";
                }
                ++current_column;
            }
        }
        if (classes != null && classes.length != 0) {
            row_contents[current_column] = new String(StringMethods.concatenateArrayOfStrings((String[])classes));
            ++current_column;
        }
        if (this.display_feature_values) {
            if (feature_values != null) {
                for (int i = 0; i < feature_values.length; ++i) {
                    row_contents[current_column] = feature_values[i][0];
                    ++current_column;
                }
            } else {
                while (current_column < row_contents.length) {
                    row_contents[current_column] = "?";
                    ++current_column;
                }
            }
        }
        this.addRow(row_contents);
    }

    private String[] getMergedSectionalClassificationsStrings(SegmentedClassification[] sub_classes, DataSet[] sub_set) {
        DecimalFormat df = new DecimalFormat("####0.##");
        int num_sections = sub_set.length;
        double[][][] times = new double[num_sections][sub_classes.length][2];
        String[] formatted = new String[num_sections];
        String[][][] classes = SegmentedClassification.getMergedSectionalClassifications(sub_classes, sub_set, times);
        for (int i = 0; i < num_sections; ++i) {
            StringBuffer this_section = new StringBuffer();
            for (int j = 0; j < classes[i].length; ++j) {
                if (classes[i][j] == null) continue;
                this_section.append(StringMethods.concatenateArrayOfStrings((String[])classes[i][j]));
                this_section.append("(" + df.format(times[i][j][0]) + "-" + df.format(times[i][j][1]) + ")");
                if (classes[i][j + 1] == null) continue;
                this_section.append(", ");
            }
            String classification = this_section.toString();
            formatted[i] = classification != null ? classification : "?";
        }
        return formatted;
    }
}

