/*
 * Decompiled with CFR 0.152.
 */
package ace.xmlparsers;

import ace.datatypes.SegmentedClassification;
import java.util.LinkedList;
import mckay.utilities.xml.ParseFileHandler;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class ParseClassificationsFileHandler
extends ParseFileHandler {
    private LinkedList<SegmentedClassification> root_classifications;
    private SegmentedClassification current_root_classification;
    private LinkedList<SegmentedClassification> subset_classifications;
    private SegmentedClassification current_subset_classification;
    private LinkedList<String> classes;
    private LinkedList<String> meta_data_keys;
    private LinkedList<String> meta_data_info;
    private int count;
    private StringBuffer element_text_so_far;

    public void startDocument() {
        this.root_classifications = new LinkedList();
        this.current_root_classification = null;
        this.subset_classifications = null;
        this.current_subset_classification = null;
        this.classes = null;
        this.meta_data_keys = null;
        this.meta_data_info = null;
        this.count = 0;
    }

    public void startElement(String namespace, String name, String qName, Attributes atts) throws SAXException {
        this.element_text_so_far = new StringBuffer();
        if (this.count == 0 && !name.equals("classifications_file")) {
            throw new SAXException("\n\nIt is in reality of the type " + name + ".");
        }
        ++this.count;
        if (name.equals("data_set")) {
            this.current_root_classification = new SegmentedClassification();
            this.root_classifications.add(this.current_root_classification);
        } else if (name.equals("section")) {
            if (this.subset_classifications == null) {
                this.subset_classifications = new LinkedList();
            }
            this.current_subset_classification = new SegmentedClassification();
            this.subset_classifications.add(this.current_subset_classification);
        } else if (name.equals("class")) {
            if (this.classes == null) {
                this.classes = new LinkedList();
            }
        } else if (name.equals("misc_info")) {
            if (this.meta_data_keys == null) {
                this.meta_data_keys = new LinkedList();
                this.meta_data_info = new LinkedList();
            }
            this.meta_data_keys.add(atts.getValue(0));
        }
    }

    public void characters(char[] ch, int start, int length) {
        String text = new String(ch, start, length);
        this.element_text_so_far.append(text);
    }

    public void endElement(String namespace, String name, String qName) {
        String parsed_text = this.element_text_so_far.toString();
        if (name.equals("class")) {
            this.classes.add(parsed_text);
        } else if (name.equals("misc_info")) {
            this.meta_data_info.add(parsed_text);
        } else if (name.equals("data_set_id")) {
            this.current_root_classification.identifier = parsed_text;
        } else if (name.equals("role")) {
            this.current_root_classification.role = parsed_text;
        } else if (name.equals("start")) {
            this.current_subset_classification.start = Double.parseDouble(parsed_text);
        } else if (name.equals("stop")) {
            this.current_subset_classification.stop = Double.parseDouble(parsed_text);
        } else if (name.equals("data_set")) {
            int i;
            String[] str;
            Object[] obj;
            if (this.classes != null) {
                obj = this.classes.toArray();
                str = new String[obj.length];
                for (i = 0; i < str.length; ++i) {
                    str[i] = (String)obj[i];
                }
                this.current_root_classification.classifications = str;
            }
            if (this.meta_data_keys != null) {
                obj = this.meta_data_keys.toArray();
                str = new String[obj.length];
                for (i = 0; i < str.length; ++i) {
                    str[i] = (String)obj[i];
                }
                this.current_root_classification.misc_info_key = str;
            }
            if (this.meta_data_info != null) {
                obj = this.meta_data_info.toArray();
                str = new String[obj.length];
                for (i = 0; i < str.length; ++i) {
                    str[i] = (String)obj[i];
                }
                this.current_root_classification.misc_info_info = str;
            }
            if (this.subset_classifications != null) {
                obj = this.subset_classifications.toArray();
                SegmentedClassification[] sc = new SegmentedClassification[obj.length];
                for (i = 0; i < sc.length; ++i) {
                    sc[i] = (SegmentedClassification)obj[i];
                }
                this.current_root_classification.sub_classifications = sc;
            }
            this.classes = null;
            this.meta_data_keys = null;
            this.meta_data_info = null;
            this.subset_classifications = null;
            this.current_root_classification = null;
        } else if (name.equals("section")) {
            if (this.classes != null) {
                Object[] obj = this.classes.toArray();
                String[] str = new String[obj.length];
                for (int i = 0; i < str.length; ++i) {
                    str[i] = (String)obj[i];
                }
                this.current_subset_classification.classifications = str;
            }
            this.classes = null;
            this.current_subset_classification = null;
        }
    }

    public void endDocument() {
        this.parsed_file_contents = this.root_classifications.toArray();
    }
}

