/*
 * Decompiled with CFR 0.152.
 */
package ace.xmlparsers;

import ace.xmlparsers.ParseACEProjectFileHandler;
import ace.xmlparsers.ParseClassificationsFileHandler;
import ace.xmlparsers.ParseDataSetFileHandler;
import ace.xmlparsers.ParseFeatureDefinitionsFileHandler;
import ace.xmlparsers.ParseTaxonomyFileHandler;
import ace.xmlparsers.UnknownFileHandler;
import java.io.File;
import mckay.utilities.staticlibraries.StringMethods;
import mckay.utilities.xml.ParseFileHandler;
import mckay.utilities.xml.ParsingXMLErrorHandler;
import org.apache.xerces.parsers.SAXParser;
import org.xml.sax.ContentHandler;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class XMLDocumentParser {
    public static Object parseXMLDocument(String file_path, String document_type) throws Exception {
        ParseFileHandler handler;
        File test_file = new File(file_path);
        if (!test_file.exists()) {
            throw new Exception("The specified path " + file_path + " does not refer to an existing file.");
        }
        if (test_file.isDirectory()) {
            throw new Exception("The specified path " + file_path + " refers to a directory, not to a file.");
        }
        SAXParser reader = new SAXParser();
        reader.setFeature("http://xml.org/sax/features/validation", true);
        reader.setErrorHandler((ErrorHandler)new ParsingXMLErrorHandler());
        if (document_type.equals("feature_vector_file")) {
            handler = new ParseDataSetFileHandler();
        } else if (document_type.equals("feature_key_file")) {
            handler = new ParseFeatureDefinitionsFileHandler();
        } else if (document_type.equals("taxonomy_file")) {
            handler = new ParseTaxonomyFileHandler();
        } else if (document_type.equals("classifications_file")) {
            handler = new ParseClassificationsFileHandler();
        } else if (document_type.equals("ace_project_file")) {
            handler = new ParseACEProjectFileHandler();
        } else {
            throw new Exception(new String("Invalid type of XML file specified. The XML file type " + document_type + " is not known."));
        }
        reader.setContentHandler((ContentHandler)handler);
        try {
            reader.parse(file_path);
        }
        catch (SAXParseException e) {
            throw new Exception("The " + file_path + " file is not a valid XML file.\n\nDetails of the problem: " + e.getMessage() + "\n\nThis error is likely in the region of line " + e.getLineNumber() + ".");
        }
        catch (SAXException e) {
            throw new Exception("The " + file_path + " file must be of type " + document_type + "." + e.getMessage());
        }
        catch (Exception e) {
            throw new Exception("The " + file_path + " file is not formatted properly.\n\nDetails of the problem: " + e.getMessage());
        }
        return handler.parsed_file_contents;
    }

    public static String getFileType(String file_path) throws Exception {
        String type = "unknown";
        String ext = StringMethods.getExtension((String)file_path);
        if (file_path.endsWith(".sp")) {
            return "special_file";
        }
        if (ext == null || !ext.equals(".xml")) {
            return type;
        }
        SAXParser reader = new SAXParser();
        reader.setFeature("http://xml.org/sax/features/validation", true);
        reader.setErrorHandler((ErrorHandler)new ParsingXMLErrorHandler());
        UnknownFileHandler handler = new UnknownFileHandler();
        reader.setContentHandler(handler);
        try {
            reader.parse(file_path);
        }
        catch (SAXException saxe) {
            String message = saxe.getMessage();
            if (!(message.equals("taxonomy_file") || message.equals("feature_key_file") || message.equals("feature_vector_file") || message.equals("classifications_file") || message.equals("project_file") || message.equals("unknown_file") || message.equals("special_file"))) {
                throw saxe;
            }
            return message;
        }
        return type;
    }
}

