/*
 * Decompiled with CFR 0.152.
 */
package mckay.utilities.general;

import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.text.StringCharacterIterator;
import mckay.utilities.staticlibraries.FileMethods;
import mckay.utilities.staticlibraries.MathAndStatsMethods;
import mckay.utilities.staticlibraries.StringMethods;

public class HTMLWriter {
    public static String convertSpecialCharacters(String to_convert) {
        StringBuffer result = new StringBuffer();
        StringCharacterIterator iterator = new StringCharacterIterator(to_convert);
        char character = iterator.current();
        while (character != '\uffff') {
            if (character == '<') {
                result.append("&lt;");
            } else if (character == '>') {
                result.append("&gt;");
            } else if (character == '\"') {
                result.append("&quot;");
            } else if (character == '\'') {
                result.append("&#039;");
            } else if (character == '\\') {
                result.append("&#092;");
            } else if (character == '&') {
                result.append("&amp;");
            } else {
                result.append(character);
            }
            character = iterator.next();
        }
        return result.toString();
    }

    public static String[] convertSpecialCharacters(String[] to_convert) {
        String[] temp_array = new String[to_convert.length];
        for (int i = 0; i < to_convert.length; ++i) {
            temp_array[i] = HTMLWriter.convertSpecialCharacters(to_convert[i]);
        }
        return temp_array;
    }

    public static DataOutputStream startNewHTMLFile(String path, String background_colour, String text_colour, boolean can_erase, String document_title, boolean include_text) {
        DataOutputStream writer = null;
        File html_file = FileMethods.getNewFileForWriting(path, can_erase);
        if (html_file != null) {
            try {
                writer = FileMethods.getDataOutputStream(html_file);
                String header = "<html>\n<head>\n\t<title>" + document_title + "</title>\n</head>\n\n";
                String body = "<body text=\"" + text_colour + "\" bgcolor=\"" + background_colour + "\">\n\n";
                String anchor = "<a name=\"Top\"></a>\n\n";
                String title = "<h1><font color=\"#0000FF\">" + document_title + "</font></h1>\n\n";
                writer.writeBytes(header);
                writer.writeBytes(body);
                if (include_text) {
                    writer.writeBytes(anchor);
                    writer.writeBytes(title);
                }
            }
            catch (Exception e) {
                html_file = null;
            }
        }
        return writer;
    }

    public static StringBuffer startNewHTMLFile(String background_colour, String text_colour, String document_title, boolean include_text) {
        StringBuffer html_buffer = new StringBuffer("");
        String header = "<html>\n<head>\n\t<title>" + document_title + "</title>\n</head>\n\n";
        String body = "<body text=\"" + text_colour + "\" bgcolor=\"" + background_colour + "\">\n\n";
        String anchor = "<a name=\"Top\"></a>\n\n";
        String title = "<h1><font color=\"#0000FF\">" + document_title + "</font></h1>\n\n";
        html_buffer.append(header);
        html_buffer.append(body);
        if (include_text) {
            html_buffer.append(anchor);
            html_buffer.append(title);
        }
        return html_buffer;
    }

    public static void endHTMLFile(DataOutputStream writer, boolean include_text) throws IOException {
        String section_end_rule = "<br>\n<hr>\n\n";
        String anchor_link = "<p><tt><a href=\"#Top\">-top of page-</a></tt></p>\n\n";
        String end_tags = "</body>\n</html>\n";
        if (include_text) {
            writer.writeBytes(section_end_rule);
            writer.writeBytes(anchor_link);
        }
        writer.writeBytes(end_tags);
        writer.close();
    }

    public static void endHTMLFile(StringBuffer writer, boolean include_text) {
        String section_end_rule = "<br>\n<hr>\n\n";
        String anchor_link = "<p><tt><a href=\"#Top\">-top of page-</a></tt></p>\n\n";
        String end_tags = "</body>\n</html>\n";
        if (include_text) {
            writer.append(section_end_rule);
            writer.append(anchor_link);
        }
        writer.append(end_tags);
    }

    public static void addParagraph(String paragraph, DataOutputStream writer) throws IOException {
        writer.writeBytes("<p>" + paragraph + "</p>\n\n");
    }

    public static void addParagraph(String paragraph, StringBuffer writer) {
        writer.append("<p>" + paragraph + "</p>\n\n");
    }

    public static void addHorizontalRule(DataOutputStream writer) throws IOException {
        writer.writeBytes("<p><hr></p>\n\n");
    }

    public static void addHorizontalRule(StringBuffer writer) {
        writer.append("<p><hr></p>\n\n");
    }

    public static void addList(String[] list, boolean numbered, DataOutputStream writer) throws IOException {
        if (numbered) {
            writer.writeBytes("<ol>\n");
        } else {
            writer.writeBytes("<ul>\n");
        }
        for (int i = 0; i < list.length; ++i) {
            writer.writeBytes("\t<li>" + list[i] + "\n");
        }
        if (numbered) {
            writer.writeBytes("</ol>\n\n");
        } else {
            writer.writeBytes("</ul>\n\n");
        }
    }

    public static void addList(String[] list, boolean numbered, StringBuffer writer) {
        if (numbered) {
            writer.append("<ol>\n");
        } else {
            writer.append("<ul>\n");
        }
        for (int i = 0; i < list.length; ++i) {
            writer.append("\t<li>" + list[i] + "\n");
        }
        if (numbered) {
            writer.append("</ol>\n\n");
        } else {
            writer.append("</ul>\n\n");
        }
    }

    public static void addTable(String[][] table, String[] column_headings, DataOutputStream writer) throws IOException {
        writer.writeBytes("<table border=1>\n");
        if (column_headings != null) {
            writer.writeBytes("\t<tr>\n");
            for (int column = 0; column < column_headings.length; ++column) {
                writer.writeBytes("\t\t<td>");
                writer.writeBytes("<b>" + column_headings[column] + "</b>");
                writer.writeBytes("</td>\n");
            }
            writer.writeBytes("\t</tr>\n");
        }
        for (int row = 0; row < table.length; ++row) {
            if (table[row] == null) continue;
            writer.writeBytes("\t<tr>\n");
            for (int column = 0; column < table[row].length; ++column) {
                writer.writeBytes("\t\t<td>");
                if (table[row][column] != null) {
                    writer.writeBytes(table[row][column]);
                }
                writer.writeBytes("</td>\n");
            }
            writer.writeBytes("\t</tr>\n");
        }
        writer.writeBytes("</table>\n\n");
    }

    public static void addTable(String[][] table, String[] column_headings, boolean bold_first_column, StringBuffer writer) {
        writer.append("<table border=1>\n");
        if (column_headings != null) {
            writer.append("\t<tr>\n");
            for (int column = 0; column < column_headings.length; ++column) {
                writer.append("\t\t<td>");
                writer.append("<b>" + column_headings[column] + "</b>");
                writer.append("</td>\n");
            }
            writer.append("\t</tr>\n");
        }
        for (int row = 0; row < table.length; ++row) {
            if (table[row] == null) continue;
            writer.append("\t<tr>\n");
            for (int column = 0; column < table[row].length; ++column) {
                writer.append("\t\t<td>");
                if (table[row][column] != null) {
                    if (bold_first_column && column == 0) {
                        writer.append("<b>");
                    }
                    writer.append(table[row][column]);
                    if (bold_first_column && column == 0) {
                        writer.append("</b>");
                    }
                }
                writer.append("</td>\n");
            }
            writer.append("\t</tr>\n");
        }
        writer.append("</table>\n\n");
    }

    public static void addTableHighlightingHighestInRow(String[][] table, String[] column_headings, boolean bold_first_column, StringBuffer writer) {
        writer.append("<table border=1>\n");
        if (column_headings != null) {
            writer.append("\t<tr>\n");
            for (int column = 0; column < column_headings.length; ++column) {
                writer.append("\t\t<td>");
                writer.append("<b>" + column_headings[column] + "</b>");
                writer.append("</td>\n");
            }
            writer.append("\t</tr>\n");
        }
        for (int row = 0; row < table.length; ++row) {
            if (table[row] == null) continue;
            writer.append("\t<tr>\n");
            int column_to_highlight = -1;
            if (table[row].length > 1) {
                int first_column = 0;
                if (bold_first_column) {
                    first_column = 1;
                }
                double[] column_contents = new double[table[row].length - first_column];
                boolean no_numbers = true;
                for (int i = 0; i < column_contents.length; ++i) {
                    try {
                        column_contents[i] = Double.valueOf(table[row][i + first_column]);
                        no_numbers = false;
                        continue;
                    }
                    catch (NumberFormatException e) {
                        column_contents[i] = Double.NEGATIVE_INFINITY;
                    }
                }
                if (!no_numbers) {
                    column_to_highlight = first_column + MathAndStatsMethods.getIndexOfLargest(column_contents);
                }
            }
            for (int column = 0; column < table[row].length; ++column) {
                writer.append("\t\t<td>");
                if (table[row][column] != null) {
                    if (bold_first_column && column == 0) {
                        writer.append("<b>");
                    }
                    if (column == column_to_highlight) {
                        writer.append("<i><b>");
                    }
                    writer.append(table[row][column]);
                    if (column == column_to_highlight) {
                        writer.append("<b></i>");
                    }
                    if (bold_first_column && column == 0) {
                        writer.append("</b>");
                    }
                }
                writer.append("</td>\n");
            }
            writer.append("\t</tr>\n");
        }
        writer.append("</table>\n\n");
    }

    public static DataOutputStream[] startNewFramesPage(String root_path, String root_title, int left_frame_size, String title_page_title, File[] sub_directory_dummy) throws Exception {
        DataOutputStream[] array_to_return = new DataOutputStream[2];
        String subdirectory_path = HTMLWriter.getFrameSubdirectoryPath(root_path);
        boolean success = FileMethods.createEmptyDirectory(subdirectory_path);
        if (!success) {
            throw new Exception("Could not create sub-directory to hold HTML files.\nThis may be because this path is currently protected.\n\nTry saving using a different name.");
        }
        sub_directory_dummy[0] = new File(subdirectory_path);
        String title_page_path = HTMLWriter.getDefaultPageFramePath(root_path, title_page_title);
        array_to_return[1] = HTMLWriter.startNewHTMLFile(title_page_path, "#e4e4e4", "#000000", true, title_page_title, true);
        if (array_to_return[1] == null) {
            throw new Exception("Could not save the default HTML file.");
        }
        String contents_file_path = HTMLWriter.getContentsFramePath(root_path);
        File contents_file = FileMethods.getNewFileForWriting(contents_file_path, true);
        if (contents_file == null) {
            throw new Exception("Could not save the contents HTML page.");
        }
        array_to_return[0] = FileMethods.getDataOutputStream(contents_file);
        array_to_return[0].writeBytes("<html>\n<head>\n\t<title>Contents Directory</title>\n</head>\n\n");
        array_to_return[0].writeBytes("<body bgcolor=\"#000000\" text=\"#FFFFFF\" link=\"#FFFFFF\" vlink=\"#FFFFFF\" alink=\"#FFFFFF\">\n\n");
        array_to_return[0].writeBytes("<font size=+1>Contents</font><br>\n");
        array_to_return[0].writeBytes("<font size=+1>Directory</font>\n\n");
        array_to_return[0].writeBytes("<p><font size=-1><font color=\"#FFFFFF\"><a href=\"" + title_page_title + ".html\" target=\"right\">Home</a></font></font></p>\n\n");
        File root_file = FileMethods.getNewFileForWriting(root_path, true);
        if (root_file == null) {
            throw new Exception("Could not save the root HTML page.");
        }
        DataOutputStream root_writer = FileMethods.getDataOutputStream(root_file);
        String header = "<html>\n<head>\n\t<title>" + root_title + "</title>\n</head>\n\n";
        String frameset_top = "<frameset cols=\"" + left_frame_size + "%, *\", border=no>\n";
        String contents_frame = "\t<frame src=\"" + sub_directory_dummy[0].getName() + "/Contents.html\", name=left>\n";
        String title_page_frame = "\t<frame src=\"" + sub_directory_dummy[0].getName() + "/" + title_page_title + ".html\", name=right>\n";
        String frameset_bottom = "</frameset>\n\n";
        String ender = "</html>\n";
        root_writer.writeBytes(header);
        root_writer.writeBytes(frameset_top);
        root_writer.writeBytes(contents_frame);
        root_writer.writeBytes(title_page_frame);
        root_writer.writeBytes(frameset_bottom);
        root_writer.writeBytes(ender);
        root_writer.close();
        return array_to_return;
    }

    public static DataOutputStream addFrame(String new_file_title, File directory, DataOutputStream contents_file_stream) throws Exception {
        String file_path = directory.getAbsoluteFile() + "/" + new_file_title + ".html";
        DataOutputStream writer = HTMLWriter.startNewHTMLFile(file_path, "#e4e4e4", "#000000", true, new_file_title, true);
        if (writer == null) {
            throw new Exception("Could not generate HTML file:\n" + file_path);
        }
        contents_file_stream.writeBytes("<p><font size=-1><font color=\"#FFFFFF\"><a href=\"" + new_file_title + ".html\" target=\"right\">" + new_file_title + "</a></font></font></p>\n\n");
        return writer;
    }

    public static String getFrameSubdirectoryPath(String root_path) throws Exception {
        String root_path_no_extension = StringMethods.removeExtension(root_path);
        if (root_path_no_extension == null) {
            throw new Exception("Root file must have an extension.");
        }
        String subdirectory_path = root_path_no_extension + "_documents";
        return subdirectory_path;
    }

    public static String getContentsFramePath(String root_path) throws Exception {
        String subdirectory_path = HTMLWriter.getFrameSubdirectoryPath(root_path);
        String contents_path = subdirectory_path + "/" + "Contents.html";
        return contents_path;
    }

    public static String getDefaultPageFramePath(String root_path, String title_page_title) throws Exception {
        String subdirectory_path = HTMLWriter.getFrameSubdirectoryPath(root_path);
        String default_page_path = subdirectory_path + "/" + title_page_title + ".html";
        return default_page_path;
    }

    public static String[][] addLineBreaksToArray(String[][] to_process) {
        String[][] list = new String[to_process.length][1];
        for (int i = 0; i < list.length; ++i) {
            String list_so_far = "";
            for (int j = 0; j < to_process[i].length; ++j) {
                if (j != 0) {
                    list_so_far = list_so_far + "<br>";
                }
                list_so_far = list_so_far + HTMLWriter.convertSpecialCharacters(to_process[i][j]);
            }
            list[i][0] = list_so_far;
        }
        return list;
    }
}

