/*
 * Decompiled with CFR 0.152.
 */
package mckay.utilities.gui.progressbars;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.GridLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JTextArea;
import javax.swing.Timer;
import mckay.utilities.gui.progressbars.DoubleProgressBarTaskMonitor;

public class DoubleProgressBarDialog
extends JFrame
implements ActionListener {
    private DoubleProgressBarTaskMonitor task_monitor;
    private Timer timer;
    private JFrame parent_window;
    private JProgressBar top_progress_bar;
    private JProgressBar bottom_progress_bar;
    private JTextArea top_report_text_area;
    private JTextArea bottom_report_text_area;
    private Container content_pane;
    private JPanel progress_panel;
    private JPanel button_panel;
    private JButton cancel_button;

    public DoubleProgressBarDialog(JFrame parent_window, DoubleProgressBarTaskMonitor task_monitor, int time_between_polls) {
        this.task_monitor = task_monitor;
        this.parent_window = parent_window;
        if (parent_window != null) {
            parent_window.setEnabled(false);
        }
        this.setTitle("Progress");
        int horizontal_gap = 6;
        int vertical_gap = 4;
        this.content_pane = this.getContentPane();
        this.content_pane.setLayout(new BorderLayout(horizontal_gap, vertical_gap));
        this.progress_panel = new JPanel(new GridLayout(4, 1, horizontal_gap, vertical_gap));
        this.button_panel = new JPanel();
        this.top_progress_bar = new JProgressBar(0, 1);
        this.top_progress_bar.setValue(0);
        this.top_progress_bar.setStringPainted(true);
        this.bottom_progress_bar = new JProgressBar(0, 1);
        this.bottom_progress_bar.setValue(0);
        this.bottom_progress_bar.setStringPainted(true);
        int number_text_columns = 50;
        int number_text_rows = 2;
        this.top_report_text_area = new JTextArea(number_text_rows, number_text_columns);
        this.top_report_text_area.setEditable(false);
        this.top_report_text_area.setLineWrap(false);
        this.top_report_text_area.setCursor(null);
        this.bottom_report_text_area = new JTextArea(number_text_rows, number_text_columns);
        this.bottom_report_text_area.setEditable(false);
        this.bottom_report_text_area.setLineWrap(false);
        this.bottom_report_text_area.setCursor(null);
        this.cancel_button = new JButton("Cancel");
        this.cancel_button.addActionListener(this);
        this.progress_panel.add(this.top_progress_bar);
        this.progress_panel.add(this.top_report_text_area);
        this.progress_panel.add(this.bottom_progress_bar);
        this.progress_panel.add(this.bottom_report_text_area);
        this.button_panel.add(this.cancel_button);
        this.content_pane.add((Component)this.progress_panel, "Center");
        this.content_pane.add((Component)this.button_panel, "South");
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                DoubleProgressBarDialog.this.cancel();
            }
        });
        this.timer = new Timer(time_between_polls, new ProgressBarActionListener());
        this.setCursor(Cursor.getPredefinedCursor(3));
        this.timer.start();
        this.pack();
        this.setLocationRelativeTo(parent_window);
        this.setVisible(true);
    }

    public void actionPerformed(ActionEvent event) {
        if (event.getSource().equals(this.cancel_button)) {
            this.cancel();
        }
    }

    public void cancel() {
        this.timer.stop();
        this.task_monitor.stop();
        this.setCursor(null);
        if (this.parent_window != null) {
            this.parent_window.setEnabled(true);
        }
        this.setVisible(false);
    }

    private void done() {
        Toolkit.getDefaultToolkit().beep();
        this.timer.stop();
        this.setCursor(null);
        if (this.parent_window != null) {
            this.parent_window.setEnabled(true);
        }
        this.setVisible(false);
    }

    private class ProgressBarActionListener
    implements ActionListener {
        private ProgressBarActionListener() {
        }

        public void actionPerformed(ActionEvent evt) {
            if (DoubleProgressBarDialog.this.task_monitor.startNewTopProgress()) {
                DoubleProgressBarDialog.this.top_progress_bar.setValue(0);
                DoubleProgressBarDialog.this.top_progress_bar.setMaximum(DoubleProgressBarDialog.this.task_monitor.getTopLengthOfTask());
            }
            DoubleProgressBarDialog.this.top_progress_bar.setValue(DoubleProgressBarDialog.this.task_monitor.getTopCurrentAmountCompleted());
            DoubleProgressBarDialog.this.top_report_text_area.setText(DoubleProgressBarDialog.this.task_monitor.getTopTextMessage());
            DoubleProgressBarDialog.this.top_report_text_area.setCaretPosition(DoubleProgressBarDialog.this.top_report_text_area.getDocument().getLength());
            if (DoubleProgressBarDialog.this.task_monitor.startNewBottomProgress()) {
                DoubleProgressBarDialog.this.bottom_progress_bar.setValue(0);
                DoubleProgressBarDialog.this.bottom_progress_bar.setMaximum(DoubleProgressBarDialog.this.task_monitor.getBottomLengthOfTask());
            }
            DoubleProgressBarDialog.this.bottom_progress_bar.setValue(DoubleProgressBarDialog.this.task_monitor.getBottomCurrentAmountCompleted());
            DoubleProgressBarDialog.this.bottom_report_text_area.setText(DoubleProgressBarDialog.this.task_monitor.getBottomTextMessage());
            DoubleProgressBarDialog.this.bottom_report_text_area.setCaretPosition(DoubleProgressBarDialog.this.bottom_report_text_area.getDocument().getLength());
            if (DoubleProgressBarDialog.this.task_monitor.isDone()) {
                DoubleProgressBarDialog.this.done();
            }
        }
    }
}

