/*
 * Decompiled with CFR 0.152.
 */
package mckay.utilities.gui.progressbars;

public abstract class DoubleProgressBarTaskMonitor {
    protected long overall_start_time;
    protected long overall_end_time;
    protected int sub_task_index = 0;
    protected String[] sub_task_names;
    protected long[] sub_task_durations;
    protected boolean new_top_task_started = false;
    protected boolean new_bottom_task_started = false;
    protected int top_length_of_task = 1;
    protected int bottom_length_of_task = 1;
    protected int top_current_amount_completed = 0;
    protected int bottom_current_amount_completed = 0;
    protected long top_time_started = System.currentTimeMillis();
    protected long bottom_time_started = System.currentTimeMillis();
    protected String top_progress_message = "Overall Processing";
    protected String bottom_progress_message = new String("");
    protected boolean task_completed = false;
    protected boolean task_canceled = false;

    public abstract void go();

    public void initializeOverallTask(int number_of_subtasks) {
        this.top_time_started = System.currentTimeMillis();
        this.top_current_amount_completed = -1;
        this.top_length_of_task = number_of_subtasks;
        this.new_top_task_started = true;
        this.overall_start_time = this.top_time_started;
        this.sub_task_names = new String[this.top_length_of_task];
        this.sub_task_durations = new long[this.top_length_of_task];
    }

    public void startNewSubTask(int tasks_in_subtask, String sub_task_name) {
        ++this.top_current_amount_completed;
        this.bottom_current_amount_completed = -1;
        this.bottom_time_started = System.currentTimeMillis();
        this.bottom_progress_message = sub_task_name;
        this.bottom_length_of_task = tasks_in_subtask;
        this.new_bottom_task_started = true;
        this.sub_task_names[this.sub_task_index] = sub_task_name;
        this.sub_task_durations[this.sub_task_index] = this.bottom_time_started;
        if (this.sub_task_index != 0) {
            this.sub_task_durations[this.sub_task_index - 1] = this.bottom_time_started - this.sub_task_durations[this.sub_task_index - 1];
        }
        ++this.sub_task_index;
    }

    public void setSubTaskProgressValue(int progress_value) {
        this.bottom_current_amount_completed = progress_value;
    }

    public void markTaskComplete() {
        this.overall_end_time = System.currentTimeMillis();
        this.sub_task_durations[this.sub_task_index - 1] = this.overall_end_time - this.sub_task_durations[this.sub_task_index - 1];
        this.task_completed = true;
    }

    public String[][] getProcessingTimeLogs(boolean want_raw_milliseconds) {
        String[][] log_data = new String[this.sub_task_names.length + 1][2];
        for (int i = 0; i < log_data.length - 1; ++i) {
            log_data[i][0] = this.sub_task_names[i];
            log_data[i][1] = want_raw_milliseconds ? "" + this.sub_task_durations[i] : this.findTimeWithProperUnits(new Long(this.sub_task_durations[i] / 1000L).intValue());
        }
        log_data[this.sub_task_names.length][0] = "TOTAL";
        log_data[this.sub_task_names.length][1] = want_raw_milliseconds ? "" + (this.overall_end_time - this.overall_start_time) : this.findTimeWithProperUnits(new Long((this.overall_end_time - this.overall_start_time) / 1000L).intValue());
        return log_data;
    }

    public void stop() {
        this.task_canceled = true;
    }

    public boolean isCancelled() {
        return this.task_canceled;
    }

    public boolean isDone() {
        return this.task_completed;
    }

    public boolean startNewTopProgress() {
        boolean temp = this.new_top_task_started;
        this.new_top_task_started = false;
        return temp;
    }

    public boolean startNewBottomProgress() {
        boolean temp = this.new_bottom_task_started;
        this.new_bottom_task_started = false;
        return temp;
    }

    public int getTopLengthOfTask() {
        return this.top_length_of_task;
    }

    public int getBottomLengthOfTask() {
        return this.bottom_length_of_task;
    }

    public int getTopCurrentAmountCompleted() {
        return this.top_current_amount_completed;
    }

    public int getBottomCurrentAmountCompleted() {
        return this.bottom_current_amount_completed;
    }

    public String getTopTextMessage() {
        if (this.top_length_of_task == 0) {
            return new String("");
        }
        String return_string = new String(this.top_progress_message + "\n");
        return_string = return_string + this.getTimeEstimate(this.top_current_amount_completed, this.top_length_of_task, (double)this.bottom_current_amount_completed / (double)this.bottom_length_of_task, this.top_time_started);
        return return_string;
    }

    public String getBottomTextMessage() {
        if (this.bottom_length_of_task == 0) {
            return new String("");
        }
        String return_string = new String(this.bottom_progress_message + "\n");
        return_string = return_string + this.getTimeEstimate(this.bottom_current_amount_completed, this.bottom_length_of_task, -1.0, this.bottom_time_started);
        return return_string;
    }

    private String getTimeEstimate(double current_amount_completed, double length_of_task, double fraction_sub_task_completed, long time_started) {
        double fraction_completed = current_amount_completed / length_of_task;
        if (fraction_sub_task_completed > 0.001) {
            fraction_completed += fraction_sub_task_completed / length_of_task;
        }
        double time_already_passed_sec = (System.currentTimeMillis() - time_started) / 1000L;
        double time_total_sec = time_already_passed_sec / fraction_completed;
        double time_remaining_sec = time_total_sec - time_already_passed_sec;
        int time_already_passed = (int)time_already_passed_sec;
        int time_remaining = (int)time_remaining_sec;
        if (time_remaining < 0) {
            time_remaining = 0;
        }
        String time_passed_message = this.findTimeWithProperUnits(time_already_passed);
        String time_remaining_message = this.findTimeWithProperUnits(time_remaining);
        if (current_amount_completed < 0.99) {
            return new String("Time elapsed: " + time_passed_message);
        }
        return new String("Time elapsed: " + time_passed_message + "        Estimated time remaining: " + time_remaining_message);
    }

    protected String findTimeWithProperUnits(int seconds) {
        if (seconds > 3601) {
            int hours = seconds / 3600;
            int minutes = (seconds - hours * 3600) / 60;
            return new String(hours + " hours and " + minutes + " minutes");
        }
        if (seconds > 120) {
            int minutes = seconds / 60;
            return new String(minutes + " minutes");
        }
        return new String(seconds + " seconds");
    }
}

