/*
 * Decompiled with CFR 0.152.
 */
package mckay.utilities.gui.tables;

import java.awt.Color;
import java.awt.Component;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;

public class StripedTableCellRenderer
implements TableCellRenderer {
    protected TableCellRenderer targetRenderer;
    protected Color evenBack;
    protected Color evenFore;
    protected Color oddBack;
    protected Color oddFore;

    public StripedTableCellRenderer(TableCellRenderer targetRenderer, Color evenBack, Color evenFore, Color oddBack, Color oddFore) {
        this.targetRenderer = targetRenderer;
        this.evenBack = evenBack;
        this.evenFore = evenFore;
        this.oddBack = oddBack;
        this.oddFore = oddFore;
    }

    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        TableCellRenderer renderer = this.targetRenderer;
        if (renderer == null) {
            renderer = table.getDefaultRenderer(table.getColumnClass(column));
        }
        Component comp = renderer.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        if (!isSelected && !hasFocus) {
            if ((row & 1) == 0) {
                comp.setBackground(this.evenBack != null ? this.evenBack : table.getBackground());
                comp.setForeground(this.evenFore != null ? this.evenFore : table.getForeground());
            } else {
                comp.setBackground(this.oddBack != null ? this.oddBack : table.getBackground());
                comp.setForeground(this.oddFore != null ? this.oddFore : table.getForeground());
            }
        }
        return comp;
    }

    public static void installInColumn(JTable table, int columnIndex, Color evenBack, Color evenFore, Color oddBack, Color oddFore) {
        TableColumn tc = table.getColumnModel().getColumn(columnIndex);
        TableCellRenderer targetRenderer = tc.getCellRenderer();
        tc.setCellRenderer(new StripedTableCellRenderer(targetRenderer, evenBack, evenFore, oddBack, oddFore));
    }

    public static void installInTable(JTable table, Color evenBack, Color evenFore, Color oddBack, Color oddFore) {
        StripedTableCellRenderer sharedInstance = null;
        int columns = table.getColumnCount();
        for (int i = 0; i < columns; ++i) {
            TableColumn tc = table.getColumnModel().getColumn(i);
            TableCellRenderer targetRenderer = tc.getCellRenderer();
            if (targetRenderer != null) {
                tc.setCellRenderer(new StripedTableCellRenderer(targetRenderer, evenBack, evenFore, oddBack, oddFore));
                continue;
            }
            if (sharedInstance == null) {
                sharedInstance = new StripedTableCellRenderer(null, evenBack, evenFore, oddBack, oddFore);
            }
            tc.setCellRenderer(sharedInstance);
        }
    }
}

