/*
 * Decompiled with CFR 0.152.
 */
package mckay.utilities.gui.tables;

import java.awt.Component;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JTable;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import mckay.utilities.general.SmartComparator;
import mckay.utilities.staticlibraries.SortingMethods;

public class TableSortModel
implements TableModel,
TableModelListener {
    private DefaultTableModel real_model;
    private int[] indexes;
    private SmartComparator comparator;

    public TableSortModel(JTable table) throws IllegalArgumentException {
        DefaultTableModel model;
        if (table.getModel() == null) {
            throw new IllegalArgumentException("A null TableModel was provided to the table sorter.");
        }
        if (!(table.getModel() instanceof DefaultTableModel)) {
            throw new IllegalArgumentException("A non-DefaultTableModel TableModel was provided to the table sorter.");
        }
        this.comparator = new SmartComparator();
        this.real_model = model = (DefaultTableModel)table.getModel();
        this.real_model.addTableModelListener(this);
        table.setModel(this);
        this.attachColumnClickListenerForSorting(table);
        this.allocate();
    }

    public void tableChanged(TableModelEvent event) {
    }

    public static void setColumnWidths(JTable table, TableColumn[] columns_to_set, int max) {
        String dummy = "";
        for (int i = 0; i < max; ++i) {
            dummy = dummy + "w";
        }
        TableCellRenderer renderer = table.getTableHeader().getDefaultRenderer();
        Component component = renderer.getTableCellRendererComponent(table, dummy, false, false, 0, 0);
        max = component.getPreferredSize().width;
        for (int i = 0; i < columns_to_set.length; ++i) {
            int width = TableSortModel.getPreferredWidthForColumn(table, columns_to_set[i]);
            if (width > max) {
                width = max;
            }
            columns_to_set[i].setMinWidth(width);
            columns_to_set[i].setMaxWidth(width);
        }
        table.doLayout();
    }

    public int getTrueRowIndex(int row) {
        return this.indexes[row];
    }

    public void addRow(Object[] row_data) {
        int[] temp = new int[this.indexes.length + 1];
        for (int i = 0; i < this.indexes.length; ++i) {
            temp[i] = this.indexes[i];
        }
        temp[this.indexes.length] = this.indexes.length;
        this.indexes = temp;
        this.real_model.addRow(row_data);
    }

    public void removeRows(int[] row_indexes) {
        int i;
        int[] true_indexes = new int[row_indexes.length];
        for (int i2 = 0; i2 < row_indexes.length; ++i2) {
            true_indexes[i2] = this.indexes[row_indexes[i2]];
        }
        true_indexes = SortingMethods.sortIntArray(true_indexes);
        int decrement = 0;
        for (i = 0; i < true_indexes.length; ++i) {
            true_indexes[i] = true_indexes[i] - decrement;
            ++decrement;
        }
        for (i = 0; i < true_indexes.length; ++i) {
            int j;
            int ind = 0;
            for (int j2 = 0; j2 < this.indexes.length; ++j2) {
                if (this.indexes[j2] != true_indexes[i]) continue;
                ind = j2;
                j2 = this.indexes.length;
            }
            int[] temp = new int[this.indexes.length - 1];
            for (j = 0; j < temp.length; ++j) {
                temp[j] = j < ind ? this.indexes[j] : this.indexes[j + 1];
            }
            this.indexes = temp;
            for (j = 0; j < this.indexes.length; ++j) {
                if (this.indexes[j] <= true_indexes[i]) continue;
                int n = j;
                this.indexes[n] = this.indexes[n] - 1;
            }
            this.real_model.removeRow(true_indexes[i]);
        }
    }

    public Object getValueAt(int row, int column) {
        return this.real_model.getValueAt(this.indexes[row], column);
    }

    public void setValueAt(Object value, int row, int column) {
        this.real_model.setValueAt(value, this.indexes[row], column);
    }

    public int getRowCount() {
        return this.real_model.getRowCount();
    }

    public int getColumnCount() {
        return this.real_model.getColumnCount();
    }

    public String getColumnName(int column) {
        return this.real_model.getColumnName(column);
    }

    public Class getColumnClass(int column) {
        return this.real_model.getColumnClass(column);
    }

    public boolean isCellEditable(int row, int column) {
        return this.real_model.isCellEditable(this.indexes[row], column);
    }

    public void addTableModelListener(TableModelListener listener) {
        this.real_model.addTableModelListener(listener);
    }

    public void removeTableModelListener(TableModelListener listener) {
        this.real_model.removeTableModelListener(listener);
    }

    private void attachColumnClickListenerForSorting(JTable table) throws IllegalArgumentException {
        if (table.getModel() != this) {
            throw new IllegalArgumentException("Given table does not have a model matching this TableSortModel.");
        }
        final JTable this_table = table;
        MouseAdapter listener = new MouseAdapter(){

            public void mouseClicked(MouseEvent event) {
                TableColumnModel tcm = this_table.getColumnModel();
                int vc = tcm.getColumnIndexAtX(event.getX());
                int mc = this_table.convertColumnIndexToModel(vc);
                TableSortModel.this.sort(mc);
            }
        };
        JTableHeader table_header = table.getTableHeader();
        table_header.addMouseListener(listener);
    }

    private void allocate() {
        this.indexes = new int[this.getRowCount()];
        for (int i = 0; i < this.indexes.length; ++i) {
            this.indexes[i] = i;
        }
    }

    private void sort(int column) {
        int row_count = this.getRowCount();
        for (int i = 0; i < row_count; ++i) {
            for (int j = i + 1; j < row_count; ++j) {
                if (this.compare(this.indexes[i], this.indexes[j], column) <= 0) continue;
                this.swap(i, j);
            }
        }
    }

    private void swap(int i, int j) {
        int temp = this.indexes[i];
        this.indexes[i] = this.indexes[j];
        this.indexes[j] = temp;
    }

    private int compare(int i, int j, int column) {
        Object a = this.real_model.getValueAt(i, column);
        Object b = this.real_model.getValueAt(j, column);
        return this.comparator.compare(a, b);
    }

    private static int getPreferredWidthForColumn(JTable table, TableColumn column) {
        int cell_width;
        int header_width = TableSortModel.getColumnHeaderWidth(table, column);
        if (header_width > (cell_width = TableSortModel.getWidthOfWidestCellInColumn(table, column))) {
            return header_width + 14;
        }
        return cell_width + 6;
    }

    private static int getColumnHeaderWidth(JTable table, TableColumn column) {
        TableCellRenderer renderer = table.getTableHeader().getDefaultRenderer();
        Component component = renderer.getTableCellRendererComponent(table, column.getHeaderValue(), false, false, 0, 0);
        return component.getPreferredSize().width;
    }

    private static int getWidthOfWidestCellInColumn(JTable table, TableColumn column) {
        int c = column.getModelIndex();
        int width = 0;
        int max_width = 0;
        for (int r = 0; r < table.getRowCount(); ++r) {
            TableCellRenderer renderer = table.getCellRenderer(r, c);
            Component component = renderer.getTableCellRendererComponent(table, table.getValueAt(r, c), false, false, r, c);
            width = component.getPreferredSize().width;
            if (width <= max_width) continue;
            max_width = width;
        }
        return max_width;
    }
}

