/*
 * Decompiled with CFR 0.152.
 */
package mckay.utilities.gui.templates;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.DataOutputStream;
import java.io.File;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import mckay.utilities.gui.progressbars.SimpleProgressBarDialog;
import mckay.utilities.gui.templates.ListInputParser;
import mckay.utilities.staticlibraries.FileMethods;
import mckay.utilities.staticlibraries.SortingMethods;
import mckay.utilities.staticlibraries.StringMethods;

public class ListInputPanel
extends JPanel
implements ActionListener {
    private ListInputParser file_parser;
    private JTextArea text_area;
    private JButton load_button;
    private JButton save_button;
    private JButton clear_button;
    private JButton organize_button;
    private JFileChooser save_chooser;

    public ListInputPanel(ListInputParser file_parser) {
        super(new BorderLayout(4, 4));
        this.file_parser = file_parser;
        int horizontal_gap = 4;
        int vertical_gap = 4;
        JPanel button_panel = new JPanel(new GridLayout(1, 4));
        this.load_button = new JButton("Load");
        this.save_button = new JButton("Save");
        this.clear_button = new JButton("Clear");
        this.organize_button = new JButton("Organize");
        button_panel.add(this.load_button);
        button_panel.add(this.save_button);
        button_panel.add(this.clear_button);
        button_panel.add(this.organize_button);
        this.save_button.addActionListener(this);
        this.load_button.addActionListener(this);
        this.clear_button.addActionListener(this);
        this.organize_button.addActionListener(this);
        if (file_parser == null) {
            this.load_button.setEnabled(false);
        }
        this.text_area = new JTextArea();
        this.text_area.setLineWrap(false);
        this.text_area.setEditable(true);
        this.text_area.setText("");
        JScrollPane scroll_pane = new JScrollPane(this.text_area);
        this.add((Component)button_panel, "North");
        this.add((Component)scroll_pane, "Center");
    }

    public void actionPerformed(ActionEvent event) {
        if (event.getSource().equals(this.load_button)) {
            this.loadStrings();
        } else if (event.getSource().equals(this.save_button)) {
            this.saveText();
        } else if (event.getSource().equals(this.clear_button)) {
            this.clearText();
        } else if (event.getSource().equals(this.organize_button)) {
            this.organizeText();
        }
    }

    public void focusOnTextInput() {
        this.text_area.requestFocusInWindow();
    }

    public void clearText() {
        this.text_area.setText("");
    }

    public void setText(String new_text) {
        if (new_text != null) {
            this.text_area.setText(new_text);
            this.text_area.setCaretPosition(0);
        }
    }

    public void setStrings(String[] new_strings) {
        this.clearText();
        this.appendStrings(new_strings);
    }

    public void appendText(String new_text) {
        if (new_text != null) {
            this.text_area.append(new_text);
            this.text_area.setCaretPosition(0);
        }
    }

    public void appendStrings(String[] new_strings) {
        if (new_strings != null && new_strings.length != 0) {
            for (int i = 0; i < new_strings.length; ++i) {
                if (i == 0) {
                    if (!this.text_area.getText().equals("")) {
                        this.text_area.append("\n");
                    }
                } else {
                    this.text_area.append("\n");
                }
                this.text_area.append(new_strings[i]);
            }
            this.text_area.setCaretPosition(0);
        }
    }

    public String getText() {
        return this.text_area.getText();
    }

    public String[] getStrings() {
        String field_contents = this.text_area.getText();
        if (field_contents == null) {
            return null;
        }
        if (field_contents.equals("")) {
            return null;
        }
        String[] search_strings = StringMethods.breakIntoTokens(field_contents, "\n");
        if (search_strings.length == 0) {
            return null;
        }
        return search_strings;
    }

    public String[] getProcessedStrings() {
        String[] uncleaned_strings = this.getStrings();
        if (uncleaned_strings != null) {
            String[] duplicate_removed_strings = StringMethods.removeDoubles(uncleaned_strings);
            String[] sorted_strings = SortingMethods.sortArray(duplicate_removed_strings);
            return sorted_strings;
        }
        return null;
    }

    public void organizeText() {
        String[] cleaned_contents = this.getProcessedStrings();
        if (cleaned_contents != null) {
            this.setStrings(cleaned_contents);
        }
    }

    public void setEnabled(boolean enable) {
        super.setEnabled(enable);
        this.text_area.setEnabled(enable);
        this.load_button.setEnabled(enable);
        this.save_button.setEnabled(enable);
        this.clear_button.setEnabled(enable);
        this.organize_button.setEnabled(enable);
    }

    private void loadStrings() {
        String[] strings_to_add = null;
        SimpleProgressBarDialog progress_bar = new SimpleProgressBarDialog(2, this);
        this.file_parser.setProgressBar(progress_bar);
        try {
            strings_to_add = this.file_parser.getStrings();
        }
        catch (Exception e) {
            progress_bar.done();
            JOptionPane.showMessageDialog(null, e.getMessage(), " ERROR", 0);
        }
        progress_bar.incrementStatus();
        if (strings_to_add != null) {
            this.appendStrings(strings_to_add);
        }
        progress_bar.done();
    }

    private void saveText() {
        String selected_path;
        File selected_file;
        int browse_return;
        if (this.save_chooser == null) {
            this.save_chooser = new JFileChooser();
        }
        if ((browse_return = this.save_chooser.showSaveDialog(this)) == 0 && (selected_file = FileMethods.getNewFileForWriting(selected_path = this.save_chooser.getSelectedFile().getAbsolutePath(), false)) != null) {
            try {
                System.out.println("a");
                DataOutputStream writer = FileMethods.getDataOutputStream(selected_file);
                System.out.println("b");
                writer.writeBytes(this.getText());
                System.out.println("c");
            }
            catch (Exception e) {
                JOptionPane.showMessageDialog(null, "Unable to write file.", "ERROR", 0);
            }
        }
    }
}

