/*
 * Decompiled with CFR 0.152.
 */
package mckay.utilities.gui.templates;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JEditorPane;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import mckay.utilities.general.FileSaver;
import mckay.utilities.staticlibraries.FileMethods;

public class ResultsDisplayPanel
extends JPanel
implements ActionListener,
HyperlinkListener {
    private JEditorPane display_pane;
    private JButton save_button;
    private JComboBox save_format_combo_box;
    private JFileChooser save_chooser;
    private FileSaver saver;

    public ResultsDisplayPanel(FileSaver saver) {
        super(new BorderLayout(4, 4));
        this.saver = saver;
        int horizontal_gap = 4;
        int vertical_gap = 4;
        this.display_pane = new JEditorPane();
        this.display_pane.setContentType("text/html");
        this.display_pane.setEditable(false);
        this.display_pane.addHyperlinkListener(this);
        JScrollPane scroll_pane = new JScrollPane(this.display_pane);
        this.save_button = new JButton("Save");
        this.save_button.addActionListener(this);
        this.save_format_combo_box = new JComboBox<String>(saver.getFileFormatExtension());
        JPanel combo_panel = ResultsDisplayPanel.getLabeledContainer("SAVE FORMAT:", this.save_format_combo_box, horizontal_gap);
        JPanel save_panel = new JPanel(new BorderLayout(horizontal_gap, vertical_gap));
        save_panel.add((Component)this.save_button, "West");
        save_panel.add(new JLabel(""));
        save_panel.add((Component)combo_panel, "East");
        this.add((Component)save_panel, "North");
        this.add((Component)scroll_pane, "Center");
    }

    public void actionPerformed(ActionEvent event) {
        if (event.getSource().equals(this.save_button)) {
            this.saveText();
        }
    }

    public void hyperlinkUpdate(HyperlinkEvent event) {
        if (event.getEventType() == HyperlinkEvent.EventType.ENTERED) {
            this.setCursor(Cursor.getPredefinedCursor(12));
        } else if (event.getEventType() == HyperlinkEvent.EventType.EXITED) {
            this.setCursor(Cursor.getPredefinedCursor(0));
        } else if (event.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
            try {
                this.display_pane.setPage(event.getURL());
            }
            catch (Exception f) {
                this.display_pane.setText("Unable to find requested page:\n" + event.getURL());
            }
        }
    }

    public void setText(String new_text) {
        if (new_text != null) {
            this.display_pane.setText(new_text);
            this.display_pane.setCaretPosition(0);
        }
    }

    private void saveText() {
        String selected_path;
        File selected_file;
        int browse_return;
        if (this.save_chooser == null) {
            this.save_chooser = new JFileChooser();
        }
        if ((browse_return = this.save_chooser.showSaveDialog(this)) == 0 && (selected_file = FileMethods.getNewFileForWriting(selected_path = this.save_chooser.getSelectedFile().getAbsolutePath(), false)) != null) {
            try {
                this.saver.saveContents((String)this.save_format_combo_box.getSelectedItem(), this.display_pane.getText(), selected_file);
            }
            catch (Exception e) {
                JOptionPane.showMessageDialog(null, e.getMessage() + "\n\nUnable to write file.", "ERROR", 0);
            }
        }
    }

    private static JPanel getLabeledContainer(String label_text, Container container, int gap) {
        JPanel panel = new JPanel(new BorderLayout(gap, gap));
        panel.add((Component)new JLabel(label_text), "West");
        panel.add((Component)container, "Center");
        return panel;
    }
}

