/*
 * Decompiled with CFR 0.152.
 */
package mckay.utilities.sound.midi;

import java.io.File;
import java.io.IOException;
import java.util.LinkedList;
import javax.sound.midi.MetaMessage;
import javax.sound.midi.MidiEvent;
import javax.sound.midi.MidiFileFormat;
import javax.sound.midi.MidiMessage;
import javax.sound.midi.MidiSystem;
import javax.sound.midi.Receiver;
import javax.sound.midi.Sequence;
import javax.sound.midi.Sequencer;
import javax.sound.midi.Synthesizer;
import javax.sound.midi.Track;
import javax.sound.midi.Transmitter;

public class MIDIMethods {
    public static Sequencer playMIDISequence(Sequence midi_sequence) throws Exception {
        if (midi_sequence == null) {
            throw new Exception("No MIDI data passed for playback.");
        }
        Sequencer sequencer = MidiSystem.getSequencer();
        if (sequencer == null) {
            throw new Exception("Could not acquire a MIDI sequencer from the system.");
        }
        Synthesizer synthesizer = null;
        sequencer.open();
        sequencer.setSequence(midi_sequence);
        if (!(sequencer instanceof Synthesizer)) {
            synthesizer = MidiSystem.getSynthesizer();
            synthesizer.open();
            Receiver synth_receiver = synthesizer.getReceiver();
            Transmitter seq_transmitter = sequencer.getTransmitter();
            seq_transmitter.setReceiver(synth_receiver);
        }
        sequencer.start();
        return sequencer;
    }

    public static String getMIDIFileFormatData(File file) throws Exception {
        try {
            Sequence sequence = MidiSystem.getSequence(file);
            MidiFileFormat file_format = MidiSystem.getMidiFileFormat(file);
            float division_code = sequence.getDivisionType();
            String division_type = null;
            if (division_code == 0.0f) {
                division_type = "PPQ";
            } else if (division_code == 24.0f) {
                division_type = "SMPTE, 24 frames per second";
            } else if (division_code == 25.0f) {
                division_type = "SMPTE, 25 frames per second";
            } else if (division_code == 29.97f) {
                division_type = "SMPTE, 29.97 frames per second";
            } else if (division_code == 30.0f) {
                division_type = "SMPTE, 30 frames per second";
            }
            String timing_resolution_type = null;
            timing_resolution_type = sequence.getDivisionType() == 0.0f ? " ticks per beat" : " ticks per frame";
            String data = new String();
            data = data + new String("FILE NAME: " + file.getName() + "\n");
            data = data + new String("MIDI FILE TYPE: " + file_format.getType() + "\n");
            data = data + new String("NUMBER OF TRACKS: " + sequence.getTracks().length + "\n");
            data = data + new String("DURATION: " + (double)sequence.getMicrosecondLength() / 1000000.0 + " seconds\n");
            data = data + new String("NUMBER OF TICKS: " + sequence.getTickLength() + " ticks\n");
            data = data + new String("TIMING DIVISION TYPE: " + division_type + "\n");
            data = data + new String("TIMING RESOLUTION: " + sequence.getResolution() + timing_resolution_type + "\n");
            data = data + new String("TICK DURATION: " + (double)sequence.getMicrosecondLength() / 1000000.0 / (double)sequence.getTickLength() + " seconds\n");
            data = data + new String("TITLE: " + (String)file_format.getProperty("title") + "\n");
            data = data + new String("AUTHOR: " + (String)file_format.getProperty("author") + "\n");
            data = data + new String("COPYRIGHT: " + (String)file_format.getProperty("copyright") + "\n");
            data = data + new String("COMMENT: " + (String)file_format.getProperty("comment") + "\n");
            return data;
        }
        catch (IOException ex) {
            throw new Exception("File " + file.getName() + " is not a readable MIDI file.");
        }
    }

    public static double[] getSecondsPerTick(Sequence sequence) {
        int ticks_per_beat = sequence.getResolution();
        double mean_ticks_per_sec = (double)sequence.getTickLength() / ((double)sequence.getMicrosecondLength() / 1000000.0);
        double[] seconds_per_tick = new double[(int)sequence.getTickLength() + 1];
        for (int i = 0; i < seconds_per_tick.length; ++i) {
            seconds_per_tick[i] = 1.0 / mean_ticks_per_sec;
        }
        Track[] tracks = sequence.getTracks();
        for (int n_track = 0; n_track < tracks.length; ++n_track) {
            Track track = tracks[n_track];
            for (int n_event = 0; n_event < track.size(); ++n_event) {
                MetaMessage meta_message;
                MidiEvent event = track.get(n_event);
                MidiMessage message = event.getMessage();
                if (!(message instanceof MetaMessage) || (meta_message = (MetaMessage)message).getType() != 81) continue;
                byte[] meta_data = meta_message.getData();
                int microseconds_per_beat = (meta_data[0] & 0xFF) << 16 | (meta_data[1] & 0xFF) << 8 | meta_data[2] & 0xFF;
                double current_seconds_per_tick = (double)microseconds_per_beat / (double)ticks_per_beat;
                current_seconds_per_tick /= 1000000.0;
                for (int i = (int)event.getTick(); i < seconds_per_tick.length; ++i) {
                    seconds_per_tick[i] = current_seconds_per_tick;
                }
            }
        }
        return seconds_per_tick;
    }

    public static Sequence[] breakSequenceIntoWindows(Sequence original_sequence, double window_duration, double window_overlap_offset) throws Exception {
        double seconds_accumulated_so_far;
        if (original_sequence.getDivisionType() != 0.0f) {
            throw new Exception("The specified MIDI sequence uses SMPTE time encoding.\nOnly PPQ time encoding is accepted here.");
        }
        if ((double)original_sequence.getTickLength() > 2.147483646E9) {
            throw new Exception("The MIDI sequence could not be processed because it is too long.");
        }
        double[] seconds_per_tick = MIDIMethods.getSecondsPerTick(original_sequence);
        LinkedList<Integer> window_start_ticks_list = new LinkedList<Integer>();
        LinkedList<Integer> window_end_ticks_list = new LinkedList<Integer>();
        double total_duration = (double)original_sequence.getMicrosecondLength() / 1000000.0;
        double time_interval_to_next_tick = window_duration - window_overlap_offset;
        boolean found_next_tick = false;
        int tick_of_next_beginning = 0;
        int this_tick = 0;
        for (double total_seconds_accumulated_so_far = 0.0; total_seconds_accumulated_so_far < total_duration && this_tick < seconds_per_tick.length; total_seconds_accumulated_so_far += seconds_accumulated_so_far - window_overlap_offset) {
            window_start_ticks_list.add(new Integer(this_tick));
            for (seconds_accumulated_so_far = 0.0; seconds_accumulated_so_far < window_duration && this_tick < seconds_per_tick.length; seconds_accumulated_so_far += seconds_per_tick[this_tick], ++this_tick) {
                if (found_next_tick || !(seconds_accumulated_so_far > time_interval_to_next_tick)) continue;
                tick_of_next_beginning = this_tick;
                found_next_tick = true;
            }
            window_end_ticks_list.add(new Integer(this_tick - 1));
            if (found_next_tick) {
                this_tick = tick_of_next_beginning;
            }
            found_next_tick = false;
        }
        Integer[] window_start_ticks_I = window_start_ticks_list.toArray(new Integer[1]);
        int[] window_start_ticks = new int[window_start_ticks_I.length];
        for (int i = 0; i < window_start_ticks.length; ++i) {
            window_start_ticks[i] = window_start_ticks_I[i];
        }
        Integer[] window_end_ticks_I = window_end_ticks_list.toArray(new Integer[1]);
        int[] window_end_ticks = new int[window_end_ticks_I.length];
        for (int i = 0; i < window_end_ticks.length; ++i) {
            window_end_ticks[i] = window_end_ticks_I[i];
        }
        Sequence[] windowed_sequences = new Sequence[window_start_ticks.length];
        Track[][] windowed_tracks = new Track[window_start_ticks.length][];
        for (int win = 0; win < windowed_sequences.length; ++win) {
            windowed_sequences[win] = new Sequence(original_sequence.getDivisionType(), original_sequence.getResolution(), original_sequence.getTracks().length);
            windowed_tracks[win] = windowed_sequences[win].getTracks();
        }
        Track[] original_tracks = original_sequence.getTracks();
        return windowed_sequences;
    }
}

