/*
 * Decompiled with CFR 0.152.
 */
package mckay.utilities.sound.sampled;

public class AudioMethodsDSP {
    public static double[][] applyGain(double[][] samples, double gain) {
        double[][] altered_samples = new double[samples.length][];
        for (int i = 0; i < altered_samples.length; ++i) {
            altered_samples[i] = new double[samples[i].length];
            for (int j = 0; j < altered_samples[i].length; ++j) {
                altered_samples[i][j] = samples[i][j] * gain;
            }
        }
        return altered_samples;
    }

    public static void applyGainAndPanning(double[][] samples_to_modify, double gain, double panning) throws Exception {
        int chan;
        if (gain < 0.0 || gain > 1.0) {
            throw new Exception("Gain of " + gain + " specified.\n" + "This value must be between 0.0 and 1.0.");
        }
        if (panning < -1.0 || panning > 1.0) {
            throw new Exception("Panning of " + panning + " specified.\n" + "This value must be between -1.0 and 1.0.");
        }
        if (samples_to_modify == null) {
            throw new Exception("Empty set of samples provided.");
        }
        for (chan = 0; chan < samples_to_modify.length; ++chan) {
            if (samples_to_modify[chan] != null) continue;
            throw new Exception("Channel " + chan + " is empty.");
        }
        for (chan = 0; chan < samples_to_modify.length; ++chan) {
            int samp = 0;
            while (samp < samples_to_modify[chan].length) {
                double[] dArray = samples_to_modify[chan];
                int n = samp++;
                dArray[n] = dArray[n] * gain;
            }
        }
        if (samples_to_modify.length == 2 && panning != 0.0) {
            int samp;
            if (panning > 0.0) {
                double left_multiplier = 1.0 - panning;
                samp = 0;
                while (samp < samples_to_modify[0].length) {
                    double[] dArray = samples_to_modify[0];
                    int n = samp++;
                    dArray[n] = dArray[n] * left_multiplier;
                }
            }
            if (panning < 0.0) {
                double right_multiplier = panning + 1.0;
                samp = 0;
                while (samp < samples_to_modify[1].length) {
                    double[] dArray = samples_to_modify[1];
                    int n = samp++;
                    dArray[n] = dArray[n] * right_multiplier;
                }
            }
        }
    }

    public static double[] getSamplesMixedDownIntoOneChannel(double[][] audio_samples) {
        if (audio_samples.length == 1) {
            return audio_samples[0];
        }
        double number_channels = audio_samples.length;
        int number_samples = audio_samples[0].length;
        double[] samples_mixed_down = new double[number_samples];
        for (int samp = 0; samp < number_samples; ++samp) {
            double total_so_far = 0.0;
            int chan = 0;
            while ((double)chan < number_channels) {
                total_so_far += audio_samples[chan][samp];
                ++chan;
            }
            samples_mixed_down[samp] = total_so_far / number_channels;
        }
        return samples_mixed_down;
    }

    public static double[][] clipSamples(double[][] original_samples) throws Exception {
        if (original_samples == null) {
            throw new Exception("Empty set of samples to provided.");
        }
        double[][] clipped_samples = new double[original_samples.length][];
        for (int chan = 0; chan < clipped_samples.length; ++chan) {
            clipped_samples[chan] = new double[original_samples[chan].length];
            for (int samp = 0; samp < clipped_samples[chan].length; ++samp) {
                clipped_samples[chan][samp] = original_samples[chan][samp] < -1.0 ? -1.0 : (original_samples[chan][samp] > 1.0 ? 1.0 : original_samples[chan][samp]);
            }
        }
        return clipped_samples;
    }

    public static double[] normalizeSamples(double[] samples_to_normalize) {
        int samp;
        double[] normalized_samples = new double[samples_to_normalize.length];
        for (int samp2 = 0; samp2 < normalized_samples.length; ++samp2) {
            normalized_samples[samp2] = samples_to_normalize[samp2];
        }
        double max_sample_value = 0.0;
        for (samp = 0; samp < normalized_samples.length; ++samp) {
            if (!(Math.abs(normalized_samples[samp]) > max_sample_value)) continue;
            max_sample_value = Math.abs(normalized_samples[samp]);
        }
        if (max_sample_value != 0.0) {
            samp = 0;
            while (samp < normalized_samples.length) {
                int n = samp++;
                normalized_samples[n] = normalized_samples[n] / max_sample_value;
            }
        }
        return normalized_samples;
    }

    public static double[][] normalizeSamples(double[][] samples_to_normalize) {
        int samp;
        int chan;
        double[][] normalized_samples = new double[samples_to_normalize.length][samples_to_normalize[0].length];
        for (int chan2 = 0; chan2 < normalized_samples.length; ++chan2) {
            for (int samp2 = 0; samp2 < normalized_samples[chan2].length; ++samp2) {
                normalized_samples[chan2][samp2] = samples_to_normalize[chan2][samp2];
            }
        }
        double max_sample_value = 0.0;
        for (chan = 0; chan < normalized_samples.length; ++chan) {
            for (samp = 0; samp < normalized_samples[chan].length; ++samp) {
                if (!(Math.abs(normalized_samples[chan][samp]) > max_sample_value)) continue;
                max_sample_value = Math.abs(normalized_samples[chan][samp]);
            }
        }
        if (max_sample_value != 0.0) {
            for (chan = 0; chan < normalized_samples.length; ++chan) {
                samp = 0;
                while (samp < normalized_samples[chan].length) {
                    double[] dArray = normalized_samples[chan];
                    int n = samp++;
                    dArray[n] = dArray[n] / max_sample_value;
                }
            }
        }
        return normalized_samples;
    }

    public static double[][] getCopyOfSamples(double[][] original_samples) {
        double[][] new_samples = new double[original_samples.length][];
        for (int chan = 0; chan < new_samples.length; ++chan) {
            new_samples[chan] = new double[original_samples[chan].length];
            for (int samp = 0; samp < new_samples[chan].length; ++samp) {
                new_samples[chan][samp] = original_samples[chan][samp];
            }
        }
        return new_samples;
    }

    public static int convertTimeToSample(double time, float sampling_rate) {
        return (int)Math.round(time * (double)sampling_rate);
    }

    public static double convertSampleToTime(int sample, float sampling_rate) {
        return (double)sample / (double)sampling_rate;
    }

    public static double findMaximumSampleValue(int bit_depth) {
        int max_sample_value_int = 1;
        for (int i = 0; i < bit_depth - 1; ++i) {
            max_sample_value_int *= 2;
        }
        double max_sample_value = (double)(--max_sample_value_int) - 1.0;
        return max_sample_value;
    }

    public static double[] getAutoCorrelation(double[] signal, int min_lag, int max_lag) {
        double[] autocorrelation = new double[max_lag - min_lag + 1];
        for (int lag = min_lag; lag <= max_lag; ++lag) {
            int auto_indice = lag - min_lag;
            autocorrelation[auto_indice] = 0.0;
            for (int samp = 0; samp < signal.length - lag; ++samp) {
                int n = auto_indice;
                autocorrelation[n] = autocorrelation[n] + signal[samp] * signal[samp + lag];
            }
        }
        return autocorrelation;
    }

    public static double[] getAutoCorrelationLabels(double sampling_rate, int min_lag, int max_lag) {
        double[] labels = new double[max_lag - min_lag + 1];
        for (int i = 0; i < labels.length; ++i) {
            labels[i] = sampling_rate / (double)(i + min_lag);
        }
        return labels;
    }

    public static void applyClickAvoidanceAttenuationEnvelope(double[][] sample_values, double click_avoid_env_length, float sample_rate) throws Exception {
        int chan;
        double amplitude_multipler;
        int samp;
        if (sample_values == null) {
            throw new Exception("Empty set of samples provided.");
        }
        if (sample_rate <= 0.0f) {
            throw new Exception("Given sample rate is " + sample_rate + " Hz.\n" + "This value should be greater than zero.");
        }
        if (click_avoid_env_length < 0.0) {
            throw new Exception("Click avoidance envelope length is " + click_avoid_env_length + " seconds.\n" + "This value should be 0.0 seconds or higher.");
        }
        double duration_of_audio = (float)sample_values[0].length / sample_rate;
        if (2.0 * click_avoid_env_length >= duration_of_audio) {
            throw new Exception("Click avoidance envelope length is " + click_avoid_env_length + " seconds.\n" + "This would lead to combined envelope lengths longer than the provided audio.");
        }
        int sample_duration = (int)(click_avoid_env_length * (double)sample_rate);
        int start_sample_1 = 0;
        int end_sample_1 = sample_duration - 1;
        int start_sample_2 = sample_values[0].length - 1 - sample_duration;
        int end_sample_2 = sample_values[0].length - 1;
        for (samp = start_sample_1; samp <= end_sample_1; ++samp) {
            amplitude_multipler = (double)samp / (double)end_sample_1;
            for (chan = 0; chan < sample_values.length; ++chan) {
                double[] dArray = sample_values[chan];
                int n = samp;
                dArray[n] = dArray[n] * amplitude_multipler;
            }
        }
        for (samp = start_sample_2; samp <= end_sample_2; ++samp) {
            amplitude_multipler = 1.0 - (double)(samp - start_sample_2) / (double)(end_sample_2 - start_sample_2);
            for (chan = 0; chan < sample_values.length; ++chan) {
                double[] dArray = sample_values[chan];
                int n = samp;
                dArray[n] = dArray[n] * amplitude_multipler;
            }
        }
    }
}

