/*
 * Decompiled with CFR 0.152.
 */
package mckay.utilities.sound.sampled;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ShortBuffer;
import javax.sound.sampled.AudioFileFormat;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.Mixer;
import javax.sound.sampled.SourceDataLine;
import javax.sound.sampled.TargetDataLine;
import javax.sound.sampled.UnsupportedAudioFileException;
import mckay.utilities.sound.sampled.AudioEventLineListener;
import mckay.utilities.sound.sampled.AudioMethodsDSP;

public class AudioMethodsGeneral {
    public static AudioFormat getCopyOfAudioFormat(AudioFormat old_audio_format) {
        return new AudioFormat(old_audio_format.getEncoding(), old_audio_format.getSampleRate(), old_audio_format.getSampleSizeInBits(), old_audio_format.getChannels(), old_audio_format.getFrameSize(), old_audio_format.getFrameRate(), old_audio_format.isBigEndian());
    }

    public static String getAudioFormatData(AudioFormat audio_format) {
        String encoding = audio_format.getEncoding().toString() + "\n";
        String endian = audio_format.isBigEndian() ? "big-endian\n" : "little-endian\n";
        String sampling_rate = audio_format.getSampleRate() / 1000.0f + " kHz\n";
        String bit_depth = audio_format.getSampleSizeInBits() + " bits\n";
        String channels = audio_format.getChannels() == 1 ? "mono\n" : (audio_format.getChannels() == 2 ? "stereo\n" : audio_format.getChannels() + " channels\n");
        String frame_size = 8 * audio_format.getFrameSize() + " bits\n";
        String frame_rate = audio_format.getFrameRate() + " frames per second\n";
        String additional_properties = audio_format.properties() + "\n";
        String data = new String();
        data = data + new String("SAMPLING RATE: " + sampling_rate);
        data = data + new String("BIT DEPTH: " + bit_depth);
        data = data + new String("CHANNELS: " + channels);
        data = data + new String("FRAME SIZE: " + frame_size);
        data = data + new String("FRAME RATE: " + frame_rate);
        data = data + new String("ENCODING: " + encoding);
        data = data + new String("BYTE ORDER: " + endian);
        data = data + new String("PROPERTIES: " + additional_properties);
        return data;
    }

    public static String getAudioFileFormatData(File file) throws Exception {
        try {
            AudioFileFormat audio_file_format = AudioSystem.getAudioFileFormat(file);
            String file_name = file.getName() + "\n";
            String file_type = audio_file_format.getType().toString() + "\n";
            String file_size = audio_file_format.getByteLength() / 1024 + " kilobytes\n";
            String length_of_audio_data = audio_file_format.getFrameLength() + " sample frames\n";
            String time_duration = (float)audio_file_format.getFrameLength() / audio_file_format.getFormat().getFrameRate() + " seconds\n";
            String additional_properties = audio_file_format.properties() + "\n";
            String data = new String();
            data = data + new String("FILE NAME: " + file_name);
            data = data + new String("FILE TYPE: " + file_type);
            data = data + new String("FILE SIZE: " + file_size);
            data = data + new String("FRAMES OF AUDIO DATA: " + length_of_audio_data);
            data = data + new String("TIME DURATION: " + time_duration);
            data = data + new String("PROPERTIES: " + additional_properties);
            data = data + "\n" + AudioMethodsGeneral.getAudioFormatData(audio_file_format.getFormat());
            return data;
        }
        catch (UnsupportedAudioFileException ex) {
            throw new Exception("File " + file.getName() + " has an unsupported audio format.");
        }
        catch (IOException ex) {
            throw new Exception("File " + file.getName() + " is not readable.");
        }
    }

    public static String[] getAvailableFileFormatTypes() {
        AudioFileFormat.Type[] file_types = AudioSystem.getAudioFileTypes();
        String[] file_type_labels = new String[file_types.length];
        for (int i = 0; i < file_types.length; ++i) {
            file_type_labels[i] = file_types[file_types.length - 1 - i].toString();
        }
        return file_type_labels;
    }

    public static AudioFileFormat.Type getAudioFileFormatType(String file_type_name) {
        if (file_type_name.equals("WAVE")) {
            return AudioFileFormat.Type.WAVE;
        }
        if (file_type_name.equals("AIFF")) {
            return AudioFileFormat.Type.AIFF;
        }
        if (file_type_name.equals("AIFC")) {
            return AudioFileFormat.Type.AIFC;
        }
        if (file_type_name.equals("AU")) {
            return AudioFileFormat.Type.AU;
        }
        if (file_type_name.equals("SND")) {
            return AudioFileFormat.Type.SND;
        }
        return null;
    }

    public static String getAvailableMixerData() {
        Mixer.Info[] mixer_info = AudioSystem.getMixerInfo();
        String data = new String();
        for (int i = 0; i < mixer_info.length; ++i) {
            data = data + new String("INDEX: " + i + "\n");
            data = data + new String("NAME: " + mixer_info[i].getName()) + "\n";
            data = data + new String("VERSION: " + mixer_info[i].getVersion()) + "\n";
            data = data + new String("VENDOR: " + mixer_info[i].getVendor()) + "\n";
            data = data + new String("DESCRIPTION: " + mixer_info[i].getDescription()) + "\n";
            data = data + new String("\n");
        }
        return data;
    }

    public static Mixer getMixer(int mixer_index, AudioEventLineListener listener) {
        Mixer.Info[] mixer_info = AudioSystem.getMixerInfo();
        Mixer mixer = AudioSystem.getMixer(mixer_info[mixer_index]);
        if (listener != null) {
            mixer.addLineListener(listener);
        }
        return mixer;
    }

    public static TargetDataLine getTargetDataLine(AudioFormat audio_format, AudioEventLineListener listener) throws Exception {
        DataLine.Info data_line_info = new DataLine.Info(TargetDataLine.class, audio_format);
        TargetDataLine target_data_line = null;
        target_data_line = (TargetDataLine)AudioSystem.getLine(data_line_info);
        if (listener != null) {
            target_data_line.addLineListener(listener);
        }
        target_data_line.open(audio_format);
        target_data_line.start();
        return target_data_line;
    }

    public static TargetDataLine getTargetDataLine(AudioFormat audio_format, Mixer mixer, AudioEventLineListener listener) throws Exception {
        DataLine.Info data_line_info = new DataLine.Info(TargetDataLine.class, audio_format);
        TargetDataLine target_data_line = null;
        target_data_line = (TargetDataLine)mixer.getLine(data_line_info);
        if (listener != null) {
            target_data_line.addLineListener(listener);
        }
        target_data_line.open(audio_format);
        target_data_line.start();
        return target_data_line;
    }

    public static SourceDataLine getSourceDataLine(AudioFormat audio_format, AudioEventLineListener listener) {
        SourceDataLine source_data_line = null;
        DataLine.Info data_line_info = new DataLine.Info(SourceDataLine.class, audio_format);
        try {
            source_data_line = (SourceDataLine)AudioSystem.getLine(data_line_info);
            if (listener != null) {
                source_data_line.addLineListener(listener);
            }
            source_data_line.open(audio_format);
        }
        catch (LineUnavailableException e) {
            System.out.println(e);
            System.exit(0);
        }
        source_data_line.start();
        return source_data_line;
    }

    public static AudioInputStream getInputStream(ByteArrayOutputStream byte_stream, AudioFormat audio_format) {
        byte[] audio_bytes = byte_stream.toByteArray();
        ByteArrayInputStream input_byte_stream = new ByteArrayInputStream(audio_bytes);
        long number_of_sample_frames = audio_bytes.length / audio_format.getFrameSize();
        AudioInputStream audio_input_stream = new AudioInputStream(input_byte_stream, audio_format, number_of_sample_frames);
        return audio_input_stream;
    }

    public static AudioInputStream getInputStream(byte[] audio_bytes, AudioFormat audio_format) {
        ByteArrayInputStream input_byte_stream = new ByteArrayInputStream(audio_bytes);
        long number_of_sample_frames = audio_bytes.length / audio_format.getFrameSize();
        AudioInputStream audio_input_stream = new AudioInputStream(input_byte_stream, audio_format, number_of_sample_frames);
        return audio_input_stream;
    }

    public static AudioInputStream getInputStream(File audio_file) throws Exception {
        AudioInputStream audio_input_stream = null;
        try {
            audio_input_stream = AudioSystem.getAudioInputStream(audio_file);
        }
        catch (UnsupportedAudioFileException ex) {
            throw new Exception("File " + audio_file.getName() + " has an unsupported audio format.");
        }
        catch (IOException ex) {
            throw new Exception("File " + audio_file.getName() + " is not readable.");
        }
        return audio_input_stream;
    }

    public static AudioFormat getConvertedAudioFormat(AudioFormat original_format) {
        int bit_depth = original_format.getSampleSizeInBits();
        if (bit_depth != 8 && bit_depth != 16) {
            bit_depth = 16;
        }
        return new AudioFormat(AudioFormat.Encoding.PCM_SIGNED, original_format.getSampleRate(), bit_depth, original_format.getChannels(), original_format.getChannels() * (bit_depth / 8), original_format.getSampleRate(), true);
    }

    public static AudioInputStream getConvertedAudioStream(AudioInputStream audio_input_stream) {
        AudioFormat original_audio_format = (audio_input_stream = AudioMethodsGeneral.convertUnsupportedFormat(audio_input_stream)).getFormat();
        AudioFormat new_audio_format = AudioMethodsGeneral.getConvertedAudioFormat(original_audio_format);
        if (!new_audio_format.matches(original_audio_format)) {
            audio_input_stream = AudioSystem.getAudioInputStream(new_audio_format, audio_input_stream);
        }
        return audio_input_stream;
    }

    public static AudioInputStream convertUnsupportedFormat(AudioInputStream audio_input_stream) {
        DataLine.Info info = new DataLine.Info(SourceDataLine.class, audio_input_stream.getFormat());
        if (!AudioSystem.isLineSupported(info)) {
            AudioFormat original_format = audio_input_stream.getFormat();
            int bit_depth = 16;
            AudioFormat new_audio_format = new AudioFormat(AudioFormat.Encoding.PCM_SIGNED, original_format.getSampleRate(), bit_depth, original_format.getChannels(), original_format.getChannels() * (bit_depth / 8), original_format.getSampleRate(), true);
            audio_input_stream = AudioSystem.getAudioInputStream(new_audio_format, audio_input_stream);
        }
        return audio_input_stream;
    }

    public static double[][] extractSampleValues(AudioInputStream audio_input_stream) throws Exception {
        double[][] sample_values;
        block7: {
            ByteBuffer byte_buffer;
            double max_sample_value;
            int number_samples;
            int bit_depth;
            int number_of_channels;
            block6: {
                byte[] audio_bytes = AudioMethodsGeneral.getBytesFromAudioInputStream(audio_input_stream);
                int number_bytes = audio_bytes.length;
                AudioFormat this_audio_format = audio_input_stream.getFormat();
                number_of_channels = this_audio_format.getChannels();
                bit_depth = this_audio_format.getSampleSizeInBits();
                if (bit_depth != 16 && bit_depth != 8 || !this_audio_format.isBigEndian() || this_audio_format.getEncoding() != AudioFormat.Encoding.PCM_SIGNED) {
                    throw new Exception("Only 8 or 16 bit signed PCM samples with a big-endian\nbyte order can be analyzed currently.");
                }
                int number_of_bytes = audio_bytes.length;
                int bytes_per_sample = bit_depth / 8;
                number_samples = number_of_bytes / bytes_per_sample / number_of_channels;
                if ((number_samples == 2 || bytes_per_sample == 2) && number_of_bytes % 2 != 0 || number_samples == 2 && bytes_per_sample == 2 && number_of_bytes % 4 != 0) {
                    throw new Exception("Uneven number of bytes for given bit depth and number of channels.");
                }
                max_sample_value = AudioMethodsDSP.findMaximumSampleValue(bit_depth) + 2.0;
                sample_values = new double[number_of_channels][number_samples];
                byte_buffer = ByteBuffer.wrap(audio_bytes);
                if (bit_depth != 8) break block6;
                for (int samp = 0; samp < number_samples; ++samp) {
                    for (int chan = 0; chan < number_of_channels; ++chan) {
                        sample_values[chan][samp] = (double)byte_buffer.get() / max_sample_value;
                    }
                }
                break block7;
            }
            if (bit_depth != 16) break block7;
            ShortBuffer short_buffer = byte_buffer.asShortBuffer();
            for (int samp = 0; samp < number_samples; ++samp) {
                for (int chan = 0; chan < number_of_channels; ++chan) {
                    sample_values[chan][samp] = (double)short_buffer.get() / max_sample_value;
                }
            }
        }
        return sample_values;
    }

    public static byte[] getBytesFromAudioInputStream(AudioInputStream audio_input_stream) throws Exception {
        float buffer_duration_in_seconds = 0.25f;
        int buffer_size = AudioMethodsGeneral.getNumberBytesNeeded(buffer_duration_in_seconds, audio_input_stream.getFormat());
        byte[] rw_buffer = new byte[buffer_size + 2];
        ByteArrayOutputStream byte_array_output_stream = new ByteArrayOutputStream();
        int position = audio_input_stream.read(rw_buffer, 0, rw_buffer.length);
        while (position > 0) {
            byte_array_output_stream.write(rw_buffer, 0, position);
            position = audio_input_stream.read(rw_buffer, 0, rw_buffer.length);
        }
        byte[] results = byte_array_output_stream.toByteArray();
        try {
            byte_array_output_stream.close();
        }
        catch (IOException e) {
            System.out.println(e);
            System.exit(0);
        }
        return results;
    }

    public static int getNumberBytesNeeded(double duration_in_seconds, AudioFormat audio_format) {
        int frame_size_in_bytes = audio_format.getFrameSize();
        float frame_rate = audio_format.getFrameRate();
        return (int)((double)((float)frame_size_in_bytes * frame_rate) * duration_in_seconds);
    }

    public static int getNumberBytesNeeded(int number_samples, AudioFormat audio_format) {
        int number_bytes_per_sample = audio_format.getSampleSizeInBits() / 8;
        int number_channels = audio_format.getChannels();
        return number_samples * number_bytes_per_sample * number_channels;
    }

    public static AudioInputStream convertToAudioInputStream(double[][] samples, AudioFormat audio_format) throws Exception {
        int number_bytes_needed = AudioMethodsGeneral.getNumberBytesNeeded(samples[0].length, audio_format);
        byte[] audio_bytes = new byte[number_bytes_needed];
        AudioMethodsGeneral.writeSamplesToBuffer(samples, audio_format.getSampleSizeInBits(), audio_bytes);
        return AudioMethodsGeneral.getInputStream(audio_bytes, audio_format);
    }

    public static void writeSamplesToBuffer(double[][] sample_values, int bit_depth, byte[] buffer) throws Exception {
        block8: {
            ByteBuffer byte_buffer;
            double max_sample_value;
            block7: {
                if (sample_values == null) {
                    throw new Exception("Empty set of samples to write provided.");
                }
                if (bit_depth != 8 && bit_depth != 16) {
                    throw new Exception("Bit depth of " + bit_depth + " specified." + "Only bit depths of 8 or 16 currently accepted.");
                }
                if (buffer == null) {
                    throw new Exception("Null buffer for storing samples provided.");
                }
                sample_values = AudioMethodsDSP.clipSamples(sample_values);
                max_sample_value = AudioMethodsDSP.findMaximumSampleValue(bit_depth);
                byte_buffer = ByteBuffer.wrap(buffer);
                if (bit_depth != 8) break block7;
                for (int samp = 0; samp < sample_values[0].length; ++samp) {
                    for (int chan = 0; chan < sample_values.length; ++chan) {
                        double sample_value = sample_values[chan][samp] * max_sample_value;
                        byte_buffer.put((byte)sample_value);
                    }
                }
                break block8;
            }
            if (bit_depth != 16) break block8;
            ShortBuffer short_buffer = byte_buffer.asShortBuffer();
            for (int samp = 0; samp < sample_values[0].length; ++samp) {
                for (int chan = 0; chan < sample_values.length; ++chan) {
                    double sample_value = sample_values[chan][samp] * max_sample_value;
                    short_buffer.put((short)sample_value);
                }
            }
        }
    }

    public static void saveByteArrayOutputStream(ByteArrayOutputStream audio, AudioFormat audio_format, File save_file, AudioFileFormat.Type file_type) throws Exception {
        if (audio == null) {
            throw new Exception("No audio data provided to save.");
        }
        if (audio_format == null) {
            throw new Exception("No audio format provided for saving.");
        }
        if (save_file == null) {
            throw new Exception("No file provided for saving.");
        }
        if (file_type == null) {
            throw new Exception("No audio file format provided for saving.");
        }
        int number_bytes = audio.size();
        int bytes_per_frame = audio_format.getFrameSize();
        long number_frames = number_bytes / bytes_per_frame;
        ByteArrayInputStream bais = new ByteArrayInputStream(audio.toByteArray());
        AudioInputStream audio_input_stream = new AudioInputStream(bais, audio_format, number_frames);
        AudioMethodsGeneral.saveToFile(audio_input_stream, save_file, file_type);
    }

    public static void saveToFile(AudioInputStream audio_input_stream, File file_to_save_to, AudioFileFormat.Type file_type) throws Exception {
        if (audio_input_stream == null) {
            throw new Exception("No audio provided to save.");
        }
        if (file_to_save_to == null) {
            throw new Exception("No file provided to save to.");
        }
        if (file_type == null) {
            throw new Exception("No file type to save to specified.");
        }
        AudioSystem.write(audio_input_stream, file_type, file_to_save_to);
    }
}

