/*
 * Decompiled with CFR 0.152.
 */
package mckay.utilities.sound.sampled;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import javax.sound.sampled.AudioFileFormat;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.TargetDataLine;

public class AudioMethodsRecording {
    public static RecordThread recordByteArrayOutputStream(TargetDataLine target_data_line) throws Exception {
        RecordThread record_thread = new RecordThread(target_data_line);
        record_thread.start();
        return record_thread;
    }

    public static RecordToFileThread recordToFile(TargetDataLine target_data_line, File file_to_save_to, AudioFileFormat.Type file_type) throws Exception {
        RecordToFileThread record_thread = new RecordToFileThread(target_data_line, file_to_save_to, file_type);
        record_thread.start();
        return record_thread;
    }

    public static class RecordToFileThread
    extends Thread {
        private TargetDataLine target_data_line;
        private File file_to_save_to;
        private AudioFileFormat.Type file_type;

        RecordToFileThread(TargetDataLine target_data_line, File file_to_save_to, AudioFileFormat.Type file_type) throws Exception {
            if (target_data_line == null) {
                throw new Exception("Target TargetDataLine for recording is empty.");
            }
            if (file_type == null) {
                throw new Exception("No file type to save to specified.");
            }
            if (file_to_save_to == null) {
                throw new Exception("No file to save to specified.");
            }
            try {
                file_to_save_to.createNewFile();
            }
            catch (Exception e) {
                throw new Exception("Cannot write to the given audio file: " + file_to_save_to.getAbsolutePath() + ".");
            }
            if (!file_to_save_to.canWrite() || !file_to_save_to.isFile()) {
                throw new Exception("Cannot write to the given audio file: " + file_to_save_to.getAbsolutePath() + ".");
            }
            this.target_data_line = target_data_line;
            this.file_to_save_to = file_to_save_to;
            this.file_type = file_type;
        }

        public void run() {
            try {
                AudioSystem.write(new AudioInputStream(this.target_data_line), this.file_type, this.file_to_save_to);
            }
            catch (IOException e) {
                System.out.println(e);
                System.exit(0);
            }
        }

        public void stopRecording() {
            this.target_data_line.stop();
            this.target_data_line.close();
        }
    }

    public static class RecordThread
    extends Thread {
        private byte[] rw_buffer;
        private boolean stop_recording;
        private TargetDataLine target_data_line;
        private ByteArrayOutputStream byte_array_output_stream;

        RecordThread(TargetDataLine target_data_line) throws Exception {
            int frame_size_in_bytes = target_data_line.getFormat().getFrameSize();
            float frame_rate = target_data_line.getFormat().getFrameRate();
            float buffer_duration_in_seconds = 0.25f;
            int buffer_size = (int)((float)frame_size_in_bytes * frame_rate * buffer_duration_in_seconds);
            if (target_data_line == null) {
                throw new Exception("Target TargetDataLine for recording is empty.");
            }
            this.target_data_line = target_data_line;
            this.rw_buffer = new byte[buffer_size];
            this.stop_recording = false;
            this.byte_array_output_stream = null;
        }

        public void run() {
            this.stop_recording = false;
            this.byte_array_output_stream = new ByteArrayOutputStream();
            while (!this.stop_recording) {
                int position = this.target_data_line.read(this.rw_buffer, 0, this.rw_buffer.length);
                if (position <= 0) continue;
                this.byte_array_output_stream.write(this.rw_buffer, 0, position);
            }
            try {
                this.byte_array_output_stream.close();
            }
            catch (IOException e) {
                System.out.println(e);
                System.exit(0);
            }
            this.target_data_line.stop();
            this.target_data_line.close();
        }

        public void stopRecording() {
            this.stop_recording = true;
        }

        public ByteArrayOutputStream getRecordedData() {
            return this.byte_array_output_stream;
        }

        public AudioFormat getFormatUsedForRecording() {
            return this.target_data_line.getFormat();
        }
    }
}

