/*
 * Decompiled with CFR 0.152.
 */
package mckay.utilities.sound.sampled;

import java.util.Date;
import java.util.Random;
import javax.sound.sampled.AudioFormat;
import mckay.utilities.sound.sampled.AudioMethodsDSP;
import mckay.utilities.sound.sampled.AudioMethodsGeneral;

public class AudioMethodsSynthesis {
    private static final int SINE_WAVE = 1;
    private static final int BASIC_TONE = 2;
    private static final int STEREO_PANNING = 3;
    private static final int STEREO_PINPONG = 4;
    private static final int FM_SWEEP = 5;
    private static final int DECAY_PULSE = 6;
    private static final int WHITE_NOISE = 7;

    public static double[][] synthesizeAndWriteToBuffer(byte[] buffer, double duration, AudioFormat audio_format, int synthesis_type, double gain, double panning, double fundamental_frequency, double max_frac_samp_rate, double click_avoid_env_length) throws Exception {
        if (audio_format == null) {
            throw new Exception("Null audio format provided.");
        }
        if (audio_format.getSampleSizeInBits() != 16 && audio_format.getSampleSizeInBits() != 8 || !audio_format.isBigEndian() || audio_format.getEncoding() != AudioFormat.Encoding.PCM_SIGNED) {
            throw new Exception("Only 8 or 16 bit signed PCM samples with a big-endian\nbyte order can be generated currently.");
        }
        int number_of_channels = audio_format.getChannels();
        float sample_rate = audio_format.getSampleRate();
        int bit_depth = audio_format.getSampleSizeInBits();
        int total_number_of_samples_per_channel = 0;
        if (buffer != null) {
            int bytes_per_sample = bit_depth / 8;
            int total_number_of_bytes = buffer.length;
            int total_number_of_samples = total_number_of_bytes / bytes_per_sample;
            total_number_of_samples_per_channel = total_number_of_samples / number_of_channels;
        } else {
            total_number_of_samples_per_channel = (int)((double)sample_rate * duration);
        }
        double[][] sample_values = null;
        if (synthesis_type == 1) {
            sample_values = AudioMethodsSynthesis.generateSamplesSineWave(fundamental_frequency, number_of_channels, sample_rate, max_frac_samp_rate, total_number_of_samples_per_channel);
        } else if (synthesis_type == 2) {
            sample_values = AudioMethodsSynthesis.generateSamplesBasicTone(fundamental_frequency, number_of_channels, sample_rate, max_frac_samp_rate, total_number_of_samples_per_channel);
        } else if (synthesis_type == 3) {
            sample_values = AudioMethodsSynthesis.generateSamplesStereoPanning(fundamental_frequency, number_of_channels, sample_rate, max_frac_samp_rate, total_number_of_samples_per_channel);
        } else if (synthesis_type == 4) {
            sample_values = AudioMethodsSynthesis.generateSamplesStereoPingpong(fundamental_frequency, number_of_channels, sample_rate, max_frac_samp_rate, total_number_of_samples_per_channel);
        } else if (synthesis_type == 5) {
            sample_values = AudioMethodsSynthesis.generateSamplesFMSweep(fundamental_frequency, number_of_channels, sample_rate, max_frac_samp_rate, total_number_of_samples_per_channel);
        } else if (synthesis_type == 6) {
            sample_values = AudioMethodsSynthesis.generateSamplesDecayPulse(fundamental_frequency, number_of_channels, sample_rate, max_frac_samp_rate, total_number_of_samples_per_channel);
        } else if (synthesis_type == 7) {
            sample_values = AudioMethodsSynthesis.generateWhiteNoise(number_of_channels, total_number_of_samples_per_channel);
        } else {
            throw new Exception("Invalid synthesis type specified.");
        }
        AudioMethodsDSP.applyGainAndPanning(sample_values, gain, panning);
        AudioMethodsDSP.applyClickAvoidanceAttenuationEnvelope(sample_values, click_avoid_env_length, sample_rate);
        int samples_per_channel = sample_values[0].length;
        for (int chan = 0; chan < sample_values.length; ++chan) {
            if (sample_values[chan].length == samples_per_channel) continue;
            throw new Exception("Channels do not have equal number of samples.");
        }
        if (buffer != null) {
            AudioMethodsGeneral.writeSamplesToBuffer(sample_values, bit_depth, buffer);
            return null;
        }
        return sample_values;
    }

    public static int getSynthesisTypeCode(String synthesis_type_name) throws Exception {
        if (synthesis_type_name.equals("Sine Wave")) {
            return 1;
        }
        if (synthesis_type_name.equals("Basic Tone")) {
            return 2;
        }
        if (synthesis_type_name.equals("Stereo Panning")) {
            return 3;
        }
        if (synthesis_type_name.equals("Stereo Pingpong")) {
            return 4;
        }
        if (synthesis_type_name.equals("FM Sweep")) {
            return 5;
        }
        if (synthesis_type_name.equals("Decay Pulse")) {
            return 6;
        }
        if (synthesis_type_name.equals("White Noise")) {
            return 7;
        }
        throw new Exception("Unknown type of synthesis specified: " + synthesis_type_name + ".\n" + "Known types of synthesis are:\n" + "   Sine Wave, Basic Tone, Stereo Panning, Stereo Pingpong\n" + "   FM Sweep, White Noise and Decay Pulse.");
    }

    public static String[] getSynthesisNames() {
        String[] names = new String[]{"Sine Wave", "Basic Tone", "Stereo Panning", "Stereo Pingpong", "FM Sweep", "Decay Pulse", "White Noise"};
        return names;
    }

    public static double[][] generateSamplesSineWave(double fund_freq, int number_of_channels, float sample_rate, double max_frac_samp_rate, int total_samples_per_chan) throws Exception {
        if (max_frac_samp_rate <= 0.0) {
            throw new Exception("Invalid maximum allowable fraction of sampling rate of " + max_frac_samp_rate + " specified.\n" + "This value must be above 0.");
        }
        if (fund_freq <= 0.0) {
            throw new Exception("Invalid fundamental frequence of " + fund_freq + " Hz specified.\n" + "Frequency must be above 0 Hz.");
        }
        if (fund_freq >= max_frac_samp_rate * (double)sample_rate) {
            throw new Exception("Invalid fundamental frequency of " + fund_freq + " Hz specified.\n" + "Frequency must be below " + max_frac_samp_rate * (double)sample_rate + " Hz\n" + "under current settings. This is done in order to avoid aliasing at this\n" + "sampling rate of " + sample_rate + " Hz for this type of synthesis.");
        }
        if (number_of_channels < 1) {
            throw new Exception("There must be 1 or more channels. You specified " + number_of_channels + ".");
        }
        if (sample_rate <= 0.0f) {
            throw new Exception("Invalid sampling rate of " + sample_rate + " Hz specified.\n" + "Must be greater than 0.");
        }
        if (total_samples_per_chan <= 0) {
            throw new Exception("Invalid total number of samples per channel of " + total_samples_per_chan + " specified.\n" + "Must be greater than 0.");
        }
        double[][] samples = new double[number_of_channels][total_samples_per_chan];
        for (int samp = 0; samp < total_samples_per_chan; ++samp) {
            double time = (float)samp / sample_rate;
            double sample_value = Math.sin(Math.PI * 2 * fund_freq * time);
            for (int chan = 0; chan < samples.length; ++chan) {
                samples[chan][samp] = sample_value;
            }
        }
        return samples;
    }

    public static double[][] generateSamplesBasicTone(double fund_freq, int number_of_channels, float sample_rate, double max_frac_samp_rate, int total_samples_per_chan) throws Exception {
        if (max_frac_samp_rate <= 0.0) {
            throw new Exception("Invalid maximum allowable fraction of sampling rate of " + max_frac_samp_rate + " specified.\n" + "This value must be above 0.");
        }
        if (fund_freq <= 0.0) {
            throw new Exception("Invalid fundamental frequence of " + fund_freq + " Hz specified.\n" + "Frequency must be above 0 Hz.");
        }
        if (fund_freq >= max_frac_samp_rate * (double)sample_rate / 1.8) {
            throw new Exception("Invalid fundamental frequency of " + fund_freq + " Hz specified.\n" + "Frequency must be below " + max_frac_samp_rate * (double)sample_rate / 1.8 + " Hz\n" + "under current settings. This is done in order to avoid aliasing at this\n" + "sampling rate of " + sample_rate + " Hz for this type of synthesis.");
        }
        if (number_of_channels < 1) {
            throw new Exception("There must be 1 or more channels. You specified " + number_of_channels + ".");
        }
        if (sample_rate <= 0.0f) {
            throw new Exception("Invalid sampling rate of " + sample_rate + " Hz specified.\n" + "Must be greater than 0.");
        }
        if (total_samples_per_chan <= 0) {
            throw new Exception("Invalid total number of samples per channel of " + total_samples_per_chan + " specified.\n" + "Must be greater than 0.");
        }
        double[][] samples = new double[number_of_channels][total_samples_per_chan];
        for (int samp = 0; samp < total_samples_per_chan; ++samp) {
            double time = (float)samp / sample_rate;
            double sample_value = Math.sin(Math.PI * 2 * fund_freq * time) + Math.sin(7.5398223686155035 * fund_freq * time) + Math.sin(11.309733552923255 * fund_freq * time);
            sample_value /= 3.0;
            for (int chan = 0; chan < samples.length; ++chan) {
                samples[chan][samp] = sample_value;
            }
        }
        return samples;
    }

    public static double[][] generateSamplesStereoPanning(double fund_freq, int number_of_channels, float sample_rate, double max_frac_samp_rate, int total_samples_per_chan) throws Exception {
        if (max_frac_samp_rate <= 0.0) {
            throw new Exception("Invalid maximum allowable fraction of sampling rate of " + max_frac_samp_rate + " specified.\n" + "This value must be above 0.");
        }
        if (fund_freq <= 0.0) {
            throw new Exception("Invalid fundamental frequence of " + fund_freq + " Hz specified.\n" + "Frequency must be above 0 Hz.");
        }
        if (fund_freq >= max_frac_samp_rate * (double)sample_rate / 1.8) {
            throw new Exception("Invalid fundamental frequency of " + fund_freq + " Hz specified.\n" + "Frequency must be below " + max_frac_samp_rate * (double)sample_rate + " Hz\n" + "under current settings. This is done in order to avoid aliasing at this\n" + "sampling rate of " + sample_rate + " Hz for this type of synthesis.");
        }
        if (number_of_channels != 2) {
            throw new Exception("There must be 2 channels. You specified " + number_of_channels + ".");
        }
        if (sample_rate <= 0.0f) {
            throw new Exception("Invalid sampling rate of " + sample_rate + " Hz specified.\n" + "Must be greater than 0.");
        }
        if (total_samples_per_chan <= 0) {
            throw new Exception("Invalid total number of samples per channel of " + total_samples_per_chan + " specified.\n" + "Must be greater than 0.");
        }
        double[][] samples = new double[number_of_channels][total_samples_per_chan];
        for (int samp = 0; samp < total_samples_per_chan; ++samp) {
            double time = (float)samp / sample_rate;
            double right_gain = (double)samp / (double)total_samples_per_chan;
            double left_gain = 1.0 - right_gain;
            double original_left_sample_value = Math.sin(Math.PI * 2 * fund_freq * time);
            double original_right_sample_value = Math.sin(Math.PI * 2 * fund_freq / 2.0 * time);
            samples[0][samp] = left_gain * original_left_sample_value;
            samples[1][samp] = right_gain * original_right_sample_value;
        }
        return samples;
    }

    public static double[][] generateSamplesStereoPingpong(double fund_freq, int number_of_channels, float sample_rate, double max_frac_samp_rate, int total_samples_per_chan) throws Exception {
        if (max_frac_samp_rate <= 0.0) {
            throw new Exception("Invalid maximum allowable fraction of sampling rate of " + max_frac_samp_rate + " specified.\n" + "This value must be above 0.");
        }
        if (fund_freq <= 0.0) {
            throw new Exception("Invalid fundamental frequence of " + fund_freq + " Hz specified.\n" + "Frequency must be above 0 Hz.");
        }
        if (fund_freq >= max_frac_samp_rate * (double)sample_rate / 1.8) {
            throw new Exception("Invalid fundamental frequency of " + fund_freq + " Hz specified.\n" + "Frequency must be below " + max_frac_samp_rate * (double)sample_rate + " Hz\n" + "under current settings. This is done in order to avoid aliasing at this\n" + "sampling rate of " + sample_rate + " Hz for this type of synthesis.");
        }
        if (number_of_channels != 2) {
            throw new Exception("There must be 2 channels. You specified " + number_of_channels + ".");
        }
        if (sample_rate <= 0.0f) {
            throw new Exception("Invalid sampling rate of " + sample_rate + " Hz specified.\n" + "Must be greater than 0.");
        }
        if (total_samples_per_chan <= 0) {
            throw new Exception("Invalid total number of samples per channel of " + total_samples_per_chan + " specified.\n" + "Must be greater than 0.");
        }
        double[][] samples = new double[number_of_channels][total_samples_per_chan];
        double number_of_times_a_sec_switches_occur = 4.0;
        double switch_time_interval = 1.0 / number_of_times_a_sec_switches_occur;
        double time_of_last_switch = 0.0;
        double right_gain = 0.0;
        double left_gain = 1.0;
        for (int samp = 0; samp < total_samples_per_chan; ++samp) {
            double time = (float)samp / sample_rate;
            if (time - time_of_last_switch > switch_time_interval) {
                double temp = left_gain;
                left_gain = right_gain;
                right_gain = temp;
                time_of_last_switch = time;
            }
            double original_left_sample_value = Math.sin(Math.PI * 2 * fund_freq * time);
            double original_right_sample_value = Math.sin(Math.PI * 2 * fund_freq * 0.8 * time);
            samples[0][samp] = left_gain * original_left_sample_value;
            samples[1][samp] = right_gain * original_right_sample_value;
        }
        return samples;
    }

    public static double[][] generateSamplesFMSweep(double fund_freq, int number_of_channels, float sample_rate, double max_frac_samp_rate, int total_samples_per_chan) throws Exception {
        if (max_frac_samp_rate <= 0.0) {
            throw new Exception("Invalid maximum allowable fraction of sampling rate of " + max_frac_samp_rate + " specified.\n" + "This value must be above 0.");
        }
        if (fund_freq <= 0.0) {
            throw new Exception("Invalid fundamental frequence of " + fund_freq + " Hz specified.\n" + "Frequency must be above 0 Hz.");
        }
        if (fund_freq >= max_frac_samp_rate * (double)sample_rate) {
            throw new Exception("Invalid fundamental frequency of " + fund_freq + " Hz specified.\n" + "Frequency must be below " + max_frac_samp_rate * (double)sample_rate + " Hz\n" + "under current settings. This is done in order to avoid aliasing at this\n" + "sampling rate of " + sample_rate + " Hz for this type of synthesis.");
        }
        if (number_of_channels < 1) {
            throw new Exception("There must be 1 or more channels. You specified " + number_of_channels + ".");
        }
        if (sample_rate <= 0.0f) {
            throw new Exception("Invalid sampling rate of " + sample_rate + " Hz specified.\n" + "Must be greater than 0.");
        }
        if (total_samples_per_chan <= 0) {
            throw new Exception("Invalid total number of samples per channel of " + total_samples_per_chan + " specified.\n" + "Must be greater than 0.");
        }
        double[][] samples = new double[number_of_channels][total_samples_per_chan];
        double high_freq = fund_freq;
        double low_freq = high_freq / 10.0;
        for (int samp = 0; samp < total_samples_per_chan; ++samp) {
            double time = (float)samp / sample_rate;
            double fraction_done = (double)samp / (double)total_samples_per_chan;
            double freq = low_freq + (high_freq - low_freq) * fraction_done;
            double sample_value = Math.sin(Math.PI * 2 * freq * time);
            for (int chan = 0; chan < samples.length; ++chan) {
                samples[chan][samp] = sample_value;
            }
        }
        return samples;
    }

    public static double[][] generateSamplesDecayPulse(double fund_freq, int number_of_channels, float sample_rate, double max_frac_samp_rate, int total_samples_per_chan) throws Exception {
        if (max_frac_samp_rate <= 0.0) {
            throw new Exception("Invalid maximum allowable fraction of sampling rate of " + max_frac_samp_rate + " specified.\n" + "This value must be above 0.");
        }
        if (fund_freq <= 0.0) {
            throw new Exception("Invalid fundamental frequence of " + fund_freq + " Hz specified.\n" + "Frequency must be above 0 Hz.");
        }
        if (fund_freq >= max_frac_samp_rate * (double)sample_rate) {
            throw new Exception("Invalid fundamental frequency of " + fund_freq + " Hz specified.\n" + "Frequency must be below " + max_frac_samp_rate * (double)sample_rate + " Hz\n" + "under current settings. This is done in order to avoid aliasing at this\n" + "sampling rate of " + sample_rate + " Hz for this type of synthesis.");
        }
        if (number_of_channels < 1) {
            throw new Exception("There must be 1 or more channels. You specified " + number_of_channels + ".");
        }
        if (sample_rate <= 0.0f) {
            throw new Exception("Invalid sampling rate of " + sample_rate + " Hz specified.\n" + "Must be greater than 0.");
        }
        if (total_samples_per_chan <= 0) {
            throw new Exception("Invalid total number of samples per channel of " + total_samples_per_chan + " specified.\n" + "Must be greater than 0.");
        }
        double[][] samples = new double[number_of_channels][total_samples_per_chan];
        for (int samp = 0; samp < total_samples_per_chan; ++samp) {
            double time = (float)samp / sample_rate;
            double fraction_done = (double)samp / (double)total_samples_per_chan;
            double amplitude_coef = 1.0 - fraction_done;
            double sample_value = amplitude_coef * Math.sin(Math.PI * 2 * fund_freq * time);
            for (int chan = 0; chan < samples.length; ++chan) {
                samples[chan][samp] = sample_value;
            }
        }
        return samples;
    }

    public static double[][] generateWhiteNoise(int number_of_channels, int total_samples_per_chan) throws Exception {
        if (number_of_channels < 1) {
            throw new Exception("There must be 1 or more channels. You specified " + number_of_channels + ".");
        }
        if (total_samples_per_chan <= 0) {
            throw new Exception("Invalid total number of samples per channel of " + total_samples_per_chan + " specified.\n" + "Must be greater than 0.");
        }
        double[][] samples = new double[number_of_channels][total_samples_per_chan];
        Random generator = new Random(new Date().getTime());
        for (int samp = 0; samp < total_samples_per_chan; ++samp) {
            for (int chan = 0; chan < number_of_channels; ++chan) {
                samples[chan][samp] = 2.0 * generator.nextDouble() - 1.0;
            }
        }
        return samples;
    }
}

