/*
 * Decompiled with CFR 0.152.
 */
package mckay.utilities.staticlibraries;

import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.util.Vector;
import javax.swing.JOptionPane;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileMethods {
    public static File getNewFileForWriting(String path, boolean can_erase) {
        int response;
        boolean go_ahead = true;
        File to_file = new File(path);
        if (to_file.exists() && !can_erase && (response = JOptionPane.showConfirmDialog(null, "A file with the path " + path + " already exists.\nDo you wish to overwrite it?", "Warning", 2, 2)) != 0) {
            go_ahead = false;
        }
        if (go_ahead) {
            try {
                DataOutputStream writer = FileMethods.getDataOutputStream(to_file);
                writer.writeBytes("");
                writer.close();
                return to_file;
            }
            catch (Exception e) {
                JOptionPane.showMessageDialog(null, "Unable to write file.", "ERROR", 0);
                return null;
            }
        }
        return null;
    }

    public static DataOutputStream getDataOutputStream(File file) throws FileNotFoundException {
        FileOutputStream to = new FileOutputStream(file);
        return new DataOutputStream(to);
    }

    public static boolean validateFile(File file, boolean need_read, boolean need_write) throws Exception {
        if (file == null) {
            throw new Exception("Empty file reference provided.");
        }
        if (!file.exists()) {
            throw new Exception("File " + file.getPath() + " does not exist.");
        }
        if (file.isDirectory()) {
            throw new Exception("Reference to a directory instead of a file: " + file.getPath() + ".");
        }
        if (!file.isFile()) {
            throw new Exception("Reference to " + file.getPath() + "is not a valid file.");
        }
        if (need_read && !file.canRead()) {
            throw new Exception("Cannot read from file " + file.getPath() + ".");
        }
        if (need_write && !file.canWrite()) {
            throw new Exception("File " + file.getPath() + " cannot be written to.");
        }
        return true;
    }

    public static File[] getAllFilesInDirectory(File directory, boolean explore_subdirectories, FileFilter filter, Vector<File> results) {
        if (!directory.isDirectory()) {
            return null;
        }
        if (results == null) {
            results = new Vector();
        }
        File[] in_this_directory = directory.listFiles(filter);
        for (int i = 0; i < in_this_directory.length; ++i) {
            if (in_this_directory[i].isDirectory()) {
                if (!explore_subdirectories) continue;
                FileMethods.getAllFilesInDirectory(in_this_directory[i], explore_subdirectories, filter, results);
                continue;
            }
            results.add(in_this_directory[i]);
        }
        File[] results_array = results.toArray(new File[1]);
        if (results_array[0] == null) {
            return null;
        }
        return results_array;
    }

    public static boolean createEmptyDirectory(String path) {
        boolean success;
        File directory = new File(path);
        if (directory.exists() && !(success = FileMethods.deleteDirectoryRecursively(directory))) {
            return false;
        }
        return directory.mkdir();
    }

    public static boolean deleteDirectoryRecursively(File directory) {
        if (directory.isDirectory()) {
            String[] children = directory.list();
            for (int i = 0; i < children.length; ++i) {
                boolean success = FileMethods.deleteDirectoryRecursively(new File(directory, children[i]));
                if (success) continue;
                return false;
            }
        }
        return directory.delete();
    }

    public static void copyFile(String original, String destination) throws Exception {
        int c;
        File original_file = new File(original);
        File destination_file = new File(destination);
        if (!original_file.exists()) {
            throw new Exception("File with path " + original + " does not exist.");
        }
        if (destination_file.exists()) {
            throw new Exception("File with path " + destination + " already exists.");
        }
        FileReader in = new FileReader(original_file);
        FileWriter out = new FileWriter(destination_file);
        while ((c = in.read()) != -1) {
            out.write(c);
        }
        in.close();
        out.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String parseTextFile(File to_parse) throws Exception {
        FileMethods.validateFile(to_parse, true, false);
        StringBuilder contents = new StringBuilder();
        BufferedReader buffered_input = new BufferedReader(new FileReader(to_parse));
        try {
            String line = null;
            while ((line = buffered_input.readLine()) != null) {
                contents.append(line);
                contents.append(System.getProperty("line.separator"));
            }
        }
        finally {
            buffered_input.close();
        }
        return contents.toString();
    }

    public static String[] parseTextFileLines(File to_parse) throws Exception {
        FileMethods.validateFile(to_parse, true, false);
        FileReader reader = new FileReader(to_parse);
        BufferedReader parser = new BufferedReader(reader);
        Vector<String> parsed_lines = new Vector<String>();
        String this_line = "";
        while ((this_line = parser.readLine()) != null) {
            parsed_lines.add(this_line);
        }
        return parsed_lines.toArray(new String[1]);
    }
}

