/*
 * Decompiled with CFR 0.152.
 */
package mckay.utilities.staticlibraries;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.net.HttpURLConnection;
import java.net.ProtocolException;
import java.net.URL;
import java.net.URLConnection;

public class NetworkMethods {
    public static String sendGetRequest(String url_to_access, String request_parameters) throws Exception {
        String result = null;
        if (url_to_access.startsWith("http://")) {
            String url_with_parameters = url_to_access;
            if (request_parameters != null && request_parameters.length() > 0) {
                url_with_parameters = url_with_parameters + "?" + request_parameters;
            }
            URLConnection connection = new URL(url_with_parameters).openConnection();
            BufferedReader reader = new BufferedReader(new InputStreamReader(connection.getInputStream()));
            StringBuffer buffer = new StringBuffer();
            String line = null;
            while ((line = reader.readLine()) != null) {
                buffer.append(line);
            }
            reader.close();
            result = buffer.toString();
        }
        return result;
    }

    public static void postData(URL url_to_access, Reader to_send, Writer response_writer) throws Exception {
        HttpURLConnection url_connection = null;
        try {
            url_connection = (HttpURLConnection)url_to_access.openConnection();
            try {
                url_connection.setRequestMethod("POST");
            }
            catch (ProtocolException e) {
                throw new Exception("HttpURLConnection does not support POST", e);
            }
            url_connection.setDoOutput(true);
            url_connection.setDoInput(true);
            url_connection.setUseCaches(false);
            url_connection.setAllowUserInteraction(false);
            url_connection.setRequestProperty("Content-type", "text/xml; charset=UTF-8");
            OutputStream out = url_connection.getOutputStream();
            try {
                OutputStreamWriter writer = new OutputStreamWriter(out, "UTF-8");
                NetworkMethods.pipe(to_send, writer);
                ((Writer)writer).close();
            }
            catch (IOException e) {
                throw new Exception("IOException while posting data", e);
            }
            finally {
                if (out != null) {
                    out.close();
                }
            }
            InputStream in = url_connection.getInputStream();
            try {
                InputStreamReader reader = new InputStreamReader(in);
                NetworkMethods.pipe(reader, response_writer);
                ((Reader)reader).close();
            }
            catch (IOException e) {
                throw new Exception("IOException while reading response", e);
            }
            finally {
                if (in != null) {
                    in.close();
                }
            }
        }
        catch (IOException e) {
            throw new Exception("Connection error while attempting to post to " + url_to_access + ": " + e);
        }
        finally {
            if (url_connection != null) {
                url_connection.disconnect();
            }
        }
    }

    public static void pipe(Reader reader, Writer writer) throws IOException {
        char[] buffer = new char[1024];
        int read = 0;
        while ((read = reader.read(buffer)) >= 0) {
            writer.write(buffer, 0, read);
        }
        writer.flush();
    }
}

