/*
 * Decompiled with CFR 0.152.
 */
package mckay.utilities.vectorsorter;

import java.util.Vector;
import mckay.utilities.vectorsorter.QuicksortComparator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SortableVector<E>
extends Vector<E> {
    private QuicksortComparator comparator;
    private static final long serialVersionUID = 53006L;

    public SortableVector(QuicksortComparator comparator) {
        this.comparator = comparator;
    }

    public void sort() {
        this.quickSort();
    }

    private void quickSort() {
        int[] problem_stack = new int[10000];
        int left = 0;
        int right = this.size() - 1;
        int problem = 2;
        while (problem != 0) {
            if (right > left) {
                int pivot = this.partition(left, right);
                if (pivot - left > right - pivot) {
                    problem_stack[problem] = left;
                    problem_stack[problem + 1] = pivot - 1;
                    left = pivot + 1;
                } else {
                    problem_stack[problem] = pivot + 1;
                    problem_stack[problem + 1] = right;
                    right = pivot - 1;
                }
                problem += 2;
                continue;
            }
            left = problem_stack[problem -= 2];
            right = problem_stack[problem + 1];
        }
    }

    private int partition(int left, int right) {
        int median = (left + right) / 2;
        this.order(left, median);
        this.order(median, right);
        this.order(median, left);
        Object pivot_element = this.get(left);
        int known_low = left;
        for (int unknown = left + 1; unknown <= right; ++unknown) {
            if (this.comparator.compare(this.get(unknown), pivot_element) >= 0) continue;
            this.swap(++known_low, unknown);
        }
        this.swap(left, known_low);
        return known_low;
    }

    private void order(int first, int second) {
        if (this.comparator.compare(this.get(first), this.get(second)) > 0) {
            this.swap(first, second);
        }
    }

    private void swap(int first, int second) {
        Object temp = this.elementAt(first);
        this.setElementAt(this.elementAt(second), first);
        this.setElementAt(temp, second);
    }
}

