/*
 * Decompiled with CFR 0.152.
 */
package mckay.utilities.webservices;

import java.text.SimpleDateFormat;
import java.util.Date;
import javax.swing.JOptionPane;
import mckay.utilities.staticlibraries.StringMethods;

public abstract class NetworkSearch {
    protected boolean literal_search = true;
    protected boolean or_based_search = false;
    protected boolean include_similar_but_non_matching = false;
    protected String[] strings_to_exclude = null;
    protected String specific_site = null;
    protected String limit_to_language = "No Limitations";
    protected String limit_to_country = "No Limitations";
    protected String region_to_search_from = "No Limitations";
    protected String limit_to_file_type = "No Limitations";
    protected boolean suppress_similar_hits = false;
    protected boolean suppress_adult_content = false;
    public static final String[] included_languages = new String[]{"No Limitations", "English", "French", "Spanish", "Portuguese", "German", "Chinese", "Japanese", "Turkish", "Arabic"};
    public static final String[] included_countries = new String[]{"No Limitations", "Canada", "U.S.A.", "U.K.", "France", "Spain", "Germany", "Austria", "Brazil", "Japan", "China", "Turkey"};
    public static final String[] included_file_types = new String[]{"No Limitations", "html", "txt", "pdf", "doc", "ppt", "xls", "rss"};
    public static final int GOOGLE_SOAP_CODE = 1;
    public static final int YAHOO_REST_CODE = 2;

    public void setLiteralSearch(boolean literal_search) {
        this.literal_search = literal_search;
    }

    public void setOrBasedSearch(boolean or_based_search) {
        this.or_based_search = or_based_search;
    }

    public void setIncludeSimilarButNonMatchingStrings(boolean include_similar_but_non_matching) {
        this.include_similar_but_non_matching = include_similar_but_non_matching;
    }

    public void setSearchStringsToExclude(String[] strings_to_exclude) throws Exception {
        if (strings_to_exclude != null) {
            for (int i = 0; i < strings_to_exclude.length; ++i) {
                if (strings_to_exclude[i] != null) continue;
                throw new Exception("Null search exclusion string specified.");
            }
        }
        this.strings_to_exclude = strings_to_exclude;
    }

    public void setSpecificSiteToSearch(String specific_site) {
        this.specific_site = specific_site;
    }

    public void setLanguageResultsMustBeIn(String language) throws Exception {
        if (language == null) {
            throw new Exception("Null language string provided.");
        }
        boolean found = false;
        for (int i = 0; i < included_languages.length; ++i) {
            if (!included_languages[i].equals(language)) continue;
            found = true;
        }
        if (!found) {
            throw new Exception("Language of " + language + " specified.\nLimiting searches to this language is not permitted.");
        }
        this.limit_to_language = language;
    }

    public void setCountryResultsMustBeIn(String country) throws Exception {
        if (country == null) {
            throw new Exception("Null country string provided.");
        }
        boolean found = false;
        for (int i = 0; i < included_countries.length; ++i) {
            if (!included_countries[i].equals(country)) continue;
            found = true;
        }
        if (!found) {
            throw new Exception("Country of " + country + " specified.\nLimiting searches to this country is not permitted.");
        }
        this.limit_to_country = country;
    }

    public void setRegionToSearchFrom(String country) throws Exception {
        if (country == null) {
            throw new Exception("Null country string provided.");
        }
        boolean found = false;
        for (int i = 0; i < included_countries.length; ++i) {
            if (!included_countries[i].equals(country)) continue;
            found = true;
        }
        if (!found) {
            throw new Exception("Country of " + country + " specified.\nPerforming searches in this country is not permitted.");
        }
        this.region_to_search_from = country;
    }

    public void setFileTypeResultsMustBelongTo(String file_type) throws Exception {
        if (file_type == null) {
            throw new Exception("Null file type string provided.");
        }
        boolean found = false;
        for (int i = 0; i < included_file_types.length; ++i) {
            if (!included_file_types[i].equals(file_type)) continue;
            found = true;
        }
        if (!found) {
            throw new Exception("File type of " + file_type + " specified.\nLimiting searches to this file type is not permitted.");
        }
        this.limit_to_file_type = file_type;
    }

    public void setSuppressSimilarHits(boolean suppress_similar_hits) {
        this.suppress_similar_hits = suppress_similar_hits;
    }

    public void setSuppressAdultContent(boolean suppress_adult_content) {
        this.suppress_adult_content = suppress_adult_content;
    }

    public String[][] getSearchResults(String search_string, int start_index, int max_results, String[] number_hits, String[] query_used) throws Exception {
        String[] search_array = new String[]{search_string};
        return this.getSearchResults(search_array, start_index, max_results, number_hits, query_used);
    }

    public long getNumberHits(String search_string, String[] query_used) throws Exception {
        String[] search_array = new String[]{search_string};
        return this.getNumberHits(search_array, query_used);
    }

    public String getHTMLFormattedSearchResults(String[][] search_results, int start_rank, String total_hits, String query_used, String service_name) {
        String formatted_results = "<HTML>\n<HEAD>\n\t<TITLE>Search Results</TITLE>\n</HEAD>\n<BODY>\n";
        if (search_results.length == 0) {
            formatted_results = formatted_results + "<p><b>No hits</b> found with the " + service_name + " web services.</p>\n";
        } else {
            String total = StringMethods.getNumberFormattedWithCommas(Integer.parseInt(total_hits));
            formatted_results = formatted_results + "<i>Results " + start_rank + " to " + (start_rank + search_results.length - 1) + " of about </i><b>" + total + "</b><i> hits found with the " + service_name + " web services.\n";
            formatted_results = formatted_results + "Note that the total hits reported by some web services are not filtered by certain query filters even when the actual results are.</i>\n<hr>\n";
            for (int i = 0; i < search_results.length; ++i) {
                formatted_results = formatted_results + "\n<p><b>RESULT " + (i + start_rank) + ":</b> " + search_results[i][0] + "<br>\n";
                formatted_results = formatted_results + "<a href=\"" + search_results[i][1] + "\">" + search_results[i][1] + "</a><br>\n";
                formatted_results = formatted_results + search_results[i][2] + "</p>\n";
            }
        }
        formatted_results = formatted_results + "<br><hr><br>\n<i>Search query used: </i><b>" + query_used + "</b><i>.<br>\n";
        formatted_results = formatted_results + "It is important to note that this query may not contain all of the query parameters used, however. This is because many web services impose maxima on query lengths, so it can be more effective to directly incorporate query parameters into web service objects when possible.</i>\n";
        formatted_results = formatted_results + "<p><hr><br>\n<i>" + this.getSearchServiceLimitations() + "</i>";
        formatted_results = formatted_results + "\n</BODY>\n</HTML>";
        return formatted_results;
    }

    public abstract String getSeachServiceName();

    public abstract String getSearchServiceLimitations();

    public abstract String[][] getSearchResults(String[] var1, int var2, int var3, String[] var4, String[] var5) throws Exception;

    public abstract long getNumberHits(String[] var1, String[] var2) throws Exception;

    public long getNumberHits(String[] search_strings, String[] query_used, int allowed_attempts) throws Exception {
        int try_number = 1;
        int overall_tries = 1;
        while (try_number <= allowed_attempts) {
            try {
                return this.getNumberHits(search_strings, query_used);
            }
            catch (Exception e) {
                if (try_number >= allowed_attempts) {
                    SimpleDateFormat date_format = new SimpleDateFormat("dd-MM-yyyy kk:mm:ss");
                    String date = date_format.format(new Date());
                    String times_submitted_message = "Query submitted unsuccessfully " + overall_tries + " times.\n\n";
                    String date_message = "Last attempt at " + date + ".\n\n";
                    String request_message = "Do you wish to continue submitting this query?\n\n";
                    String overall_message = e.getMessage() + times_submitted_message + date_message + request_message;
                    int choice = JOptionPane.showConfirmDialog(null, overall_message, "ERROR", 2);
                    if (choice == 2) {
                        throw e;
                    }
                    ++overall_tries;
                    try_number = 1;
                    continue;
                }
                ++try_number;
                ++overall_tries;
            }
        }
        throw new Exception("Query unsuccesful.");
    }

    protected abstract String formatSearchString(String[] var1) throws Exception;

    protected abstract Object prepareSearcher(Object var1) throws Exception;

    protected abstract void formatErrorMessage(Exception var1, String var2, int var3) throws Exception;
}

