/*
 * Decompiled with CFR 0.152.
 */
package mckay.utilities.webservices;

import com.yahoo.search.SearchClient;
import com.yahoo.search.SearchException;
import com.yahoo.search.WebSearchRequest;
import com.yahoo.search.WebSearchResult;
import com.yahoo.search.WebSearchResults;
import java.io.IOException;
import java.math.BigInteger;
import java.net.InetAddress;
import mckay.utilities.staticlibraries.StringMethods;
import mckay.utilities.webservices.NetworkSearch;

public class YahooWebSearch
extends NetworkSearch {
    private SearchClient search_client;

    public YahooWebSearch(String yahoo_application_id) {
        this.search_client = new SearchClient(yahoo_application_id);
    }

    public String getSeachServiceName() {
        return "Yahoo! REST-like Web Search";
    }

    public String getSearchServiceLimitations() {
        String limitations = "\nThe " + this.getSeachServiceName() + " web services have the following limitations in the context of all of the available search parameters:\n" + "<ul>\n" + "<li>Suppressing similar hits affects the returned search results but not the returned hit count.\n" + "<li>There is no functionality for searching for similar but non-matching strings.\n" + "<li>Searches cannot be performed using a service located specifically in Turkey.\n" + "<li>Only up to 5000 queries may be performed per day per IP address.\n" + "</ul>\n";
        return limitations;
    }

    public String[][] getSearchResults(String[] search_strings, int start_index, int max_results, String[] number_hits, String[] query_used) throws Exception {
        String[][] formatted_search_results = null;
        String query = this.formatSearchString(search_strings);
        this.formatErrorMessage(null, query, max_results);
        try {
            WebSearchRequest request = new WebSearchRequest(query);
            request = (WebSearchRequest)this.prepareSearcher(request);
            request.setStart(new BigInteger(String.valueOf(start_index)));
            request.setResults(max_results);
            WebSearchResults query_results = this.search_client.webSearch(request);
            WebSearchResult[] query_results_array = query_results.listResults();
            formatted_search_results = new String[query_results_array.length][3];
            for (int i = 0; i < formatted_search_results.length; ++i) {
                formatted_search_results[i][0] = query_results_array[i].getTitle();
                formatted_search_results[i][1] = query_results_array[i].getUrl();
                formatted_search_results[i][2] = query_results_array[i].getSummary();
            }
            if (number_hits != null) {
                number_hits[0] = query_results.getTotalResultsAvailable().toString();
            }
            if (query_used != null) {
                query_used[0] = query;
            }
        }
        catch (Exception e) {
            this.formatErrorMessage(e, query, max_results);
        }
        return formatted_search_results;
    }

    public long getNumberHits(String[] search_strings, String[] query_used) throws Exception {
        String query = this.formatSearchString(search_strings);
        this.formatErrorMessage(null, query, 0);
        try {
            WebSearchRequest request = new WebSearchRequest(query);
            request = (WebSearchRequest)this.prepareSearcher(request);
            WebSearchResults query_results = this.search_client.webSearch(request);
            WebSearchResult[] query_results_array = query_results.listResults();
            long number_hits = query_results.getTotalResultsAvailable().longValue();
            if (query_used != null) {
                query_used[0] = query;
            }
            return number_hits;
        }
        catch (Exception e) {
            this.formatErrorMessage(e, query, 0);
            return 0L;
        }
    }

    protected String formatSearchString(String[] search_strings) throws Exception {
        int i;
        if (search_strings == null) {
            throw new Exception("No search strings specified in query.");
        }
        for (int i2 = 0; i2 < search_strings.length; ++i2) {
            if (search_strings[i2] != null) continue;
            throw new Exception("One or more search terms is null.");
        }
        String formatted_query = "";
        for (i = 0; i < search_strings.length; ++i) {
            if (i != 0) {
                formatted_query = this.or_based_search ? formatted_query + " OR " : formatted_query + " ";
            }
            if (!this.literal_search) continue;
            if (!search_strings[i].startsWith("\"") && !search_strings[i].endsWith("\"")) {
                formatted_query = formatted_query + "\"" + search_strings[i] + "\"";
                continue;
            }
            if (this.or_based_search) {
                String[] words = StringMethods.breakIntoTokens(search_strings[i], " ");
                String to_add = words[0];
                if (words.length > 1) {
                    for (int j = 1; j < words.length; ++j) {
                        to_add = to_add + " OR " + words[j];
                    }
                }
                formatted_query = formatted_query + to_add;
                continue;
            }
            formatted_query = formatted_query + search_strings[i];
        }
        if (this.strings_to_exclude != null) {
            for (i = 0; i < this.strings_to_exclude.length; ++i) {
                formatted_query = formatted_query + " -\"" + this.strings_to_exclude[i] + "\"";
            }
        }
        return formatted_query;
    }

    protected Object prepareSearcher(Object searcher) {
        String region_code;
        String country_code;
        String language_code;
        WebSearchRequest this_searcher = (WebSearchRequest)searcher;
        if (this.specific_site != null) {
            this_searcher.addSite(this.specific_site);
        }
        if ((language_code = this.getLanguageCode(this.limit_to_language)) != null) {
            this_searcher.setLanguage(language_code);
        }
        if ((country_code = this.getCountryCode(this.limit_to_country)) != null) {
            this_searcher.setCountry(country_code);
        }
        if ((region_code = this.getCountryCode(this.region_to_search_from)) != null) {
            this_searcher.setRegion(region_code);
        }
        if (!this.limit_to_file_type.equals("No Limitations")) {
            if (this.limit_to_file_type.equals("doc")) {
                this_searcher.setFormat("msword");
            } else {
                this_searcher.setFormat(this.limit_to_file_type);
            }
        }
        this_searcher.setSimilarOk(!this.suppress_similar_hits);
        this_searcher.setAdultOk(!this.suppress_adult_content);
        return this_searcher;
    }

    protected void formatErrorMessage(Exception exception, String query, int max_results) throws Exception {
        if (exception == null) {
            if (max_results > 100) {
                throw new Exception("Service error when using " + this.getSeachServiceName() + ".\n\n" + "Requested a search with " + max_results + " results.\n" + "Yahoo only allows up to 100.\n\n");
            }
        } else if (exception != null) {
            if (exception.toString().indexOf("quota") != -1) {
                throw new Exception("Service error when attempting to use " + this.getSeachServiceName() + ".\n\n" + "Daily search quota exceeded.\n" + "Yahoo only allows 5000 queries per day per authorization key per IP address.\n" + "You must wait for your quota to be cleared before you can perform more searches.\n\n");
            }
            if (exception.toString().indexOf("Invalid authorization key") != -1) {
                throw new Exception("Connection error when attempting to use " + this.getSeachServiceName() + ".\n\n" + "Invalid Yahoo! Application ID used.\n" + "Please correct this in the options.\n\n");
            }
            if (exception.toString().indexOf("Connection timed out") != -1) {
                throw new Exception("Service error when attempting to use " + this.getSeachServiceName() + ".\n\n" + "Timed out while trying to contact Yahoo.\n" + "Service may be temporarily overloaded.\n" + "Please retry your search immediately.\n\n");
            }
            try {
                InetAddress address = InetAddress.getByName("www.yahoo.com");
            }
            catch (Exception f) {
                throw new Exception("Unable to access the internet.\nPlease ensure that your computer is connected to the internet or other appropriate network.\n");
            }
            if (exception instanceof IOException) {
                throw new Exception("I/O error when attempting to access " + this.getSeachServiceName() + ".\n" + "This is most likely a general network error.\n" + exception.toString() + "\n\n" + "Query used: " + query + "\n\n");
            }
            if (exception instanceof SearchException) {
                throw new Exception("Search error when using " + this.getSeachServiceName() + ".\n\n" + exception.toString() + "\n\n" + "Query used: " + query + "\n\n");
            }
            throw new Exception("Search error when using " + this.getSeachServiceName() + ".\n\n" + exception.toString() + "\n\n" + "Query used: " + query + "\n\n");
        }
    }

    private String getLanguageCode(String language) {
        String return_value = null;
        if (language.equals("English")) {
            return_value = "en";
        } else if (language.equals("French")) {
            return_value = "fr";
        } else if (language.equals("Spanish")) {
            return_value = "es";
        } else if (language.equals("Portuguese")) {
            return_value = "pt";
        } else if (language.equals("German")) {
            return_value = "de";
        } else if (language.equals("Chinese")) {
            return_value = "szh";
        } else if (language.equals("Japanese")) {
            return_value = "ja";
        } else if (language.equals("Turkish")) {
            return_value = "tr";
        } else if (language.equals("Arabic")) {
            return_value = "ar";
        }
        return return_value;
    }

    private String getCountryCode(String country) {
        String return_value = null;
        if (country.equals("Canada")) {
            return_value = "ca";
        } else if (country.equals("U.S.A.")) {
            return_value = "us";
        } else if (country.equals("U.K.")) {
            return_value = "uk";
        } else if (country.equals("France")) {
            return_value = "fr";
        } else if (country.equals("Spain")) {
            return_value = "es";
        } else if (country.equals("Germany")) {
            return_value = "de";
        } else if (country.equals("Austria")) {
            return_value = "at";
        } else if (country.equals("Brazil")) {
            return_value = "br";
        } else if (country.equals("Japan")) {
            return_value = "jp";
        } else if (country.equals("China")) {
            return_value = "cn";
        }
        return return_value;
    }
}

