/*
 * Decompiled with CFR 0.152.
 */
package com.echonest.api.v4;

import com.echonest.api.v4.EchoNestAPI;
import com.echonest.api.v4.EchoNestException;
import com.echonest.api.v4.Params;
import com.echonest.api.v4.util.MQuery;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ENItem {
    protected Map data;
    protected EchoNestAPI en;
    private String type;
    private String path;
    private String originalID = null;
    private String id;

    ENItem(EchoNestAPI en, String type, String path, Map data) throws EchoNestException {
        this.en = en;
        this.type = type;
        this.path = path;
        this.data = data;
        this.id = this.findID();
        this.extractForeignIDs(data);
    }

    ENItem(EchoNestAPI en, String type, String path, String id) throws EchoNestException {
        this.en = en;
        this.type = type;
        this.path = path;
        this.originalID = id;
        this.id = id;
        this.refresh();
    }

    ENItem(EchoNestAPI en, String type, String path, String nameOrID, boolean byName) throws EchoNestException {
        this.en = en;
        this.type = type;
        this.path = path;
        if (byName) {
            this.data = this.getItemMapByName(nameOrID, null);
        } else {
            this.originalID = nameOrID;
            this.data = this.getItemMap(nameOrID);
        }
        this.id = this.findID();
        this.extractForeignIDs(this.data);
    }

    ENItem(EchoNestAPI en, String type, String path, String id, String idType) throws EchoNestException {
        this.en = en;
        this.type = type;
        this.path = path;
        this.originalID = id;
        this.data = this.getItemMap(id, null, idType);
        this.id = this.findID();
        this.extractForeignIDs(this.data);
    }

    private String findID() throws EchoNestException {
        String alt_name = String.valueOf(this.type) + "_" + "id";
        if (this.data.get("id") != null) {
            return (String)this.data.get("id");
        }
        if (this.data.get(alt_name) != null) {
            return (String)this.data.get(alt_name);
        }
        throw new EchoNestException(4, "Missing ID");
    }

    protected void refresh() throws EchoNestException {
        this.data = this.getItemMap(this.id);
        this.id = this.findID();
        this.extractForeignIDs(this.data);
    }

    public String toString() {
        return this.data.toString();
    }

    public void fetchBuckets(String[] bucket) throws EchoNestException {
        this.fetchBuckets(bucket, false);
    }

    public boolean hasBucket(String bucket) {
        return this.data.containsKey(bucket);
    }

    public void fetchBuckets(String[] bucket, boolean force) throws EchoNestException {
        ArrayList<String> buckets = new ArrayList<String>();
        String[] stringArray = bucket;
        int n = bucket.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            if (force || !this.data.containsKey(s)) {
                buckets.add(s);
            }
            ++n2;
        }
        if (buckets.size() > 0) {
            Map map = this.getItemMap(this.getID(), buckets);
            this.extractForeignIDs(map);
            for (String s : buckets) {
                Object value = map.get(s);
                if (value == null) continue;
                this.data.put(s, value);
            }
        }
    }

    public void fetchBucket(String bucket) throws EchoNestException {
        this.fetchBucket(bucket, bucket);
    }

    public void fetchBucket(String bucket, boolean force) throws EchoNestException {
        this.fetchBucket(bucket, bucket, force);
    }

    protected void fetchBucket(String paramName, String bucketName) throws EchoNestException {
        this.fetchBucket(paramName, bucketName, false);
    }

    protected void fetchBucket(String paramName, String bucketName, boolean force) throws EchoNestException {
        if (force || !this.data.containsKey(bucketName)) {
            Map map = this.getItemMap(this.getID(), paramName);
            this.extractForeignIDs(map);
            Object value = map.get(bucketName);
            if (value != null) {
                this.data.put(bucketName, value);
            }
        }
    }

    private void extractForeignIDs(Map map) {
        List idList = (List)map.get("foreign_ids");
        if (idList != null) {
            for (Object o : idList) {
                Map idMap = (Map)o;
                String catalog = (String)idMap.get("catalog");
                String id = (String)idMap.get("foreign_id");
                this.data.put(catalog, id);
            }
        }
    }

    public String getID() {
        return this.id;
    }

    protected String getString(String path) {
        return (String)this.getObject(path);
    }

    protected Object getObject(String path) {
        MQuery mq = new MQuery(this.data);
        return mq.getObject(path);
    }

    protected Double getDouble(String path) {
        Object val = this.getObject(path);
        if (val != null) {
            if (val instanceof List) {
                val = ((List)val).get(0);
            }
            return ((Number)val).doubleValue();
        }
        return Double.NaN;
    }

    protected Integer getInteger(String path) {
        Number val = (Number)this.getObject(path);
        return val.intValue();
    }

    private Map getItemMap(String id) throws EchoNestException {
        return this.getItemMap(id, (String)null);
    }

    private Map getItemMap(String id, String bucket) throws EchoNestException {
        return this.getItemMap(id, bucket, "id");
    }

    private Map getItemMapByName(String name, String bucket) throws EchoNestException {
        return this.getItemMap(name, bucket, "name");
    }

    private Map getItemMap(String id, String bucket, String idType) throws EchoNestException {
        Params p = new Params();
        p.add(idType, id);
        if (bucket != null) {
            p.add("bucket", bucket);
        }
        Map results = this.en.getCmd().sendCommand(String.valueOf(this.type) + "/profile", p);
        Map response = (Map)results.get("response");
        MQuery mq = new MQuery(response);
        return (Map)mq.getObject(this.path);
    }

    private Map getItemMap(String id, List<String> buckets) throws EchoNestException {
        Params p = new Params();
        p.add("id", id);
        if (buckets != null) {
            p.add("bucket", buckets);
        }
        Map results = this.en.getCmd().sendCommand(String.valueOf(this.type) + "/profile", p);
        Map response = (Map)results.get("response");
        MQuery mq = new MQuery(response);
        return (Map)mq.getObject(this.path);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ENItem other = (ENItem)obj;
        return !(this.id == null ? other.id != null : !this.id.equals(other.id));
    }

    public String getOriginalID() {
        return this.originalID;
    }
}

