/*
 * Decompiled with CFR 0.152.
 */
package com.echonest.api.v4;

import com.echonest.api.v4.Artist;
import com.echonest.api.v4.ArtistParams;
import com.echonest.api.v4.EchoNestException;
import com.echonest.api.v4.PagedListInfo;
import com.echonest.api.v4.Params;
import com.echonest.api.v4.Song;
import com.echonest.api.v4.Term;
import com.echonest.api.v4.Track;
import com.echonest.api.v4.util.Commander;
import com.echonest.api.v4.util.MQuery;
import com.echonest.api.v4.util.Utilities;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EchoNestAPI {
    private Commander cmd = new Commander("EchoNestAPI");
    private Params stdParams = new Params();

    public EchoNestAPI() throws EchoNestException {
        this(EchoNestAPI.getApiKey());
        this.setMinCommandTime(500);
    }

    public EchoNestAPI(String apiKey) {
        this.stdParams.add("api_key", apiKey);
        this.cmd.setStandardParams(this.stdParams);
    }

    public Artist newArtistByID(String id) throws EchoNestException {
        return new Artist(this, id, false);
    }

    public Artist newArtistByName(String name) throws EchoNestException {
        return new Artist(this, name, true);
    }

    private static String getApiKey() throws EchoNestException {
        String key = System.getProperty("ECHO_NEST_API_KEY");
        if (key == null) {
            key = System.getenv("ECHO_NEST_API_KEY");
        }
        if (key == null) {
            System.out.println("No API KEY set");
            throw new EchoNestException(-4, "No API Key");
        }
        return key;
    }

    public void setHostName(String hostName) {
        this.cmd.setHost(hostName);
    }

    public void setMinCommandTime(int minTime) {
        this.cmd.setMinCommandTime(minTime);
    }

    public int getMinCommandTime() {
        return this.cmd.getMinCommandTime();
    }

    public void setTraceSends(boolean traceSends) {
        this.cmd.setTraceSends(traceSends);
    }

    public void setTraceRecvs(boolean traceRecvs) {
        this.cmd.setTraceRecvs(traceRecvs);
    }

    public void showStats() {
        this.cmd.showStats();
    }

    public List<Artist> getSimilarArtists(Params p) throws EchoNestException {
        ArrayList<Artist> artistResults = new ArrayList<Artist>();
        Map results = this.cmd.sendCommand("artist/similar", p);
        Map response = (Map)results.get("response");
        List artistList = (List)response.get("artists");
        int i = 0;
        while (i < artistList.size()) {
            Map artistMap = (Map)artistList.get(i);
            Object oname = artistMap.get("name");
            if (oname instanceof List) {
                List lname = (List)oname;
                oname = (String)lname.get(0);
                artistMap.put("name", oname);
            }
            Artist artist = new Artist(this, (Map)artistList.get(i));
            artistResults.add(artist);
            ++i;
        }
        return artistResults;
    }

    public List<Artist> searchArtists(Params p) throws EchoNestException {
        ArrayList<Artist> artistResults = new ArrayList<Artist>();
        Map results = this.cmd.sendCommand("artist/search", p);
        Map response = (Map)results.get("response");
        List artistList = (List)response.get("artists");
        int i = 0;
        while (i < artistList.size()) {
            Artist artist = new Artist(this, (Map)artistList.get(i));
            artistResults.add(artist);
            ++i;
        }
        return artistResults;
    }

    public List<Term> getTopTerms(int count) throws EchoNestException {
        ArtistParams p = new ArtistParams();
        p.setResults(count);
        ArrayList<Term> terms = new ArrayList<Term>();
        Map results = this.cmd.sendCommand("artist/top_terms", p);
        Map response = (Map)results.get("response");
        List termList = (List)response.get("terms");
        int i = 0;
        while (i < termList.size()) {
            Map tmap = (Map)termList.get(i);
            MQuery mq = new MQuery(tmap);
            String tname = mq.getString("name");
            double frequency = mq.getDouble("frequency");
            Term term = new Term(tname, frequency, frequency);
            terms.add(term);
            ++i;
        }
        return terms;
    }

    public List<Artist> searchArtists(String name) throws EchoNestException {
        Params p = new Params();
        p.add("name", name);
        return this.searchArtists(p);
    }

    public List<Artist> searchArtists(String name, int count) throws EchoNestException {
        Params p = new Params();
        p.add("name", name);
        p.add("results", count);
        return this.searchArtists(p);
    }

    public List<Artist> topHotArtists(int count) throws EchoNestException {
        ArtistParams p = new ArtistParams();
        p.setResults(count);
        return this.topHotArtists(p);
    }

    public List<Artist> topHotArtists(Params p) throws EchoNestException {
        ArrayList<Artist> artistResults = new ArrayList<Artist>();
        Map results = this.cmd.sendCommand("artist/top_hottt", p);
        Map response = (Map)results.get("response");
        List artistList = (List)response.get("artists");
        int i = 0;
        while (i < artistList.size()) {
            Artist artist = new Artist(this, (Map)artistList.get(i));
            artistResults.add(artist);
            ++i;
        }
        return artistResults;
    }

    public List<Song> searchSongs(Params p) throws EchoNestException {
        ArrayList<Song> songResults = new ArrayList<Song>();
        Map results = this.cmd.sendCommand("song/search", p);
        Map response = (Map)results.get("response");
        List songList = (List)response.get("songs");
        int i = 0;
        while (i < songList.size()) {
            Song song = new Song(this, (Map)songList.get(i));
            songResults.add(song);
            ++i;
        }
        return songResults;
    }

    public List<Song> similarSongs(Params p) throws EchoNestException {
        ArrayList<Song> songResults = new ArrayList<Song>();
        Map results = this.cmd.sendCommand("song/similar", p);
        Map response = (Map)results.get("response");
        List songList = (List)response.get("songs");
        int i = 0;
        while (i < songList.size()) {
            Song song = new Song(this, (Map)songList.get(i));
            songResults.add(song);
            ++i;
        }
        return songResults;
    }

    public List<Song> getSongs(Params p) throws EchoNestException {
        ArrayList<Song> songResults = new ArrayList<Song>();
        Map results = this.cmd.sendCommand("song/profile", p);
        Map response = (Map)results.get("response");
        List songList = (List)response.get("songs");
        int i = 0;
        while (i < songList.size()) {
            Song song = new Song(this, (Map)songList.get(i));
            songResults.add(song);
            ++i;
        }
        return songResults;
    }

    public Track uploadTrack(URL trackUrl, boolean wait) throws EchoNestException {
        Params p = new Params();
        p.add("url", trackUrl.toExternalForm());
        p.add("wait", wait ? "true" : "false");
        if (wait) {
            p.add("bucket", "audio_summary");
        }
        int tmo = this.cmd.getTimeout();
        this.cmd.setTimeout(300000);
        try {
            Track track;
            Map results = this.cmd.sendCommand("track/upload", p, true);
            Map response = (Map)results.get("response");
            Map trackData = (Map)response.get("track");
            Track track2 = track = new Track(this, trackData);
            return track2;
        }
        finally {
            this.cmd.setTimeout(tmo);
        }
    }

    public Track uploadTrack(File audioFile, boolean wait) throws EchoNestException, IOException {
        Track track = this.getKnownTrack(audioFile);
        if (track != null) {
            return track;
        }
        Params p = new Params();
        p.add("wait", wait ? "true" : "false");
        p.add("filetype", this.getFileType(audioFile));
        if (wait) {
            p.add("bucket", "audio_summary");
        }
        int tmo = this.cmd.getTimeout();
        this.cmd.setTimeout(300000);
        try {
            Map results = this.cmd.sendCommand("track/upload", p, true, audioFile);
            Map response = (Map)results.get("response");
            Map trackData = (Map)response.get("track");
            Track track2 = track = new Track(this, trackData);
            return track2;
        }
        finally {
            this.cmd.setTimeout(tmo);
        }
    }

    public Track getKnownTrack(String md5) throws EchoNestException {
        try {
            Track track = this.newTrackByMD5(md5);
            Track.AnalysisStatus status = track.getStatus();
            if (status != Track.AnalysisStatus.UNKNOWN && status != Track.AnalysisStatus.UNAVAILABLE) {
                return track;
            }
            return null;
        }
        catch (EchoNestException e) {
            return null;
        }
    }

    public Track getKnownTrack(File file) throws IOException, EchoNestException {
        return this.getKnownTrack(Utilities.md5(file));
    }

    private String getFileType(File file) {
        int dot = file.getName().lastIndexOf(46);
        if (dot >= 0 && dot < file.getName().length() - 1) {
            return file.getName().substring(dot + 1).toLowerCase();
        }
        return "mp3";
    }

    public Track newTrackByID(String id) throws EchoNestException {
        return Track.createTrack(this, id);
    }

    public Track newTrackByMD5(String md5) throws EchoNestException {
        return new Track(this, md5, "md5");
    }

    protected PagedListInfo getDocuments(String id, String command, String path, int start, int count) throws EchoNestException {
        Params p = new Params();
        p.add("id", id);
        p.add("start", start);
        p.add("results", count);
        Map results = this.cmd.sendCommand(command, p);
        Map response = (Map)results.get("response");
        return this.getPagedDocuments(path, response);
    }

    protected PagedListInfo getDocuments(String id, String command, String path, int start, int count, String license) throws EchoNestException {
        Params p = new Params();
        p.add("id", id);
        p.add("start", start);
        p.add("results", count);
        p.add("license", license);
        Map results = this.cmd.sendCommand(command, p);
        Map response = (Map)results.get("response");
        return this.getPagedDocuments(path, response);
    }

    protected PagedListInfo getDocuments(String id, String command, String path, int start, int count, List<String> licenses) throws EchoNestException {
        Params p = new Params();
        p.add("id", id);
        p.add("start", start);
        p.add("results", count);
        p.add("license", licenses);
        Map results = this.cmd.sendCommand(command, p);
        Map response = (Map)results.get("response");
        return this.getPagedDocuments(path, response);
    }

    protected PagedListInfo getPagedDocuments(String path, Map response) throws EchoNestException {
        MQuery mq = new MQuery(response);
        Integer start = mq.getInteger("start", 0);
        Integer total = mq.getInteger("total");
        if (total == null) {
            throw new EchoNestException(-2, "Missing total in doc return");
        }
        List list = (List)mq.getObject(path);
        return new PagedListInfo(start, total, list);
    }

    protected Commander getCmd() {
        return this.cmd;
    }
}

