/*
 * Decompiled with CFR 0.152.
 */
package com.echonest.api.v4;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Params {
    private Map<String, Object> map = new HashMap<String, Object>();

    public void add(String key, String value) {
        Object curValue = this.map.get(key);
        if (curValue == null) {
            this.map.put(key, value);
        } else if (curValue instanceof List) {
            List plist = (List)curValue;
            plist.add(value);
        } else {
            ArrayList<String> plist = new ArrayList<String>();
            plist.add((String)curValue);
            plist.add(value);
            this.map.put(key, plist);
        }
    }

    public int size() {
        return this.map.size();
    }

    public void add(String key, int value) {
        this.add(key, Integer.toString(value));
    }

    public void add(String key, List<String> vals) {
        for (String v : vals) {
            this.add(key, v);
        }
    }

    public void add(String key, String[] vals) {
        String[] stringArray = vals;
        int n = vals.length;
        int n2 = 0;
        while (n2 < n) {
            String v = stringArray[n2];
            this.add(key, v);
            ++n2;
        }
    }

    public void add(String key, float value) {
        this.add(key, Float.toString(value));
    }

    public void add(String key, boolean value) {
        this.add(key, value ? "true" : "false");
    }

    public String toString(boolean first) {
        StringBuilder sb = new StringBuilder();
        for (String key : this.map.keySet()) {
            Object value = this.map.get(key);
            if (value == null) continue;
            if (value instanceof List) {
                for (Object v : (List)value) {
                    sb.append(this.getDelim(sb, first));
                    sb.append(key);
                    sb.append("=");
                    sb.append(this.encode(v.toString()));
                }
                continue;
            }
            sb.append(this.getDelim(sb, first));
            sb.append(key);
            sb.append("=");
            sb.append(this.encode(value.toString()));
        }
        return sb.toString();
    }

    private String encode(String s) {
        try {
            s = URLEncoder.encode(s, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            return s;
        }
        return s;
    }

    private String getDelim(StringBuilder sb, boolean first) {
        if (first && sb.length() == 0) {
            return "?";
        }
        return "&";
    }
}

