/*
 * Decompiled with CFR 0.152.
 */
package com.echonest.api.v4;

import com.echonest.api.v4.ENItem;
import com.echonest.api.v4.EchoNestAPI;
import com.echonest.api.v4.EchoNestException;
import com.echonest.api.v4.Params;
import com.echonest.api.v4.TrackAnalysis;
import com.echonest.api.v4.util.Commander;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public class Track
extends ENItem {
    private static final String PATH = "track";
    private static final String TYPE = "track";
    private TrackAnalysis analysis = null;
    private AnalysisStatus currentStatus = AnalysisStatus.UNKNOWN;

    Track(EchoNestAPI en, String idOrMD5, String type) throws EchoNestException {
        super(en, "track", "track", idOrMD5, type);
    }

    Track(EchoNestAPI en, Map data) throws EchoNestException {
        super(en, "track", "track", data);
    }

    static Track createTrack(EchoNestAPI en, String id) throws EchoNestException {
        HashMap<String, String> data = new HashMap<String, String>();
        data.put("id", id);
        Track track = new Track(en, data);
        return track;
    }

    public String getAnalysisURL() throws EchoNestException {
        this.fetchBucket("audio_summary");
        String url = this.getString("audio_summary.analysis_url");
        return url;
    }

    public AnalysisStatus getStatus() throws EchoNestException {
        if (this.currentStatus != AnalysisStatus.COMPLETE && this.currentStatus != AnalysisStatus.ERROR) {
            this.refresh();
            String status = this.getString("status");
            if (status == null) {
                status = "complete";
            }
            status = status.toLowerCase();
            AnalysisStatus[] analysisStatusArray = AnalysisStatus.values();
            int n = analysisStatusArray.length;
            int n2 = 0;
            while (n2 < n) {
                AnalysisStatus as = analysisStatusArray[n2];
                if (as.name().toLowerCase().equals(status)) {
                    this.currentStatus = as;
                    break;
                }
                ++n2;
            }
        }
        return this.currentStatus;
    }

    public String getTitle() throws EchoNestException {
        return this.getTopLevelItem("title");
    }

    public String getArtistName() throws EchoNestException {
        return this.getTopLevelItem("artist");
    }

    public String getPreviewUrl() throws EchoNestException {
        return this.getTopLevelItem("preview_url");
    }

    public String getAudioUrl() throws EchoNestException {
        return this.getTopLevelItem("audio_url");
    }

    public String getReleaseName() throws EchoNestException {
        return this.getTopLevelItem("release");
    }

    public String getAudioMD5() throws EchoNestException {
        return this.getTopLevelItem("audio_md5");
    }

    public String getForeignID() throws EchoNestException {
        return this.getTopLevelItem("foreign_id");
    }

    private String getTopLevelItem(String itemName) throws EchoNestException {
        if (this.getStatus() == null) {
            this.refresh();
        }
        return this.getString(itemName);
    }

    public AnalysisStatus waitForAnalysis(long timeoutMillis) throws EchoNestException {
        long startTime = System.currentTimeMillis();
        long elapsed = 0L;
        AnalysisStatus status = AnalysisStatus.UNKNOWN;
        do {
            status = this.getStatus();
            elapsed = System.currentTimeMillis() - startTime;
        } while (status == AnalysisStatus.PENDING && elapsed < timeoutMillis);
        return status;
    }

    public TrackAnalysis getAnalysis() throws EchoNestException {
        this.fetchBucket("audio_summary");
        try {
            if (this.analysis == null) {
                Map analysisMap = Commander.fetchURLAsJSON(this.getAnalysisURL());
                this.analysis = new TrackAnalysis(analysisMap);
            }
        }
        catch (IOException e) {
            throw new EchoNestException(e);
        }
        return this.analysis;
    }

    public int getKey() throws EchoNestException {
        this.fetchBucket("audio_summary");
        return this.getInteger("audio_summary.key");
    }

    public double getTempo() throws EchoNestException {
        this.fetchBucket("audio_summary");
        return this.getDouble("audio_summary.tempo");
    }

    public int getMode() throws EchoNestException {
        this.fetchBucket("audio_summary");
        return this.getInteger("audio_summary.mode");
    }

    public int getTimeSignature() throws EchoNestException {
        this.fetchBucket("audio_summary");
        return this.getInteger("audio_summary.time_signature");
    }

    public double getDuration() throws EchoNestException {
        this.fetchBucket("audio_summary");
        return this.getDouble("audio_summary.duration");
    }

    public double getLoudness() throws EchoNestException {
        this.fetchBucket("audio_summary");
        return this.getDouble("audio_summary.loudness");
    }

    public AnalysisStatus reanalyze(boolean wait) throws EchoNestException, IOException {
        Params p = new Params();
        p.add("wait", wait ? "true" : "false");
        if (wait) {
            p.add("bucket", "audio_summary");
        }
        int tmo = this.en.getCmd().getTimeout();
        this.en.getCmd().setTimeout(300000);
        try {
            Map results = this.en.getCmd().sendCommand("track/analyze", p, true);
            Map response = (Map)results.get("response");
            Map trackData = (Map)response.get("track");
        }
        finally {
            this.en.getCmd().setTimeout(tmo);
        }
        return this.getStatus();
    }

    public void showAll() throws EchoNestException {
        System.out.println(" ====== " + this.getID() + " =======");
        System.out.println("Title   : " + this.getTitle());
        System.out.println("audio   : " + this.getAudioUrl());
        System.out.println("foreign : " + this.getForeignID());
        System.out.println("Analysis: " + this.getAnalysisURL());
        System.out.println("Artist  : " + this.getArtistName());
        System.out.println("MD5     : " + this.getAudioMD5());
        System.out.println("Duration: " + this.getDuration());
        System.out.println("Key     : " + this.getKey());
        System.out.println("Loudness: " + this.getLoudness());
        System.out.println("Mode    : " + this.getMode());
        System.out.println("Preview : " + this.getPreviewUrl());
        System.out.println("Release : " + this.getReleaseName());
        System.out.println("Status  : " + (Object)((Object)this.getStatus()));
        System.out.println("Tempo   : " + this.getTempo());
        System.out.println("Time Sig: " + this.getTimeSignature());
        System.out.println();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum AnalysisStatus {
        UNKNOWN,
        PENDING,
        COMPLETE,
        UNAVAILABLE,
        ERROR;

    }
}

