/*
 * Decompiled with CFR 0.152.
 */
package com.echonest.api.v4.examples;

import com.echonest.api.v4.Artist;
import com.echonest.api.v4.Audio;
import com.echonest.api.v4.Biography;
import com.echonest.api.v4.Blog;
import com.echonest.api.v4.EchoNestAPI;
import com.echonest.api.v4.EchoNestException;
import com.echonest.api.v4.Image;
import com.echonest.api.v4.News;
import com.echonest.api.v4.PagedList;
import com.echonest.api.v4.Params;
import com.echonest.api.v4.Review;
import com.echonest.api.v4.Video;
import java.util.Collections;
import java.util.List;

public class ArtistExamples {
    private EchoNestAPI en = new EchoNestAPI();
    private static boolean trace = true;

    public ArtistExamples() throws EchoNestException {
        this.en.setTraceSends(trace);
        this.en.setTraceRecvs(false);
        this.en.setMinCommandTime(0);
    }

    public void dumpArtist(Artist artist) throws EchoNestException {
        System.out.printf("%s\n", artist.getName());
        System.out.printf("   hottt %.3f\n", artist.getHotttnesss());
        System.out.printf("   fam   %.3f\n", artist.getFamiliarity());
        System.out.println(" =========  urls ======== ");
        for (String key : artist.getUrls().keySet()) {
            System.out.printf("   %10s %s\n", key, artist.getUrls().get(key));
        }
        System.out.println(" =========  audio ======== ");
        List<Audio> audioList = artist.getAudio();
        int i = 0;
        while (i < audioList.size()) {
            System.out.printf("     == audio %d == \n", i + 1);
            Audio audio = audioList.get(i);
            audio.dump();
            ++i;
        }
        System.out.println(" =========  audio2 ======== ");
        PagedList<Audio> audioList2 = artist.getAudio(10, 40);
        int i2 = 0;
        while (i2 < audioList2.size()) {
            System.out.printf("     == audio2 %d == \n", i2 + 1);
            Audio audio = (Audio)audioList2.get(i2);
            audio.dump();
            ++i2;
        }
        System.out.println(" =========  bios ======== ");
        List<Biography> bios = artist.getBiographies();
        int i3 = 0;
        while (i3 < bios.size()) {
            Biography bio = bios.get(i3);
            bio.dump();
            ++i3;
        }
        System.out.println(" =========  blogs ======== ");
        List<Blog> blogs = artist.getBlogs();
        int i4 = 0;
        while (i4 < blogs.size()) {
            Blog blog = blogs.get(i4);
            blog.dump();
            ++i4;
        }
        System.out.println(" =========  images ======== ");
        List<Image> images = artist.getImages();
        int i5 = 0;
        while (i5 < images.size()) {
            Image image = images.get(i5);
            image.dump();
            ++i5;
        }
        System.out.println(" =========  news ======== ");
        List<News> newsList = artist.getNews();
        int i6 = 0;
        while (i6 < newsList.size()) {
            News news = newsList.get(i6);
            news.dump();
            ++i6;
        }
        System.out.println(" =========  reviews ======== ");
        List<Review> reviews = artist.getReviews();
        int i7 = 0;
        while (i7 < reviews.size()) {
            Review review = reviews.get(i7);
            review.dump();
            ++i7;
        }
        System.out.println(" =========  videos ======== ");
        List<Video> videos = artist.getVideos();
        int i8 = 0;
        while (i8 < videos.size()) {
            Video video = videos.get(i8);
            video.dump();
            ++i8;
        }
    }

    public void searchArtistByName(String name, int results) throws EchoNestException {
        Params p = new Params();
        p.add("query", name);
        p.add("rows", results);
        List<Artist> artists = this.en.searchArtists(p);
        for (Artist artist : artists) {
            this.dumpArtist(artist);
            System.out.println();
        }
    }

    public void randomWalk(String seedName, int count) throws EchoNestException {
        List<Artist> artists = this.en.searchArtists(seedName);
        if (artists.size() > 0) {
            Artist seed = artists.get(0);
            int i = 0;
            while (i < count) {
                this.dumpArtist(seed);
                List<Artist> sims = seed.getSimilar(10);
                if (sims.size() <= 0) break;
                Collections.shuffle(sims);
                seed = sims.get(0);
                ++i;
            }
        }
    }

    public void stats() {
        this.en.showStats();
    }

    public static void main(String[] args) throws EchoNestException {
        ArtistExamples sse = new ArtistExamples();
        long start = System.currentTimeMillis();
        try {
            sse.searchArtistByName("weezer", 10);
            System.out.println("Random walk");
            sse.randomWalk("weezer", 10);
        }
        finally {
            System.out.println("Runtime " + (System.currentTimeMillis() - start));
            sse.stats();
        }
    }
}

