/*
 * Decompiled with CFR 0.152.
 */
package com.echonest.api.v4.examples;

import com.echonest.api.v4.EchoNestAPI;
import com.echonest.api.v4.EchoNestException;
import com.echonest.api.v4.Params;
import com.echonest.api.v4.Song;
import java.util.List;

public class SearchSongsExample {
    private EchoNestAPI en = new EchoNestAPI();

    public SearchSongsExample() throws EchoNestException {
        this.en.setTraceSends(false);
        this.en.setTraceRecvs(false);
    }

    public void dumpSong(Song song) throws EchoNestException {
        System.out.printf("%s\n", song.getTitle());
        System.out.printf("   artist: %s\n", song.getArtistName());
        System.out.printf("   dur   : %.3f\n", song.getDuration());
        System.out.printf("   BPM   : %.3f\n", song.getTempo());
        System.out.printf("   Mode  : %d\n", song.getMode());
        System.out.printf("   S hot : %.3f\n", song.getSongHotttnesss());
        System.out.printf("   A hot : %.3f\n", song.getArtistHotttnesss());
        System.out.printf("   A fam : %.3f\n", song.getArtistFamiliarity());
        System.out.printf("   A loc : %s\n", song.getArtistLocation());
    }

    public void searchSongsByArtist(String artist, int results) throws EchoNestException {
        Params p = new Params();
        p.add("artist", artist);
        p.add("bucket", "audio_summary");
        p.add("bucket", "tracks");
        p.add("bucket", "artist_hotttnesss");
        p.add("results", results);
        List<Song> songs = this.en.searchSongs(p);
        for (Song song : songs) {
            this.dumpSong(song);
            System.out.println();
        }
    }

    public void searchSongsByTempo(String artist, int results) throws EchoNestException {
        Params p = new Params();
        p.add("artist", artist);
        p.add("bucket", "audio_summary");
        p.add("results", results);
        p.add("sort", "tempo-asc");
        List<Song> songs = this.en.searchSongs(p);
        for (Song song : songs) {
            System.out.printf("%.0f %s %s\n", song.getTempo(), song.getArtistName(), song.getTitle());
        }
    }

    public void searchSongsByTitle(String title, int results) throws EchoNestException {
        Params p = new Params();
        p.add("title", title);
        p.add("results", results);
        List<Song> songs = this.en.searchSongs(p);
        for (Song song : songs) {
            this.dumpSong(song);
            System.out.println();
        }
    }

    public void stats() {
        this.en.showStats();
    }

    public static void main(String[] args) throws EchoNestException {
        SearchSongsExample sse = new SearchSongsExample();
        sse.searchSongsByArtist("weezer", 10);
        sse.searchSongsByTempo("The Beatles", 100);
        sse.stats();
    }
}

