/*
 * Decompiled with CFR 0.152.
 */
package com.echonest.api.v4.tests;

import com.echonest.api.v4.Artist;
import com.echonest.api.v4.ArtistParams;
import com.echonest.api.v4.Audio;
import com.echonest.api.v4.Biography;
import com.echonest.api.v4.Blog;
import com.echonest.api.v4.EchoNestAPI;
import com.echonest.api.v4.EchoNestException;
import com.echonest.api.v4.Image;
import com.echonest.api.v4.News;
import com.echonest.api.v4.PagedList;
import com.echonest.api.v4.Params;
import com.echonest.api.v4.Review;
import com.echonest.api.v4.Term;
import com.echonest.api.v4.Video;
import java.util.List;
import junit.framework.TestCase;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@RunWith(value=JUnit4.class)
public class ArtistTests
extends TestCase {
    private static String BEATLES_MBID = "musicbrainz:artist:b10bbbfc-cf9e-42e0-be17-e2c3e1d2600d";
    private static String WEEZER_MBID = "musicbrainz:artist:6fe07aa5-fec0-4eca-a456-f29bff451b04";
    private static String COLDPLAY_MBID = "musicbrainz:artist:cc197bad-dc9c-440d-a5b5-d52ba2e14234";
    private static String WEEZER_PAULIFY = "paulify:artist:b8db077b79276a64d8f0f197d4986ce0";
    private static String COLDPLAY_PAULIFY = "paulify:artist:aa968850a9d255494612acd0552f8fcd";
    static EchoNestAPI en;
    static Artist beatles;
    static Artist weezer;
    static Artist coldplay;
    static boolean trace;

    static {
        trace = true;
    }

    @BeforeClass
    public static void setUpClass() throws EchoNestException {
        en = new EchoNestAPI();
        en.setMinCommandTime(0);
        en.setTraceSends(trace);
        en.setTraceRecvs(trace);
        beatles = en.searchArtists("The Beatles").get(0);
        weezer = en.searchArtists("Weezer").get(0);
        coldplay = en.searchArtists("Coldplay").get(0);
    }

    @AfterClass
    public static void tearDownClass() throws EchoNestException {
        en.showStats();
    }

    @Test
    public void testSearch() throws EchoNestException {
        List<Artist> artists = en.searchArtists("The Beatles");
        ArtistTests.assertTrue((boolean)artists.get(0).getName().equals("The Beatles"));
        artists = en.searchArtists("Weezer");
        ArtistTests.assertTrue((boolean)artists.get(0).getName().equals("Weezer"));
        artists = en.searchArtists("Guns ANd Roses");
        ArtistTests.assertTrue((boolean)artists.get(0).getName().equals("Guns N' Roses"));
        artists = en.searchArtists("GNR");
        ArtistTests.assertTrue((boolean)this.foundArtist(artists, "Guns N' Roses"));
        artists = en.searchArtists("bj\u00f6rk");
        ArtistTests.assertTrue((boolean)artists.get(0).getName().equals("Bj\u00f6rk"));
        artists = en.searchArtists("bjork");
        ArtistTests.assertTrue((boolean)artists.get(0).getName().equals("Bj\u00f6rk"));
        artists = en.searchArtists("Emerson Lake & Palmer");
        ArtistTests.assertTrue((boolean)artists.get(0).getName().equals("Emerson, Lake & Palmer"));
        artists = en.searchArtists("ThereIsNoArtistMatchingThisSTupidLongName");
        ArtistTests.assertTrue((artists.size() == 0 ? 1 : 0) != 0);
    }

    @Test
    public void testTooManySimilars() throws EchoNestException {
        try {
            beatles.getSimilar(500);
            ArtistTests.fail();
        }
        catch (EchoNestException echoNestException) {
            // empty catch block
        }
    }

    @Test
    public void testSimilars() throws EchoNestException {
        List<Artist> artists = beatles.getSimilar(50);
        ArtistTests.assertTrue((boolean)this.foundArtist(artists, "The Rolling Stones"));
        ArtistTests.assertTrue((boolean)this.foundArtist(artists, "The Beau Brummels"));
    }

    @Test
    public void testHotttnesss() throws EchoNestException {
        ArtistTests.assertTrue((this.getArtist("Lady Gaga").getHotttnesss() > 0.8 ? 1 : 0) != 0);
        ArtistTests.assertTrue((this.getArtist("Tiny Tim").getHotttnesss() < 0.6 ? 1 : 0) != 0);
    }

    @Test
    public void testFamiliarity() throws EchoNestException {
        ArtistTests.assertTrue((this.getArtist("Lady Gaga").getFamiliarity() > 0.9 ? 1 : 0) != 0);
        ArtistTests.assertTrue((this.getArtist("The Beatles").getFamiliarity() > 0.8 ? 1 : 0) != 0);
        ArtistTests.assertTrue((this.getArtist("Bonerama").getFamiliarity() < 0.6 ? 1 : 0) != 0);
    }

    @Test
    public void testAudio() throws EchoNestException {
        this.checkAudio(beatles, beatles.getAudio());
        this.checkAudio(weezer, weezer.getAudio());
        this.checkAudio(beatles, beatles.getAudio(20, 30));
        this.checkAudio(weezer, weezer.getAudio(10, 20));
    }

    @Test
    public void testAccessByName() throws EchoNestException {
        Artist weezer = en.newArtistByName("Weezer");
        this.checkAudio(weezer, weezer.getAudio());
        this.checkVideos(weezer, weezer.getVideos());
    }

    @Test
    public void testPagedAudio() throws EchoNestException {
        PagedList<Audio> plist = beatles.getAudio(2, 5);
        ArtistTests.assertTrue((plist.getStart() == 2 ? 1 : 0) != 0);
        ArtistTests.assertTrue((plist.getTotal() > 15 ? 1 : 0) != 0);
        ArtistTests.assertTrue((plist.size() == 5 ? 1 : 0) != 0);
        plist = weezer.getAudio(2, 5);
        ArtistTests.assertTrue((plist.getStart() == 2 ? 1 : 0) != 0);
        ArtistTests.assertTrue((plist.getTotal() > 15 ? 1 : 0) != 0);
        ArtistTests.assertTrue((plist.size() == 5 ? 1 : 0) != 0);
        plist = coldplay.getAudio(0, 10);
        ArtistTests.assertTrue((plist.getStart() == 0 ? 1 : 0) != 0);
        ArtistTests.assertTrue((plist.getTotal() > 15 ? 1 : 0) != 0);
        ArtistTests.assertTrue((plist.size() == 10 ? 1 : 0) != 0);
    }

    @Test
    public void testQueryByMBID() throws EchoNestException {
        Artist weezerFromMBID = en.newArtistByID(WEEZER_MBID);
        ArtistTests.assertTrue((boolean)weezer.equals(weezerFromMBID));
        Artist coldplayFromMBID = en.newArtistByID(COLDPLAY_MBID);
        ArtistTests.assertTrue((boolean)coldplay.equals(coldplayFromMBID));
    }

    @Test
    public void testMusicbranz() throws EchoNestException {
        ArtistTests.assertTrue((boolean)weezer.getForeignID("musicbrainz").equals(WEEZER_MBID));
        ArtistTests.assertTrue((boolean)coldplay.getForeignID("musicbrainz").equals(COLDPLAY_MBID));
    }

    @Test
    public void testPaulify() throws EchoNestException {
        ArtistTests.assertTrue((boolean)weezer.getForeignID("paulify").equals(WEEZER_PAULIFY));
        ArtistTests.assertTrue((boolean)coldplay.getForeignID("paulify").equals(COLDPLAY_PAULIFY));
    }

    public void checkAudio(Artist artist, List<Audio> audios) throws EchoNestException {
        for (Audio audio : audios) {
            System.out.println();
            if (trace) {
                audio.dump();
            }
            audio.getArtistName();
            audio.getDate();
            audio.getLength();
            audio.getRelease();
            audio.getTitle();
            audio.getURL();
            ArtistTests.assertNotNull((Object)audio.getURL());
        }
    }

    @Test
    public void testBiography() throws EchoNestException {
        this.checkBio(beatles, beatles.getBiographies());
        this.checkBio(weezer, weezer.getBiographies());
        this.checkBio(beatles, beatles.getBiographies(2, 3));
        this.checkBio(weezer, weezer.getBiographies(1, 5));
    }

    @Test
    public void testPagedBiography() throws EchoNestException {
        this.checkPager(beatles.getBiographies(2, 3), 2, 3, 5);
        this.checkPager(weezer.getBiographies(1, 5), 1, 5, 5);
        this.checkPager(coldplay.getBiographies(1, 5), 1, 5, 5);
    }

    private void checkPager(PagedList<?> list, int start, int size, int min) {
        ArtistTests.assertTrue((String)"pager start", (list.getStart() == start ? 1 : 0) != 0);
        ArtistTests.assertTrue((String)"pager total", (list.getTotal() > min ? 1 : 0) != 0);
        ArtistTests.assertTrue((String)"pager size", (list.size() == size ? 1 : 0) != 0);
    }

    @Test
    public void testBadBioLicenses() throws EchoNestException {
        try {
            weezer.getBiographies(0, 100, "ima-bad-license");
            ArtistTests.fail();
        }
        catch (EchoNestException echoNestException) {
            // empty catch block
        }
    }

    @Test
    public void testBioLicenses() throws EchoNestException {
        List<Artist> artists = en.topHotArtists(100);
        int count = 0;
        for (Artist artist : artists) {
            PagedList<Biography> bios = artist.getBiographies(0, 100, "cc-by-sa");
            if (bios.size() > 0) {
                ++count;
            } else {
                System.out.println("no cc-by-sa bios for " + artist.getName());
            }
            for (Biography bio : bios) {
                ArtistTests.assertTrue((boolean)bio.getLicenseType().equals("cc-by-sa"));
            }
        }
        System.out.println("Coverage is " + count);
        ArtistTests.assertTrue((String)"good bio coverage", (count > 50 ? 1 : 0) != 0);
    }

    public void checkBio(Artist artist, List<Biography> bios) throws EchoNestException {
        for (Biography bio : bios) {
            System.out.println();
            if (trace) {
                bio.dump();
            }
            bio.getLicenseAttribution();
            bio.getLicenseType();
            bio.getSite();
            bio.getText();
            bio.getURL();
            ArtistTests.assertNotNull((Object)bio.getLicenseAttribution());
            ArtistTests.assertNotNull((Object)bio.getLicenseType());
            ArtistTests.assertNotNull((Object)bio.getSite());
            ArtistTests.assertNotNull((Object)bio.getText());
            ArtistTests.assertNotNull((Object)bio.getURL());
        }
    }

    @Test
    public void testBlog() throws EchoNestException {
        this.checkBlog(beatles, beatles.getBlogs());
        this.checkBlog(weezer, weezer.getBlogs());
        this.checkBlog(beatles, beatles.getBlogs(2, 3));
        this.checkBlog(weezer, weezer.getBlogs(1, 5));
    }

    @Test
    public void testPagedBlog() throws EchoNestException {
        this.checkPager(beatles.getBlogs(2, 3), 2, 3, 5);
        this.checkPager(weezer.getBlogs(1, 5), 1, 5, 5);
        this.checkPager(coldplay.getBlogs(1, 5), 1, 5, 5);
    }

    public void checkBlog(Artist artist, List<Blog> blogs) throws EchoNestException {
        for (Blog blog : blogs) {
            System.out.println();
            if (trace) {
                blog.dump();
            }
            blog.getDateFound();
            blog.getDatePosted();
            blog.getName();
            blog.getSummary();
            blog.getURL();
            ArtistTests.assertNotNull((Object)blog.getDateFound());
            ArtistTests.assertNotNull((Object)blog.getDatePosted());
            ArtistTests.assertNotNull((Object)blog.getName());
            ArtistTests.assertNotNull((Object)blog.getSummary());
            ArtistTests.assertNotNull((Object)blog.getURL());
        }
    }

    @Test
    public void testImages() throws EchoNestException {
        this.checkImage(beatles, beatles.getImages());
        this.checkImage(weezer, weezer.getImages());
        this.checkImage(beatles, beatles.getImages(2, 3));
        this.checkImage(weezer, weezer.getImages(1, 5));
    }

    @Test
    public void testPagedImages() throws EchoNestException {
        this.checkPager(beatles.getImages(2, 3), 2, 3, 5);
        this.checkPager(weezer.getImages(1, 5), 1, 5, 5);
        this.checkPager(coldplay.getImages(1, 5), 1, 5, 5);
    }

    @Test
    public void testBadImageLicenses() throws EchoNestException {
        try {
            weezer.getImages(0, 100, "ima-bad-license");
            ArtistTests.fail();
        }
        catch (EchoNestException echoNestException) {
            // empty catch block
        }
    }

    @Test
    public void testImageLicenses() throws EchoNestException {
        PagedList<Image> images = weezer.getImages(0, 100, "cc-by-sa");
        ArtistTests.assertTrue((images.size() > 0 ? 1 : 0) != 0);
        for (Image image : images) {
            ArtistTests.assertTrue((boolean)image.getLicenseType().equals("cc-by-sa"));
        }
    }

    public void checkImage(Artist artist, List<Image> images) throws EchoNestException {
        for (Image image : images) {
            System.out.println();
            if (trace) {
                image.dump();
            }
            image.getLicenseAttribution();
            image.getLicenseType();
            image.getURL();
            ArtistTests.assertNotNull((Object)image.getLicenseAttribution());
            ArtistTests.assertNotNull((Object)image.getLicenseType());
            ArtistTests.assertNotNull((Object)image.getURL());
        }
    }

    @Test
    public void testNews() throws EchoNestException {
        this.checkNews(beatles, beatles.getNews());
        this.checkNews(weezer, weezer.getNews());
        this.checkNews(beatles, beatles.getNews(2, 3));
        this.checkNews(weezer, weezer.getNews(1, 5));
    }

    @Test
    public void testPagedNews() throws EchoNestException {
        this.checkPager(beatles.getNews(2, 3), 2, 3, 5);
        this.checkPager(weezer.getNews(1, 5), 1, 5, 5);
        this.checkPager(coldplay.getNews(1, 5), 1, 5, 5);
    }

    @Test
    public void searchEmptyBucketTest() throws EchoNestException {
        Artist gaga = this.getArtist("Lady Gaga");
        ArtistTests.assertTrue((String)"audio", (!gaga.hasBucket("audio") ? 1 : 0) != 0);
        ArtistTests.assertTrue((String)"biographies", (!gaga.hasBucket("biographies") ? 1 : 0) != 0);
        ArtistTests.assertTrue((String)"blogs", (!gaga.hasBucket("blogs") ? 1 : 0) != 0);
        ArtistTests.assertTrue((String)"familiarity", (!gaga.hasBucket("familiarity") ? 1 : 0) != 0);
        ArtistTests.assertTrue((String)"hotttnesss", (!gaga.hasBucket("hotttnesss") ? 1 : 0) != 0);
        ArtistTests.assertTrue((String)"images", (!gaga.hasBucket("images") ? 1 : 0) != 0);
        ArtistTests.assertTrue((String)"news", (!gaga.hasBucket("news") ? 1 : 0) != 0);
        ArtistTests.assertTrue((String)"reviews", (!gaga.hasBucket("reviews") ? 1 : 0) != 0);
        ArtistTests.assertTrue((String)"urls", (!gaga.hasBucket("urls") ? 1 : 0) != 0);
        ArtistTests.assertTrue((String)"video", (!gaga.hasBucket("video") ? 1 : 0) != 0);
    }

    @Test
    public void searchFullBucketTest() throws EchoNestException {
        ArtistParams p = new ArtistParams();
        p.setName("Lady Gaga");
        p.includeAll();
        List<Artist> results = en.searchArtists(p);
        ArtistTests.assertTrue((String)"results", (results.size() > 0 ? 1 : 0) != 0);
        Artist gaga = results.get(0);
        ArtistTests.assertTrue((String)"audio", (boolean)gaga.hasBucket("audio"));
        ArtistTests.assertTrue((String)"biographies", (boolean)gaga.hasBucket("biographies"));
        ArtistTests.assertTrue((String)"blogs", (boolean)gaga.hasBucket("blogs"));
        ArtistTests.assertTrue((String)"familiarity", (boolean)gaga.hasBucket("familiarity"));
        ArtistTests.assertTrue((String)"hotttnesss", (boolean)gaga.hasBucket("hotttnesss"));
        ArtistTests.assertTrue((String)"images", (boolean)gaga.hasBucket("images"));
        ArtistTests.assertTrue((String)"news", (boolean)gaga.hasBucket("news"));
        ArtistTests.assertTrue((String)"reviews", (boolean)gaga.hasBucket("reviews"));
        ArtistTests.assertTrue((String)"urls", (boolean)gaga.hasBucket("urls"));
        ArtistTests.assertTrue((String)"video", (boolean)gaga.hasBucket("video"));
    }

    @Test
    public void artistCoverageWithBuckets() throws EchoNestException {
        ArtistParams p = new ArtistParams();
        p.setResults(10);
        p.includeAll();
        List<Artist> artists = en.topHotArtists(p);
        for (Artist artist : artists) {
            ArtistTests.assertTrue((String)"audio", (boolean)artist.hasBucket("audio"));
            ArtistTests.assertTrue((String)"biographies", (boolean)artist.hasBucket("biographies"));
            ArtistTests.assertTrue((String)"blogs", (boolean)artist.hasBucket("blogs"));
            ArtistTests.assertTrue((String)"familiarity", (boolean)artist.hasBucket("familiarity"));
            ArtistTests.assertTrue((String)"hotttnesss", (boolean)artist.hasBucket("hotttnesss"));
            ArtistTests.assertTrue((String)"images", (boolean)artist.hasBucket("images"));
            ArtistTests.assertTrue((String)"news", (boolean)artist.hasBucket("news"));
            ArtistTests.assertTrue((String)"reviews", (boolean)artist.hasBucket("reviews"));
            ArtistTests.assertTrue((String)"urls", (boolean)artist.hasBucket("urls"));
            ArtistTests.assertTrue((String)"video", (boolean)artist.hasBucket("video"));
        }
    }

    @Test
    public void artistSearchWithBuckets() throws EchoNestException {
        ArtistParams p = new ArtistParams();
        p.setResults(10);
        p.includeAll();
        p.setName("the");
        List<Artist> artists = en.searchArtists(p);
        for (Artist artist : artists) {
            ArtistTests.assertTrue((String)"audio", (boolean)artist.hasBucket("audio"));
            ArtistTests.assertTrue((String)"biographies", (boolean)artist.hasBucket("biographies"));
            ArtistTests.assertTrue((String)"blogs", (boolean)artist.hasBucket("blogs"));
            ArtistTests.assertTrue((String)"familiarity", (boolean)artist.hasBucket("familiarity"));
            ArtistTests.assertTrue((String)"hotttnesss", (boolean)artist.hasBucket("hotttnesss"));
            ArtistTests.assertTrue((String)"images", (boolean)artist.hasBucket("images"));
            ArtistTests.assertTrue((String)"news", (boolean)artist.hasBucket("news"));
            ArtistTests.assertTrue((String)"reviews", (boolean)artist.hasBucket("reviews"));
            ArtistTests.assertTrue((String)"urls", (boolean)artist.hasBucket("urls"));
            ArtistTests.assertTrue((String)"video", (boolean)artist.hasBucket("video"));
        }
    }

    @Test
    public void artistSearchWithFamConstraints() throws EchoNestException {
        ArtistParams p = new ArtistParams();
        p.setResults(10);
        p.includeFamiliarity();
        p.setMinFamiliarity(0.8f);
        p.setMaxFamiliarity(0.9f);
        List<Artist> artists = en.searchArtists(p);
        for (Artist artist : artists) {
            ArtistTests.assertTrue((String)"min_fam", (artist.getFamiliarity() >= (double)0.8f ? 1 : 0) != 0);
            ArtistTests.assertTrue((String)"max_fam", (artist.getFamiliarity() <= (double)0.9f ? 1 : 0) != 0);
        }
    }

    @Test
    public void artistSearchWithHotConstraints() throws EchoNestException {
        ArtistParams p = new ArtistParams();
        p.setResults(10);
        p.includeHotttnesss();
        p.setMinHotttnesss(0.8f);
        p.setMaxHotttnesss(0.9f);
        List<Artist> artists = en.searchArtists(p);
        for (Artist artist : artists) {
            ArtistTests.assertTrue((String)"min_hot", (artist.getHotttnesss() >= (double)0.8f ? 1 : 0) != 0);
            ArtistTests.assertTrue((String)"max_hot", (artist.getHotttnesss() <= (double)0.9f ? 1 : 0) != 0);
        }
    }

    @Test
    public void artistSearchByNameWithFamSort() throws EchoNestException {
        ArtistParams p = new ArtistParams();
        p.setResults(10);
        p.includeFamiliarity();
        p.setName("karaoke");
        p.sortBy(ArtistParams.SORT_FAMILIARITY, false);
        List<Artist> artists = en.searchArtists(p);
        double last = 1.0;
        for (Artist artist : artists) {
            ArtistTests.assertTrue((String)"fam_order", (artist.getFamiliarity() <= last ? 1 : 0) != 0);
            last = artist.getFamiliarity();
        }
    }

    @Test
    public void artistSearchByNameWithHotConstraints() {
        try {
            ArtistParams p = new ArtistParams();
            p.setResults(10);
            p.includeHotttnesss();
            p.setName("weezer");
            p.setMinHotttnesss(0.5f);
            List<Artist> artists = en.searchArtists(p);
            ArtistTests.fail((String)"no search by name with constraints");
        }
        catch (EchoNestException echoNestException) {
            // empty catch block
        }
    }

    @Test
    public void artistSearchWithBothConstraints() throws EchoNestException {
        ArtistParams p = new ArtistParams();
        p.setResults(100);
        p.includeHotttnesss();
        p.includeFamiliarity();
        p.setMinFamiliarity(0.8f);
        p.setMaxFamiliarity(0.9f);
        p.setMinHotttnesss(0.8f);
        p.setMaxHotttnesss(0.9f);
        List<Artist> artists = en.searchArtists(p);
        for (Artist artist : artists) {
            ArtistTests.assertTrue((String)"min_hot", (artist.getHotttnesss() >= (double)0.8f ? 1 : 0) != 0);
            ArtistTests.assertTrue((String)"max_hot", (artist.getHotttnesss() <= (double)0.9f ? 1 : 0) != 0);
            ArtistTests.assertTrue((String)"min_fam", (artist.getFamiliarity() >= (double)0.8f ? 1 : 0) != 0);
            ArtistTests.assertTrue((String)"max_fam", (artist.getFamiliarity() <= (double)0.9f ? 1 : 0) != 0);
        }
    }

    @Test
    public void artistSearchWithMixedConstraints() throws EchoNestException {
        ArtistParams p = new ArtistParams();
        p.setResults(20);
        p.includeHotttnesss();
        p.includeFamiliarity();
        p.setMinFamiliarity(0.8f);
        p.setMaxHotttnesss(0.9f);
        List<Artist> artists = en.searchArtists(p);
        for (Artist artist : artists) {
            ArtistTests.assertTrue((String)"max_hot", (artist.getHotttnesss() <= (double)0.9f ? 1 : 0) != 0);
            ArtistTests.assertTrue((String)"min_fam", (artist.getFamiliarity() >= (double)0.8f ? 1 : 0) != 0);
        }
    }

    @Test
    public void artistSearchWithAmbiguousConstraints() {
        try {
            ArtistParams p = new ArtistParams();
            p.setResults(10);
            p.includeHotttnesss();
            p.includeFamiliarity();
            p.setMinFamiliarity(0.8f);
            p.setMinFamiliarity(0.89f);
            List<Artist> artists = en.searchArtists(p);
            ArtistTests.fail((String)"ambiguous constraints");
        }
        catch (EchoNestException echoNestException) {
            // empty catch block
        }
    }

    @Test
    public void artistSearchWithAmbiguousSorts() {
        try {
            ArtistParams p = new ArtistParams();
            p.setResults(10);
            p.includeHotttnesss();
            p.includeFamiliarity();
            p.sortBy(ArtistParams.SORT_FAMILIARITY, true);
            p.sortBy(ArtistParams.SORT_HOTTTNESSS, true);
            List<Artist> artists = en.searchArtists(p);
            ArtistTests.fail((String)"ambiguous constraints");
        }
        catch (EchoNestException echoNestException) {
            // empty catch block
        }
    }

    @Test
    public void artistSearchForTopHot() throws EchoNestException {
        ArtistParams p = new ArtistParams();
        p.setResults(100);
        p.includeHotttnesss();
        p.sortBy(ArtistParams.SORT_HOTTTNESSS, false);
        List<Artist> artists = en.searchArtists(p);
        List<Artist> top = en.topHotArtists(100);
        ArtistTests.assertTrue((String)"size match", (top.size() == artists.size() ? 1 : 0) != 0);
        ArtistTests.assertTrue((String)"top hot match", (boolean)artists.containsAll(top));
        ArtistTests.assertTrue((String)"hot top match", (boolean)top.containsAll(artists));
    }

    @Test
    public void artistSearchForTopFam() throws EchoNestException {
        ArtistParams p = new ArtistParams();
        p.setResults(20);
        p.includeFamiliarity();
        p.sortBy(ArtistParams.SORT_FAMILIARITY, false);
        List<Artist> artists = en.searchArtists(p);
        double last = 1.0;
        for (Artist artist : artists) {
            ArtistTests.assertTrue((String)"Bad fam order", (artist.getFamiliarity() <= last ? 1 : 0) != 0);
            last = artist.getFamiliarity();
        }
    }

    @Test
    public void artistSearchWithManyResults() throws EchoNestException {
        ArtistParams p = new ArtistParams();
        p.setResults(100);
        p.includeFamiliarity();
        p.includeBlogs();
        p.sortBy(ArtistParams.SORT_FAMILIARITY, false);
        List<Artist> artists = en.searchArtists(p);
        double last = 1.0;
        for (Artist artist : artists) {
            ArtistTests.assertTrue((String)"Bad fam order", (artist.getFamiliarity() <= last ? 1 : 0) != 0);
            last = artist.getFamiliarity();
        }
    }

    @Test
    public void artistSearchWithAmbiguousQuery() throws EchoNestException {
        try {
            ArtistParams p = new ArtistParams();
            p.setResults(10);
            p.includeHotttnesss();
            p.addDescription("rock");
            p.setName("beatles");
            p.includeFamiliarity();
            p.setMinFamiliarity(0.8f);
            p.setMinFamiliarity(0.89f);
            List<Artist> artists = en.searchArtists(p);
            ArtistTests.fail((String)"ambiguous query");
        }
        catch (EchoNestException echoNestException) {
            // empty catch block
        }
    }

    @Test
    public void artistSearchByDescription() throws EchoNestException {
        ArtistParams p = new ArtistParams();
        p.setResults(20);
        p.addDescription("british invasion");
        p.sortBy(ArtistParams.SORT_FAMILIARITY, false);
        boolean found = false;
        List<Artist> artists = en.searchArtists(p);
        for (Artist artist : artists) {
            if (!artist.equals(beatles)) continue;
            found = true;
        }
        ArtistTests.assertTrue((String)"Beatles should be familiar British Invasion artist", (boolean)found);
    }

    @Test
    public void artistSearchByDescription2() throws EchoNestException {
        ArtistParams p = new ArtistParams();
        p.setResults(20);
        p.addDescription("britpop");
        p.sortBy(ArtistParams.SORT_FAMILIARITY, false);
        boolean found = false;
        List<Artist> artists = en.searchArtists(p);
        for (Artist artist : artists) {
            if (!artist.equals(beatles)) continue;
            found = true;
        }
        ArtistTests.assertTrue((String)"Beatles should be familiar British Invasion artist", (boolean)found);
    }

    @Test
    public void artistSortByFam() throws EchoNestException {
        ArtistParams p = new ArtistParams();
        p.setResults(20);
        p.includeHotttnesss();
        p.sortBy(ArtistParams.SORT_FAMILIARITY, false);
        p.includeFamiliarity();
        double lastFam = 1.0;
        List<Artist> artists = en.searchArtists(p);
        for (Artist artist : artists) {
            ArtistTests.assertTrue((String)"famsort", (artist.getFamiliarity() <= lastFam ? 1 : 0) != 0);
            lastFam = artist.getFamiliarity();
        }
        p = new ArtistParams();
        p.setResults(20);
        p.includeHotttnesss();
        p.sortBy(ArtistParams.SORT_FAMILIARITY, true);
        p.includeFamiliarity();
        lastFam = 0.0;
        artists = en.searchArtists(p);
        for (Artist artist : artists) {
            ArtistTests.assertTrue((String)"famsort", (artist.getFamiliarity() >= lastFam ? 1 : 0) != 0);
            lastFam = artist.getFamiliarity();
        }
    }

    @Test
    public void artistSortByHot() throws EchoNestException {
        ArtistParams p = new ArtistParams();
        p.setResults(20);
        p.includeHotttnesss();
        p.sortBy(ArtistParams.SORT_HOTTTNESSS, false);
        p.includeFamiliarity();
        double last = 1.0;
        List<Artist> artists = en.searchArtists(p);
        for (Artist artist : artists) {
            ArtistTests.assertTrue((String)"famsort", (artist.getHotttnesss() <= last ? 1 : 0) != 0);
            last = artist.getHotttnesss();
        }
        p = new ArtistParams();
        p.setResults(20);
        p.includeHotttnesss();
        p.sortBy(ArtistParams.SORT_HOTTTNESSS, true);
        p.includeFamiliarity();
        last = 0.0;
        artists = en.searchArtists(p);
        for (Artist artist : artists) {
            ArtistTests.assertTrue((String)"famsort", (artist.getHotttnesss() >= last ? 1 : 0) != 0);
            last = artist.getHotttnesss();
        }
    }

    @Test
    public void topTermsTest() throws EchoNestException {
        List<Term> topTerms = en.getTopTerms(1000);
        ArtistTests.assertTrue((String)"count 1000", (topTerms.size() == 1000 ? 1 : 0) != 0);
        ArtistTests.assertTrue((String)"rock is top", (boolean)topTerms.get(0).getName().equals("rock"));
        ArtistTests.assertTrue((String)"rock is 1", (topTerms.get(0).getFrequency() == 1.0 ? 1 : 0) != 0);
    }

    @Test
    public void artistSingleSpace() throws EchoNestException {
        ArtistParams p = new ArtistParams();
        p.setResults(20);
        p.addIDSpace("paulify");
        p.setLimit(true);
        List<Artist> artists = en.topHotArtists(p);
        for (Artist artist : artists) {
            ArtistTests.assertTrue((String)("id for " + artist.getName()), (artist.getForeignID("paulify").length() > 0 ? 1 : 0) != 0);
        }
    }

    @Test
    public void artistTermsTest() throws EchoNestException {
        List<Term> terms = beatles.getTerms();
        boolean found = false;
        ArtistTests.assertTrue((String)"not enough terms", (terms.size() > 20 ? 1 : 0) != 0);
        double last = 1.0;
        for (Term term : terms) {
            if (term.getName().equals("british invasion")) {
                found = true;
            }
            ArtistTests.assertTrue((String)"term sort 1", (term.getWeight() <= last ? 1 : 0) != 0);
            last = term.getWeight();
        }
        if (!found) {
            ArtistTests.fail((String)"beatles must be british invasion");
        }
        last = 1.0;
        Term.sortByFrequency(terms);
        for (Term term : terms) {
            ArtistTests.assertTrue((String)"term sort 1", (term.getFrequency() <= last ? 1 : 0) != 0);
            last = term.getFrequency();
        }
        last = 1.0;
        Term.sortByWeight(terms);
        for (Term term : terms) {
            ArtistTests.assertTrue((String)"term sort 1", (term.getWeight() <= last ? 1 : 0) != 0);
            last = term.getWeight();
        }
    }

    @Test
    public void artistTermCoverage() throws EchoNestException {
        int max = 100;
        List<Artist> hot = en.topHotArtists(max);
        int sum = 0;
        Artist minArtist = null;
        for (Artist artist : hot) {
            System.out.println("artist is " + artist.getName());
            if (minArtist == null || artist.getTerms().size() < minArtist.getTerms().size()) {
                minArtist = artist;
            }
            sum += artist.getTerms().size();
        }
        int avg = sum / max;
        ArtistTests.assertTrue((String)("avg terms is " + avg), (avg > 15 ? 1 : 0) != 0);
        ArtistTests.assertTrue((String)("too few terms for " + minArtist.getName()), (minArtist.getTerms().size() > 5 ? 1 : 0) != 0);
    }

    @Test
    public void artistTermCoverageWithBuckets() throws EchoNestException {
        int avg = 0;
        int lavg = 0;
        int max = 100;
        List<Artist> hot = en.topHotArtists(max);
        int sum = 0;
        Artist minArtist = null;
        for (Artist artist : hot) {
            if (minArtist == null || artist.getTerms().size() < minArtist.getTerms().size()) {
                minArtist = artist;
            }
            sum += artist.getTerms().size();
        }
        avg = sum / max;
        ArtistTests.assertTrue((String)("avg terms is " + avg), (avg > 15 ? 1 : 0) != 0);
        ArtistParams p = new ArtistParams();
        p.setResults(max);
        p.includeTerms();
        List<Artist> hot2 = en.topHotArtists(p);
        int sum2 = 0;
        Artist minArtist2 = null;
        for (Artist artist : hot2) {
            if (minArtist2 == null || artist.getTerms().size() < minArtist2.getTerms().size()) {
                minArtist2 = artist;
            }
            sum2 += artist.getTerms().size();
        }
        lavg = sum2 / max;
        ArtistTests.assertTrue((String)("avg terms is " + avg), (avg > 15 ? 1 : 0) != 0);
        ArtistTests.assertTrue((String)"same avg", (avg == lavg ? 1 : 0) != 0);
    }

    @Test
    public void musicBrainzArtistTest() throws EchoNestException {
        for (Artist artist : en.topHotArtists(100)) {
            String mbid = artist.getForeignID("musicbrainz");
            if (mbid != null) {
                Artist nArtist = en.newArtistByID(mbid);
                System.out.printf("%s %s %s %s\n", mbid, artist.getName(), nArtist.getForeignID("musicbrainz"), nArtist.getName());
                ArtistTests.assertTrue((String)("mbid mismatch for " + artist.getName()), (boolean)nArtist.equals(artist));
                continue;
            }
            System.out.println("NO MBID for " + artist.getName());
        }
    }

    @Test
    public void artistTermCoverageWithBuckets2() throws EchoNestException {
        int max = 250;
        int minMissing = 10;
        int hasTerms = 0;
        ArtistParams p = new ArtistParams();
        p.setResults(max);
        List<Artist> hot = en.topHotArtists(p);
        for (Artist artist : hot) {
            if (artist.getTerms().size() > 0) {
                ++hasTerms;
                continue;
            }
            System.out.println(" no terms for " + artist.getName());
        }
        int missing = max - hasTerms;
        ArtistTests.assertTrue((String)"missing too many terms", (missing > minMissing ? 1 : 0) != 0);
    }

    @Test
    public void artistMultiSpace() throws EchoNestException {
        ArtistParams p = new ArtistParams();
        p.setResults(20);
        p.addIDSpace("paulify");
        p.addIDSpace("musicbrainz");
        p.setLimit(true);
        List<Artist> artists = en.topHotArtists(p);
        for (Artist artist : artists) {
            String mbid = artist.hasBucket("musicbrainz") ? artist.getForeignID("musicbrainz") : null;
            String paulify = artist.hasBucket("paulify") ? artist.getForeignID("paulify") : null;
            ArtistTests.assertTrue((String)("id for " + artist.getName()), (mbid != null || paulify != null ? 1 : 0) != 0);
        }
    }

    @Test
    public void artistIdTranslation() throws EchoNestException {
        ArtistParams p = new ArtistParams();
        p.setResults(20);
        p.addIDSpace("paulify");
        p.setLimit(true);
        int mbCount = 0;
        List<Artist> artists = en.topHotArtists(p);
        for (Artist artist : artists) {
            String paulify = artist.getForeignID("paulify");
            Artist partist = en.newArtistByID(paulify);
            ArtistTests.assertTrue((String)"en ID mismatch", (boolean)partist.getID().equals(artist.getID()));
            String mbid = partist.getForeignID("musicbrainz");
            if (mbid != null) {
                ++mbCount;
                Artist martist = en.newArtistByID(mbid);
                ArtistTests.assertTrue((boolean)martist.getID().equals(artist.getID()));
                ArtistTests.assertTrue((String)"paulify from mbid doesn't match", (boolean)martist.getForeignID("paulify").equals(paulify));
            }
            ArtistTests.assertTrue((String)"no mbids found", (mbCount > 0 ? 1 : 0) != 0);
        }
    }

    @Test
    public void artistProfileWithBuckets() throws EchoNestException {
        List<Artist> artists = en.topHotArtists(20);
        String[] buckets = new String[]{"audio", "blogs", "biographies", "familiarity", "hotttnesss", "urls", "reviews", "images", "news", "video"};
        for (Artist artist : artists) {
            artist.fetchBuckets(buckets, true);
            ArtistTests.assertTrue((String)"audio", (boolean)artist.hasBucket("audio"));
            ArtistTests.assertTrue((String)"biographies", (boolean)artist.hasBucket("biographies"));
            ArtistTests.assertTrue((String)"blogs", (boolean)artist.hasBucket("blogs"));
            ArtistTests.assertTrue((String)"familiarity", (boolean)artist.hasBucket("familiarity"));
            ArtistTests.assertTrue((String)"hotttnesss", (boolean)artist.hasBucket("hotttnesss"));
            ArtistTests.assertTrue((String)"images", (boolean)artist.hasBucket("images"));
            ArtistTests.assertTrue((String)"news", (boolean)artist.hasBucket("news"));
            ArtistTests.assertTrue((String)"reviews", (boolean)artist.hasBucket("reviews"));
            ArtistTests.assertTrue((String)"urls", (boolean)artist.hasBucket("urls"));
            ArtistTests.assertTrue((String)"video", (boolean)artist.hasBucket("video"));
        }
    }

    @Test
    public void artistTopHotttWithIDSpaces() throws EchoNestException {
        ArtistParams p = new ArtistParams();
        p.addIDSpace("paulify");
        p.setResults(100);
        p.setLimit(true);
        List<Artist> artists = en.topHotArtists(p);
        ArtistTests.assertTrue((String)"size", (artists.size() == 100 ? 1 : 0) != 0);
        for (Artist artist : artists) {
            ArtistTests.assertTrue((String)artist.getName(), (boolean)artist.hasBucket("paulify"));
        }
    }

    @Test
    public void artistSimilarityWithIDSpaces() throws EchoNestException {
        ArtistParams p = new ArtistParams();
        p.addIDSpace("paulify");
        p.setResults(100);
        p.setLimit(true);
        List<Artist> artists = en.topHotArtists(p);
        ArtistTests.assertTrue((String)"size", (artists.size() == 100 ? 1 : 0) != 0);
        for (Artist artist : artists) {
            ArtistParams ps = new ArtistParams();
            ps.addIDSpace("paulify");
            ps.setResults(10);
            ps.setLimit(true);
            ps.setID(artist.getForeignID("paulify"));
            List<Artist> sartists = en.getSimilarArtists(ps);
            ArtistTests.assertTrue((String)"slength", (sartists.size() == 10 ? 1 : 0) != 0);
            for (Artist sartist : sartists) {
                ArtistTests.assertTrue((String)sartist.getName(), (boolean)sartist.hasBucket("paulify"));
            }
        }
    }

    @Test
    public void artistSimilarityWithLimitButNoBucket() {
        ArtistParams p = new ArtistParams();
        p.setLimit(true);
        p.setID(weezer.getID());
        try {
            en.getSimilarArtists(p);
            ArtistTests.fail((String)"limit with no idspace");
        }
        catch (EchoNestException echoNestException) {
            // empty catch block
        }
    }

    @Test
    public void artistCoverage() throws EchoNestException {
        int size = 20;
        int minScore = 15;
        ArtistParams p = new ArtistParams();
        p.setResults(size);
        List<Artist> artists = en.topHotArtists(p);
        int ac = 0;
        int bc = 0;
        int rc = 0;
        int ic = 0;
        int nc = 0;
        int vc = 0;
        for (Artist artist : artists) {
            if (artist.getAudio().size() > 0) {
                ++ac;
            }
            if (artist.getBlogs().size() > 0) {
                ++bc;
            }
            if (artist.getReviews().size() > 0) {
                ++rc;
            }
            if (artist.getImages().size() > 0) {
                ++ic;
            }
            if (artist.getNews().size() > 0) {
                ++nc;
            }
            if (artist.getVideos().size() <= 0) continue;
            ++vc;
        }
        ArtistTests.assertTrue((String)"audio", (ac > minScore ? 1 : 0) != 0);
        ArtistTests.assertTrue((String)"blogs", (bc > minScore ? 1 : 0) != 0);
        ArtistTests.assertTrue((String)"reviews", (rc > minScore ? 1 : 0) != 0);
        ArtistTests.assertTrue((String)"images", (ic > minScore ? 1 : 0) != 0);
        ArtistTests.assertTrue((String)"news", (nc > minScore ? 1 : 0) != 0);
        ArtistTests.assertTrue((String)"video", (vc > minScore ? 1 : 0) != 0);
    }

    public void checkNews(Artist artist, List<News> newsList) throws EchoNestException {
        for (News news : newsList) {
            System.out.println();
            if (trace) {
                news.dump();
            }
            news.getDateFound();
            news.getDatePosted();
            news.getName();
            news.getSummary();
            news.getURL();
            ArtistTests.assertNotNull((Object)news.getDateFound());
            ArtistTests.assertNotNull((Object)news.getDatePosted());
            ArtistTests.assertNotNull((Object)news.getName());
            ArtistTests.assertNotNull((Object)news.getSummary());
            ArtistTests.assertNotNull((Object)news.getURL());
        }
    }

    @Test
    public void testReviews() throws EchoNestException {
        this.checkReviews(beatles, beatles.getReviews());
        this.checkReviews(weezer, weezer.getReviews());
        this.checkReviews(beatles, beatles.getReviews(2, 3));
        this.checkReviews(weezer, weezer.getReviews(1, 5));
    }

    @Test
    public void testPagedReviews() throws EchoNestException {
        this.checkPager(beatles.getReviews(2, 3), 2, 3, 5);
        this.checkPager(weezer.getReviews(1, 5), 1, 5, 5);
        this.checkPager(coldplay.getReviews(1, 5), 1, 5, 5);
    }

    public void testArtistParams() throws EchoNestException {
        ArtistParams p = new ArtistParams();
        p.includeBlogs();
        p.includeFamiliarity();
        p.setName("weezer");
        List<Artist> artists = en.searchArtists(p);
    }

    public void checkReviews(Artist artist, List<Review> reviews) throws EchoNestException {
        for (Review review : reviews) {
            System.out.println();
            if (trace) {
                review.dump();
            }
            review.getDateFound();
            review.getDateReviewed();
            review.getImageURL();
            review.getName();
            review.getRelease();
            review.getReviewText();
            review.getSummary();
            review.getURL();
            ArtistTests.assertNotNull((Object)review.getURL());
            ArtistTests.assertNotNull((Object)review.getDateFound());
            ArtistTests.assertNotNull((Object)review.getName());
            ArtistTests.assertNotNull((Object)review.getRelease());
            ArtistTests.assertNotNull((Object)review.getSummary());
        }
    }

    @Test
    public void testVideos() throws EchoNestException {
        this.checkVideos(beatles, beatles.getVideos());
        this.checkVideos(weezer, weezer.getVideos());
        this.checkVideos(beatles, beatles.getVideos(2, 3));
        this.checkVideos(weezer, weezer.getVideos(1, 5));
    }

    @Test
    public void testPagedVideos() throws EchoNestException {
        this.checkPager(beatles.getVideos(2, 3), 2, 3, 5);
        this.checkPager(weezer.getVideos(1, 5), 1, 5, 5);
        this.checkPager(coldplay.getVideos(1, 5), 1, 5, 5);
    }

    public void checkVideos(Artist artist, List<Video> videos) throws EchoNestException {
        for (Video video : videos) {
            System.out.println();
            if (trace) {
                video.dump();
            }
            video.getDateFound();
            video.getImageURL();
            video.getTitle();
            video.getSite();
            video.getURL();
            ArtistTests.assertNotNull((Object)video.getURL());
            ArtistTests.assertNotNull((Object)video.getDateFound());
            ArtistTests.assertNotNull((Object)video.getTitle());
            ArtistTests.assertNotNull((Object)video.getSite());
        }
    }

    @Test
    public void testHotRange() throws EchoNestException {
        Params p = new Params();
        p.add("results", 1000);
        en.topHotArtists(p);
    }

    @Test
    public void testHotGaga() throws EchoNestException {
        Params p = new Params();
        p.add("results", 100);
        boolean found = false;
        List<Artist> artists = en.topHotArtists(p);
        for (Artist artist : artists) {
            if (!artist.getName().equals("Lady Gaga")) continue;
            found = true;
            break;
        }
        ArtistTests.assertTrue((boolean)found);
    }

    @Test
    public void testHotSearch() throws EchoNestException {
        Params p = new Params();
        p.add("results", 20);
        List<Artist> artists = en.topHotArtists(p);
        for (Artist artist : artists) {
            List<Artist> sartists = en.searchArtists(artist.getName(), 1);
            ArtistTests.assertTrue((String)"has results", (sartists.size() == 1 ? 1 : 0) != 0);
            ArtistTests.assertTrue((String)"name match", (boolean)sartists.get(0).getName().equals(artist.getName()));
        }
    }

    private Artist getArtist(String name) throws EchoNestException {
        return en.searchArtists(name).get(0);
    }

    private boolean foundArtist(List<Artist> artists, String name) throws EchoNestException {
        for (Artist artist : artists) {
            if (!artist.getName().equals(name)) continue;
            return true;
        }
        return false;
    }
}

