/*
 * Decompiled with CFR 0.152.
 */
package com.echonest.api.v4.tests;

import com.echonest.api.v4.Artist;
import com.echonest.api.v4.EchoNestAPI;
import com.echonest.api.v4.EchoNestException;
import com.echonest.api.v4.Segment;
import com.echonest.api.v4.Song;
import com.echonest.api.v4.SongParams;
import com.echonest.api.v4.TimedEvent;
import com.echonest.api.v4.Track;
import com.echonest.api.v4.TrackAnalysis;
import java.util.List;
import junit.framework.TestCase;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class SongTests
extends TestCase {
    static EchoNestAPI en;
    static boolean trace;
    static Song hey_jude;

    static {
        trace = true;
        hey_jude = null;
    }

    @BeforeClass
    public static void setUpClass() throws EchoNestException {
        en = new EchoNestAPI();
        en.setMinCommandTime(0);
        en.setTraceSends(trace);
        en.setTraceRecvs(trace);
        SongParams p = new SongParams();
        p.setArtist("The Beatles");
        p.setTitle("Hey Jude");
        hey_jude = en.searchSongs(p).get(0);
    }

    @AfterClass
    public static void tearDownClass() throws EchoNestException {
        en.showStats();
    }

    @Test
    public void songSearchTitleTest() throws EchoNestException {
        SongParams p = new SongParams();
        p.setTitle("tarkus");
        List<Song> songs = en.searchSongs(p);
        for (Song song : songs) {
            this.verifySong(song);
        }
        SongTests.assertTrue((songs.size() > 0 ? 1 : 0) != 0);
        SongTests.assertTrue((boolean)songs.get(0).getTitle().equals("Tarkus"));
    }

    @Test
    public void songSearchArtistTest() throws EchoNestException {
        SongParams p = new SongParams();
        p.setArtist("The Beatles");
        List<Song> songs = en.searchSongs(p);
        for (Song song : songs) {
            this.verifySong(song);
        }
        SongTests.assertTrue((songs.size() > 0 ? 1 : 0) != 0);
        SongTests.assertTrue((boolean)songs.get(0).getArtistName().equals("The Beatles"));
    }

    @Test
    public void songCombinedSearchTest() throws EchoNestException {
        SongParams p = new SongParams();
        String beatlesID = "AR6XZ861187FB4CECD";
        p.setCombined("The Beatles Hey Jude");
        List<Song> songs = en.searchSongs(p);
        SongTests.assertTrue((songs.size() > 0 ? 1 : 0) != 0);
        SongTests.assertTrue((boolean)songs.get(0).getArtistID().equals(beatlesID));
        SongTests.assertTrue((boolean)songs.get(0).getTitle().trim().equals("Hey Jude"));
        for (Song song : songs) {
            this.verifySong(song);
        }
    }

    @Test
    public void songSearchTempoTest() throws EchoNestException {
        SongParams p = new SongParams();
        p.setMinTempo(100.0f);
        p.setMaxTempo(130.0f);
        p.includeAudioSummary();
        p.sortBy(SongParams.SORT_TEMPO, true);
        List<Song> songs = en.searchSongs(p);
        double lastTempo = 0.0;
        for (Song song : songs) {
            double tempo = song.getTempo();
            SongTests.assertTrue((tempo >= 100.0 ? 1 : 0) != 0);
            SongTests.assertTrue((tempo <= 130.0 ? 1 : 0) != 0);
            SongTests.assertTrue((tempo >= lastTempo ? 1 : 0) != 0);
            lastTempo = tempo;
            this.verifySong(song);
        }
    }

    @Test
    public void songSearchModeTest() throws EchoNestException {
        SongParams p = new SongParams();
        p.setMode(1);
        p.includeAudioSummary();
        List<Song> songs = en.searchSongs(p);
        for (Song song : songs) {
            SongTests.assertTrue((song.getMode() == 1 ? 1 : 0) != 0);
            this.verifySong(song);
        }
        p = new SongParams();
        p.setMode(0);
        p.includeAudioSummary();
        songs = en.searchSongs(p);
        for (Song song : songs) {
            SongTests.assertTrue((song.getMode() == 0 ? 1 : 0) != 0);
            this.verifySong(song);
        }
    }

    @Test
    public void songCompareAudioSummaryToAnalysis() throws EchoNestException {
        double delta = 0.5;
        SongParams p = new SongParams();
        p.setMinTempo(119.0f);
        p.setMaxTempo(120.0f);
        p.addIDSpace("paulify");
        p.includeTracks();
        p.setResults(10);
        p.setLimit(true);
        List<Song> songs = en.searchSongs(p);
        for (Song song : songs) {
            Track track = song.getTrack("paulify");
            this.verifyTrack(track);
            TrackAnalysis analysis = track.getAnalysis();
            System.out.printf("mode %d %d\n", analysis.getMode(), song.getMode());
            System.out.printf("key %d %d\n", analysis.getKey(), song.getKey());
            System.out.printf("tempo %.2f %.2f\n", analysis.getTempo(), song.getTempo());
            System.out.printf("duration %.2f %.2f\n", analysis.getDuration(), song.getDuration());
            System.out.printf("loudness %.2f %.2f\n", analysis.getLoudness(), song.getLoudness());
            System.out.printf("TS %d %d\n", analysis.getTimeSignature(), song.getTimeSignature());
            SongTests.assertTrue((String)"mode", (analysis.getMode().intValue() == song.getMode() ? 1 : 0) != 0);
            SongTests.assertTrue((String)"tempo", (Math.abs(analysis.getTempo() - song.getTempo()) < delta ? 1 : 0) != 0);
            SongTests.assertTrue((String)"duration", (Math.abs(analysis.getDuration() - song.getDuration()) < delta ? 1 : 0) != 0);
            SongTests.assertTrue((String)"loudness", (Math.abs(analysis.getLoudness() - song.getLoudness()) < delta ? 1 : 0) != 0);
            SongTests.assertTrue((String)"TS", (analysis.getTimeSignature().intValue() == song.getTimeSignature() ? 1 : 0) != 0);
        }
    }

    @Test
    public void songSearchLoudnessTempoTest() throws EchoNestException {
        SongParams p = new SongParams();
        p.setMinLoudness(-30.0f);
        p.setMaxLoudness(-15.0f);
        p.setMinTempo(100.0f);
        p.setMaxTempo(120.0f);
        p.includeAudioSummary();
        p.sortBy(SongParams.SORT_DURATION, true);
        List<Song> songs = en.searchSongs(p);
        double last = 0.0;
        SongTests.assertTrue((songs.size() > 0 ? 1 : 0) != 0);
        for (Song song : songs) {
            double duration = song.getDuration();
            double loudness = song.getLoudness();
            double tempo = song.getTempo();
            SongTests.assertTrue((tempo >= 100.0 ? 1 : 0) != 0);
            SongTests.assertTrue((tempo <= 120.0 ? 1 : 0) != 0);
            SongTests.assertTrue((loudness >= -30.0 ? 1 : 0) != 0);
            SongTests.assertTrue((loudness <= -15.0 ? 1 : 0) != 0);
            SongTests.assertTrue((duration >= last ? 1 : 0) != 0);
            last = duration;
            this.verifySong(song);
        }
    }

    @Test
    public void songSearchArtistLoudnessTempoTest() throws EchoNestException {
        SongParams p = new SongParams();
        p.setMinLoudness(-30.0f);
        p.setMaxLoudness(-15.0f);
        p.setMinTempo(100.0f);
        p.setMaxTempo(120.0f);
        p.includeAudioSummary();
        p.setArtist("Elton John");
        p.setResults(100);
        p.sortBy(SongParams.SORT_DURATION, true);
        List<Song> songs = en.searchSongs(p);
        double last = 0.0;
        SongTests.assertTrue((songs.size() > 0 ? 1 : 0) != 0);
        for (Song song : songs) {
            double duration = song.getDuration();
            double loudness = song.getLoudness();
            double tempo = song.getTempo();
            SongTests.assertTrue((tempo >= 100.0 ? 1 : 0) != 0);
            SongTests.assertTrue((tempo <= 120.0 ? 1 : 0) != 0);
            SongTests.assertTrue((loudness >= -30.0 ? 1 : 0) != 0);
            SongTests.assertTrue((loudness <= -15.0 ? 1 : 0) != 0);
            SongTests.assertTrue((duration >= last ? 1 : 0) != 0);
            last = duration;
            this.verifySong(song);
        }
    }

    @Test
    public void songSearchForHotArtists() throws EchoNestException {
        List<Artist> hotArtists = en.topHotArtists(20);
        int count = 0;
        for (Artist artist : hotArtists) {
            SongParams p = new SongParams();
            p.setArtistID(artist.getID());
            p.setResults(10);
            List<Song> songs = en.searchSongs(p);
            for (Song song : songs) {
                SongTests.assertTrue((String)"mismatched artist ID", (boolean)song.getArtistID().equals(artist.getID()));
            }
            if (songs.size() <= 0) continue;
            ++count;
        }
        SongTests.assertTrue((String)"missing too many songs", (count > 10 ? 1 : 0) != 0);
    }

    @Test
    public void songSearchConstraintTest() throws EchoNestException {
        SongParams p = new SongParams();
        p.setKey(0);
        p.setMaxLoudness(-20.0f);
        p.setMode(1);
        p.setMinTempo(130.0f);
        p.includeAudioSummary();
        List<Song> songs = en.searchSongs(p);
        SongTests.assertTrue((songs.size() > 0 ? 1 : 0) != 0);
        for (Song song : songs) {
            SongTests.assertTrue((song.getKey() == 0 ? 1 : 0) != 0);
            SongTests.assertTrue((song.getLoudness() <= -20.0 ? 1 : 0) != 0);
            SongTests.assertTrue((song.getMode() == 1 ? 1 : 0) != 0);
            SongTests.assertTrue((song.getTempo() >= 130.0 ? 1 : 0) != 0);
            this.verifySong(song);
        }
    }

    @Test
    public void songSearchByDescription() throws EchoNestException {
        SongParams p = new SongParams();
        p.setResults(100);
        p.addDescription("heavy metal");
        p.sortBy(SongParams.SORT_ARTIST_FAMILIARITY, false);
        p.includeArtistFamiliarity();
        List<Song> songs = en.searchSongs(p);
        SongTests.assertTrue((songs.size() > 0 ? 1 : 0) != 0);
        boolean found = false;
        for (Song song : songs) {
            if (!song.getArtistName().equalsIgnoreCase("System Of A Down")) continue;
            found = true;
            this.verifySong(song);
        }
        if (!found) {
            SongTests.fail((String)"Can't find System of a Down");
        }
    }

    @Test
    public void songSearchHotPop() throws EchoNestException {
        SongParams p = new SongParams();
        p.setResults(100);
        p.addDescription("pop");
        p.sortBy(SongParams.SORT_SONG_HOTTTNESSS, false);
        p.includeArtistFamiliarity();
        p.includeSongHotttnesss();
        List<Song> songs = en.searchSongs(p);
        SongTests.assertTrue((songs.size() > 0 ? 1 : 0) != 0);
        boolean found = false;
        double last = 1.0;
        for (Song song : songs) {
            this.verifySong(song);
            if (song.getArtistName().equalsIgnoreCase("Lady Gaga")) {
                found = true;
            }
            SongTests.assertTrue((String)"Out of order song hotttnesss", (song.getSongHotttnesss() <= last ? 1 : 0) != 0);
            last = song.getSongHotttnesss();
        }
        if (!found) {
            SongTests.fail((String)"Can't find System of a Down");
        }
    }

    @Test
    public void songSearchColdPop() throws EchoNestException {
        SongParams p = new SongParams();
        p.setResults(100);
        p.addDescription("pop");
        p.sortBy(SongParams.SORT_SONG_HOTTTNESSS, true);
        p.includeArtistFamiliarity();
        p.includeSongHotttnesss();
        List<Song> songs = en.searchSongs(p);
        SongTests.assertTrue((songs.size() > 0 ? 1 : 0) != 0);
        double last = 0.0;
        for (Song song : songs) {
            this.verifySong(song);
            SongTests.assertTrue((String)"Out of order song hotttnesss", (song.getSongHotttnesss() >= last ? 1 : 0) != 0);
            last = song.getSongHotttnesss();
        }
    }

    @Test
    public void songSimilarSimple() throws EchoNestException {
        SongParams p = new SongParams();
        p.setID(hey_jude.getID());
        List<Song> sims = en.similarSongs(p);
        SongTests.assertTrue((sims.size() > 0 ? 1 : 0) != 0);
        for (Song song : sims) {
            this.verifySong(song);
        }
    }

    @Test
    public void songTrackTest() throws EchoNestException {
        SongParams p = new SongParams();
        p.setMinTempo(100.0f);
        p.setMaxTempo(130.0f);
        p.addIDSpace("paulify");
        p.includeTracks();
        p.setResults(100);
        p.setLimit(true);
        List<Song> songs = en.searchSongs(p);
        for (Song song : songs) {
            Track track = song.getTrack("paulify");
            System.out.println("track " + track.getID() + " status " + (Object)((Object)track.getStatus()));
        }
    }

    @Test
    public void songTrackStatusTestPlayme() throws EchoNestException {
        this.songTrackStatusTestCatalog("playme");
    }

    @Test
    public void songTrackStatusTestPaulify() throws EchoNestException {
        this.songTrackStatusTestCatalog("paulify");
    }

    @Test
    public void songTrackStatusTest7Digital() throws EchoNestException {
        this.songTrackStatusTestCatalog("7digital");
    }

    void songTrackStatusTestCatalog(String catalog) throws EchoNestException {
        SongParams p = new SongParams();
        p.setMinTempo(100.0f);
        p.setMaxTempo(130.0f);
        p.addIDSpace(catalog);
        p.includeTracks();
        p.setResults(20);
        p.setLimit(true);
        List<Song> songs = en.searchSongs(p);
        for (Song song : songs) {
            Track track = song.getTrack(catalog);
            this.verifyTrack(track);
        }
    }

    @Test
    public void songTrackTestWithEmptyTracks() throws EchoNestException {
        SongParams p = new SongParams();
        p.setMinTempo(119.0f);
        p.setMaxTempo(120.0f);
        p.addIDSpace("paulify");
        p.includeTracks();
        p.setResults(100);
        List<Song> songs = en.searchSongs(p);
        for (Song song : songs) {
            Track track = song.getTrack("paulify");
            if (track == null) continue;
            this.verifyTrack(track);
        }
    }

    @Test
    public void songTrackAnalysisTest() throws EchoNestException {
        SongParams p = new SongParams();
        p.setMinTempo(100.0f);
        p.setMaxTempo(110.0f);
        p.addIDSpace("paulify");
        p.includeTracks();
        p.setResults(10);
        p.setLimit(true);
        List<Song> songs = en.searchSongs(p);
        for (Song song : songs) {
            Track track = song.getTrack("paulify");
            this.verifyTrack(track);
            this.verifyAnalysis(track.getAnalysis());
        }
    }

    @Test
    public void songAnalysisTest() throws EchoNestException {
        SongParams p = new SongParams();
        p.setMinTempo(100.0f);
        p.setMaxTempo(110.0f);
        p.includeAudioSummary();
        p.setResults(10);
        List<Song> songs = en.searchSongs(p);
        for (Song song : songs) {
            this.verifyAnalysis(song.getAnalysis());
        }
    }

    private void verifyTrack(Track track) throws EchoNestException {
        SongTests.assertTrue((String)"status check", (boolean)track.getStatus().equals((Object)Track.AnalysisStatus.COMPLETE));
        track.showAll();
    }

    private void verifyAnalysis(TrackAnalysis analysis) {
        System.out.println("num samples : " + analysis.getNumSamples());
        System.out.println("sample md5  : " + analysis.getMD5());
        System.out.println("num channels: " + analysis.getNumChannels());
        System.out.println("duration    : " + analysis.getDuration());
        System.out.println(" Sections ");
        List<TimedEvent> sections = analysis.getSections();
        for (TimedEvent e : sections) {
            System.out.println(e);
        }
        System.out.println(" Bars ");
        List<TimedEvent> bars = analysis.getBars();
        for (TimedEvent e : bars) {
            System.out.println(e);
        }
        System.out.println(" Beats ");
        List<TimedEvent> beats = analysis.getBeats();
        for (TimedEvent e : beats) {
            System.out.println(e);
        }
        System.out.println(" Tatums ");
        List<TimedEvent> tatums = analysis.getTatums();
        for (TimedEvent e : tatums) {
            System.out.println(e);
        }
        System.out.println(" Segments ");
        List<Segment> segments = analysis.getSegments();
        for (Segment e : segments) {
            System.out.println(e);
        }
    }

    private void verifySong(Song song) throws EchoNestException {
        song.showAll();
    }
}

