/*
 * Decompiled with CFR 0.152.
 */
package com.echonest.api.v4.tests;

import com.echonest.api.v4.Artist;
import com.echonest.api.v4.Audio;
import com.echonest.api.v4.EchoNestAPI;
import com.echonest.api.v4.EchoNestException;
import com.echonest.api.v4.Segment;
import com.echonest.api.v4.Song;
import com.echonest.api.v4.SongParams;
import com.echonest.api.v4.TimedEvent;
import com.echonest.api.v4.Track;
import com.echonest.api.v4.TrackAnalysis;
import java.io.IOException;
import java.net.URL;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import junit.framework.TestCase;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class TrackTests
extends TestCase {
    static EchoNestAPI en;
    static boolean trace;
    static Song hey_jude;
    static Random rng;

    static {
        trace = true;
        hey_jude = null;
        rng = new Random();
    }

    @BeforeClass
    public static void setUpClass() throws EchoNestException {
        en = new EchoNestAPI();
        en.setMinCommandTime(0);
        en.setTraceSends(trace);
        en.setTraceRecvs(trace);
    }

    @AfterClass
    public static void tearDownClass() throws EchoNestException {
        en.showStats();
    }

    @Test
    public void trackFromID() throws EchoNestException {
        String id = "TRWXVPA1296187FC15";
        Track track = en.newTrackByID(id);
        TrackTests.assertTrue((String)"track status", (track.getStatus() == Track.AnalysisStatus.COMPLETE ? 1 : 0) != 0);
        TrackTests.assertTrue((String)"track id", (boolean)track.getID().equals(id));
        this.verifyTrack(track);
    }

    @Test
    public void trackFromMD5() throws EchoNestException {
        String md5 = "07a096fd8880931695723d19b1a11611";
        String id = "TRWXVPA1296187FC15";
        Track track = en.newTrackByMD5(md5);
        TrackTests.assertTrue((String)"track status", (track.getStatus() == Track.AnalysisStatus.COMPLETE ? 1 : 0) != 0);
        TrackTests.assertTrue((String)"track id", (boolean)track.getID().equals(id));
        this.verifyTrack(track);
    }

    private void verifyTrack(Track track) throws EchoNestException {
        track.showAll();
        TrackTests.assertTrue((String)"has analysis url", (track.getAnalysisURL() != null ? 1 : 0) != 0);
        this.verifyAnalysis(track.getAnalysis(), false);
    }

    private void verifyAnalysis(TrackAnalysis analysis, boolean full) {
        System.out.println("num samples : " + analysis.getNumSamples());
        System.out.println("sample md5  : " + analysis.getMD5());
        System.out.println("num channels: " + analysis.getNumChannels());
        System.out.println("duration    : " + analysis.getDuration());
        if (full) {
            System.out.println(" Sections ");
            List<TimedEvent> sections = analysis.getSections();
            for (TimedEvent e : sections) {
                System.out.println(e);
            }
            System.out.println(" Bars ");
            List<TimedEvent> bars = analysis.getBars();
            for (TimedEvent e : bars) {
                System.out.println(e);
            }
            System.out.println(" Beats ");
            List<TimedEvent> beats = analysis.getBeats();
            for (TimedEvent e : beats) {
                System.out.println(e);
            }
            System.out.println(" Tatums ");
            List<TimedEvent> tatums = analysis.getTatums();
            for (TimedEvent e : tatums) {
                System.out.println(e);
            }
            System.out.println(" Segments ");
            List<Segment> segments = analysis.getSegments();
            for (Segment e : segments) {
                System.out.println(e);
            }
        }
    }

    @Test
    public void trackAnalysisFromSongTrack() throws EchoNestException {
        SongParams p = new SongParams();
        p.sortBy(SongParams.SORT_ARTIST_HOTTTNESSS, false);
        p.addIDSpace("paulify");
        p.setLimit(true);
        p.includeTracks();
        p.setResults(1);
        List<Song> songs = en.searchSongs(p);
        for (Song song : songs) {
            Track track = song.getTrack("paulify");
            this.verifyTrack(track);
            String tid = track.getID();
            Track newTrack = en.newTrackByID(tid);
            this.verifyTrack(newTrack);
        }
    }

    @Test
    public void trackAnalysisTest() throws EchoNestException, IOException {
        List<Artist> artists = en.topHotArtists(100);
        Collections.shuffle(artists);
        Artist artist = artists.get(0);
        List<Audio> audio = artist.getAudio();
        Collections.shuffle(audio);
        if (audio.size() > 0) {
            Audio a = audio.get(0);
            URL url = new URL(a.getURL());
            Track track = en.uploadTrack(url, true);
            track.waitForAnalysis(30000L);
            this.verifyTrack(track);
        }
    }
}

