/*
 * Decompiled with CFR 0.152.
 */
package com.echonest.api.v4.util;

import com.echonest.api.v4.EchoNestException;
import com.echonest.api.v4.Params;
import com.echonest.api.v4.util.StatsManager;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.Charset;
import java.util.Map;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;

public class Commander {
    private String name;
    private String defaultHost = "developer.echonest.com";
    private String host;
    private String prefix = "/api/v4/";
    private boolean traceSends = false;
    private boolean traceRecvs = false;
    private boolean traceErrs = true;
    private int minCommandTime = 0;
    private int timeout = 30000;
    private int tryCount = 1;
    private long lastCommandTime;
    private Params standardParams = new Params();
    private StatsManager statsManager = new StatsManager();
    private long startTime;
    private int cmdCount = 0;
    private String expectedVersion = "4.";
    private JSONParser parser = new JSONParser();
    long last_time = 0L;

    public Commander(String name) {
        this.name = name;
        this.startTime = System.currentTimeMillis();
        this.host = System.getenv("ECHO_NEST_API_HOST");
        if (this.host == null) {
            this.host = this.defaultHost;
        }
        if (System.getenv("ECHO_NEST_API_TRACE_SENDS") != null) {
            this.traceSends = true;
        }
        if (System.getenv("ECHO_NEST_API_TRACE_RECVS") != null) {
            this.traceRecvs = true;
        }
    }

    public Map sendCommand(String command, Params params) throws EchoNestException {
        return this.sendCommand(command, params, false);
    }

    public Map sendCommand(String command, Params params, boolean usePost) throws EchoNestException {
        return this.sendCommand(command, params, usePost, null);
    }

    public Map sendCommand(String command, Params params, boolean usePost, File file) throws EchoNestException {
        long curGap = System.currentTimeMillis() - this.lastCommandTime;
        long delayTime = (long)this.minCommandTime - curGap;
        this.delay(delayTime);
        StatsManager.Tracker tracker = this.statsManager.start(command);
        try {
            StringBuilder url = new StringBuilder();
            url.append("http://");
            url.append(this.host);
            url.append(this.prefix);
            url.append(command);
            url.append(params.toString(true));
            url.append(this.standardParams.toString(params.size() == 0));
            Map results = this.getCheckedResults(url.toString(), usePost, file);
            this.statsManager.end(tracker);
            Map map = results;
            return map;
        }
        finally {
            this.statsManager.close(tracker);
        }
    }

    public static Map fetchURLAsJSON(String urls) throws IOException {
        InputStream is = null;
        try {
            JSONParser parser = new JSONParser();
            URI uri = new URI(urls);
            URL url = uri.toURL();
            URLConnection urc = url.openConnection();
            is = new BufferedInputStream(urc.getInputStream());
            BufferedReader in = new BufferedReader(new InputStreamReader(is, Charset.forName("UTF-8")));
            JSONObject jSONObject = (JSONObject)parser.parse((Reader)in);
            return jSONObject;
        }
        catch (ParseException e) {
            throw new IOException("Parse Exception", e);
        }
        catch (URISyntaxException e) {
            throw new IOException("Bad URI " + urls);
        }
        finally {
            if (is != null) {
                is.close();
            }
        }
    }

    public void showStats() {
        this.statsManager.dump();
    }

    private Map getCheckedResults(String command, boolean usePost, File file) throws EchoNestException {
        boolean ok = false;
        Map results = null;
        try {
            results = this.getMapResults(command, usePost, file);
            this.checkStatus(results);
            ok = true;
            Map map = results;
            return map;
        }
        catch (IOException ioe) {
            throw new EchoNestException(ioe);
        }
        finally {
            if (!ok && this.traceErrs && !this.traceSends) {
                System.out.println("send-err-> " + command);
                if (results != null && !this.traceRecvs) {
                    System.out.println("recv-err-> " + results.toString());
                }
            }
        }
    }

    private Map getMapResults(String command, boolean usePost, File file) throws IOException {
        String results = this.getStringResults(command, usePost, file);
        try {
            return (JSONObject)this.parser.parse(results);
        }
        catch (ParseException e) {
            throw new IOException("Parse Exception", e);
        }
    }

    private String getStringResults(String command, boolean usePost, File file) throws IOException {
        InputStream is = null;
        is = usePost && file != null ? this.post(command, file) : this.sendCommandRaw(command, usePost, file);
        BufferedReader in = new BufferedReader(new InputStreamReader(is, Charset.forName("UTF-8")));
        String line = null;
        StringBuilder results = new StringBuilder();
        while ((line = in.readLine()) != null) {
            results.append(line);
        }
        if (this.traceRecvs) {
            System.out.println("received-->     " + results.toString());
        }
        in.close();
        return results.toString();
    }

    private InputStream post(String command, File file) throws IOException {
        HttpURLConnection conn = null;
        DataOutputStream dos = null;
        URL url = null;
        try {
            URI uri = new URI(command);
            url = uri.toURL();
        }
        catch (URISyntaxException e) {
            throw new IOException("Bad URL " + e);
        }
        catch (MalformedURLException e) {
            throw new IOException("Bad URL " + e);
        }
        if (this.traceSends) {
            System.out.println("Sending-->     " + url);
        }
        conn = (HttpURLConnection)url.openConnection();
        conn.setDoInput(true);
        conn.setDoOutput(true);
        conn.setAllowUserInteraction(false);
        conn.setUseCaches(false);
        conn.setRequestMethod("POST");
        conn.setRequestProperty("Content-Type", "application/octet-stream");
        if (this.getTimeout() != -1) {
            conn.setReadTimeout(this.getTimeout());
            conn.setConnectTimeout(this.getTimeout());
        }
        dos = new DataOutputStream(conn.getOutputStream());
        FileInputStream is = new FileInputStream(file);
        int r = 0;
        byte[] data = new byte[1024];
        while ((r = ((InputStream)is).read(data, 0, data.length)) != -1) {
            dos.write(data, 0, r);
        }
        ((InputStream)is).close();
        dos.flush();
        dos.close();
        return conn.getInputStream();
    }

    private InputStream sendCommandRaw(String command, boolean usePost, File file) throws IOException {
        try {
            String fullCommand = command;
            URI uri = new URI(fullCommand);
            URL url = uri.toURL();
            ++this.cmdCount;
            if (this.traceSends) {
                long now = System.currentTimeMillis();
                long delta = now - this.last_time;
                this.last_time = now;
                System.out.printf("Sending %d %d %d-->     %s\n", this.cmdCount, now - this.startTime, delta, url);
            }
            BufferedInputStream is = null;
            int i = 0;
            while (i < this.tryCount) {
                try {
                    URLConnection urc = url.openConnection();
                    if (usePost && urc instanceof HttpURLConnection) {
                        ((HttpURLConnection)urc).setRequestMethod("POST");
                    }
                    if (this.getTimeout() != -1) {
                        urc.setReadTimeout(this.getTimeout());
                        urc.setConnectTimeout(this.getTimeout());
                    }
                    is = new BufferedInputStream(urc.getInputStream());
                    break;
                }
                catch (FileNotFoundException e) {
                    throw e;
                }
                catch (IOException e) {
                    System.out.println(String.valueOf(this.name) + " Error: " + e + " cmd: " + command);
                    ++i;
                }
            }
            this.lastCommandTime = System.currentTimeMillis();
            if (is == null) {
                System.out.println(String.valueOf(this.name) + " retry failure  cmd: " + url);
                throw new IOException("Can't send command");
            }
            return is;
        }
        catch (URISyntaxException ex) {
            throw new IOException("bad uri " + ex);
        }
    }

    private void delay(long time) {
        if (time < 0L) {
            return;
        }
        try {
            Thread.sleep(time);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    public boolean isTraceSends() {
        return this.traceSends;
    }

    public void setTraceSends(boolean traceSends) {
        this.traceSends = traceSends;
    }

    public boolean isTraceRecvs() {
        return this.traceRecvs;
    }

    public void setTraceRecvs(boolean trackRecvs) {
        this.traceRecvs = trackRecvs;
    }

    public int getMinCommandTime() {
        return this.minCommandTime;
    }

    public void setMinCommandTime(int minCommandTime) {
        this.minCommandTime = minCommandTime;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    public int getTryCount() {
        return this.tryCount;
    }

    public void setTryCount(int tryCount) {
        this.tryCount = tryCount;
    }

    public String getName() {
        return this.name;
    }

    public Params getStandardParams() {
        return this.standardParams;
    }

    public void setStandardParams(Params standardParams) {
        this.standardParams = standardParams;
    }

    private void checkStatus(Map results) throws EchoNestException {
        Map response = (Map)results.get("response");
        Map status = (Map)response.get("status");
        String version = (String)status.get("version");
        String message = (String)status.get("message");
        Long scode = (Long)status.get("code");
        int code = scode.intValue();
        if (!version.startsWith(this.expectedVersion)) {
            throw new EchoNestException(-2, "Unexpected API version number");
        }
        if (code != 0) {
            throw new EchoNestException(code, message);
        }
    }

    void test() throws IOException, EchoNestException {
        String command = "http://developer3.sandpit.us/api/v4/artist/get_similar?&api_key=XZTXVRO3VC3FBXS8C&id=ARH6W4X1187B99274F&format=json&rows=10&start=0&bucket=hotttnesss";
        String results = this.getStringResults(command, false, null);
        System.out.println(results);
        Map jo = this.getCheckedResults(command, false, null);
        System.out.println(jo);
        String errcmd = "http://developer3.sandpit.us/api/v4/artist/get_similar?&api_key=AZTXVRO3VC3FBXS8C&id=ARH6W4X1187B99274F&format=json&rows=10&start=0&bucket=hotttnesss";
        Map jo2 = this.getCheckedResults(errcmd, false, null);
        System.out.println(jo2);
    }

    void test2() throws EchoNestException {
        Params params = new Params();
        params.add("rows", 10);
        params.add("bucket", "hotttnesss");
        params.add("bucket", "familiarity");
        params.add("id", "ARH6W4X1187B99274F");
        Map results = this.sendCommand("artist/get_similar", params, false);
        System.out.println(results);
    }

    void test3() throws EchoNestException {
        Params params = new Params();
        params.add("rows", 10);
        params.add("bucket", "hotttnesss");
        params.add("bucket", "familiarity");
        params.add("bucket", "crap");
        params.add("id", "ARH6W4X1187B99274F");
        params.add("id", "ARH1N081187B9AC562");
        Map results = this.sendCommand("artist/get_similar", params, false);
        System.out.println(results);
    }

    public static void main(String[] args) throws Exception {
        Commander cmd = new Commander("test");
        Params stdParams = new Params();
        stdParams.add("api_key", "EHY4JJEGIOFA1RCJP");
        stdParams.add("api_key", "XZTXVRO3VC3FBXS8C");
        cmd.setStandardParams(stdParams);
        cmd.test2();
        cmd.test3();
    }
}

