/*
 * Decompiled with CFR 0.152.
 */
package com.echonest.api.v4.util;

import com.echonest.api.v4.util.ShellCommand;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.io.StreamTokenizer;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;

public class Shell
extends Thread {
    private Map commandList;
    private int totalCommands = 0;
    private String prompt;
    private boolean done = false;
    private boolean trace = false;
    private CommandHistory history = new CommandHistory();
    private BufferedReader in;
    private static Pattern historyPush = Pattern.compile("(.+):p");
    private static Pattern editPattern = Pattern.compile("\\^(.+?)\\^(.*?)\\^?");
    private static Pattern bbPattern = Pattern.compile("(!!)");

    public Shell() {
        this.commandList = new HashMap();
        this.addStandardCommands();
        this.in = new BufferedReader(new InputStreamReader(System.in));
    }

    public void setTrace(boolean trace) {
        this.trace = trace;
    }

    private void addStandardCommands() {
        this.add("help", new ShellCommand(){

            public String execute(Shell ci, String[] args) {
                Shell.this.dumpCommands();
                return "";
            }

            public String getHelp() {
                return "lists available commands";
            }
        });
        this.add("history", new ShellCommand(){

            public String execute(Shell ci, String[] args) {
                Shell.this.history.dump();
                return "";
            }

            public String getHelp() {
                return "shows command history";
            }
        });
        this.add("status", new ShellCommand(){

            public String execute(Shell ci, String[] args) {
                Shell.this.putResponse("Total number of commands: " + Shell.this.totalCommands);
                return "";
            }

            public String getHelp() {
                return "shows command status";
            }
        });
        this.add("echo", new ShellCommand(){

            public String execute(Shell ci, String[] args) {
                StringBuffer b = new StringBuffer(80);
                int i = 1;
                while (i < args.length) {
                    b.append(args[i]);
                    b.append(" ");
                    ++i;
                }
                Shell.this.putResponse(b.toString());
                return "";
            }

            public String getHelp() {
                return "display a line of text";
            }
        });
        this.add("menu", new ShellCommand(){

            public String execute(Shell ci, String[] args) {
                String cmd;
                block5: {
                    if (args.length < 2) {
                        return "usage: menu command-number [args]";
                    }
                    try {
                        int which = Integer.parseInt(args[1]);
                        cmd = Shell.this.getCommandByNumber(which);
                        if (cmd != null) break block5;
                        return "can't find that command";
                    }
                    catch (NumberFormatException e) {
                        return "bad number format";
                    }
                }
                String[] subargs = new String[args.length - 1];
                if (args.length > 2) {
                    System.arraycopy(args, 2, subargs, 1, subargs.length - 1);
                }
                subargs[0] = cmd;
                return Shell.this.execute(subargs);
            }

            public String getHelp() {
                return "execute a command by number";
            }
        });
        this.addAlias("menu", "m");
        this.add("quit", new ShellCommand(){

            public String execute(Shell ci, String[] args) {
                Shell.this.done = true;
                return "";
            }

            public String getHelp() {
                return "exit the shell";
            }
        });
        this.add("on_exit", new ShellCommand(){

            public String execute(Shell ci, String[] args) {
                return "";
            }

            public String getHelp() {
                return "command executed upon exit";
            }
        });
        this.add("version", new ShellCommand(){

            public String execute(Shell ci, String[] args) {
                Shell.this.putResponse("Command Interpreter - Version 1.1 ");
                return "";
            }

            public String getHelp() {
                return "displays version information";
            }
        });
        this.add("gc", new ShellCommand(){

            public String execute(Shell ci, String[] args) {
                Runtime.getRuntime().gc();
                return "";
            }

            public String getHelp() {
                return "performs garbage collection";
            }
        });
        this.add("memory", new ShellCommand(){

            public String execute(Shell ci, String[] args) {
                long totalMem = Runtime.getRuntime().totalMemory();
                long freeMem = Runtime.getRuntime().freeMemory();
                Shell.this.putResponse("Free Memory  : " + (double)freeMem / 1048576.0 + " mbytes");
                Shell.this.putResponse("Total Memory : " + (double)totalMem / 1048576.0 + " mbytes");
                return "";
            }

            public String getHelp() {
                return "shows memory statistics";
            }
        });
        this.add("delay", new ShellCommand(){

            public String execute(Shell ci, String[] args) {
                if (args.length == 2) {
                    try {
                        float seconds = Float.parseFloat(args[1]);
                        Thread.sleep((long)(seconds * 1000.0f));
                    }
                    catch (NumberFormatException nfe) {
                        Shell.this.putResponse("Usage: delay time-in-seconds");
                    }
                    catch (InterruptedException interruptedException) {}
                } else {
                    Shell.this.putResponse("Usage: delay time-in-seconds");
                }
                return "";
            }

            public String getHelp() {
                return "pauses for a given number of seconds";
            }
        });
        this.add("alias", new ShellCommand(){

            public String execute(Shell ci, String[] args) {
                if (args.length == 3) {
                    String alias = args[1];
                    String cmd = args[2];
                    Shell.this.addAlias(cmd, alias);
                } else {
                    Shell.this.putResponse("Usage: alias name def");
                }
                return "";
            }

            public String getHelp() {
                return "adds a pseudonym or shorthand term for a command";
            }
        });
        this.add("repeat", new ShellCommand(){

            public String execute(Shell ci, String[] args) {
                if (args.length >= 3) {
                    try {
                        int count = Integer.parseInt(args[1]);
                        String[] subargs = new String[args.length - 2];
                        System.arraycopy(args, 2, subargs, 0, subargs.length);
                        int i = 0;
                        while (i < count) {
                            Shell.this.putResponse(Shell.this.execute(subargs));
                            ++i;
                        }
                    }
                    catch (NumberFormatException nfe) {
                        Shell.this.putResponse("Usage: repeat count command args");
                    }
                } else {
                    Shell.this.putResponse("Usage: repeat count command args");
                }
                return "";
            }

            public String getHelp() {
                return "repeatedly execute a command";
            }
        });
        this.add("redirect", new ShellCommand(){

            public String execute(Shell ci, String[] args) {
                if (args.length >= 3) {
                    try {
                        String[] subargs = new String[args.length - 2];
                        System.arraycopy(args, 2, subargs, 0, subargs.length);
                        PrintStream oldOut = System.out;
                        PrintStream newOut = new PrintStream(args[1]);
                        System.setOut(newOut);
                        Shell.this.putResponse(Shell.this.execute(subargs));
                        newOut.close();
                        System.setOut(oldOut);
                    }
                    catch (IOException ioe) {
                        System.err.println("Can't write to " + args[1] + " " + ioe);
                    }
                } else {
                    Shell.this.putResponse("Usage: redirect file command [args ...]");
                }
                return "";
            }

            public String getHelp() {
                return "redirect command output to a file";
            }
        });
        this.add("load", new ShellCommand(){

            public String execute(Shell ci, String[] args) {
                if (args.length == 2) {
                    if (!Shell.this.load(args[1])) {
                        Shell.this.putResponse("load: trouble loading " + args[1]);
                    }
                } else {
                    Shell.this.putResponse("Usage: load filename");
                }
                return "";
            }

            public String getHelp() {
                return "load and execute commands from a file";
            }
        });
        this.add("chain", new ShellCommand(){

            public String execute(Shell ci, String[] args) {
                if (args.length > 1) {
                    String[] subargs = new String[args.length - 1];
                    ArrayList<String[]> commands = new ArrayList<String[]>(5);
                    int count = 0;
                    int i = 1;
                    while (i < args.length) {
                        if (args[i].equals(";")) {
                            if (count > 0) {
                                String[] trimmedArgs = new String[count];
                                System.arraycopy(subargs, 0, trimmedArgs, 0, trimmedArgs.length);
                                commands.add(trimmedArgs);
                                count = 0;
                            }
                        } else {
                            subargs[count++] = args[i];
                        }
                        ++i;
                    }
                    if (count > 0) {
                        String[] trimmedArgs = new String[count];
                        System.arraycopy(subargs, 0, trimmedArgs, 0, trimmedArgs.length);
                        commands.add(trimmedArgs);
                        count = 0;
                    }
                    Iterator i2 = commands.iterator();
                    while (i2.hasNext()) {
                        Shell.this.putResponse(Shell.this.execute((String[])i2.next()));
                    }
                } else {
                    Shell.this.putResponse("Usage: chain cmd1 ; cmd2 ; cmd3 ");
                }
                return "";
            }

            public String getHelp() {
                return "execute multiple commands on a single line";
            }
        });
        this.add("time", new ShellCommand(){

            public String execute(Shell ci, String[] args) {
                if (args.length > 1) {
                    String[] subargs = new String[args.length - 1];
                    System.arraycopy(args, 1, subargs, 0, subargs.length);
                    long startTime = System.currentTimeMillis();
                    Shell.this.putResponse(Shell.this.execute(subargs));
                    long endTime = System.currentTimeMillis();
                    Shell.this.putResponse("Time: " + (double)(endTime - startTime) / 1000.0 + " seconds");
                } else {
                    Shell.this.putResponse("Usage: time cmd [args]");
                }
                return "";
            }

            public String getHelp() {
                return "report the time it takes to run a command";
            }
        });
    }

    private void dumpCommands() {
        int count = 0;
        Set unsortedKeys = this.commandList.keySet();
        TreeSet sortedKeys = new TreeSet(unsortedKeys);
        for (String cmdName : sortedKeys) {
            String help = ((ShellCommand)this.commandList.get(cmdName)).getHelp();
            this.putResponse(String.valueOf(count) + ") " + cmdName + " - " + help);
            ++count;
        }
    }

    private String getCommandByNumber(int which) {
        int count = 0;
        Set unsortedKeys = this.commandList.keySet();
        TreeSet sortedKeys = new TreeSet(unsortedKeys);
        for (String cmdName : sortedKeys) {
            if (count == which) {
                return cmdName;
            }
            ++count;
        }
        return null;
    }

    public void add(String name, ShellCommand command) {
        this.commandList.put(name, command);
    }

    public void addAlias(String command, String alias) {
        this.commandList.put(alias, this.commandList.get(command));
    }

    public void add(Map newCommands) {
        this.commandList.putAll(newCommands);
    }

    public synchronized void putResponse(String response) {
        if (response != null && response.length() > 0) {
            System.out.println(response);
        }
    }

    protected void onExit() {
        this.execute("on_exit");
        System.out.println("----------\n");
    }

    public String execute(String[] args) {
        String response = "";
        if (args.length > 0) {
            ShellCommand ci = (ShellCommand)this.commandList.get(args[0]);
            try {
                response = ci != null ? ci.execute(this, args) : "ERR  CMD_NOT_FOUND";
            }
            catch (Exception e) {
                response = "Exception: " + e;
                e.printStackTrace();
            }
            ++this.totalCommands;
        }
        return response;
    }

    public String execute(String cmdString) {
        if (this.trace) {
            System.out.println("Execute: " + cmdString);
        }
        return this.execute(this.parseMessage(cmdString));
    }

    protected String[] parseMessage(String message) {
        ArrayList<String> words = new ArrayList<String>(20);
        StreamTokenizer st = new StreamTokenizer(new StringReader(message));
        st.resetSyntax();
        st.whitespaceChars(0, 32);
        st.wordChars(33, 255);
        st.quoteChar(34);
        st.quoteChar(34);
        st.commentChar(35);
        try {
            while (true) {
                int tokenType;
                if ((tokenType = st.nextToken()) == -3) {
                    words.add(st.sval);
                    continue;
                }
                if (tokenType == 39 || tokenType == 34) {
                    words.add(st.sval);
                    continue;
                }
                if (tokenType == -2) {
                    System.out.println("Unexpected numeric token!");
                    continue;
                }
                break;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return words.toArray(new String[words.size()]);
    }

    public void run() {
        while (!this.done) {
            try {
                this.printPrompt();
                String message = this.getInputLine();
                if (message == null) break;
                if (this.trace) {
                    System.out.println("\n----------");
                    System.out.println("In : " + message);
                }
                if ((message = message.trim()).length() <= 0) continue;
                this.putResponse(this.execute(message));
            }
            catch (IOException e) {
                System.out.println("IOException: " + e);
                break;
            }
        }
        this.onExit();
    }

    private String getInputLine() throws IOException {
        boolean error;
        boolean echo;
        boolean justPush;
        String message;
        block19: {
            message = this.in.readLine();
            justPush = false;
            echo = false;
            error = false;
            if (message == null) {
                return null;
            }
            Matcher m = historyPush.matcher(message);
            if (m.matches()) {
                justPush = true;
                echo = true;
                message = m.group(1);
            }
            if (message.startsWith("^")) {
                m = editPattern.matcher(message);
                if (m.matches()) {
                    String orig = m.group(1);
                    String sub = m.group(2);
                    try {
                        Pattern pat = Pattern.compile(orig);
                        Matcher subMatcher = pat.matcher(this.history.getLast(0));
                        if (subMatcher.find()) {
                            message = subMatcher.replaceFirst(sub);
                            echo = true;
                            break block19;
                        }
                        error = true;
                        this.putResponse(String.valueOf(message) + ": substitution failed");
                    }
                    catch (PatternSyntaxException pse) {
                        error = true;
                        this.putResponse("Bad regexp: " + pse.getDescription());
                    }
                } else {
                    error = true;
                    this.putResponse("bad substitution sytax, use ^old^new^");
                }
            } else {
                m = bbPattern.matcher(message);
                if (m.find()) {
                    message = m.replaceAll(this.history.getLast(0));
                    echo = true;
                } else if (message.startsWith("!")) {
                    if (message.matches("!\\d+")) {
                        int which = Integer.parseInt(message.substring(1));
                        message = this.history.get(which);
                    } else if (message.matches("!-\\d+")) {
                        int which = Integer.parseInt(message.substring(2));
                        message = this.history.getLast(which - 1);
                    } else {
                        message = this.history.findLast(message.substring(1));
                    }
                    echo = true;
                }
            }
        }
        if (error) {
            return "";
        }
        if (message.length() > 0) {
            this.history.add(message);
        }
        if (echo) {
            this.putResponse(message);
        }
        return justPush ? "" : message;
    }

    public void close() {
        this.done = true;
    }

    private void printPrompt() {
        if (this.prompt != null) {
            System.out.print(this.prompt);
        }
    }

    public boolean load(String filename) {
        try {
            String inputLine;
            FileReader fr = new FileReader(filename);
            BufferedReader br = new BufferedReader(fr);
            while ((inputLine = br.readLine()) != null) {
                String response = this.execute(inputLine);
                if (response.equals("OK")) continue;
                this.putResponse(response);
            }
            fr.close();
            return true;
        }
        catch (IOException ioe) {
            return false;
        }
    }

    public void setPrompt(String prompt) {
        this.prompt = prompt;
    }

    public String getPrompt() {
        return this.prompt;
    }

    public static void main(String[] args) {
        Shell ci = new Shell();
        try {
            System.out.println("Welcome to the Command interpreter test program");
            ci.setPrompt("CI> ");
            ci.run();
            System.out.println("Goodbye!");
        }
        catch (Throwable t) {
            System.out.println(t);
        }
    }

    public static String mash(String[] args, int start) {
        StringBuilder sb = new StringBuilder();
        int i = start;
        while (i < args.length) {
            sb.append(args[i]);
            sb.append(" ");
            ++i;
        }
        return sb.toString().trim();
    }

    class CommandHistory {
        private List history = new ArrayList(100);

        CommandHistory() {
        }

        public void add(String command) {
            this.history.add(command);
        }

        public String getLast(int offset) {
            if (this.history.size() > offset) {
                return (String)this.history.get(this.history.size() - 1 - offset);
            }
            Shell.this.putResponse("command not found");
            return "";
        }

        public String get(int which) {
            if (this.history.size() > which) {
                return (String)this.history.get(which);
            }
            Shell.this.putResponse("command not found");
            return "";
        }

        public String findLast(String match) {
            int i = this.history.size() - 1;
            while (i >= 0) {
                String cmd = this.get(i);
                if (cmd.startsWith(match)) {
                    return cmd;
                }
                --i;
            }
            Shell.this.putResponse("command not found");
            return "";
        }

        public void dump() {
            int i = 0;
            while (i < this.history.size()) {
                String cmd = this.get(i);
                Shell.this.putResponse(String.valueOf(i) + " " + cmd);
                ++i;
            }
        }
    }
}

