/*
 * Decompiled with CFR 0.152.
 */
package com.echonest.api.v4.util;

import com.echonest.api.v4.util.OpData;
import com.echonest.api.v4.util.PerformanceStats;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class StatsManager {
    private Map<String, OpData> map = new HashMap<String, OpData>();

    public Tracker start(String name) {
        return new Tracker(name, System.currentTimeMillis());
    }

    public void end(Tracker tracker) {
        tracker.endTime = System.currentTimeMillis();
        long delta = tracker.endTime - tracker.startTime;
        OpData opData = this.get(tracker.name);
        ++opData.count;
        opData.sumTime += delta;
        if (delta > opData.maxTime) {
            opData.maxTime = delta;
        }
        if (delta < opData.minTime) {
            opData.minTime = delta;
        }
    }

    public void close(Tracker tracker) {
        if (tracker.endTime == 0L) {
            OpData opData = this.get(tracker.name);
            ++opData.count;
            ++opData.error;
        }
    }

    private OpData get(String op) {
        OpData opData = this.map.get(op);
        if (opData == null) {
            opData = new OpData(op);
            this.map.put(op, opData);
        }
        return opData;
    }

    public PerformanceStats getOverallPerformanceStats() {
        int total = 0;
        int errs = 0;
        int sum = 0;
        long min = Long.MAX_VALUE;
        long max = Long.MIN_VALUE;
        PerformanceStats ps = new PerformanceStats();
        ArrayList<OpData> opList = new ArrayList<OpData>(this.map.values());
        for (OpData opData : opList) {
            total += opData.count;
            errs += opData.error;
            sum = (int)((long)sum + opData.sumTime);
            if (opData.minTime < min) {
                min = opData.minTime;
            }
            if (opData.maxTime <= max) continue;
            max = opData.maxTime;
        }
        ps.setCalls(total);
        ps.setFailures(errs);
        ps.setTotalCallTime(sum);
        ps.setMinCallTime(min);
        ps.setMinCallTime(max);
        return ps;
    }

    public void dump() {
        System.out.printf("||%5s|| %4s|| %6s || %6s || %6s || %s ||\n", "Calls", "Fail", "Avg", "Min", "Max", "Method");
        int total = 0;
        int errs = 0;
        int sum = 0;
        ArrayList<OpData> opList = new ArrayList<OpData>(this.map.values());
        Collections.sort(opList);
        for (OpData opData : opList) {
            System.out.println(opData);
            total += opData.count;
            errs += opData.error;
            sum = (int)((long)sum + opData.sumTime);
        }
        int successCount = total - errs;
        System.out.println("");
        System.out.printf(" Total calls : %d \n", total);
        System.out.printf(" Total errors: %d \n", errs);
        if (total > 0) {
            System.out.printf(" Success Rate: %d %%\n", 100 * (total - errs) / total);
        }
        if (successCount > 0) {
            System.out.printf(" Average Time: %d ms\n", sum / successCount);
        }
        System.out.println("");
    }

    public static class Tracker {
        String name;
        long startTime;
        long endTime = 0L;

        Tracker(String name, long start) {
            this.name = name;
            this.startTime = start;
        }
    }
}

