/*
 * Decompiled with CFR 0.152.
 */
package org.jaudiotagger.tag.id3.framebody;

import java.io.ByteArrayOutputStream;
import java.nio.ByteBuffer;
import org.jaudiotagger.audio.generic.Utils;
import org.jaudiotagger.tag.InvalidTagException;
import org.jaudiotagger.tag.datatype.AbstractString;
import org.jaudiotagger.tag.datatype.ByteArraySizeTerminated;
import org.jaudiotagger.tag.datatype.NumberHashMap;
import org.jaudiotagger.tag.datatype.StringNullTerminated;
import org.jaudiotagger.tag.datatype.TextEncodedStringNullTerminated;
import org.jaudiotagger.tag.id3.AbstractTagFrameBody;
import org.jaudiotagger.tag.id3.framebody.AbstractID3v2FrameBody;
import org.jaudiotagger.tag.id3.framebody.FrameBodyPIC;
import org.jaudiotagger.tag.id3.framebody.ID3v23FrameBody;
import org.jaudiotagger.tag.id3.framebody.ID3v24FrameBody;
import org.jaudiotagger.tag.id3.valuepair.ImageFormats;

public class FrameBodyAPIC
extends AbstractID3v2FrameBody
implements ID3v24FrameBody,
ID3v23FrameBody {
    public static final String IMAGE_IS_URL = "-->";

    public FrameBodyAPIC() {
        this.setObjectValue("TextEncoding", (byte)0);
    }

    public FrameBodyAPIC(FrameBodyAPIC body) {
        super(body);
    }

    public FrameBodyAPIC(FrameBodyPIC body) {
        this.setObjectValue("TextEncoding", body.getTextEncoding());
        this.setObjectValue("MIMEType", ImageFormats.getMimeTypeForFormat((String)body.getObjectValue("ImageType")));
        this.setObjectValue("PictureType", body.getObjectValue("PictureType"));
        this.setObjectValue("Description", body.getDescription());
        this.setObjectValue("PictureData", body.getObjectValue("PictureData"));
    }

    public FrameBodyAPIC(byte textEncoding, String mimeType, byte pictureType, String description, byte[] data) {
        this.setObjectValue("TextEncoding", textEncoding);
        this.setMimeType(mimeType);
        this.setPictureType(pictureType);
        this.setDescription(description);
        this.setImageData(data);
    }

    public FrameBodyAPIC(ByteBuffer byteBuffer, int frameSize) throws InvalidTagException {
        super(byteBuffer, frameSize);
    }

    public void setDescription(String description) {
        this.setObjectValue("Description", description);
    }

    public String getDescription() {
        return (String)this.getObjectValue("Description");
    }

    public void setMimeType(String mimeType) {
        this.setObjectValue("MIMEType", mimeType);
    }

    public String getMimeType() {
        return (String)this.getObjectValue("MIMEType");
    }

    public void setImageData(byte[] imageData) {
        this.setObjectValue("PictureData", imageData);
    }

    public byte[] getImageData() {
        return (byte[])this.getObjectValue("PictureData");
    }

    public void setPictureType(byte pictureType) {
        this.setObjectValue("PictureType", pictureType);
    }

    public int getPictureType() {
        return ((Long)this.getObjectValue("PictureType")).intValue();
    }

    public String getIdentifier() {
        return "APIC";
    }

    public void write(ByteArrayOutputStream tagBuffer) {
        if (!((AbstractString)this.getObject("Description")).canBeEncoded()) {
            this.setTextEncoding((byte)1);
        }
        super.write(tagBuffer);
    }

    protected void setupObjectList() {
        this.objectList.add(new NumberHashMap("TextEncoding", (AbstractTagFrameBody)this, 1));
        this.objectList.add(new StringNullTerminated("MIMEType", this));
        this.objectList.add(new NumberHashMap("PictureType", (AbstractTagFrameBody)this, 1));
        this.objectList.add(new TextEncodedStringNullTerminated("Description", this));
        this.objectList.add(new ByteArraySizeTerminated("PictureData", this));
    }

    public boolean isImageUrl() {
        return this.getMimeType() != null && this.getMimeType().equals(IMAGE_IS_URL);
    }

    public String getImageUrl() {
        if (this.isImageUrl()) {
            return Utils.getString((byte[])this.getObjectValue("PictureData"), 0, ((byte[])this.getObjectValue("PictureData")).length, "ISO-8859-1");
        }
        return "";
    }
}

