/*
 * Decompiled with CFR 0.152.
 */
package net.roarsoftware.lastfm;

import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import net.roarsoftware.lastfm.Caller;
import net.roarsoftware.lastfm.Result;
import net.roarsoftware.lastfm.Session;
import net.roarsoftware.util.StringUtilities;
import net.roarsoftware.xml.DomElement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Authenticator {
    private Authenticator() {
    }

    public static Session getMobileSession(String username, String password, String apiKey, String secret) {
        if (!StringUtilities.isMD5(password)) {
            password = StringUtilities.md5(password);
        }
        String authToken = StringUtilities.md5(username + password);
        Map<String, String> params = StringUtilities.map("api_key", apiKey, "username", username, "authToken", authToken);
        String sig = Authenticator.createSignature("auth.getMobileSession", params, secret);
        Result result = Caller.getInstance().call("auth.getMobileSession", apiKey, "username", username, "authToken", authToken, "api_sig", sig);
        DomElement element = result.getContentElement();
        return Session.sessionFromElement(element, apiKey, secret);
    }

    public static String getToken(String apiKey) {
        Result result = Caller.getInstance().call("auth.getToken", apiKey, new String[0]);
        return result.getContentElement().getText();
    }

    public static Session getSession(String token, String apiKey, String secret) {
        String m = "auth.getSession";
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("api_key", apiKey);
        params.put("token", token);
        params.put("api_sig", Authenticator.createSignature(m, params, secret));
        Result result = Caller.getInstance().call(m, apiKey, params);
        return Session.sessionFromElement(result.getContentElement(), apiKey, secret);
    }

    static String createSignature(String method, Map<String, String> params, String secret) {
        params = new TreeMap<String, String>(params);
        params.put("method", method);
        StringBuilder b = new StringBuilder(100);
        for (Map.Entry<String, String> entry : params.entrySet()) {
            b.append(entry.getKey());
            b.append(entry.getValue());
        }
        b.append(secret);
        return StringUtilities.md5(b.toString());
    }
}

