/*
 * Decompiled with CFR 0.152.
 */
package net.roarsoftware.lastfm;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.HttpURLConnection;
import java.net.Proxy;
import java.net.URL;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeSet;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import net.roarsoftware.lastfm.Authenticator;
import net.roarsoftware.lastfm.CallException;
import net.roarsoftware.lastfm.Result;
import net.roarsoftware.lastfm.Session;
import net.roarsoftware.lastfm.cache.Cache;
import net.roarsoftware.lastfm.cache.FileSystemCache;
import net.roarsoftware.util.StringUtilities;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Caller {
    private static final String PARAM_API_KEY = "api_key";
    private static final String PARAM_METHOD = "method";
    private static final String DEFAULT_API_ROOT = "http://ws.audioscrobbler.com/2.0/";
    private static final Caller instance = new Caller();
    private String apiRootUrl = "http://ws.audioscrobbler.com/2.0/";
    private Proxy proxy;
    private String userAgent = "tst";
    private boolean debugMode = false;
    private Cache cache = new FileSystemCache();
    private Result lastResult;

    private Caller() {
    }

    public static Caller getInstance() {
        return instance;
    }

    public void setApiRootUrl(String apiRootUrl) {
        this.apiRootUrl = apiRootUrl;
    }

    public void setProxy(Proxy proxy) {
        this.proxy = proxy;
    }

    public void setUserAgent(String userAgent) {
        this.userAgent = userAgent;
    }

    public void setDebugMode(boolean debugMode) {
        this.debugMode = debugMode;
    }

    public Cache getCache() {
        return this.cache;
    }

    public void setCache(Cache cache) {
        this.cache = cache;
    }

    public Result call(String method, String apiKey, String ... params) throws CallException {
        return this.call(method, apiKey, StringUtilities.map(params));
    }

    public Result call(String method, String apiKey, Map<String, String> params) throws CallException {
        return this.call(method, apiKey, params, null);
    }

    public Result call(String method, Session session, String ... params) {
        return this.call(method, session.getApiKey(), StringUtilities.map(params), session);
    }

    public Result call(String method, Session session, Map<String, String> params) {
        return this.call(method, session.getApiKey(), params, session);
    }

    private Result call(String method, String apiKey, Map<String, String> params, Session session) {
        params = new HashMap<String, String>(params);
        InputStream inputStream = null;
        String cacheEntryName = Cache.createCacheEntryName(method, params);
        if (session == null && this.cache != null && this.cache.contains(cacheEntryName) && !this.cache.isExpired(cacheEntryName)) {
            inputStream = this.cache.load(cacheEntryName);
        }
        if (inputStream == null) {
            params.put(PARAM_API_KEY, apiKey);
            if (session != null) {
                params.put("sk", session.getKey());
                String sig = Authenticator.createSignature(method, params, session.getSecret());
                params.put("api_sig", sig);
            }
            try {
                HttpURLConnection urlConnection = this.openConnection(this.apiRootUrl);
                urlConnection.setRequestMethod("POST");
                urlConnection.setDoOutput(true);
                OutputStream outputStream = urlConnection.getOutputStream();
                BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(outputStream));
                String post = this.buildParameterQueue(method, params, new String[0]);
                if (this.debugMode) {
                    System.out.println("body: " + post);
                }
                writer.write(post);
                writer.close();
                int responseCode = urlConnection.getResponseCode();
                if (responseCode == 403 || responseCode == 400) {
                    inputStream = urlConnection.getErrorStream();
                } else {
                    if (responseCode != 200) {
                        this.lastResult = Result.createHttpErrorResult(responseCode, urlConnection.getResponseMessage());
                        return this.lastResult;
                    }
                    inputStream = urlConnection.getInputStream();
                    if (this.cache != null) {
                        long expirationTime;
                        long expires = urlConnection.getHeaderFieldDate("Expires", -1L);
                        if (expires == -1L && (expirationTime = this.cache.getExpirationPolicy().getExpirationTime(method, params)) > 0L) {
                            expires = expirationTime == Long.MAX_VALUE ? Long.MAX_VALUE : System.currentTimeMillis() + expirationTime;
                        }
                        if (expires != -1L) {
                            this.cache.store(cacheEntryName, inputStream, expires);
                            inputStream = this.cache.load(cacheEntryName);
                            if (inputStream == null) {
                                throw new CallException("caching failed.");
                            }
                        }
                    }
                }
            }
            catch (IOException e) {
                throw new CallException(e);
            }
        }
        try {
            Result.Status status;
            Document document = this.newDocumentBuilder().parse(inputStream);
            Element root = document.getDocumentElement();
            String statusString = root.getAttribute("status");
            Result.Status status2 = status = "ok".equals(statusString) ? Result.Status.OK : Result.Status.FAILED;
            if (status == Result.Status.FAILED) {
                if (this.cache != null) {
                    this.cache.remove(cacheEntryName);
                }
                Element error = (Element)root.getElementsByTagName("error").item(0);
                int errorCode = Integer.parseInt(error.getAttribute("code"));
                String message = error.getTextContent();
                if (this.debugMode) {
                    System.err.printf("Failed. Code: %d, Error: %s%n", errorCode, message);
                }
                this.lastResult = Result.createRestErrorResult(errorCode, message);
            } else {
                this.lastResult = Result.createOkResult(document);
            }
            return this.lastResult;
        }
        catch (IOException e) {
            throw new CallException(e);
        }
        catch (SAXException e) {
            throw new CallException(e);
        }
    }

    public Result getLastResult() {
        return this.lastResult;
    }

    private DocumentBuilder newDocumentBuilder() {
        try {
            return DocumentBuilderFactory.newInstance().newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            throw new RuntimeException(e);
        }
    }

    public HttpURLConnection openConnection(String url) throws IOException {
        if (this.isDebugMode()) {
            System.out.println("open: " + url);
        }
        URL u = new URL(url);
        HttpURLConnection urlConnection = this.proxy != null ? (HttpURLConnection)u.openConnection(this.proxy) : (HttpURLConnection)u.openConnection();
        urlConnection.setRequestProperty("User-Agent", this.userAgent);
        return urlConnection;
    }

    private String buildParameterQueue(String method, Map<String, String> params, String ... strings) {
        StringBuilder builder = new StringBuilder(100);
        builder.append("method=");
        builder.append(method);
        builder.append('&');
        Iterator<Map.Entry<String, String>> it = params.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<String, String> entry = it.next();
            builder.append(entry.getKey());
            builder.append('=');
            builder.append(StringUtilities.encode(entry.getValue()));
            if (!it.hasNext() && strings.length <= 0) continue;
            builder.append('&');
        }
        int count = 0;
        for (String string : strings) {
            builder.append(count % 2 == 0 ? string : StringUtilities.encode(string));
            if (++count == strings.length) continue;
            if (count % 2 == 0) {
                builder.append('&');
                continue;
            }
            builder.append('=');
        }
        return builder.toString();
    }

    private String createSignature(Map<String, String> params, String secret) {
        TreeSet<String> sorted = new TreeSet<String>(params.keySet());
        StringBuilder builder = new StringBuilder(50);
        for (String s : sorted) {
            builder.append(s);
            builder.append(StringUtilities.encode(params.get(s)));
        }
        builder.append(secret);
        return StringUtilities.md5(builder.toString());
    }

    public Proxy getProxy() {
        return this.proxy;
    }

    public String getUserAgent() {
        return this.userAgent;
    }

    public boolean isDebugMode() {
        return this.debugMode;
    }
}

