/*
 * Decompiled with CFR 0.152.
 */
package net.roarsoftware.lastfm;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Locale;
import net.roarsoftware.lastfm.Caller;
import net.roarsoftware.lastfm.ImageHolder;
import net.roarsoftware.lastfm.Result;
import net.roarsoftware.lastfm.Session;
import net.roarsoftware.lastfm.User;
import net.roarsoftware.lastfm.Venue;
import net.roarsoftware.xml.DomElement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Event
extends ImageHolder {
    private static final DateFormat DATE_FORMAT = new SimpleDateFormat("EEE, dd MMM yyyy", Locale.ENGLISH);
    private static final DateFormat TIME_FORMAT = new SimpleDateFormat("HH:mm", Locale.ENGLISH);
    private int id;
    private String title;
    private Collection<String> artists;
    private String headliner;
    private Collection<TicketSupplier> tickets;
    private Date startDate;
    private String description;
    private String url;
    private String website;
    private int attendance;
    private int reviews;
    private Venue venue;

    private Event() {
    }

    public Collection<String> getArtists() {
        return this.artists;
    }

    public int getAttendance() {
        return this.attendance;
    }

    public String getDescription() {
        return this.description;
    }

    public String getHeadliner() {
        return this.headliner;
    }

    public int getId() {
        return this.id;
    }

    public int getReviews() {
        return this.reviews;
    }

    public Date getStartDate() {
        return this.startDate;
    }

    public String getTitle() {
        return this.title;
    }

    public String getUrl() {
        return this.url;
    }

    public String getWebsite() {
        return this.website;
    }

    public Collection<TicketSupplier> getTicketSuppliers() {
        return this.tickets;
    }

    public Venue getVenue() {
        return this.venue;
    }

    public static Event getInfo(String eventId, String apiKey) {
        Result result = Caller.getInstance().call("event.getInfo", apiKey, "event", eventId);
        return Event.eventFromElement(result.getContentElement());
    }

    public static Result attend(String eventId, AttendanceStatus status, Session session) {
        return Caller.getInstance().call("event.attend", session, "event", eventId, "status", String.valueOf(status.getId()));
    }

    public static Result share(String eventId, String recipients, String message, Session session) {
        return Caller.getInstance().call("event.share", session, "event", eventId, "recipient", recipients, "message", message);
    }

    public static Collection<User> getAttendees(String eventId, String apiKey) {
        Result result = Caller.getInstance().call("event.getAttendees", apiKey, "event", eventId);
        DomElement root = result.getContentElement();
        ArrayList<User> users = new ArrayList<User>(Integer.parseInt(root.getAttribute("total")));
        for (DomElement element : root.getChildren("user")) {
            users.add(User.userFromElement(element));
        }
        return users;
    }

    static Event eventFromElement(DomElement e) {
        if (e == null) {
            return null;
        }
        Event event = new Event();
        ImageHolder.loadImages(event, e);
        event.id = Integer.parseInt(e.getChildText("id"));
        event.title = e.getChildText("title");
        event.description = e.getChildText("description");
        event.url = e.getChildText("url");
        if (e.hasChild("attendance")) {
            event.attendance = Integer.parseInt(e.getChildText("attendance"));
        }
        if (e.hasChild("reviews")) {
            event.reviews = Integer.parseInt(e.getChildText("reviews"));
        }
        try {
            event.startDate = DATE_FORMAT.parse(e.getChildText("startDate"));
            if (e.hasChild("startTime")) {
                Date startTime = TIME_FORMAT.parse(e.getChildText("startTime"));
                Calendar c = GregorianCalendar.getInstance();
                c.setTime(event.startDate);
                Calendar timeCalendar = GregorianCalendar.getInstance();
                timeCalendar.setTime(startTime);
                c.set(11, timeCalendar.get(11));
                c.set(12, timeCalendar.get(12));
                event.startDate = c.getTime();
            }
        }
        catch (ParseException e1) {
            e1.printStackTrace();
        }
        event.headliner = e.getChild("artists").getChildText("headliner");
        event.artists = new ArrayList<String>();
        for (DomElement element : e.getChild("artists").getChildren("artist")) {
            event.artists.add(element.getText());
        }
        event.website = e.getChildText("website");
        event.tickets = new ArrayList<TicketSupplier>();
        for (DomElement ticket : e.getChild("tickets").getChildren("ticket")) {
            event.tickets.add(new TicketSupplier(ticket.getAttribute("supplier"), ticket.getText()));
        }
        event.venue = Venue.venueFromElement(e.getChild("venue"));
        return event;
    }

    public static class TicketSupplier {
        private String name;
        private String website;

        public TicketSupplier(String name, String website) {
            this.name = name;
            this.website = website;
        }

        public String getName() {
            return this.name;
        }

        public String getWebsite() {
            return this.website;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum AttendanceStatus {
        ATTENDING(0),
        MAYBE_ATTENDING(1),
        NOT_ATTENDING(2);

        private int id;

        private AttendanceStatus(int id) {
            this.id = id;
        }

        public int getId() {
            return this.id;
        }
    }
}

