/*
 * Decompiled with CFR 0.152.
 */
package net.roarsoftware.lastfm;

import java.util.Collection;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import net.roarsoftware.lastfm.ImageSize;
import net.roarsoftware.xml.DomElement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ImageHolder {
    protected Map<ImageSize, String> imageUrls = new HashMap<ImageSize, String>();

    public Set<ImageSize> availableSizes() {
        return this.imageUrls.keySet();
    }

    public String getImageURL(ImageSize size) {
        return this.imageUrls.get((Object)size);
    }

    protected static void loadImages(ImageHolder holder, DomElement element) {
        Collection<DomElement> images = element.getChildren("image");
        for (DomElement image : images) {
            String attribute = image.getAttribute("size");
            ImageSize size = null;
            if (attribute == null) {
                size = ImageSize.MEDIUM;
            } else {
                try {
                    size = ImageSize.valueOf(attribute.toUpperCase(Locale.ENGLISH));
                }
                catch (IllegalArgumentException e) {
                    // empty catch block
                }
            }
            if (size == null) continue;
            holder.imageUrls.put(size, image.getText());
        }
    }
}

