/*
 * Decompiled with CFR 0.152.
 */
package net.roarsoftware.lastfm;

import java.util.ArrayList;
import java.util.Collection;
import net.roarsoftware.lastfm.Caller;
import net.roarsoftware.lastfm.ImageSize;
import net.roarsoftware.lastfm.Result;
import net.roarsoftware.lastfm.Session;
import net.roarsoftware.lastfm.Track;
import net.roarsoftware.xml.DomElement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Playlist {
    private int id;
    private String title;
    private String annotation;
    private int size;
    private String creator;
    private Collection<Track> tracks = new ArrayList<Track>();

    private Playlist() {
    }

    public String getCreator() {
        return this.creator;
    }

    public int getId() {
        return this.id;
    }

    public int getSize() {
        return this.size;
    }

    public String getTitle() {
        return this.title;
    }

    public String getAnnotation() {
        return this.annotation;
    }

    public Collection<Track> getTracks() {
        return this.tracks;
    }

    public static Playlist fetchAlbumPlaylist(String albumId, String apiKey) {
        return Playlist.fetch("lastfm://playlist/album/" + albumId, apiKey);
    }

    public static Playlist fetchUserPlaylist(int playlistId, String apiKey) {
        return Playlist.fetch("lastfm://playlist/" + playlistId, apiKey);
    }

    public static Playlist fetchTagPlaylist(String tag, String apiKey) {
        return Playlist.fetch("lastfm://playlist/tag/" + tag + "/freetracks", apiKey);
    }

    public static Playlist fetch(String playlistUrl, String apiKey) {
        Result result = Caller.getInstance().call("playlist.fetch", apiKey, "playlistURL", playlistUrl);
        return Playlist.playlistFromElement(result.getContentElement());
    }

    public static Result addTrack(int playlistId, String artist, String track, Session session) {
        return Caller.getInstance().call("playlist.addTrack", session, "playlistID", String.valueOf(playlistId), "artist", artist, "track", track);
    }

    public static Playlist create(String title, String description, Session session) {
        Result result = Caller.getInstance().call("Playlist.create", session, "title", title, "description", description);
        if (!result.isSuccessful()) {
            return null;
        }
        return Playlist.playlistFromElement(result.getContentElement().getChild("playlist"));
    }

    static Playlist playlistFromElement(DomElement e) {
        if (e == null) {
            return null;
        }
        Playlist p = new Playlist();
        if (e.hasChild("id")) {
            p.id = Integer.parseInt(e.getChildText("id"));
        }
        p.title = e.getChildText("title");
        if (e.hasChild("size")) {
            p.size = Integer.parseInt(e.getChildText("size"));
        }
        p.creator = e.getChildText("creator");
        p.annotation = e.getChildText("annotation");
        DomElement tl = e.getChild("trackList");
        if (tl != null) {
            for (DomElement te : tl.getChildren("track")) {
                Track t = new Track(te.getChildText("title"), te.getChildText("identifier"), te.getChildText("creator"));
                t.album = te.getChildText("album");
                t.duration = Integer.parseInt(te.getChildText("duration")) / 1000;
                t.imageUrls.put(ImageSize.LARGE, te.getChildText("image"));
                t.imageUrls.put(ImageSize.ORIGINAL, te.getChildText("image"));
                t.location = te.getChildText("location");
                for (DomElement ext : te.getChildren("extension")) {
                    if (!"http://www.last.fm".equals(ext.getAttribute("application"))) continue;
                    for (DomElement child : ext.getChildren()) {
                        t.lastFmExtensionInfos.put(child.getTagName(), child.getText());
                    }
                }
                p.tracks.add(t);
            }
            if (p.size == 0) {
                p.size = p.tracks.size();
            }
        }
        return p;
    }
}

