/*
 * Decompiled with CFR 0.152.
 */
package net.roarsoftware.lastfm;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import net.roarsoftware.lastfm.Album;
import net.roarsoftware.lastfm.Artist;
import net.roarsoftware.lastfm.Caller;
import net.roarsoftware.lastfm.Chart;
import net.roarsoftware.lastfm.Event;
import net.roarsoftware.lastfm.ImageHolder;
import net.roarsoftware.lastfm.ImageSize;
import net.roarsoftware.lastfm.PaginatedResult;
import net.roarsoftware.lastfm.Period;
import net.roarsoftware.lastfm.Playlist;
import net.roarsoftware.lastfm.Result;
import net.roarsoftware.lastfm.Session;
import net.roarsoftware.lastfm.Track;
import net.roarsoftware.xml.DomElement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class User
extends ImageHolder {
    private String name;
    private String url;
    private String language;
    private String country;
    private int age = -1;
    private String gender;
    private boolean subscriber;
    private int numPlaylists;
    private int playcount;

    private User(String name, String url) {
        this.name = name;
        this.url = url;
    }

    public String getName() {
        return this.name;
    }

    public String getUrl() {
        return this.url;
    }

    public int getAge() {
        return this.age;
    }

    public String getCountry() {
        return this.country;
    }

    public String getGender() {
        return this.gender;
    }

    public String getLanguage() {
        return this.language;
    }

    public int getNumPlaylists() {
        return this.numPlaylists;
    }

    public int getPlaycount() {
        return this.playcount;
    }

    public boolean isSubscriber() {
        return this.subscriber;
    }

    public String getImageURL() {
        return this.getImageURL(ImageSize.MEDIUM);
    }

    public static Collection<User> getFriends(String user, String apiKey) {
        return User.getFriends(user, false, 100, apiKey);
    }

    public static Collection<User> getFriends(String user, boolean recenttracks, int limit, String apiKey) {
        Result result = Caller.getInstance().call("user.getFriends", apiKey, "user", user, "recenttracks", String.valueOf(recenttracks ? 1 : 0), "limit", String.valueOf(limit));
        if (!result.isSuccessful()) {
            return Collections.emptyList();
        }
        DomElement element = result.getContentElement();
        ArrayList<User> friends = new ArrayList<User>();
        for (DomElement domElement : element.getChildren("user")) {
            friends.add(User.userFromElement(domElement));
        }
        return friends;
    }

    public static Collection<User> getNeighbours(String user, String apiKey) {
        return User.getFriends(user, false, 100, apiKey);
    }

    public static Collection<User> getNeighbours(String user, int limit, String apiKey) {
        Result result = Caller.getInstance().call("user.getNeighbours", apiKey, "user", user, "limit", String.valueOf(limit));
        if (!result.isSuccessful()) {
            return Collections.emptyList();
        }
        DomElement element = result.getContentElement();
        ArrayList<User> friends = new ArrayList<User>();
        for (DomElement domElement : element.getChildren("user")) {
            friends.add(User.userFromElement(domElement));
        }
        return friends;
    }

    public static Collection<Track> getRecentTracks(String user, String apiKey) {
        return User.getRecentTracks(user, 10, apiKey);
    }

    public static Collection<Track> getRecentTracks(String user, int limit, String apiKey) {
        Result result = Caller.getInstance().call("user.getRecentTracks", apiKey, "user", user, "limit", String.valueOf(limit));
        if (!result.isSuccessful()) {
            return Collections.emptyList();
        }
        DomElement element = result.getContentElement();
        ArrayList<Track> tracks = new ArrayList<Track>();
        for (DomElement e : element.getChildren("track")) {
            tracks.add(Track.trackFromElement(e));
        }
        return tracks;
    }

    public static Collection<Album> getTopAlbums(String user, String apiKey) {
        return User.getTopAlbums(user, Period.OVERALL, apiKey);
    }

    public static Collection<Album> getTopAlbums(String user, Period period, String apiKey) {
        Result result = Caller.getInstance().call("user.getTopAlbums", apiKey, "user", user, "period", period.getString());
        if (!result.isSuccessful()) {
            return Collections.emptyList();
        }
        DomElement element = result.getContentElement();
        ArrayList<Album> albums = new ArrayList<Album>();
        for (DomElement domElement : element.getChildren("album")) {
            albums.add(Album.albumFromElement(domElement));
        }
        return albums;
    }

    public static Collection<Artist> getTopArtists(String user, String apiKey) {
        return User.getTopArtists(user, Period.OVERALL, apiKey);
    }

    public static Collection<Artist> getTopArtists(String user, Period period, String apiKey) {
        Result result = Caller.getInstance().call("user.getTopArtists", apiKey, "user", user, "period", period.getString());
        if (!result.isSuccessful()) {
            return Collections.emptyList();
        }
        DomElement element = result.getContentElement();
        ArrayList<Artist> artists = new ArrayList<Artist>();
        for (DomElement domElement : element.getChildren("artist")) {
            artists.add(Artist.artistFromElement(domElement));
        }
        return artists;
    }

    public static Collection<Track> getTopTracks(String user, String apiKey) {
        return User.getTopTracks(user, Period.OVERALL, apiKey);
    }

    public static Collection<Track> getTopTracks(String user, Period period, String apiKey) {
        Result result = Caller.getInstance().call("user.getTopTracks", apiKey, "user", user, "period", period.getString());
        if (!result.isSuccessful()) {
            return Collections.emptyList();
        }
        DomElement element = result.getContentElement();
        ArrayList<Track> tracks = new ArrayList<Track>();
        for (DomElement domElement : element.getChildren("track")) {
            tracks.add(Track.trackFromElement(domElement));
        }
        return tracks;
    }

    public static Collection<String> getTopTags(String user, String apiKey) {
        return User.getTopTags(user, -1, apiKey);
    }

    public static Collection<String> getTopTags(String user, int limit, String apiKey) {
        Result result;
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("user", user);
        if (limit != -1) {
            params.put("limit", String.valueOf(limit));
        }
        if (!(result = Caller.getInstance().call("user.getTopTags", apiKey, params)).isSuccessful()) {
            return Collections.emptyList();
        }
        DomElement element = result.getContentElement();
        ArrayList<String> tags = new ArrayList<String>();
        for (DomElement domElement : element.getChildren("tag")) {
            tags.add(domElement.getChildText("name"));
        }
        return tags;
    }

    public static Chart<Album> getWeeklyAlbumChart(String user, String apiKey) {
        return User.getWeeklyAlbumChart(user, null, null, -1, apiKey);
    }

    public static Chart<Album> getWeeklyAlbumChart(String user, int limit, String apiKey) {
        return User.getWeeklyAlbumChart(user, null, null, limit, apiKey);
    }

    public static Chart<Album> getWeeklyAlbumChart(String user, String from, String to, int limit, String apiKey) {
        return Chart.getChart("user.getWeeklyAlbumChart", "user", user, "album", from, to, limit, apiKey);
    }

    public static Chart<Artist> getWeeklyArtistChart(String user, String apiKey) {
        return User.getWeeklyArtistChart(user, null, null, -1, apiKey);
    }

    public static Chart<Artist> getWeeklyArtistChart(String user, int limit, String apiKey) {
        return User.getWeeklyArtistChart(user, null, null, limit, apiKey);
    }

    public static Chart<Artist> getWeeklyArtistChart(String user, String from, String to, int limit, String apiKey) {
        return Chart.getChart("user.getWeeklyArtistChart", "user", user, "artist", from, to, limit, apiKey);
    }

    public static Chart<Track> getWeeklyTrackChart(String user, String apiKey) {
        return User.getWeeklyTrackChart(user, null, null, -1, apiKey);
    }

    public static Chart<Track> getWeeklyTrackChart(String user, int limit, String apiKey) {
        return User.getWeeklyTrackChart(user, null, null, limit, apiKey);
    }

    public static Chart<Track> getWeeklyTrackChart(String user, String from, String to, int limit, String apiKey) {
        return Chart.getChart("user.getWeeklyTrackChart", "user", user, "track", from, to, limit, apiKey);
    }

    public static LinkedHashMap<String, String> getWeeklyChartList(String user, String apiKey) {
        return Chart.getWeeklyChartList("user", user, apiKey);
    }

    public static Collection<Chart> getWeeklyChartListAsCharts(String user, String apiKey) {
        return Chart.getWeeklyChartListAsCharts("user", user, apiKey);
    }

    public static Collection<Event> getEvents(String user, String apiKey) {
        Result result = Caller.getInstance().call("user.getEvents", apiKey, "user", user);
        if (!result.isSuccessful()) {
            return Collections.emptyList();
        }
        DomElement element = result.getContentElement();
        ArrayList<Event> events = new ArrayList<Event>();
        for (DomElement domElement : element.getChildren("event")) {
            events.add(Event.eventFromElement(domElement));
        }
        return events;
    }

    public static PaginatedResult<Event> getPastEvents(String user, String apiKey) {
        return User.getPastEvents(user, 1, 0, apiKey);
    }

    public static PaginatedResult<Event> getPastEvents(String user, int page, int limit, String apiKey) {
        Result result = Caller.getInstance().call("user.getPastEvents", apiKey, "user", user, "page", String.valueOf(page), "limit", String.valueOf(limit));
        if (!result.isSuccessful()) {
            return new PaginatedResult<Event>(0, 0, Collections.emptyList());
        }
        DomElement element = result.getContentElement();
        ArrayList<Event> events = new ArrayList<Event>();
        for (DomElement domElement : element.getChildren("event")) {
            events.add(Event.eventFromElement(domElement));
        }
        int currentPage = Integer.valueOf(element.getAttribute("page"));
        int totalPages = Integer.valueOf(element.getAttribute("totalPages"));
        return new PaginatedResult<Event>(currentPage, totalPages, events);
    }

    public static PaginatedResult<Event> getRecommendedEvents(Session session) {
        return User.getRecommendedEvents(0, session);
    }

    public static PaginatedResult<Event> getRecommendedEvents(int page, Session session) {
        return User.getRecommendedEvents(0, 0, session);
    }

    public static PaginatedResult<Event> getRecommendedEvents(int page, int limit, Session session) {
        Result result = Caller.getInstance().call("user.getRecommendedEvents", session, "page", String.valueOf(page), "limit", String.valueOf(limit), "user", session.getUsername());
        if (!result.isSuccessful()) {
            return new PaginatedResult<Event>(0, 0, Collections.emptyList());
        }
        DomElement element = result.getContentElement();
        ArrayList<Event> events = new ArrayList<Event>();
        for (DomElement domElement : element.getChildren("event")) {
            events.add(Event.eventFromElement(domElement));
        }
        int currentPage = Integer.valueOf(element.getAttribute("page"));
        int totalPages = Integer.valueOf(element.getAttribute("totalPages"));
        return new PaginatedResult<Event>(currentPage, totalPages, events);
    }

    public static Collection<Playlist> getPlaylists(String user, String apiKey) {
        Result result = Caller.getInstance().call("user.getPlaylists", apiKey, "user", user);
        if (!result.isSuccessful()) {
            return Collections.emptyList();
        }
        ArrayList<Playlist> playlists = new ArrayList<Playlist>();
        for (DomElement element : result.getContentElement().getChildren("playlist")) {
            playlists.add(Playlist.playlistFromElement(element));
        }
        return playlists;
    }

    public static Collection<Track> getLovedTracks(String user, String apiKey) {
        Result result = Caller.getInstance().call("user.getLovedTracks", apiKey, "user", user);
        if (!result.isSuccessful()) {
            return Collections.emptyList();
        }
        DomElement element = result.getContentElement();
        ArrayList<Track> tracks = new ArrayList<Track>();
        for (DomElement domElement : element.getChildren("track")) {
            tracks.add(Track.trackFromElement(domElement));
        }
        return tracks;
    }

    public static User getInfo(Session session) {
        Result result = Caller.getInstance().call("user.getInfo", session, new String[0]);
        if (!result.isSuccessful()) {
            return null;
        }
        DomElement element = result.getContentElement();
        return User.userFromElement(element);
    }

    public static PaginatedResult<Artist> getRecommendedArtists(Session session) {
        return User.getRecommendedArtists(1, session);
    }

    public static PaginatedResult<Artist> getRecommendedArtists(int page, Session session) {
        Result result = Caller.getInstance().call("user.getRecommendedArtists", session, "page", String.valueOf(page));
        if (!result.isSuccessful()) {
            return new PaginatedResult<Artist>(0, 0, Collections.emptyList());
        }
        DomElement element = result.getContentElement();
        Collection<DomElement> children = element.getChildren("artist");
        ArrayList<Artist> artists = new ArrayList<Artist>(children.size());
        for (DomElement domElement : children) {
            artists.add(Artist.artistFromElement(domElement));
        }
        page = Integer.parseInt(element.getAttribute("page"));
        int total = Integer.parseInt(element.getAttribute("totalPages"));
        return new PaginatedResult<Artist>(page, total, artists);
    }

    public static Result shout(String user, String message, Session session) {
        return Caller.getInstance().call("user.shout", session, "user", user, "message", message);
    }

    static User userFromElement(DomElement element) {
        User user = new User(element.getChildText("name"), element.getChildText("url"));
        ImageHolder.loadImages(user, element);
        user.language = element.getChildText("lang");
        user.country = element.getChildText("country");
        if (element.hasChild("age")) {
            try {
                user.age = Integer.parseInt(element.getChildText("age"));
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        user.gender = element.getChildText("gender");
        user.subscriber = "1".equals(element.getChildText("subscriber"));
        if (element.hasChild("playcount")) {
            try {
                user.playcount = Integer.parseInt(element.getChildText("playcount"));
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        if (element.hasChild("playlists")) {
            try {
                user.numPlaylists = Integer.parseInt(element.getChildText("playlists"));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return user;
    }
}

