/*
 * Decompiled with CFR 0.152.
 */
package net.roarsoftware.lastfm.cache;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Properties;
import net.roarsoftware.lastfm.cache.Cache;
import net.roarsoftware.lastfm.cache.ScrobbleCache;
import net.roarsoftware.lastfm.scrobble.Scrobbler;
import net.roarsoftware.lastfm.scrobble.SubmissionData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileSystemCache
extends Cache
implements ScrobbleCache {
    private static final String SUBMISSIONS_FILE = "submissions.txt";
    private File cacheDir;

    public FileSystemCache() {
        this(new File(System.getProperty("user.home") + "/.last.fm-cache"));
    }

    public FileSystemCache(File cacheDir) {
        this.cacheDir = cacheDir;
    }

    @Override
    public boolean contains(String cacheEntryName) {
        return new File(this.cacheDir, cacheEntryName + ".xml").exists();
    }

    @Override
    public void remove(String cacheEntryName) {
        new File(this.cacheDir, cacheEntryName + ".xml").delete();
        new File(this.cacheDir, cacheEntryName + ".meta").delete();
    }

    @Override
    public boolean isExpired(String cacheEntryName) {
        File f = new File(this.cacheDir, cacheEntryName + ".meta");
        if (!f.exists()) {
            return false;
        }
        try {
            Properties p = new Properties();
            p.load(new FileInputStream(f));
            long expirationDate = Long.valueOf(p.getProperty("expiration-date"));
            return expirationDate < System.currentTimeMillis();
        }
        catch (IOException e) {
            return false;
        }
    }

    @Override
    public void clear() {
        for (File file : this.cacheDir.listFiles()) {
            if (!file.isFile()) continue;
            file.delete();
        }
    }

    @Override
    public InputStream load(String cacheEntryName) {
        try {
            return new FileInputStream(new File(this.cacheDir, cacheEntryName + ".xml"));
        }
        catch (FileNotFoundException e) {
            return null;
        }
    }

    @Override
    public void store(String cacheEntryName, InputStream inputStream, long expirationDate) {
        this.createCache();
        File f = new File(this.cacheDir, cacheEntryName + ".xml");
        try {
            int read;
            BufferedInputStream is = new BufferedInputStream(inputStream);
            BufferedOutputStream os = new BufferedOutputStream(new FileOutputStream(f));
            byte[] buffer = new byte[4096];
            while ((read = is.read(buffer)) != -1) {
                os.write(buffer, 0, read);
            }
            os.close();
            is.close();
            File fm = new File(this.cacheDir, cacheEntryName + ".meta");
            Properties p = new Properties();
            p.setProperty("expiration-date", Long.toString(expirationDate));
            p.store(new FileOutputStream(fm), null);
        }
        catch (IOException e) {
            // empty catch block
        }
    }

    private void createCache() {
        if (!this.cacheDir.exists()) {
            this.cacheDir.mkdirs();
            if (!this.cacheDir.isDirectory()) {
                this.cacheDir = this.cacheDir.getParentFile();
            }
        }
    }

    @Override
    public void cacheScrobble(Collection<SubmissionData> submissions) {
        this.cacheScrobble(submissions.toArray(new SubmissionData[submissions.size()]));
    }

    @Override
    public void cacheScrobble(SubmissionData ... submissions) {
        this.createCache();
        try {
            BufferedWriter w = new BufferedWriter(new FileWriter(new File(this.cacheDir, SUBMISSIONS_FILE), true));
            for (SubmissionData submission : submissions) {
                w.append(submission.toString());
                w.newLine();
            }
            w.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public boolean isEmpty() {
        File file = new File(this.cacheDir, SUBMISSIONS_FILE);
        if (!file.exists()) {
            return true;
        }
        try {
            BufferedReader r = new BufferedReader(new FileReader(file));
            String line = r.readLine();
            r.close();
            return line == null || "".equals(line);
        }
        catch (IOException iOException) {
            return true;
        }
    }

    @Override
    public void scrobble(Scrobbler scrobbler) throws IOException {
        File file = new File(this.cacheDir, SUBMISSIONS_FILE);
        if (file.exists()) {
            String line;
            BufferedReader r = new BufferedReader(new FileReader(file));
            ArrayList<SubmissionData> list = new ArrayList<SubmissionData>(50);
            while ((line = r.readLine()) != null) {
                SubmissionData d = new SubmissionData(line);
                list.add(d);
                if (list.size() != 50) continue;
                scrobbler.submit(list);
                list.clear();
            }
            if (list.size() > 0) {
                scrobbler.submit(list);
            }
            r.close();
            FileWriter w = new FileWriter(file);
            w.close();
        }
    }

    @Override
    public void clearScrobbleCache() {
        File file = new File(this.cacheDir, SUBMISSIONS_FILE);
        file.delete();
    }
}

