/*
 * Decompiled with CFR 0.152.
 */
package codecLib.mp3;

import codecLib.mp3.Constants;

public class MultiChannelInfo
implements Constants {
    protected int status;
    protected int presentChannels;
    protected int extFrameLength;
    protected int numberOfArrangementChannels;
    protected int numberOfLanguageChannels;
    protected int MLSamplingRate;
    protected int numberOfMLSamples;
    protected float[] LFESamples = new float[12];

    public String toString() {
        if (this.status != 0) {
            return "(no info)";
        }
        int n2 = 0;
        int n3 = 0;
        if ((this.presentChannels & 4) != 0) {
            ++n2;
        }
        if ((this.presentChannels & 8) != 0) {
            ++n2;
        }
        if ((this.presentChannels & 0x10) != 0) {
            ++n2;
        }
        if ((this.presentChannels & 0x20) != 0) {
            ++n3;
        }
        if ((this.presentChannels & 0x40) != 0) {
            ++n3;
        }
        String string = "scheme: " + n2 + "/" + n3;
        if ((this.presentChannels & 0x80) != 0) {
            string = string + "+lfe";
        }
        if ((this.presentChannels & 0x8000) != 0) {
            string = string + ", second stereo programm";
        }
        if (this.numberOfLanguageChannels > 0) {
            string = string + ", " + this.numberOfLanguageChannels + " language channels on " + this.MLSamplingRate + " Hz";
        }
        return string;
    }

    public int getStatus() {
        return this.status;
    }

    public int getPresentChannels() {
        return this.presentChannels;
    }

    public int getExtFrameLength() {
        return this.extFrameLength;
    }

    public int getNumberOfArrangementChannels() {
        return this.numberOfArrangementChannels;
    }

    public int getNumberOfLanguageChannels() {
        return this.numberOfLanguageChannels;
    }

    public int getMLSamplingRate() {
        return this.MLSamplingRate;
    }

    public int getNumberOfMLSamples() {
        return this.numberOfMLSamples;
    }

    public float[] getLFESamples() {
        return this.LFESamples;
    }
}

