/*
 * Decompiled with CFR 0.152.
 */
package org.greenstone.applet.phind;

import java.applet.Applet;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.Label;
import java.awt.Panel;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.DataInputStream;
import java.io.IOException;
import java.net.URL;
import java.util.Date;
import org.apache.xerces.parsers.DOMParser;
import org.greenstone.applet.phind.ResultBox;
import org.greenstone.applet.phind.ResultDisplay;
import org.greenstone.applet.phind.ResultItem;
import org.greenstone.applet.phind.URLUTF8Encoder;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.InputSource;

public class Phind
extends Applet
implements ActionListener {
    public String collection;
    public String classifier;
    public String library_address;
    public String phindcgi_address;
    public String initialSearch;
    public int phraseBlockSize;
    public boolean vertical;
    public int depth;
    public int fontSize;
    public String fontName;
    public Font plainFont;
    public Font boldFont;
    public boolean showImage;
    public String backdrop_address;
    public Image backgroundImage;
    public boolean showBorder;
    public Color panel_fg;
    public Color panel_bg;
    public Color column_1_fg;
    public Color column_1_bg;
    public Color column_2_fg;
    public Color column_2_bg;
    public Color highlight_fg;
    public Color highlight_bg;
    public Color thesaurus_fg;
    public Color thesaurus_bg;
    public Color thesaurus_bar_fg;
    public Color thesaurus_bar_bg;
    public Color expansion_fg;
    public Color expansion_bg;
    public Color expansion_bar_fg;
    public Color expansion_bar_bg;
    public Color document_fg;
    public Color document_bg;
    public Color document_bar_fg;
    public Color document_bar_bg;
    public Color message_fg;
    public Color message_bg;
    int column_1_width;
    int column_2_width;
    String searchWindowName;
    String documentWindowName;
    int mode;
    final int initMode = 0;
    final int idleMode = 1;
    final int searchMode = 2;
    boolean showControlPanel;
    Label titleLabel;
    TextField wordField;
    Button searchButton;
    Button prevButton;
    Button nextButton;
    Panel resultPanel;
    ResultDisplay firstDisplay;
    ResultDisplay lastDisplay;
    Date lastQueryEndTime;

    @Override
    public String getAppletInfo() {
        return "Phind by Gordon Paynter (paynter@cs.waikato.ac.nz). Copyright 1997-2000.";
    }

    @Override
    public void init() {
        this.mode = 0;
        this.getParameters();
        this.setBackground(this.panel_bg);
        this.lastQueryEndTime = new Date();
        this.plainFont = new Font(this.fontName, 0, this.fontSize);
        this.boldFont = new Font(this.fontName, 1, this.fontSize);
        this.setLayout(new BorderLayout());
        this.resultPanel = new Panel();
        if (this.vertical) {
            this.resultPanel.setLayout(new GridLayout(this.depth, 1, 0, 2));
        } else {
            System.out.println("horizontal");
            this.resultPanel.setLayout(new GridLayout(1, this.depth, 2, 0));
        }
        this.add("Center", this.resultPanel);
        ResultDisplay d2 = null;
        this.firstDisplay = new ResultDisplay(this, null);
        this.resultPanel.add(this.firstDisplay);
        if (this.depth == 1) {
            this.lastDisplay = this.firstDisplay;
        } else {
            ResultDisplay d1 = this.firstDisplay;
            for (int i = 2; i <= this.depth; ++i) {
                d2 = new ResultDisplay(this, d1);
                this.resultPanel.add(d2);
                d1 = d2;
            }
            this.lastDisplay = d2;
        }
        this.initialiseControlPanel();
        this.setStatus("Welcome to Phind.");
        this.mode = 1;
        if (this.initialSearch.length() > 0) {
            this.searchForWord(this.initialSearch);
        }
    }

    void setStatus(String status) {
        this.showStatus(status);
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        Component target = (Component)evt.getSource();
        if (target == this.searchButton) {
            System.out.println("search button pressed");
            this.searchForWord(this.getSearchTerm());
        } else if (target == this.wordField) {
            System.out.println("word field entered");
            this.searchForWord(this.getSearchTerm());
        } else if (target == this.prevButton) {
            System.out.println("prev button pressed");
            this.shiftPrevious();
        } else if (target == this.nextButton) {
            System.out.println("prev button pressed");
            this.shiftNext();
        } else {
            System.out.println("unknown action: " + evt.toString());
        }
    }

    void searchForWord(String searchWord) {
        System.err.println("in searchforword!!");
        if (this.mode == 1) {
            this.setSearchTerm(searchWord);
            searchWord = URLUTF8Encoder.encode(searchWord);
            if (searchWord.length() > 1) {
                this.setStatus("searching for \"" + searchWord + "\"");
                this.firstDisplay.emptyContents();
                ResultBox result = this.lookupPhraseOnServer(null, false, searchWord, searchWord, 2);
                if (result == null) {
                    this.setStatus("No results for \"" + searchWord + "\"");
                    return;
                }
                result.display = this.firstDisplay.display(result);
                result.setSize(result.display.getSize());
                result.paintAll(result.getGraphics());
            }
            this.enablePreviousAndNext();
        }
    }

    void searchForPhrase(ResultBox source, String key, String phrase, int queryMode) {
        if (this.mode == 1) {
            if (queryMode <= 2 && source.display.next != null) {
                source.display.next.emptyContents();
            }
            this.setStatus("Searching for \"" + phrase + "\"");
            ResultBox result = this.lookupPhraseOnServer(source, true, key, phrase, queryMode);
            if (result == null) {
                this.setStatus("No result for \"" + phrase + "\"");
                return;
            }
            if (queryMode <= 2) {
                result.display = this.lastDisplay.display(result);
                result.setSize(result.display.getSize());
                result.paintAll(result.getGraphics());
            }
            this.enablePreviousAndNext();
        }
    }

    ResultBox lookupPhraseOnServer(ResultBox source, boolean keyKnown, String key, String phrase, int queryMode) {
        this.disableSearchButton();
        this.mode = 2;
        ResultBox r = null;
        if (queryMode <= 2) {
            r = new ResultBox(this, this.collection, key, phrase, source);
        } else if (queryMode == 3 || queryMode == 4 || queryMode == 5) {
            r = source;
        }
        try {
            this.queryServer(keyKnown, key, queryMode, r);
        }
        catch (Exception e) {
            System.out.println("Phind query error: " + e.toString());
            this.setStatus("Query error: " + e.toString());
            this.mode = 1;
            this.enableSearchButton();
            return null;
        }
        this.setStatus(r.c.numberOfItems + " results for \"" + phrase + "\"");
        this.mode = 1;
        this.enableSearchButton();
        this.lastQueryEndTime = new Date();
        return r;
    }

    void queryServer(boolean keyKnown, String word, int queryMode, ResultBox area) throws IOException {
        String query = this.phindcgi_address + "c=" + this.collection + "&pc=" + this.classifier;
        query = keyKnown ? query + "&ppnum=" + word : query + "&ppnum=0" + "&pptext=" + word;
        int first_e = 0;
        int last_e = 0;
        int first_d = 0;
        int last_d = 0;
        int first_l = 0;
        int last_l = 0;
        if (queryMode <= 2) {
            last_e = this.phraseBlockSize;
            last_d = this.phraseBlockSize;
            last_l = this.phraseBlockSize;
        } else if (queryMode == 3) {
            first_e = area.nextPhraseBlock * this.phraseBlockSize;
            ++area.nextPhraseBlock;
            last_e = area.nextPhraseBlock * this.phraseBlockSize;
        } else if (queryMode == 4) {
            first_d = area.nextDocumentBlock * this.phraseBlockSize;
            ++area.nextDocumentBlock;
            last_d = area.nextDocumentBlock * this.phraseBlockSize;
        } else if (queryMode == 5) {
            first_l = area.nextThesaurusLinkBlock * this.phraseBlockSize;
            ++area.nextThesaurusLinkBlock;
            last_l = area.nextThesaurusLinkBlock * this.phraseBlockSize;
        }
        query = query + "&pfe=" + first_e + "&ple=" + last_e + "&pfd=" + first_d + "&pld=" + last_d + "&pfl=" + first_l + "&pll=" + last_l;
        System.out.println("1:sending query: " + query);
        try {
            URL phindcgi = new URL(query);
            DataInputStream in = new DataInputStream(phindcgi.openStream());
            DOMParser parser = new DOMParser();
            parser.parse(new InputSource(in));
            Document data_doc = parser.getDocument();
            Element data_elem = data_doc.getDocumentElement();
            area.parseXML(data_elem);
            in.close();
        }
        catch (Exception e) {
            System.err.println("Error sending query to phindcgi: " + e);
            e.printStackTrace();
        }
        area.repaint();
    }

    String tidy_URL(String address, boolean isCGI) {
        if (!address.startsWith("http")) {
            if (address.startsWith("/")) {
                URL document = this.getDocumentBase();
                String port = "";
                if (document.getPort() != -1) {
                    port = ":" + document.getPort();
                }
                address = "http://" + document.getHost() + port + address;
            } else {
                URL document = this.getDocumentBase();
                String directory = document.getFile();
                int end = directory.lastIndexOf(47);
                String port = "";
                if (document.getPort() != -1) {
                    port = ":" + document.getPort();
                }
                directory = directory.substring(0, end + 1);
                address = "http://" + document.getHost() + port + directory + address;
            }
        }
        if (isCGI) {
            if (address.indexOf(63) == -1) {
                address = address + "?";
            } else if (!address.endsWith("?")) {
                address = address + "&";
            }
        }
        return address;
    }

    void displayWebPage(String address, String window) {
        try {
            URL url = new URL(address);
            if (window.length() > 0) {
                this.getAppletContext().showDocument(url, window);
            } else {
                this.getAppletContext().showDocument(url);
            }
        }
        catch (Exception e) {
            System.out.println("Cannot open web page: " + e.toString());
        }
    }

    void getParameters() {
        this.collection = this.parameterValue("collection");
        System.out.println("Phind collection: " + this.collection);
        this.classifier = this.parameterValue("classifier", "1");
        System.out.println("Phind classifier: " + this.classifier);
        this.library_address = this.parameterValue("library");
        this.library_address = this.tidy_URL(this.library_address, true);
        System.out.println("Phind library: " + this.library_address);
        this.phindcgi_address = this.parameterValue("library") + this.parameterValue("phindcgi");
        this.phindcgi_address = this.tidy_URL(this.phindcgi_address, true);
        System.out.println("Phind phindcgi: " + this.phindcgi_address);
        this.initialSearch = this.parameterValue("initial_search", "");
        this.showControlPanel = true;
        if (this.parameterValue("control_panel", "show").toLowerCase().equals("hide")) {
            this.showControlPanel = false;
        }
        this.backdrop_address = this.parameterValue("backdrop", "");
        if (this.backdrop_address.length() > 0) {
            this.backdrop_address = this.tidy_URL(this.backdrop_address, false);
            System.out.println("Phind backdrop URL: " + this.backdrop_address);
            try {
                URL backdrop_url = new URL(this.backdrop_address);
                this.backgroundImage = this.getImage(backdrop_url);
                this.showImage = true;
            }
            catch (Exception e) {
                System.out.println("Phind could not load " + this.backdrop_address);
                this.showImage = false;
            }
        }
        this.showBorder = this.parameterValue("border", "on").equals("off");
        this.vertical = !this.parameterValue("orientation", "vertical").toLowerCase().startsWith("hori");
        this.depth = this.parameterValue("depth", 3);
        String order = this.parameterValue("resultorder", "standard");
        if (!order.equals("standard")) {
            int next;
            ResultItem.sortMessage = next = 20;
            for (int x = 0; x < order.length(); ++x) {
                if (order.charAt(x) == ',') {
                    --next;
                    continue;
                }
                if (order.charAt(x) == 'L') {
                    ResultItem.sortLinkItem = next;
                    continue;
                }
                if (order.charAt(x) == 'l') {
                    ResultItem.sortMoreLinks = next;
                    continue;
                }
                if (order.charAt(x) == 'E') {
                    ResultItem.sortPhraseItem = next;
                    continue;
                }
                if (order.charAt(x) == 'e') {
                    ResultItem.sortMorePhrases = next;
                    continue;
                }
                if (order.charAt(x) == 'D') {
                    ResultItem.sortDocumentItem = next;
                    continue;
                }
                if (order.charAt(x) != 'd') continue;
                ResultItem.sortMoreDocuments = next;
            }
            System.out.println("link: " + ResultItem.sortLinkItem);
            System.out.println("exps: " + ResultItem.sortPhraseItem);
            System.out.println("docs: " + ResultItem.sortDocumentItem);
        }
        this.phraseBlockSize = this.parameterValue("blocksize", 10);
        this.fontSize = this.parameterValue("fontsize", 10);
        this.fontName = this.parameterValue("fontname", "Helvetica");
        this.column_1_width = this.parameterValue("first_column_width", 6);
        this.column_2_width = this.parameterValue("second_column_width", this.column_1_width);
        this.searchWindowName = this.parameterValue("search_window", "phindsearch");
        this.documentWindowName = this.parameterValue("document_window", "phinddoc");
        this.panel_fg = this.parameterValue("panel_fg", Color.black);
        this.panel_bg = this.parameterValue("panel_bg", Color.white);
        this.highlight_bg = this.parameterValue("highlight_bg", Color.yellow);
        this.expansion_fg = this.parameterValue("expansion_fg", Color.black);
        this.thesaurus_fg = this.parameterValue("thesaurus_fg", new Color(0, 100, 0));
        this.document_fg = this.parameterValue("document_fg", Color.blue);
        this.thesaurus_bar_fg = this.parameterValue("thesaurus_bar_fg", Color.black);
        this.expansion_bar_fg = this.parameterValue("expansion_bar_fg", Color.black);
        this.document_bar_fg = this.parameterValue("document_bar_fg", Color.black);
        this.thesaurus_bar_bg = this.parameterValue("thesaurus_bar_bg", new Color(160, 160, 190));
        this.expansion_bar_bg = this.parameterValue("expansion_bar_bg", new Color(255, 200, 200));
        this.document_bar_bg = this.parameterValue("document_bar_bg", new Color(150, 193, 156));
        this.column_1_fg = this.parameterValue("first_column_fg", Color.black);
        this.column_1_bg = this.parameterValue("first_column_bg", new Color(235, 245, 235));
        this.column_2_fg = this.parameterValue("second_column_fg", Color.black);
        this.column_2_bg = this.parameterValue("second_column_bg", new Color(200, 220, 200));
        this.message_fg = this.parameterValue("message_fg", Color.black);
        this.message_bg = this.parameterValue("message_bg", Color.white);
    }

    String parameterValue(String name) {
        try {
            return this.getParameter(name);
        }
        catch (Exception e) {
            System.err.println("Phind: you must give a parameter for \"" + name + "\".  Stopping.");
            this.stop();
            return "";
        }
    }

    String parameterValue(String name, String defaultValue) {
        String text = this.getParameter(name);
        if (text == null) {
            return defaultValue;
        }
        System.out.println("Phind " + name + ": " + text);
        return text;
    }

    int parameterValue(String name, int defaultValue) {
        int value;
        try {
            value = Integer.parseInt(this.getParameter(name));
        }
        catch (Exception e) {
            return defaultValue;
        }
        System.out.println("Phind " + name + ": " + value);
        return value;
    }

    Color parameterValue(String name, Color defaultValue) {
        String text = this.getParameter(name);
        if (text == null) {
            return defaultValue;
        }
        if ((text = text.toLowerCase()).startsWith("#") && text.length() == 7) {
            text = text.substring(1);
            try {
                int r = Integer.parseInt(text.substring(0, 2), 16);
                int g = Integer.parseInt(text.substring(2, 4), 16);
                int b = Integer.parseInt(text.substring(4), 16);
                return new Color(r, g, b);
            }
            catch (Exception e) {
                return defaultValue;
            }
        }
        if (text.equals("black")) {
            return Color.black;
        }
        if (text.equals("blue")) {
            return Color.blue;
        }
        if (text.equals("cyan")) {
            return Color.cyan;
        }
        if (text.equals("darkgray")) {
            return Color.darkGray;
        }
        if (text.equals("gray")) {
            return Color.gray;
        }
        if (text.equals("green")) {
            return Color.green;
        }
        if (text.equals("lightgray")) {
            return Color.lightGray;
        }
        if (text.equals("magenta")) {
            return Color.magenta;
        }
        if (text.equals("orange")) {
            return Color.orange;
        }
        if (text.equals("pink")) {
            return Color.pink;
        }
        if (text.equals("red")) {
            return Color.red;
        }
        if (text.equals("white")) {
            return Color.white;
        }
        if (text.equals("yellow")) {
            return Color.yellow;
        }
        return defaultValue;
    }

    void initialiseControlPanel() {
        if (this.showControlPanel) {
            Panel p1 = new Panel();
            this.add("North", p1);
            p1.setLayout(new FlowLayout(1, 0, 0));
            this.searchButton = new Button("Search");
            this.searchButton.setFont(this.boldFont);
            this.searchButton.addActionListener(this);
            p1.add(this.searchButton);
            Label tempLabel = new Label("  for");
            tempLabel.setFont(this.boldFont);
            p1.add(tempLabel);
            this.wordField = new TextField(12);
            this.wordField.setFont(this.boldFont);
            this.wordField.addActionListener(this);
            p1.add(this.wordField);
            Label temp2 = new Label("          ");
            p1.add(temp2);
            this.prevButton = new Button("Previous");
            this.prevButton.setFont(this.boldFont);
            this.prevButton.addActionListener(this);
            this.prevButton.setEnabled(false);
            p1.add(this.prevButton);
            this.nextButton = new Button("  Next  ");
            this.nextButton.setFont(this.boldFont);
            this.nextButton.addActionListener(this);
            this.nextButton.setEnabled(false);
            p1.add(this.nextButton);
        }
    }

    void enableSearchButton() {
        if (this.showControlPanel) {
            this.searchButton.setEnabled(true);
        }
    }

    void disableSearchButton() {
        if (this.showControlPanel) {
            this.searchButton.setEnabled(false);
        }
    }

    String getSearchTerm() {
        if (this.showControlPanel) {
            return this.wordField.getText();
        }
        return this.initialSearch;
    }

    void setSearchTerm(String word) {
        if (this.showControlPanel) {
            this.wordField.setText(word);
        }
    }

    void enablePreviousAndNext() {
        if (this.showControlPanel) {
            Component c = this.firstDisplay.current;
            if (c.getClass().getName().endsWith("ResultBox")) {
                if (((ResultBox)c).prevBoxExists()) {
                    this.prevButton.setEnabled(true);
                } else {
                    this.prevButton.setEnabled(false);
                }
            }
            if ((c = this.lastDisplay.current).getClass().getName().endsWith("ResultBox")) {
                if (((ResultBox)c).nextBoxExists()) {
                    this.nextButton.setEnabled(true);
                } else {
                    this.nextButton.setEnabled(false);
                }
            }
        }
    }

    void shiftPrevious() {
        ResultBox b;
        Component c = this.firstDisplay.current;
        if (c.getClass().getName().endsWith("ResultBox") && (b = (ResultBox)c).prevBoxExists()) {
            b = b.prev;
            this.firstDisplay.emptyContents();
            for (int i = 1; i <= this.depth && b != null; ++i) {
                this.lastDisplay.display(b);
                b.setSize(b.display.getSize());
                b.paintAll(b.getGraphics());
                b = b.next;
            }
        }
        this.enablePreviousAndNext();
    }

    void shiftNext() {
        ResultBox b;
        Component c = this.lastDisplay.current;
        if (c.getClass().getName().endsWith("ResultBox") && (b = (ResultBox)c).nextBoxExists()) {
            c = this.firstDisplay.current;
            b = (ResultBox)c;
            b = b.next;
            this.firstDisplay.emptyContents();
            for (int i = 1; i <= this.depth && b != null; ++i) {
                this.lastDisplay.display(b);
                b.setSize(b.display.getSize());
                b.paintAll(b.getGraphics());
                b = b.next;
            }
        }
        this.enablePreviousAndNext();
    }
}

