/*
 * Decompiled with CFR 0.152.
 */
package org.greenstone.applet.phind;

import java.awt.BorderLayout;
import java.awt.Panel;
import java.awt.Scrollbar;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import org.greenstone.applet.phind.Phind;
import org.greenstone.applet.phind.ResultCanvas;
import org.greenstone.applet.phind.ResultDisplay;
import org.greenstone.applet.phind.ResultItemDocument;
import org.greenstone.applet.phind.ResultItemLink;
import org.greenstone.applet.phind.ResultItemPhrase;
import org.greenstone.applet.phind.ResultTitle;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ResultBox
extends Panel
implements AdjustmentListener {
    Phind phind;
    ResultDisplay display;
    ResultBox prev;
    ResultBox next;
    ResultCanvas c;
    ResultTitle t;
    Scrollbar s;
    Panel label;
    String searchKey;
    String searchPhrase;
    String searchCollection;
    int numberOfOccurances;
    int numberOfExpansions;
    int numberOfDocuments;
    int numberOfThesaurusLinks;
    int expansionsRetrieved;
    int documentsRetrieved;
    int thesaurusLinksRetrieved;
    int nextPhraseBlock;
    int nextDocumentBlock;
    int nextThesaurusLinkBlock;
    int mode = 0;
    final int initMode = 0;
    public final int emptyMode = 1;
    final int loadingMode = 2;
    final int finishedMode = 3;
    String buffer;
    boolean finished;

    ResultBox(Phind p, String collect, String key, String phrase, ResultBox rb) {
        this.phind = p;
        this.display = null;
        this.next = null;
        this.prev = rb;
        if (this.prev != null) {
            this.prev.next = this;
        }
        this.searchKey = key;
        this.searchPhrase = phrase;
        this.searchCollection = collect;
        this.numberOfOccurances = -1;
        this.numberOfExpansions = -1;
        this.numberOfDocuments = -1;
        this.numberOfThesaurusLinks = -1;
        this.expansionsRetrieved = 0;
        this.documentsRetrieved = 0;
        this.thesaurusLinksRetrieved = 0;
        this.nextPhraseBlock = 1;
        this.nextDocumentBlock = 1;
        this.nextThesaurusLinkBlock = 1;
        this.setLayout(new BorderLayout());
        this.s = new Scrollbar(1);
        this.disableScrollbar();
        this.s.addAdjustmentListener(this);
        this.add("East", this.s);
        this.c = new ResultCanvas(this);
        this.add("Center", this.c);
        this.t = new ResultTitle(this);
        this.add("North", this.t);
        this.buffer = "";
        this.finished = false;
        this.mode = 1;
    }

    static String describeContents(String phrase, String c) {
        return "\"" + phrase + "\" in " + c + ".";
    }

    String describeContents() {
        return ResultBox.describeContents(this.searchPhrase, this.searchCollection);
    }

    void resetBox() {
        this.buffer = "";
        this.finished = false;
        this.c.resetCanvas();
        this.disableScrollbar();
        this.mode = 1;
        this.numberOfExpansions = -1;
        this.numberOfDocuments = -1;
        this.numberOfThesaurusLinks = -1;
        this.expansionsRetrieved = 0;
        this.documentsRetrieved = 0;
        this.thesaurusLinksRetrieved = 0;
    }

    void setStatus(String status) {
        this.phind.setStatus(status);
    }

    void disableScrollbar() {
        if (this.s.isEnabled()) {
            this.s.setValues(0, 1, 0, 1);
            this.s.setUnitIncrement(1);
            this.s.setBlockIncrement(1);
            this.s.setEnabled(false);
        }
    }

    public boolean prevBoxExists() {
        return this.prev != null;
    }

    public boolean nextBoxExists() {
        return this.next != null;
    }

    void lookupPhrase(String key, String phrase, int queryMode) {
        this.buffer = "";
        this.finished = false;
        this.phind.searchForPhrase(this, key, phrase, queryMode);
        this.t.repaint();
    }

    @Override
    public void adjustmentValueChanged(AdjustmentEvent evt) {
        this.c.repaint();
    }

    void parseXML(Element data) {
        this.searchKey = data.getAttribute("id");
        this.numberOfDocuments = Integer.valueOf(data.getAttribute("df"));
        this.numberOfExpansions = Integer.valueOf(data.getAttribute("ef"));
        this.numberOfThesaurusLinks = Integer.valueOf(data.getAttribute("lf"));
        this.numberOfOccurances = Integer.valueOf(data.getAttribute("tf"));
        for (Node e = data.getFirstChild(); e != null; e = e.getNextSibling()) {
            int i;
            String node_name = e.getNodeName();
            if (node_name.equals("phrase")) {
                this.searchPhrase = this.getNodeText(e);
                continue;
            }
            if (node_name.equals("expansionList")) {
                NodeList expansions = ((Element)e).getElementsByTagName("expansion");
                for (i = 0; i < expansions.getLength(); ++i) {
                    this.processExpansionElement((Element)expansions.item(i));
                }
                continue;
            }
            if (node_name.equals("documentList")) {
                NodeList documents = ((Element)e).getElementsByTagName("document");
                for (i = 0; i < documents.getLength(); ++i) {
                    this.processDocumentElement((Element)documents.item(i));
                }
                continue;
            }
            if (node_name.equals("thesaurusList")) {
                NodeList thesaurai = ((Element)e).getElementsByTagName("thesaurus");
                for (i = 0; i < thesaurai.getLength(); ++i) {
                    this.processThesaurusElement((Element)thesaurai.item(i));
                }
                continue;
            }
            System.out.println("error in phinddata format, have unwanted node, " + node_name);
        }
        this.c.updateMarkers();
    }

    boolean processExpansionElement(Element e) {
        ResultItemPhrase ri;
        Node suffix_node;
        String num = "";
        String id = "";
        String tf = "";
        String df = "";
        String prefix = "";
        String body = "";
        String suffix = "";
        body = this.searchPhrase;
        id = e.getAttribute("id");
        tf = e.getAttribute("tf");
        df = e.getAttribute("df");
        num = e.getAttribute("num");
        Node prefix_node = this.getChildByTagName(e, "prefix");
        if (prefix_node != null) {
            prefix = this.getNodeText(prefix_node);
        }
        if ((suffix_node = this.getChildByTagName(e, "suffix")) != null) {
            suffix = this.getNodeText(suffix_node);
        }
        if (this.c.addResultItem(ri = new ResultItemPhrase(id, tf, df, prefix, body, suffix))) {
            ++this.expansionsRetrieved;
            return true;
        }
        return false;
    }

    boolean processDocumentElement(Element d) {
        ResultItemDocument ri;
        String num = "";
        String hash = "";
        String freq = "";
        String title = "";
        num = d.getAttribute("num");
        freq = d.getAttribute("freq");
        hash = d.getAttribute("hash");
        Node title_node = this.getChildByTagName(d, "title");
        if (title_node != null) {
            title = this.getNodeText(title_node);
        }
        if (this.c.addResultItem(ri = new ResultItemDocument(hash, title, freq))) {
            ++this.documentsRetrieved;
            return true;
        }
        return false;
    }

    boolean processThesaurusElement(Element t) {
        ResultItemLink ri;
        String num = "";
        String id = "";
        String tf = "";
        String df = "";
        String type = "";
        String phrase = "";
        id = t.getAttribute("id");
        tf = t.getAttribute("tf");
        df = t.getAttribute("df");
        type = t.getAttribute("type");
        num = t.getAttribute("num");
        Node phrase_node = this.getChildByTagName(t, "phrase");
        if (phrase_node != null) {
            phrase = this.getNodeText(phrase_node);
        }
        if (this.c.addResultItem(ri = new ResultItemLink(id, phrase, type, tf, df))) {
            ++this.thesaurusLinksRetrieved;
            return true;
        }
        return false;
    }

    protected String getNodeText(Node elem) {
        Node n;
        elem.normalize();
        for (n = elem.getFirstChild(); n != null && n.getNodeType() != 3; n = n.getNextSibling()) {
        }
        if (n == null) {
            return "";
        }
        return n.getNodeValue();
    }

    protected Node getChildByTagName(Node n, String name) {
        for (Node child = n.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (!child.getNodeName().equals(name)) continue;
            return child;
        }
        return null;
    }
}

