/*
 * Decompiled with CFR 0.152.
 */
package org.greenstone.applet.phind;

import java.awt.Canvas;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Scrollbar;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Date;
import java.util.Vector;
import org.greenstone.applet.phind.Phind;
import org.greenstone.applet.phind.ResultBox;
import org.greenstone.applet.phind.ResultItem;

public class ResultCanvas
extends Canvas {
    Phind phind;
    ResultBox parent;
    Scrollbar scrollbar;
    Font areaPlain;
    Font areaBold;
    int lineSpacing;
    int numberOfItems;
    int firstItemDisplayed;
    int itemSelected;
    Vector<ResultItem> items;
    public static Image backgroundImage;

    ResultCanvas(ResultBox p) {
        this.parent = p;
        this.phind = p.phind;
        this.scrollbar = p.s;
        this.parent.disableScrollbar();
        this.areaPlain = this.phind.plainFont;
        this.areaBold = this.phind.boldFont;
        this.lineSpacing = this.phind.fontSize + 2;
        this.items = new Vector();
        this.numberOfItems = 0;
        this.firstItemDisplayed = 0;
        this.itemSelected = -1;
        if (backgroundImage == null) {
            backgroundImage = p.phind.backgroundImage;
        }
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                ResultCanvas.this.mouseClicked(evt);
            }
        });
    }

    void resetCanvas() {
        this.items.removeAllElements();
        this.numberOfItems = 0;
        this.repaint();
    }

    boolean addResultItem(ResultItem item) {
        int index;
        for (index = 0; index < this.numberOfItems && (item.sort < this.items.elementAt((int)index).sort || item.sort == this.items.elementAt((int)index).sort && item.frequency <= this.items.elementAt((int)index).frequency); ++index) {
        }
        this.items.insertElementAt(item, index);
        ++this.numberOfItems;
        return true;
    }

    void updateMarkers() {
        this.updateMorePhrasesMarker();
        this.updateMoreDocumentsMarker();
        this.updateMoreLinksMarker();
    }

    void updateMorePhrasesMarker() {
        System.out.println("updateMorePhrasesMarker() ");
        System.out.println("expansions retrieved = " + this.parent.expansionsRetrieved + " num expansions = " + this.parent.numberOfExpansions);
        boolean found = false;
        int index = 0;
        while (!found && index < this.numberOfItems) {
            if (this.items.elementAt(index).isMorePhrases()) {
                found = true;
                continue;
            }
            ++index;
        }
        if (this.parent.expansionsRetrieved == this.parent.numberOfExpansions) {
            if (found) {
                this.items.removeElementAt(index);
                --this.numberOfItems;
            }
        } else if (this.parent.expansionsRetrieved < this.parent.numberOfExpansions && !found) {
            ResultItem ri = new ResultItem(4);
            this.addResultItem(ri);
        }
    }

    void updateMoreDocumentsMarker() {
        boolean found = false;
        int index = 0;
        while (!found && index < this.numberOfItems) {
            if (this.items.elementAt(index).isMoreDocuments()) {
                found = true;
                continue;
            }
            ++index;
        }
        if (this.parent.documentsRetrieved == this.parent.numberOfDocuments) {
            if (found) {
                this.items.removeElementAt(index);
                --this.numberOfItems;
            }
        } else if (this.parent.documentsRetrieved < this.parent.numberOfDocuments && !found) {
            ResultItem ri = new ResultItem(2);
            this.addResultItem(ri);
        }
    }

    void updateMoreLinksMarker() {
        boolean found = false;
        int index = 0;
        while (!found && index < this.numberOfItems) {
            if (this.items.elementAt(index).isMoreLinks()) {
                found = true;
                continue;
            }
            ++index;
        }
        if (this.parent.thesaurusLinksRetrieved == this.parent.numberOfThesaurusLinks) {
            if (found) {
                this.items.removeElementAt(index);
                --this.numberOfItems;
            }
        } else if (this.parent.thesaurusLinksRetrieved < this.parent.numberOfThesaurusLinks && !found) {
            ResultItem ri = new ResultItem(6);
            this.addResultItem(ri);
        }
    }

    @Override
    public void update(Graphics g) {
        this.paint(g);
    }

    @Override
    public void paint(Graphics g) {
        int tab;
        ResultItem result;
        int i;
        Dimension canvasSize = this.getSize();
        g.setFont(this.areaPlain);
        int space = g.getFontMetrics().stringWidth(" ");
        int nought = g.getFontMetrics().stringWidth("0");
        int firstColumnWidth = this.phind.column_1_width * nought;
        int secondColumnWidth = this.phind.column_2_width * nought;
        int columnWidth = firstColumnWidth + secondColumnWidth;
        int firstColumnLeft = canvasSize.width - columnWidth;
        int secondColumnLeft = firstColumnLeft + firstColumnWidth;
        int mainLeftMargin = 0;
        int mainRightMargin = firstColumnLeft;
        int visible = canvasSize.height / this.lineSpacing;
        int scrollValue = this.scrollbar.getValue();
        if (this.numberOfItems <= visible) {
            scrollValue = 0;
        } else if (scrollValue > this.numberOfItems - visible) {
            scrollValue = this.numberOfItems - visible;
        }
        this.firstItemDisplayed = scrollValue;
        Color fore = this.phind.panel_fg;
        Color back = this.phind.panel_bg;
        if (this.phind.showImage) {
            try {
                g.drawImage(backgroundImage, mainLeftMargin, 0, mainRightMargin, canvasSize.height, back, null);
            }
            catch (Exception e) {
                this.phind.showImage = false;
                System.err.println("ResultCanvas paint error: " + e);
                g.setColor(back);
                g.fillRect(0, 0, canvasSize.width, canvasSize.height);
            }
        } else {
            g.setColor(back);
            g.fillRect(0, 0, canvasSize.width, canvasSize.height);
        }
        if (this.numberOfItems == 0) {
            g.drawString("No phrases match this query.", mainLeftMargin + 10, this.lineSpacing);
        }
        int y = 0;
        int center = mainLeftMargin + (mainRightMargin - mainLeftMargin - g.getFontMetrics().stringWidth(this.parent.searchPhrase)) / 2;
        int thesColumn = mainLeftMargin + firstColumnWidth + g.getFontMetrics().stringWidth("Narrower term");
        for (i = scrollValue; i < this.numberOfItems && y + this.lineSpacing < canvasSize.height; ++i) {
            String body;
            String prefix;
            result = this.items.elementAt(i);
            y += this.lineSpacing;
            g.setFont(this.areaPlain);
            if (i == this.itemSelected) {
                g.setColor(this.phind.highlight_bg);
                g.fillRect(mainLeftMargin, y - this.lineSpacing + 2, mainRightMargin, this.lineSpacing);
            }
            if (result.isPhrase()) {
                prefix = result.prefixText();
                body = result.mainText();
                String suffix = result.suffixText();
                g.setColor(this.phind.expansion_fg);
                g.setFont(this.areaPlain);
                tab = center - g.getFontMetrics().stringWidth(prefix) - space;
                g.drawString(prefix, tab, y);
                g.setFont(this.areaBold);
                g.drawString(body, center, y);
                tab = center + space + g.getFontMetrics().stringWidth(body);
                g.setFont(this.areaPlain);
                g.drawString(suffix, tab, y);
                continue;
            }
            if (result.isDocument()) {
                body = result.mainText();
                g.setColor(this.phind.document_fg);
                g.setFont(this.areaPlain);
                tab = (mainRightMargin - g.getFontMetrics().stringWidth(body)) / 2;
                g.drawString(body, tab, y);
                continue;
            }
            if (result.isLink()) {
                prefix = result.prefixText() + ":";
                body = result.mainText();
                tab = thesColumn - g.getFontMetrics().stringWidth(prefix) - space;
                g.setColor(this.phind.thesaurus_fg);
                g.setFont(this.areaPlain);
                g.drawString(prefix, tab, y);
                g.setFont(this.areaBold);
                g.drawString(body, thesColumn, y);
                continue;
            }
            if (!result.isMorePhrases() && !result.isMoreDocuments() && !result.isMoreLinks()) continue;
            body = result.mainText();
            if (result.isMorePhrases()) {
                g.setColor(this.phind.expansion_bar_bg);
            } else if (result.isMoreDocuments()) {
                g.setColor(this.phind.document_bar_bg);
            } else {
                g.setColor(this.phind.thesaurus_bar_bg);
            }
            g.fillRect(mainLeftMargin, y - this.lineSpacing + 2, mainRightMargin, this.lineSpacing);
            if (result.isMorePhrases()) {
                g.setColor(this.phind.expansion_bar_fg);
            } else if (result.isMoreDocuments()) {
                g.setColor(this.phind.document_bar_fg);
            } else {
                g.setColor(this.phind.thesaurus_bar_fg);
            }
            g.setFont(this.areaPlain);
            tab = (mainRightMargin - g.getFontMetrics().stringWidth(body)) / 2;
            g.drawString(body, tab, y);
        }
        g.setColor(this.phind.column_1_bg);
        g.fillRect(firstColumnLeft, 0, firstColumnWidth, canvasSize.height);
        g.setColor(this.phind.column_2_bg);
        g.fillRect(secondColumnLeft, 0, secondColumnWidth, canvasSize.height);
        g.setColor(this.phind.column_1_fg);
        g.setFont(this.areaPlain);
        y = 0;
        for (i = scrollValue; i < this.numberOfItems && y + this.lineSpacing < canvasSize.height; ++i) {
            result = this.items.elementAt(i);
            String docsText = result.docsText();
            String freqText = result.freqText();
            y += this.lineSpacing;
            if (docsText.length() > 0) {
                tab = secondColumnLeft - space - g.getFontMetrics().stringWidth(docsText);
                g.drawString(docsText, tab, y);
            }
            if (freqText.length() <= 0) continue;
            tab = secondColumnLeft + secondColumnWidth - space - g.getFontMetrics().stringWidth(freqText);
            g.drawString(freqText, tab, y);
        }
        if (visible >= this.numberOfItems) {
            this.parent.disableScrollbar();
        } else {
            this.scrollbar.setValues(scrollValue, visible, 0, this.numberOfItems);
            this.scrollbar.setBlockIncrement(visible - 1);
            this.scrollbar.setEnabled(true);
        }
        if (this.phind.showBorder) {
            g.setColor(this.phind.panel_fg);
            g.drawRect(0, 0, canvasSize.width - 1, canvasSize.height - 1);
        }
    }

    public void mouseClicked(MouseEvent event) {
        Date now = new Date();
        if (now.getTime() < this.phind.lastQueryEndTime.getTime() + 1000L) {
            System.out.println("Ignoring click - too close to last query.");
            return;
        }
        int rowSelected = event.getY() / this.lineSpacing;
        this.itemSelected = rowSelected + this.firstItemDisplayed;
        ResultItem item = this.items.elementAt(this.itemSelected);
        if (this.itemSelected <= this.numberOfItems) {
            if (item.isPhrase()) {
                this.itemSelected = this.itemSelected;
                this.update(this.getGraphics());
                this.parent.lookupPhrase(item.hiddenText(), item.toString(), 2);
            } else if (item.isLink()) {
                this.itemSelected = this.itemSelected;
                this.update(this.getGraphics());
                this.parent.lookupPhrase(item.hiddenText(), item.toString(), 2);
            } else if (item.isDocument()) {
                this.itemSelected = this.itemSelected;
                this.update(this.getGraphics());
                String address = this.phind.library_address + "a=d&c=" + this.phind.collection + "&d=" + item.hiddenText() + "&q=" + this.parent.searchPhrase.replace(' ', '+');
                this.phind.displayWebPage(address, this.phind.documentWindowName);
            } else if (item.isMorePhrases()) {
                this.parent.lookupPhrase(this.parent.searchKey, this.parent.searchPhrase, 3);
            } else if (item.isMoreDocuments()) {
                this.parent.lookupPhrase(this.parent.searchKey, this.parent.searchPhrase, 4);
            } else if (item.isMoreLinks()) {
                this.parent.lookupPhrase(this.parent.searchKey, this.parent.searchPhrase, 5);
            }
            this.repaint();
        }
    }
}

